/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.scm.sm.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.common.EntryBaseStatusEnum;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleFactory;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleInfo;
import com.kingdee.eas.industry.emm.scm.sm.client.AbstractAnalyseDeliveryPlanDetailTabUI;
import com.kingdee.eas.mm.report.MaterialIssueModesEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class AnalyseDeliveryPlanDetailTabUI
extends AbstractAnalyseDeliveryPlanDetailTabUI {
    private static final Logger logger = CoreUIObject.getLogger(AnalyseDeliveryPlanDetailTabUI.class);

    public void onLoad() throws Exception {
        ArrayList stockids;
        super.onLoad();
        List list = stockids = this.getUIContext().get("STOCKIDS") == null ? new ArrayList() : (List)this.getUIContext().get("STOCKIDS");
        if (stockids.size() > 0) {
            EntityViewInfo viewinfo = new EntityViewInfo();
            HashSet set = new HashSet();
            set.addAll(stockids);
            FilterInfo filterinfo = new FilterInfo();
            filterinfo.getFilterItems().add(new FilterItemInfo("stocks.id", set, CompareType.INCLUDE));
            viewinfo.setFilter(filterinfo);
            this.setDataObject("manufactureOrderStockQuery", (IObjectValue)viewinfo);
        }
        String consignMentId = (String)this.getUIContext().get("CONSGINMENTID");
        ConsignmentScheduleInfo info = ConsignmentScheduleFactory.getRemoteInstance().getConsignmentScheduleInfo((IObjectPK)new ObjectUuidPK(consignMentId));
        String orderentryid = info.getParent().getId().toString();
        EntityViewInfo _viewInfo = new EntityViewInfo();
        FilterInfo _filterinfo = new FilterInfo();
        _filterinfo.getFilterItems().add(new FilterItemInfo("id", (Object)orderentryid, CompareType.EQUALS));
        _viewInfo.setFilter(_filterinfo);
        this.setDataObject("F7PurOrderEntryQuery", (IObjectValue)_viewInfo);
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            IRowSetMetaData rsmd = rowSet.getRowSetMetaData();
            rsmd.setColumnType(3, 12);
            rowSet.beforeFirst();
            while (rowSet.next()) {
                rowSet.updateObject("baseStatus", (Object)EntryBaseStatusEnum.getEnum((int)rowSet.getInt("baseStatus")));
            }
            rowSet.beforeFirst();
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
    }

    private void onGetStockRowSet(IRowSet rowSet) {
        try {
            IRowSetMetaData rsmd = rowSet.getRowSetMetaData();
            rsmd.setColumnType(11, 12);
            rsmd.setColumnType(10, 12);
            rowSet.beforeFirst();
            while (rowSet.next()) {
                rowSet.updateObject("stocks.provideType", (Object)MaterialProvideTypeEnum.getEnum((int)rowSet.getInt("stocks.provideType")));
                rowSet.updateObject("stocks.issueMode", (Object)MaterialIssueModesEnum.getEnum((String)rowSet.getString("stocks.issueMode")));
            }
            rowSet.beforeFirst();
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
    }

    private void cleanOutData(IRowSet rowSet) throws SQLException {
        ArrayList stockids = this.getUIContext().get("STOCKIDS") == null ? new ArrayList() : (List)this.getUIContext().get("STOCKIDS");
        ArrayList stockqtys = this.getUIContext().get("STOCKQTY") == null ? new ArrayList() : (List)this.getUIContext().get("STOCKQTY");
        HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
        for (int n = 0; n < stockids.size(); ++n) {
            String[] stocks = ((String)stockids.get(n)).split(",");
            String[] stockqty = ((String)stockqtys.get(n)).split(",");
            for (int m = 0; m < stocks.length; ++m) {
                String tmpStr = stocks[m].replaceAll("'", "");
                String _tmpStr = stockqty[m].replaceAll("'", "");
                if (stocks[n] == null || "".equals(tmpStr)) continue;
                dataMap.put(tmpStr, BigDecimal.valueOf(Double.parseDouble(_tmpStr)));
            }
        }
        while (rowSet.next()) {
            String id = rowSet.getString("stocks.id");
            if (dataMap.get(id) == null) continue;
            rowSet.updateBigDecimal("stocks.qty", (BigDecimal)dataMap.get(id));
            rowSet.updateBigDecimal("stocks.plannedQty", (BigDecimal)dataMap.get(id));
        }
        rowSet.beforeFirst();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ConsignmentScheduleFactory.getRemoteInstance();
    }
}

