/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.scm.sm.directdelivery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.basedata.scm.workshop.MaterialWorkShopEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.emm.basedata.projectjch.ProjectJCHInfo;
import com.kingdee.eas.industry.emm.basedata.LocationDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanType;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.DirectDeliveryDetailInfo;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.DirectDeliveryResultScopeVO;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.mo.CalculatePurOrderResultVO;
import com.kingdee.eas.mm.mo.DeliveryPlanSingletonFactory;
import com.kingdee.eas.mm.mo.app.TrackNumberSingleCache;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurReTypeInfo;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DirectPurOrderSingleton {
    private static DirectPurOrderSingleton instance;
    private Context ctx;
    private static HashMap<String, List<CalculatePurOrderResultVO>> mapPurOrder;
    private static HashMap<String, String[]> mapEntryIdTrackNo;
    private static String queryPurOrderSqlAll;

    private DirectPurOrderSingleton(Context _ctx) throws BOSException, EASBizException {
        this.ctx = _ctx;
        this.initPurOrderSingleton();
    }

    public static synchronized DirectPurOrderSingleton getInstance(Context ctx) throws BOSException, EASBizException {
        if (instance == null) {
            instance = new DirectPurOrderSingleton(ctx);
        }
        return instance;
    }

    public void clear() {
        instance = null;
        mapPurOrder.clear();
    }

    private void initPurOrderSingleton() throws BOSException, EASBizException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)queryPurOrderSqlAll);
            while (rs.next()) {
                ArrayList<CalculatePurOrderResultVO> purorderResult;
                CalculatePurOrderResultVO orderentry = new CalculatePurOrderResultVO();
                String purorgid = rs.getString("purorgid");
                String materialid = rs.getString("fmaterialid");
                if (IndustryUtils.isEmptyString((String)purorgid) || IndustryUtils.isEmptyString((String)materialid)) continue;
                String projectid = rs.getString("fprojectid") == null ? "" : rs.getString("fprojectid");
                String trackid = rs.getString("ftracknoid") == null ? "" : rs.getString("ftracknoid");
                String supplierid = rs.getString("fsupplierid");
                String entryid = rs.getString("entryid");
                String fpurchasepersonid = rs.getString("fpurchasepersonid");
                String fpurchasegroupid = rs.getString("fpurchasegroupid");
                String fstorageorgunitid = rs.getString("fstorageorgunitid");
                String hashcode = purorgid.hashCode() + "" + materialid.hashCode() + "" + fstorageorgunitid.hashCode();
                String hashproject = purorgid.hashCode() + "" + materialid.hashCode() + "" + projectid.hashCode() + "" + fstorageorgunitid.hashCode();
                String hashtrack = purorgid.hashCode() + "" + materialid.hashCode() + "" + projectid.hashCode() + "" + trackid.hashCode() + "" + fstorageorgunitid.hashCode();
                orderentry.setSupplyOrgUnitid(fstorageorgunitid);
                orderentry.setOrderid(rs.getString("orderid"));
                orderentry.setOrderentryid(entryid);
                orderentry.setQty(rs.getBigDecimal("qty"));
                orderentry.setActualqty(rs.getBigDecimal("actualqty"));
                orderentry.setOrderdate(rs.getTimestamp("bizdate"));
                orderentry.setOrderentryno(rs.getInt("seq"));
                orderentry.setPurorgid(rs.getString("purorgid"));
                orderentry.setSupplierid(supplierid);
                orderentry.setPurGroupid(fpurchasegroupid);
                orderentry.setPurPersonid(fpurchasepersonid);
                if (mapPurOrder.get(hashcode) != null) {
                    mapPurOrder.get(hashcode).add(orderentry);
                } else {
                    purorderResult = new ArrayList<CalculatePurOrderResultVO>();
                    purorderResult.add(orderentry);
                    mapPurOrder.put(hashcode, purorderResult);
                }
                if (mapPurOrder.get(hashproject) != null) {
                    mapPurOrder.get(hashproject).add(orderentry);
                } else {
                    purorderResult = new ArrayList();
                    purorderResult.add(orderentry);
                    mapPurOrder.put(hashproject, purorderResult);
                }
                if (mapPurOrder.get(hashtrack) != null) {
                    mapPurOrder.get(hashtrack).add(orderentry);
                    continue;
                }
                purorderResult = new ArrayList();
                purorderResult.add(orderentry);
                mapPurOrder.put(hashtrack, purorderResult);
            }
        }
        catch (SQLException ex) {
            throw new EASBizException(new NumericExceptionSubItem("\u9519\u8bef", "\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u51fa\u9519" + ex.getMessage()), (Throwable)ex);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("\u9519\u8bef", "\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u51fa\u9519" + e.getMessage()), (Throwable)e);
        }
    }

    public void getPurOrderQty(DirectDeliveryResultScopeVO vo) throws BOSException, EASBizException {
        BigDecimal actualqty;
        BigDecimal actqty;
        String materialid = vo.getMaterialid();
        String projectid = vo.getProjectid() == null ? "" : vo.getProjectid();
        String trackid = vo.getTracknumberid() == null ? "" : vo.getTracknumberid();
        String workorgid = vo.getWorkstorageorgid();
        ArrayList<PurRelationshipDefinitionEntryInfo> entrys = new ArrayList<PurRelationshipDefinitionEntryInfo>();
        PurRelationshipDefinitionInfo purdefinfo = vo.getPurmethod();
        if (purdefinfo != null) {
            PurRelationshipDefinitionEntryCollection purEntrys = purdefinfo.getEntry();
            for (int n = 0; n < purEntrys.size(); ++n) {
                if (!workorgid.equals(purEntrys.get(n).getProductOrgUnit().getId().toString())) continue;
                entrys.add(purEntrys.get(n));
            }
        } else {
            throw new EASBizException(new NumericExceptionSubItem("", "\u6ca1\u6709\u8bbe\u7f6e\u5bf9\u5e94\u7684\u91c7\u8d2d\u5173\u7cfb"));
        }
        String solatedrule = vo.getSolatedrule();
        String hashcode = null;
        ArrayList<CalculatePurOrderResultVO> purorderResult = new ArrayList<CalculatePurOrderResultVO>();
        for (int n = 0; n < entrys.size(); ++n) {
            String purorgid = ((PurRelationshipDefinitionEntryInfo)entrys.get(n)).getPurchaseOrgUnit().getId().toString();
            String storageid = vo.getSupplystorageorgid();
            hashcode = solatedrule == null || "NONE".equals(solatedrule) ? purorgid.hashCode() + "" + materialid.hashCode() + "" + storageid.hashCode() : ("ITEM".equals(solatedrule) ? purorgid.hashCode() + "" + materialid.hashCode() + "" + projectid.hashCode() + "" + storageid.hashCode() : purorgid.hashCode() + "" + materialid.hashCode() + "" + projectid.hashCode() + trackid.hashCode() + "" + storageid.hashCode());
            if (mapPurOrder.get(hashcode) == null) continue;
            List<CalculatePurOrderResultVO> tmppurorderResult = mapPurOrder.get(hashcode);
            purorderResult.addAll(tmppurorderResult);
        }
        if ("ITEM".equals(solatedrule)) {
            for (CalculatePurOrderResultVO entry : purorderResult) {
                actqty = vo.getActqty();
                actualqty = entry.getActualqty();
                String entryid = entry.getOrderentryid();
                String[] tracks = mapEntryIdTrackNo.get(entryid);
                vo.setPurGroupID(entry.getPurGroupid());
                vo.setPurPersonID(entry.getPurPersonid());
                if (!IndustryUtils.isEmptyString((String)vo.getSupplierID()) && !vo.getSupplierID().equals(entry.getSupplierid()) || !this.filterSETracks(this.ctx, trackid, tracks) || actualqty.compareTo(BigDecimal.ZERO) <= 0 || actqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (actqty.compareTo(actualqty) >= 0) {
                    entry.setActualqty(BigDecimal.ZERO);
                    vo.setActqty(actqty.subtract(actualqty));
                    this.makeDeliveryPlan(this.ctx, vo, entry, actualqty);
                    continue;
                }
                vo.setActqty(BigDecimal.ZERO);
                entry.setActualqty(actualqty.subtract(actqty));
                this.makeDeliveryPlan(this.ctx, vo, entry, actqty);
            }
        } else {
            for (CalculatePurOrderResultVO entry : purorderResult) {
                actqty = vo.getActqty();
                actualqty = entry.getActualqty();
                vo.setPurGroupID(entry.getPurGroupid());
                vo.setPurPersonID(entry.getPurPersonid());
                if (!IndustryUtils.isEmptyString((String)vo.getSupplierID()) && !vo.getSupplierID().equals(entry.getSupplierid()) || actualqty.compareTo(BigDecimal.ZERO) <= 0 || actqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (actqty.compareTo(actualqty) >= 0) {
                    entry.setActualqty(BigDecimal.ZERO);
                    vo.setActqty(actqty.subtract(actualqty));
                    this.makeDeliveryPlan(this.ctx, vo, entry, actualqty);
                    continue;
                }
                vo.setActqty(BigDecimal.ZERO);
                entry.setActualqty(actualqty.subtract(actqty));
                this.makeDeliveryPlan(this.ctx, vo, entry, actqty);
            }
        }
    }

    private boolean filterSETracks(Context ctx, String trackid, String[] seTrackid) throws BOSException, EASBizException {
        String tracknumber = "";
        String stracknumber = "0001";
        String endnumber = "9999";
        boolean isFilter = false;
        if (trackid != null && !"".equals(trackid)) {
            tracknumber = TrackNumberSingleCache.getInstance((Context)ctx).getTrackNumber(trackid);
            if (tracknumber == null || "".equals(tracknumber)) {
                return true;
            }
            tracknumber = tracknumber.substring(tracknumber.length() - 4, tracknumber.length());
        } else {
            isFilter = true;
        }
        if (seTrackid[0] != null) {
            stracknumber = TrackNumberSingleCache.getInstance((Context)ctx).getTrackNumber(seTrackid[0]);
            stracknumber = stracknumber.substring(stracknumber.length() - 4, stracknumber.length());
        }
        if (seTrackid[1] != null) {
            endnumber = TrackNumberSingleCache.getInstance((Context)ctx).getTrackNumber(seTrackid[1]);
            endnumber = endnumber.substring(endnumber.length() - 4, endnumber.length());
        } else {
            endnumber = stracknumber;
        }
        if (stracknumber.compareTo(tracknumber) <= 0 && endnumber.compareTo(tracknumber) >= 0) {
            isFilter = true;
        }
        return isFilter;
    }

    private void makeDeliveryPlan(Context ctx, DirectDeliveryResultScopeVO vo, CalculatePurOrderResultVO entry, BigDecimal qty) throws BOSException, EASBizException {
        DirectDeliveryDetailInfo info = new DirectDeliveryDetailInfo();
        String supOrgID = vo.getSupplystorageorgid();
        StorageOrgUnitInfo supStorgetinfo = new StorageOrgUnitInfo();
        supStorgetinfo.setId(BOSUuid.read((String)supOrgID));
        info.setSupplyStorageOrgUnit(supStorgetinfo);
        String storageid = vo.getStorageorgid();
        StorageOrgUnitInfo storgetinfo = new StorageOrgUnitInfo();
        storgetinfo.setId(BOSUuid.read((String)storageid));
        info.setStorageOrgUnit(storgetinfo);
        if (entry != null) {
            String purorgid = entry.getPurorgid();
            if (!IndustryUtils.isEmptyString((String)purorgid)) {
                PurchaseOrgUnitInfo purInfo = new PurchaseOrgUnitInfo();
                purInfo.setId(BOSUuid.read((String)purorgid));
                info.setPurchaseOrgUnit(purInfo);
            }
            info.setPurOrderEntryID(entry.getOrderentryid());
            if (!IndustryUtils.isEmptyString((String)entry.getOrderid())) {
                PurOrderInfo orderInfo = new PurOrderInfo();
                orderInfo.setId(BOSUuid.read((String)entry.getOrderid()));
                info.setPurOrder(orderInfo);
            }
            if (!IndustryUtils.isEmptyString((String)entry.getPurtypeid())) {
                PurReTypeInfo purtypeInfo = new PurReTypeInfo();
                purtypeInfo.setId(BOSUuid.read((String)entry.getPurtypeid()));
                info.setPurtype(purtypeInfo);
            }
        }
        MaterialInfo mInfo = new MaterialInfo();
        mInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(vo.getMaterialid()));
        info.setMaterial(mInfo);
        info.setMaterialName(mInfo.getName());
        info.setUnit(mInfo.getBaseUnit());
        if (!IndustryUtils.isEmptyString((String)vo.getProjectid())) {
            ProjectInfo proInfo = new ProjectInfo();
            proInfo.setId(BOSUuid.read((String)vo.getProjectid()));
            info.setProject(proInfo);
        }
        if (!IndustryUtils.isEmptyString((String)vo.getTracknumberid())) {
            TrackNumberInfo troInfo = new TrackNumberInfo();
            troInfo.setId(BOSUuid.read((String)vo.getTracknumberid()));
            info.setTrackNumber(troInfo);
        }
        if (!IndustryUtils.isEmptyString((String)entry.getSupplierid())) {
            SupplierInfo suppplierInfo = new SupplierInfo();
            suppplierInfo.setId(BOSUuid.read((String)entry.getSupplierid()));
            info.setSupplier(suppplierInfo);
        }
        if (!IndustryUtils.isEmptyString((String)vo.getWorkcenterID())) {
            WorkCenterInfo workcenter = new WorkCenterInfo();
            workcenter.setId(BOSUuid.read((String)vo.getWorkcenterID()));
            info.setWorkcenter(workcenter);
        }
        if (!IndustryUtils.isEmptyString((String)vo.getOperationID())) {
            OperationInfo operation = new OperationInfo();
            operation.setId(BOSUuid.read((String)vo.getOperationID()));
            info.setOperation(operation);
        }
        if (!IndustryUtils.isEmptyString((String)vo.getCarnumberid())) {
            ProjectJCHInfo projectjch = new ProjectJCHInfo();
            projectjch.setId(BOSUuid.read((String)vo.getCarnumberid()));
            info.setCarnumber(projectjch);
        }
        if (!IndustryUtils.isEmptyString((String)vo.getLocationid())) {
            LocationDefinedInfo locationinfo = new LocationDefinedInfo();
            locationinfo.setId(BOSUuid.read((String)vo.getLocationid()));
            info.setLocation(locationinfo);
        }
        info.setDemandDate(vo.getPlanRecDate());
        info.setDemandQty(qty);
        info.setOrderQty(qty);
        info.setFlow(entry.getFlow());
        info.setWorkShop(vo.getWorkshop());
        info.setDemandid(vo.getSourceid());
        if (!IndustryUtils.isEmptyString((String)entry.getPurGroupid())) {
            PurchaseGroupInfo ginfo = new PurchaseGroupInfo();
            ginfo.setId(BOSUuid.read((String)entry.getPurGroupid()));
            info.setPurGroup(ginfo);
        }
        if (!IndustryUtils.isEmptyString((String)entry.getPurPersonid())) {
            PersonInfo pinfo = new PersonInfo();
            pinfo.setId(BOSUuid.read((String)entry.getPurPersonid()));
            info.setPurPerson(pinfo);
        }
        try {
            info.setDeliveryWareHouse(this.getwh(ctx, entry.getFlow(), entry.getPurtypeid(), vo.getMaterialid(), vo.getStorageorgid()));
            if (info.getDeliveryWareHouse() != null) {
                info.setWmPerson(this.getpr(ctx, vo.getMaterialid(), vo.getStorageorgid(), vo.getProjectid(), info.getDeliveryWareHouse().getId().toString()));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u5339\u914d\u91c7\u8d2d\u5206\u7c7b\u62a5\u9519\uff01" + e.getMessage()), (Throwable)e);
        }
        try {
            String[] str = this.getws(ctx, vo.getMaterialid(), vo.getStorageorgid(), vo.getProjectid());
            info.setWorkShop(str[0]);
            if (str[1] != null) {
                info.setMaterialWorkShop(MaterialWorkShopEnum.getEnum(str[1]));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        info.setDpType(DeliveryPlanType.HOST);
        info.setIsolatedRule(IndustryUtils.isEmptyString((String)vo.getSolatedrule()) ? IsolatedRuleEnum.NONE : IsolatedRuleEnum.getEnum((String)vo.getSolatedrule()));
        String materialid = info.getMaterial() == null ? "" : info.getMaterial().getId().toString();
        String projectid = info.getProject() == null ? "" : info.getProject().getId().toString();
        String trackid = info.getTrackNumber() == null ? "" : info.getTrackNumber().getId().toString();
        String supplierid = info.getSupplier() == null ? "" : info.getSupplier().getId().toString();
        boolean isDirectPlan = DeliveryPlanSingletonFactory.getDirectMaterialSingleton((Context)ctx).isDirectMaterial(materialid, projectid, trackid, supplierid);
        if (isDirectPlan) {
            vo.getConsignmentList().add(info);
        }
    }

    private WarehouseInfo getwh(Context ctx, String flow, String purtypeid, String materialid, String orgid) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        if (IndustryUtils.isEmptyString((String)purtypeid) || IndustryUtils.isEmptyString((String)flow)) {
            sql.setLength(0);
            sql.append(" select Cfwarehouseid from CT_BD_DivisionWarehouse  \n");
            sql.append(" where cfmaterialid = '" + materialid + "' \n");
            sql.append(" and cfstorageorgunitid = '" + orgid + "' \n");
            sql.append("  and Cfdeletedstatus = 1 \n");
            IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String fwhid = null;
            if (irs != null && irs.next()) {
                fwhid = irs.getString("Cfwarehouseid");
            }
            if (!IndustryUtils.isEmptyString(fwhid)) {
                WarehouseInfo whinfo = new WarehouseInfo();
                whinfo.setId(BOSUuid.read((String)fwhid));
                return whinfo;
            }
        } else {
            sql.setLength(0);
            sql.append(" \n");
            sql.append(" select CFDesignatedWareho  \n");
            sql.append(" from CT_PUR_InStoreroomRules \n");
            sql.append(" where 1=1 ");
            if (!IndustryUtils.isEmptyString((String)flow)) {
                sql.append(" and CFFlow = '").append(flow).append("' ");
            }
            sql.append("and CFPurReTypeID = '").append(purtypeid).append("'");
            IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String fwhid = null;
            if (irs != null && irs.next()) {
                fwhid = irs.getString("CFDesignatedWareho");
            }
            if (!IndustryUtils.isEmptyString(fwhid)) {
                WarehouseInfo whinfo = new WarehouseInfo();
                whinfo.setId(BOSUuid.read((String)fwhid));
                return whinfo;
            }
            sql.setLength(0);
            sql.append(" select Cfwarehouseid from CT_BD_DivisionWarehouse  \n");
            sql.append(" where cfmaterialid = '" + materialid + "' \n");
            sql.append(" and cfstorageorgunitid = '" + orgid + "' \n");
            sql.append("  and Cfdeletedstatus = 1 \n");
            irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (irs != null && irs.next()) {
                fwhid = irs.getString("Cfwarehouseid");
            }
            if (!IndustryUtils.isEmptyString((String)fwhid)) {
                WarehouseInfo whinfo = new WarehouseInfo();
                whinfo.setId(BOSUuid.read((String)fwhid));
                return whinfo;
            }
        }
        return null;
    }

    private PersonInfo getpr(Context ctx, String materialid, String orgid, String projectid, String whid) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append(" select sd.cfstorepersonid \n");
        sql.append(" from CT_SC_WorkShopMaterial sw  \n");
        sql.append("  left join CT_PUR_StationDivide sd on sw.CFWorkShopType = sd.CFMaterialWS and sw.CFWorkShop = sd.cflocationdefine \n");
        sql.append("  where sw.cfreceiveorgunitid ='" + orgid + "' \n");
        sql.append("   and sw.cfmaterialid = '" + materialid + "' \n");
        sql.append(" and sd.CFWareHouseID = '").append(whid).append("' \n");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String fwhid = null;
        if (irs != null && irs.next()) {
            fwhid = irs.getString("cfstorepersonid");
        }
        if (!IndustryUtils.isEmptyString(fwhid)) {
            PersonInfo prinfo = new PersonInfo();
            prinfo.setId(BOSUuid.read((String)fwhid));
            return prinfo;
        }
        return null;
    }

    private String[] getws(Context ctx, String materialid, String orgid, String projectid) throws BOSException, SQLException {
        String ws = null;
        String wstype = null;
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append(" select sw.cfworkshop ,sw.cfworkshoptype  \n");
        sql.append(" from CT_SC_WorkShopMaterial sw  \n");
        sql.append("  where sw.cfreceiveorgunitid ='" + orgid + "' \n");
        sql.append("   and sw.cfmaterialid = '" + materialid + "' \n");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Object fwhid = null;
        if (irs != null && irs.next()) {
            ws = irs.getString("cfworkshop");
            wstype = irs.getString("cfworkshoptype");
        }
        String[] str = new String[]{ws, wstype};
        return str;
    }

    private String createTable(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("fpurchasepersonid VARCHAR(44),\r\n");
        sql.append("fpurchasegroupid  VARCHAR(44),\r\n");
        sql.append("cfpurtypeid VARCHAR(44),\r\n");
        sql.append("fsupplierid VARCHAR(44),\r\n");
        sql.append("flow VARCHAR(44),\r\n");
        sql.append("seq INT,\r\n");
        sql.append("bizdate timestamp,\r\n");
        sql.append("orderid VARCHAR(44),\r\n");
        sql.append("entryid VARCHAR(44),\r\n");
        sql.append("purorgid VARCHAR(44),\r\n");
        sql.append("fstorageorgunitid varchar(100), \r\n");
        sql.append("qty NUMERIC(28, 10),\r\n");
        sql.append("actualqty NUMERIC(28, 10),\r\n");
        sql.append("fmaterialid varchar(44),\r\n");
        sql.append("fprojectid varchar(44) ,\r\n");
        sql.append("ftracknoid varchar(44) ,\r\n");
        sql.append("cfendtracknoid varchar(44),\r\n");
        sql.append("frownum LONG );\r\n");
        return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
    }

    private String getTempInsertSql(String TableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(TableName).append("(\r\n");
        sql.append("fpurchasepersonid ,\r\n");
        sql.append("fpurchasegroupid ,\r\n");
        sql.append("cfpurtypeid ,\r\n");
        sql.append("fsupplierid ,\r\n");
        sql.append("seq ,\r\n");
        sql.append("flow ,\r\n");
        sql.append("bizdate ,\r\n");
        sql.append("orderid ,\r\n");
        sql.append("entryid ,\r\n");
        sql.append("qty ,\r\n");
        sql.append("actualqty ,\r\n");
        sql.append("purorgid ,\r\n");
        sql.append("fstorageorgunitid , \r\n");
        sql.append("fmaterialid ,\r\n");
        sql.append("fprojectid  ,\r\n");
        sql.append("ftracknoid ,\r\n");
        sql.append("cfendtracknoid ,\r\n");
        sql.append("frownum ) \r\n");
        return sql.toString();
    }

    static {
        mapPurOrder = new HashMap();
        mapEntryIdTrackNo = new HashMap();
        queryPurOrderSqlAll = " select  h.fpurchasepersonid,h.fpurchasegroupid , h.fsupplierid ,a.fbizdate bizdate,a.fseq seq,a.fparentid orderid,a.FID entryid,a.fqty - a.ftotalreceiveqty qty, \n a.fqty - a.ftotalreceiveqty actualqty,h.fpurchaseorgunitid purorgid,a.fstorageorgunitid,a.fmaterialid,a.fprojectid,a.ftracknoid   \n from t_sm_purorderentry a    \n inner join T_SM_PurOrder h on a.fparentid = h.fid   \n inner join (\n select cfmaterialid ,cfsupplystorageorg     \n from ct_sm_directdeliverydemand           \n group by cfmaterialid ,cfsupplystorageorg\n ) tt\n on a.fmaterialid = tt.cfmaterialid and a.fstorageorgunitid = tt.cfsupplystorageorg\n where A.FBASESTATUS = 4         \n and (a.fqty - a.ftotalreceiveqty) >0     \n order by h.fbizdate\n";
    }
}

