/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.qm.qc.AuditResultEnum;
import com.kingdee.eas.industry.emm.qm.qc.NCRQcBillFactory;
import com.kingdee.eas.industry.emm.qm.qc.NCRreportCollection;
import com.kingdee.eas.industry.emm.qm.qc.NCRreportFactory;
import com.kingdee.eas.industry.emm.qm.qc.NCRreportInfo;
import com.kingdee.eas.industry.emm.qm.qc.NCRtransTypeInfo;
import com.kingdee.eas.industry.webservice.AbstractWsNCRreportFacadeControllerBean;
import com.kingdee.eas.industry.webservice.WSNCRreportInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.ws.ImportException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WsNCRreportFacadeControllerBean
extends AbstractWsNCRreportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.webservice.WsNCRreportFacadeControllerBean");
    public static final String AUDITRESULT = "AUDITRESULT";
    public static final String QTY = "qty";

    @Override
    protected String[] _updateMaterialSerial(Context ctx, String materialNum, boolean isSerial) throws BOSException, EASBizException {
        System.out.print("---------------webservice start updateMaterialSerial-------------------");
        System.out.println(materialNum.getClass() + ":" + materialNum.toString() + ";");
        System.out.println("isSerial:" + isSerial + ";");
        String[] msg = new String[3];
        try {
            if (materialNum == null || materialNum.trim().equals("")) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.webservice.EMMSCMWebserviceResource", (String)"0EMMSCMWebservice-0000", (Locale)ctx.getLocale()));
            }
            int flag = isSerial ? 1 : 0;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)materialNum));
            view.setFilter(filter);
            MaterialCollection materialColl = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
            if (materialColl.size() > 0) {
                String materialId = materialColl.get(0).getId().toString();
                StringBuffer sql = new StringBuffer();
                sql.append("Select Fserialnum From T_Emm_Materialserialnum Where Fmaterial = '").append(materialId).append("'");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet.next()) {
                    sql.delete(0, sql.length());
                    sql.append("Update T_Emm_Materialserialnum Set Fserialnum = ").append(flag).append(" ");
                    sql.append("Where Fmaterial = '").append(materialId).append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                } else {
                    sql.delete(0, sql.length());
                    sql.append("insert into T_Emm_Materialserialnum (Fid, Fmaterial, Fserialnum) values ");
                    sql.append("(newbosId('39322A20'),'").append(materialId).append("',").append(flag).append(")");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                }
            } else {
                String strInfo = ResourceBase.getString((String)"com.kingdee.eas.industry.webservice.EMMSCMWebserviceResource", (String)"SCM_EASBCZWLBM", (Locale)ctx.getLocale(), (Object[])new Object[]{materialNum});
                throw new BOSException(strInfo);
            }
            msg[0] = "Y";
            msg[1] = EASResource.getString((String)"com.kingdee.eas.industry.webservice.EMMSCMWebserviceResource", (String)"0EMMSCMWebservice-0001", (Locale)ctx.getLocale());
            msg[2] = null;
        }
        catch (BOSException e) {
            ImportException excep = new ImportException(new NumericExceptionSubItem("bosException", e.getMessage()));
            msg[0] = "N";
            msg[1] = excep.getMessage();
            msg[2] = null;
            logger.error((Object)excep);
            return msg;
        }
        catch (Exception e) {
            msg[0] = "N";
            msg[1] = e.getMessage();
            msg[2] = null;
            logger.error((Object)e);
            return msg;
        }
        return msg;
    }

    protected void checkAffrimNCR(Context ctx, WSNCRreportInfo wsNCRreportInfo) throws BOSException, EASBizException {
        Boolean isReWork = wsNCRreportInfo.isIsReWork();
        BigDecimal reWorkQty = wsNCRreportInfo.getReWorkQty();
        Boolean isGoBack = wsNCRreportInfo.isIsGoBack();
        BigDecimal goBackQty = wsNCRreportInfo.getGoBackQty();
        Boolean isRelease = wsNCRreportInfo.isIsRelease();
        BigDecimal releaseQty = wsNCRreportInfo.getReleaseQty();
        Boolean isRepair = wsNCRreportInfo.isIsRepair();
        BigDecimal repairQty = wsNCRreportInfo.getRepairQty();
        Boolean isScrap = wsNCRreportInfo.isIsScrap();
        BigDecimal scrapQty = wsNCRreportInfo.getScrapQty();
        int count = 0;
        if (isReWork.booleanValue()) {
            ++count;
        }
        if (isGoBack.booleanValue()) {
            ++count;
        }
        if (isRelease.booleanValue()) {
            ++count;
        }
        if (isRepair.booleanValue()) {
            ++count;
        }
        if (isScrap.booleanValue()) {
            ++count;
        }
        if (count == 0) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.webservice.EMMSCMWebserviceResource", (String)"0EMMSCMWebservice-0002", (Locale)ctx.getLocale()));
        }
        if (isReWork.booleanValue() && (reWorkQty == null || reWorkQty.compareTo(BigDecimal.ZERO) <= 0)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.webservice.EMMSCMWebserviceResource", (String)"0EMMSCMWebservice-0003", (Locale)ctx.getLocale()));
        }
        if (isGoBack.booleanValue() && (goBackQty == null || goBackQty.compareTo(BigDecimal.ZERO) <= 0)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.webservice.EMMSCMWebserviceResource", (String)"0EMMSCMWebservice-0004", (Locale)ctx.getLocale()));
        }
        if (isRelease.booleanValue() && (releaseQty == null || releaseQty.compareTo(BigDecimal.ZERO) <= 0)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.webservice.EMMSCMWebserviceResource", (String)"0EMMSCMWebservice-0005", (Locale)ctx.getLocale()));
        }
        if (isRepair.booleanValue() && (repairQty == null || repairQty.compareTo(BigDecimal.ZERO) <= 0)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.webservice.EMMSCMWebserviceResource", (String)"0EMMSCMWebservice-0006", (Locale)ctx.getLocale()));
        }
        if (isScrap.booleanValue() && (scrapQty == null || scrapQty.compareTo(BigDecimal.ZERO) <= 0)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.webservice.EMMSCMWebserviceResource", (String)"0EMMSCMWebservice-0007", (Locale)ctx.getLocale()));
        }
    }

    @Override
    protected String[] _affrimNCR(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        System.out.print("---------------webservice start affrimNCR-------------------");
        System.out.println(model.getClass() + ":" + model.toString() + ";");
        String[] msg = new String[3];
        String fcu = "00000000-0000-0000-0000-000000000000CCE7AED4";
        UserInfo curUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        if (curUserInfo.getCU() != null) {
            fcu = curUserInfo.getCU().getId().toString();
        }
        try {
            HashMap<String, Object> dataMap;
            WSNCRreportInfo wsNCRreportInfo;
            String ncrQcId;
            if (ContextUtil.getCurrentCtrlUnit((Context)ctx) == null) {
                CtrlUnitInfo cuInfo = new CtrlUnitInfo();
                cuInfo.setId(BOSUuid.read((String)fcu));
                cuInfo.setNumber("1");
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
            }
            if (ContextUtil.getCurrentFIUnit((Context)ctx) == null) {
                CompanyOrgUnitInfo couInfo = new CompanyOrgUnitInfo();
                couInfo.setId(BOSUuid.read((String)fcu));
                couInfo.setNumber("1");
                ContextUtil.setCurrentFIUnit((Context)ctx, (CompanyOrgUnitInfo)couInfo);
            }
            if ((ncrQcId = (wsNCRreportInfo = (WSNCRreportInfo)model).getNcrQcId()) == null && ncrQcId.trim().equals("")) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.webservice.EMMSCMWebserviceResource", (String)"0EMMSCMWebservice-0008", (Locale)ctx.getLocale()));
            }
            this.checkAffrimNCR(ctx, wsNCRreportInfo);
            Boolean isReWork = wsNCRreportInfo.isIsReWork();
            BigDecimal reWorkQty = wsNCRreportInfo.getReWorkQty();
            Boolean isGoBack = wsNCRreportInfo.isIsGoBack();
            BigDecimal goBackQty = wsNCRreportInfo.getGoBackQty();
            Boolean isRelease = wsNCRreportInfo.isIsRelease();
            BigDecimal releaseQty = wsNCRreportInfo.getReleaseQty();
            Boolean isRepair = wsNCRreportInfo.isIsRepair();
            BigDecimal repairQty = wsNCRreportInfo.getRepairQty();
            Boolean isScrap = wsNCRreportInfo.isIsScrap();
            BigDecimal scrapQty = wsNCRreportInfo.getScrapQty();
            ArrayList auditList = new ArrayList();
            if (isReWork.booleanValue()) {
                dataMap = new HashMap<String, Object>();
                dataMap.put(AUDITRESULT, (Object)AuditResultEnum.REWORK);
                dataMap.put(QTY, reWorkQty);
                auditList.add(dataMap);
            }
            if (isGoBack.booleanValue()) {
                dataMap = new HashMap();
                dataMap.put(AUDITRESULT, (Object)AuditResultEnum.GOBACK);
                dataMap.put(QTY, goBackQty);
                auditList.add(dataMap);
            }
            if (isRelease.booleanValue()) {
                dataMap = new HashMap();
                dataMap.put(AUDITRESULT, (Object)AuditResultEnum.RELEASE);
                dataMap.put(QTY, releaseQty);
                auditList.add(dataMap);
            }
            if (isRepair.booleanValue()) {
                dataMap = new HashMap();
                dataMap.put(AUDITRESULT, (Object)AuditResultEnum.REPAIR);
                dataMap.put(QTY, repairQty);
                auditList.add(dataMap);
            }
            if (isScrap.booleanValue()) {
                dataMap = new HashMap();
                dataMap.put(AUDITRESULT, (Object)AuditResultEnum.SCRAP);
                dataMap.put(QTY, scrapQty);
                auditList.add(dataMap);
            }
            for (int i = 0; i < auditList.size(); ++i) {
                Map dataMap2 = (Map)auditList.get(i);
                AuditResultEnum auditEnum = (AuditResultEnum)((Object)dataMap2.get(AUDITRESULT));
                BigDecimal qty = (BigDecimal)dataMap2.get(QTY);
                NCRreportCollection ncrReportColl = NCRreportFactory.getLocalInstance(ctx).getNCRreportCollection("Where sourceBillId = '" + ncrQcId + "'");
                NCRreportInfo ncrReportInfo = ncrReportColl.get(0);
                if (i == 0) {
                    this.updateNCR(ctx, ncrReportInfo, auditEnum, qty);
                    continue;
                }
                this.addNCR(ctx, ncrReportInfo, auditEnum, qty);
            }
            NCRQcBillFactory.getLocalInstance(ctx).audit((IObjectPK)new ObjectUuidPK(ncrQcId));
            msg[0] = "Y";
            msg[1] = EASResource.getString((String)"com.kingdee.eas.industry.webservice.EMMSCMWebserviceResource", (String)"0EMMSCMWebservice-0009", (Locale)ctx.getLocale());
            msg[2] = null;
        }
        catch (BOSException e) {
            ImportException excep = new ImportException(new NumericExceptionSubItem("bosException", e.getMessage()));
            msg[0] = "N";
            msg[1] = excep.getMessage();
            msg[2] = null;
            logger.error((Object)excep);
            return msg;
        }
        catch (Exception e) {
            msg[0] = "N";
            msg[1] = e.getMessage();
            msg[2] = null;
            logger.error((Object)e);
            return msg;
        }
        return msg;
    }

    protected void updateNCR(Context ctx, NCRreportInfo ncrReportInfo, AuditResultEnum auditEnum, BigDecimal qty) throws BOSException, EASBizException {
        NCRtransTypeInfo ncrTransTypeInfo = ncrReportInfo.getTransType();
        ObjectUuidPK pk = new ObjectUuidPK(ncrReportInfo.getId());
        StringBuffer sql = new StringBuffer();
        sql.append("Update T_EMM_NCRREPORT SET FauditResult = '").append(auditEnum.getValue()).append("',");
        sql.append("fqty = ").append(qty);
        if (ncrTransTypeInfo.isIsAudit()) {
            sql.append(",fbasestatus = ").append(15);
        }
        sql.append(" Where fid = '").append(pk.toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        NCRreportFactory.getLocalInstance(ctx).passAudit((IObjectPK)pk, (CoreBillBaseInfo)ncrReportInfo);
    }

    protected void addNCR(Context ctx, NCRreportInfo ncrReportInfo, AuditResultEnum auditEnum, BigDecimal qty) throws BOSException, EASBizException {
        NCRreportInfo newNCRreport = (NCRreportInfo)ncrReportInfo.clone();
        newNCRreport.setId(null);
        String number = NCRreportFactory.getLocalInstance(ctx).getBillNumber(newNCRreport);
        newNCRreport.setNumber(number);
        newNCRreport.setAuditResult(auditEnum);
        newNCRreport.setQty(qty);
        IObjectPK pk = NCRreportFactory.getLocalInstance(ctx).save((CoreBaseInfo)newNCRreport);
        newNCRreport.setBaseStatus(BillBaseStatusEnum.EDITED);
        NCRreportFactory.getLocalInstance(ctx).submit((CoreBaseInfo)newNCRreport);
        NCRtransTypeInfo ncrTransTypeInfo = newNCRreport.getTransType();
        if (ncrTransTypeInfo.isIsAudit()) {
            newNCRreport.setBaseStatus(BillBaseStatusEnum.REVIEWCOMPLETE);
        }
        NCRreportFactory.getLocalInstance(ctx).passAudit(pk, (CoreBillBaseInfo)newNCRreport);
    }
}

