/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.IEquipmentLocationTreeFacade;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.common.core.IGeneCoreTreeBaseInfo;
import com.kingdee.eas.eqm.common.core.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class EquipmentLocationTreeBuilder
implements ITreeBuilder {
    private IEquipmentLocationTreeFacade ctrl;
    private int initalLevel;
    private int expandLevel;
    private FilterInfo filter;
    private FilterInfo defaultFilter;
    private CoreUI ui;
    Icon icon_archives = EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_startupdatacenter", (Locale)SysContext.getSysContext().getLocale());
    Icon icon_location = EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_checkpolicy", (Locale)SysContext.getSysContext().getLocale());

    public EquipmentLocationTreeBuilder(IEquipmentLocationTreeFacade ctrl, int initalLevel, int expandLevel, FilterInfo filter, FilterInfo defaultFilter) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
        this.defaultFilter = defaultFilter;
    }

    public KDTree buildTree(KDTree tree) throws Exception {
        TreeSelectionListener[] selectionListeners;
        if (this.ui != null) {
            this.ui.setCursorOfWair();
        }
        if (tree == null) {
            tree = new KDTree(false);
        }
        if ((selectionListeners = tree.getTreeSelectionListeners()) != null && selectionListeners.length > 0) {
            for (int i = 0; i < selectionListeners.length; ++i) {
                tree.removeTreeSelectionListener(selectionListeners[i]);
            }
        }
        KDTreeNode rootNode = null;
        if (tree.getModel() == null || tree.getModel().getRoot() == null || !(tree.getModel().getRoot() instanceof KDTreeNode)) {
            return null;
        }
        rootNode = (KDTreeNode)tree.getModel().getRoot();
        IObjectCollection col = null;
        col = rootNode.getUserObject() != null && rootNode.getUserObject() instanceof IGeneCoreTreeBaseInfo ? this.ctrl.getChildren((IGeneCoreTreeBaseInfo)rootNode.getUserObject(), this.initalLevel, this.filter) : this.ctrl.getChildren(null, this.initalLevel, this.filter);
        tree.setShowsRootHandles(true);
        this.buildChildren(tree, rootNode, col, this.initalLevel);
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)rootNode);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTree tree = (KDTree)event.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                    if (EquipmentLocationTreeBuilder.this.defaultFilter != null) {
                        EquipmentLocationTreeBuilder.this.getChildren(tree, treeNode, EquipmentLocationTreeBuilder.this.defaultFilter);
                    } else {
                        EquipmentLocationTreeBuilder.this.getChildren(tree, treeNode);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                KDTree tree = (KDTree)e.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)e.getPath().getLastPathComponent();
                    if (EquipmentLocationTreeBuilder.this.defaultFilter != null) {
                        EquipmentLocationTreeBuilder.this.getChildren(tree, treeNode, EquipmentLocationTreeBuilder.this.defaultFilter);
                    } else {
                        EquipmentLocationTreeBuilder.this.getChildren(tree, treeNode);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        if (this.ui != null) {
            this.ui.setCursorOfDefault();
        }
        return tree;
    }

    public KDTree buildTree(KDTree tree, FilterInfo filter, CoreUI ui) throws Exception {
        this.filter = filter;
        this.ui = ui;
        return this.buildTree(tree);
    }

    public KDTree buildTree(KDTree tree, FilterInfo filter) throws Exception {
        this.filter = filter;
        return this.buildTree(tree);
    }

    public void getChildren(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        if (treeNode.isVirtual()) {
            IGeneCoreTreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof IGeneCoreTreeBaseInfo) {
                treeNodeInfo = (IGeneCoreTreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            IObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel, filter);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }

    public void getChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            IGeneCoreTreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof IGeneCoreTreeBaseInfo) {
                treeNodeInfo = (IGeneCoreTreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            IObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode);
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode, filter);
    }

    public void setExpandLevel(int expandLevel) {
        this.expandLevel = expandLevel;
    }

    public void setFilter(FilterInfo filter) {
        this.filter = filter;
    }

    public FilterInfo getFilter() {
        return this.filter;
    }

    private void buildChildren(KDTree tree, KDTreeNode parentNode, IObjectCollection col, int level) {
        if (col == null) {
            return;
        }
        KDTreeNode beforeTreeNode = parentNode;
        IGeneCoreTreeBaseInfo parentNodeInfo = null;
        if (parentNode.getUserObject() instanceof IGeneCoreTreeBaseInfo) {
            parentNodeInfo = (IGeneCoreTreeBaseInfo)parentNode.getUserObject();
        }
        for (IGeneCoreTreeBaseInfo treeNodeInfo : col) {
            int index;
            if (!(parentNodeInfo == null || !treeNodeInfo.getLongNumber().equals(parentNodeInfo.getLongNumber()) || parentNodeInfo instanceof EquipmentLocationInfo && treeNodeInfo instanceof EquipmentArchivesInfo)) {
                parentNode.setUserObject((Object)treeNodeInfo);
                continue;
            }
            KDTreeNode treeNode = new KDTreeNode((Object)treeNodeInfo);
            if (treeNodeInfo instanceof EquipmentLocationInfo) {
                treeNode.setVirtual(true);
                treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
            } else if (treeNodeInfo.isIsLeaf()) {
                treeNode.setVirtual(false);
            } else {
                treeNode.setVirtual(true);
                treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
            }
            if (treeNodeInfo instanceof EquipmentLocationInfo) {
                treeNode.setCustomIcon(this.icon_location);
            } else if (treeNodeInfo instanceof EquipmentArchivesInfo) {
                treeNode.setCustomIcon(this.icon_archives);
            }
            if (beforeTreeNode.getLevel() == 0) {
                index = beforeTreeNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
                beforeTreeNode = treeNode;
                continue;
            }
            if (parentNodeInfo != null && parentNodeInfo instanceof EquipmentLocationInfo && treeNodeInfo instanceof EquipmentArchivesInfo) {
                if ((beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent()).getUserObject() instanceof EquipmentLocationInfo) {
                    beforeTreeNode = parentNode;
                } else {
                    int parentLevel = parentNodeInfo.getLevel();
                    int curLevel = treeNodeInfo.getLevel() + parentLevel;
                    for (int beforeLevel = ((IGeneCoreTreeBaseInfo)beforeTreeNode.getUserObject()).getLevel() + parentLevel; beforeLevel >= curLevel && beforeTreeNode.getParent() != null; --beforeLevel) {
                        beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                    }
                }
            } else {
                int curLevel = treeNodeInfo.getLevel();
                for (int beforeLevel = ((IGeneCoreTreeBaseInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel && beforeTreeNode.getParent() != null; --beforeLevel) {
                    beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                }
            }
            index = beforeTreeNode.getChildCount();
            tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
            beforeTreeNode = treeNode;
        }
    }
}

