/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesEntryFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesEntryInfo;
import com.kingdee.eas.eqm.archives.datatask.DataImportEqmArchivesTools;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportEqmArchivesEntry
extends EQMBaseDataTransmission {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.archives.EquipmentArchivesTransmissionResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentArchivesEntryFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        StorageOrgUnitInfo storageInfo = null;
        EquipmentArchivesEntryInfo info = new EquipmentArchivesEntryInfo();
        Hashtable baseData = hsData;
        String storageOrgNumber = this.getDataString(baseData, "FStorageOrgUnit_number");
        String material_number = this.getDataString(baseData, "FMaterial_number");
        String equipment_number = this.getDataString(baseData, "FEquipment_number");
        String serialNumber = this.getDataString(baseData, "FSerialNumber");
        String qty = this.getDataString(baseData, "FQty");
        String remark = this.getDataString(baseData, "FRemark");
        if (storageOrgNumber == null || "".equals(storageOrgNumber.trim())) {
            throw new TaskExternalException(DataImportEqmArchivesEntry.getResourceMsg("storageOrgUnit_IsNotNull"));
        }
        if (equipment_number == null || "".equals(equipment_number.trim())) {
            throw new TaskExternalException(DataImportEqmArchivesEntry.getResourceMsg("equipment_IsNotNull"));
        }
        if (material_number == null || "".equals(material_number.trim())) {
            throw new TaskExternalException(DataImportEqmArchivesEntry.getResourceMsg("entrys_IsNotNull"));
        }
        if (qty == null || "".equals(qty.trim())) {
            throw new TaskExternalException(DataImportEqmArchivesEntry.getResourceMsg("qty_IsNotNull"));
        }
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)serialNumber, (String)DataImportEqmArchivesEntry.getResourceMsg("serialNumber"), (int)30);
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)remark, (String)DataImportEqmArchivesEntry.getResourceMsg("remark"), (int)100);
        this.isAuthorizedOrgUnit(ctx, storageOrgNumber);
        try {
            storageInfo = DataImportTools.getStorageOrgUnitInfoFromNumber((Context)ctx, (String)storageOrgNumber);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        info = DataImportEqmArchivesTools.getEquipmentArchivesEntryInfo(ctx, equipment_number, material_number, storageInfo.getId().toString());
        int precision = info.getMaterial().getBaseUnit().getQtyPrecision();
        BigDecimal num = DataImportEqmTools.getNumByPrecision((String)qty, (int)precision, (String)DataImportEqmArchivesEntry.getResourceMsg("qty"), (boolean)true, (boolean)false);
        info.setQty(num);
        info.setRemark(remark);
        info.setSerialNumbe(serialNumber);
        return info;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.archives.app.ExpEquipmentArchivesEntryQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("meterQuery");
        return viewInfo.getFilter();
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            int description = Integer.parseInt(rs.getString("entrys.unit.qtyPrecision") != null ? rs.getString("entrys.unit.qtyPrecision") : "4");
            this.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FStorageOrgUnit_name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FEquipment_number", rs.getString("number"));
            this.putTable(result, "FEquipment_name", rs.getString("name"));
            this.putTable(result, "FMaterial_number", rs.getString("entrys.number"));
            this.putTable(result, "FMaterial_name", rs.getString("entrys.name"));
            this.putTable(result, "FMaterial_model", rs.getString("entrys.model"));
            this.putTable(result, "FSerialNumber", rs.getString("entrys.serialNumber"));
            this.putTable(result, "FUnit_number", rs.getString("entrys.unit.number"));
            this.putTable(result, "FUnit_name", rs.getString("entrys.unit.name"));
            String qty = DataImportEqmTools.getNumByPrecision((String)rs.getString("entrys.qty"), (int)description);
            this.putTable(result, "FQty", qty);
            this.putTable(result, "FRemark", rs.getString("entrys.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected String getImportPermItemName() {
        return "eqm_equipmentarchives_13import";
    }

    public static String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RESOURCE_PATH, (String)key);
    }
}

