/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.basedata.EQMBaseDataException;
import com.kingdee.eas.eqm.basedata.EqmClassTeamFactory;
import com.kingdee.eas.eqm.basedata.EqmClassTeamFrequencyInfo;
import com.kingdee.eas.eqm.basedata.EqmClassTeamInfo;
import com.kingdee.eas.eqm.basedata.client.AbstractEqmClassTeamEditUI;
import com.kingdee.eas.eqm.common.core.GeneCheckedStatusEnum;
import com.kingdee.eas.eqm.common.core.codingrule.GeneCodingRuleData;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class EqmClassTeamEditUI
extends AbstractEqmClassTeamEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EqmClassTeamEditUI.class);
    private static final String TB_STARTTIME = "startTime";
    private static final String TB_ENDTIME = "endTime";
    private static final String TB_RESTSTART = "restStart";
    private static final String TB_RESTEND = "restEnd";
    private static final String TB_TIMES = "workHours";
    private static final String TB_NUM = "number";
    private static final String TB_NAME = "name";
    private static final String TB_ISREST = "isRest";
    private static final String TIME_FORMAT = CtrlFormatUtilities.getTimeFormatString();
    private KDTEditAdapter entryTableChange;
    private KDTSelectListener kdtEntryTableSelected;
    private static final String EQMCLASSTEAM_RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.EquipmentClassTeamResource";
    private GeneCodingRuleData codingRuleData = null;

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtStorageOrgUnit, null, (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
        KDTimePicker tpStartTime = new KDTimePicker();
        tpStartTime.setTimePattern("HH:mm:ss");
        this.kdtFrequency.getColumn(TB_STARTTIME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)tpStartTime));
        this.kdtFrequency.getColumn(TB_STARTTIME).getStyleAttributes().setNumberFormat(TIME_FORMAT);
        KDTimePicker tpEndTime = new KDTimePicker();
        tpEndTime.setTimePattern("HH:mm:ss");
        this.kdtFrequency.getColumn(TB_ENDTIME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)tpEndTime));
        this.kdtFrequency.getColumn(TB_ENDTIME).getStyleAttributes().setNumberFormat(TIME_FORMAT);
        KDTimePicker tpRestStart = new KDTimePicker();
        tpRestStart.setTimePattern("HH:mm:ss");
        this.kdtFrequency.getColumn(TB_RESTSTART).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)tpRestStart));
        this.kdtFrequency.getColumn(TB_RESTSTART).getStyleAttributes().setNumberFormat(TIME_FORMAT);
        KDTimePicker tpRestEnd = new KDTimePicker();
        tpRestEnd.setTimePattern("HH:mm:ss");
        this.kdtFrequency.getColumn(TB_RESTEND).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)tpRestEnd));
        this.kdtFrequency.getColumn(TB_RESTEND).getStyleAttributes().setNumberFormat(TIME_FORMAT);
        this.prmtStorageOrgUnit.setEnabled(true);
        this.kdtFrequency.setColumnMoveable(true);
        this.kdtFrequency.setActiveCellStatus(1);
        this.kdtFrequency.getActionMap().remove("AddRow");
        this.kdtFrequency.getActionMap().remove("RemoveRow");
        this.kdtFrequency.getActionMap().remove("Delete");
        this.kdtFrequency.getActionMap().remove("Paste");
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDContainer1.getContentPane().removeAll();
        this.kDContainer1.getContentPane().add((Component)this.kdtFrequency, "Center");
    }

    protected void initListener() {
        super.initListener();
        if (this.entryTableChange != null) {
            this.kdtFrequency.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
        this.entryTableChange = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    EqmClassTeamEditUI.this.kdtFrequency_editStopped(e);
                }
                catch (Exception exc) {
                    EqmClassTeamEditUI.this.handUIException(exc);
                }
            }
        };
        this.kdtFrequency.addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.kdtEntryTableSelected != null) {
            this.kdtFrequency.removeKDTSelectListener(this.kdtEntryTableSelected);
        }
        this.kdtEntryTableSelected = new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                EqmClassTeamEditUI.this.kdtFrequency_Selected(e);
            }
        };
        this.kdtFrequency.addKDTSelectListener(this.kdtEntryTableSelected);
        this.kdtFrequency.addKDTActiveCellListener(new KDTActiveCellListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void activeCellChanged(KDTActiveCellEvent e) {
                try {
                    EqmClassTeamEditUI.this.kdtMain_activeCellChanged(e);
                }
                catch (Exception exc) {
                    EqmClassTeamEditUI.this.handUIException(exc);
                }
            }
        });
        KDCheckBox isRestBox = (KDCheckBox)this.kdtFrequency.getColumn(TB_ISREST).getEditor().getComponent();
        isRestBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EqmClassTeamEditUI.this.isRest_changed(e);
            }
        });
    }

    protected void isRest_changed(ItemEvent e) {
        int selectedRowIndex = this.kdtFrequency.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            return;
        }
        IRow row = this.kdtFrequency.getRow(selectedRowIndex);
        Boolean oldValue = (Boolean)row.getCell(TB_ISREST).getValue();
        if (Boolean.FALSE.equals(oldValue == false)) {
            row.getCell(TB_RESTSTART).setValue(null);
            row.getCell(TB_RESTEND).setValue(null);
        } else {
            this.setTimeFieldStatus();
        }
    }

    protected void kdtFrequency_Selected(KDTSelectEvent e) {
        if (this.kdtFrequency.getSelectManager().getActiveRowIndex() == -1) {
            return;
        }
        KDTSelectBlock selectBlock = e.getSelectBlock();
        int beginRow = selectBlock.getBeginRow();
        int endRow = selectBlock.getEndRow();
        int beginColumn = selectBlock.getBeginCol();
        int endColumn = selectBlock.getEndCol();
        if (beginRow != endRow || beginColumn != endColumn) {
            return;
        }
        this.checkSelectedDateTime(beginRow, beginColumn);
    }

    private void kdtFrequency_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = this.kdtFrequency.getSelectManager().getActiveRowIndex();
        int colIndex = this.kdtFrequency.getSelectManager().getActiveColumnIndex();
        String fieldName = this.kdtFrequency.getColumnKey(colIndex);
        this.checkDateTime(rowIndex, colIndex, fieldName);
    }

    private void checkSelectedDateTime(int rowIndex, int colIndex) {
        Date startTime = (Date)this.kdtFrequency.getRow(rowIndex).getCell(TB_STARTTIME).getValue();
        Date endTime = (Date)this.kdtFrequency.getRow(rowIndex).getCell(TB_ENDTIME).getValue();
        Date startRestTime = (Date)this.kdtFrequency.getRow(rowIndex).getCell(TB_RESTSTART).getValue();
        if (null == startTime || null == endTime) {
            return;
        }
        if ((null != startTime || null != endTime) && Boolean.TRUE.equals((Boolean)this.kdtFrequency.getRow(rowIndex).getCell(TB_ISREST).getValue())) {
            this.kdtFrequency.getRow(rowIndex).getCell(TB_RESTSTART).getStyleAttributes().setLocked(false);
        }
        if (null != startRestTime && Boolean.TRUE.equals((Boolean)this.kdtFrequency.getRow(rowIndex).getCell(TB_ISREST).getValue())) {
            this.kdtFrequency.getRow(rowIndex).getCell(TB_RESTEND).getStyleAttributes().setLocked(false);
        }
    }

    private void checkDateTime(int rowIndex, int colIndex, String fieldName) {
        Object obj;
        if ((TB_STARTTIME.equalsIgnoreCase(fieldName) || TB_ENDTIME.equalsIgnoreCase(fieldName) || TB_RESTSTART.equalsIgnoreCase(fieldName) || TB_RESTEND.equalsIgnoreCase(fieldName)) && (obj = this.kdtFrequency.getRow(rowIndex).getCell(fieldName).getValue()) != null) {
            this.kdtFrequency.getRow(rowIndex).getCell(fieldName).setValue((Object)this.cutSecond((Date)obj));
            long lStartTime = 0L;
            long lEndTime = 0L;
            long lStartRestTime = 0L;
            long lEndRestTime = 0L;
            Date startTime = (Date)this.kdtFrequency.getRow(rowIndex).getCell(TB_STARTTIME).getValue();
            Date endTime = (Date)this.kdtFrequency.getRow(rowIndex).getCell(TB_ENDTIME).getValue();
            Date startRestTime = (Date)this.kdtFrequency.getRow(rowIndex).getCell(TB_RESTSTART).getValue();
            Date endRestTime = (Date)this.kdtFrequency.getRow(rowIndex).getCell(TB_RESTEND).getValue();
            double restTimes = 0.0;
            if (null == startTime || null == endTime) {
                return;
            }
            if (null != startRestTime) {
                lStartTime = this.cutDay(startTime);
                lEndTime = this.cutDay(endTime);
                lStartRestTime = this.cutDay(startRestTime);
                if (endRestTime != null) {
                    lEndRestTime = this.cutDay(endRestTime);
                }
                if (lStartTime >= lEndTime) {
                    lEndTime += 1440L;
                }
                if (lStartRestTime < lStartTime) {
                    lStartRestTime += 1440L;
                }
                if (lStartRestTime >= lStartTime && lStartRestTime <= lEndTime) {
                    if (Boolean.TRUE.equals((Boolean)this.kdtFrequency.getRow(rowIndex).getCell(TB_ISREST).getValue())) {
                        this.kdtFrequency.getRow(rowIndex).getCell(TB_RESTEND).getStyleAttributes().setLocked(false);
                    }
                    if (endRestTime != null) {
                        if (lEndRestTime < lStartTime) {
                            lEndRestTime += 1440L;
                        }
                        if (lEndRestTime < lStartRestTime || lEndRestTime > lEndTime) {
                            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)EQMCLASSTEAM_RESOURCE_PATH, (String)"EndRestTimeError"));
                            this.kdtFrequency.getRow(rowIndex).getCell(TB_RESTEND).setValue(null);
                            startRestTime = null;
                        }
                    }
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)EQMCLASSTEAM_RESOURCE_PATH, (String)"StartRestTimeError"));
                    this.kdtFrequency.getRow(rowIndex).getCell(TB_RESTEND).setValue(null);
                    this.kdtFrequency.getRow(rowIndex).getCell(TB_RESTSTART).setValue(null);
                    endRestTime = null;
                    startRestTime = null;
                }
            }
            if (startRestTime != null && endRestTime != null) {
                restTimes = endRestTime.getTime() - startRestTime.getTime();
            }
            if (startTime != null && endTime != null) {
                if (Boolean.TRUE.equals((Boolean)this.kdtFrequency.getRow(rowIndex).getCell(TB_ISREST).getValue())) {
                    this.kdtFrequency.getRow(rowIndex).getCell(TB_RESTSTART).getStyleAttributes().setLocked(false);
                }
                if (Boolean.FALSE.equals((Boolean)this.kdtFrequency.getRow(rowIndex).getCell(TB_ISREST).getValue())) {
                    restTimes = 0.0;
                }
                double times = ((double)(endTime.getTime() - startTime.getTime()) - restTimes) / 3600000.0;
                NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
                times = Double.valueOf(df.format(new Double(times)));
                if (times < 0.01) {
                    times += 24.0;
                }
                if (startTime != null && endTime != null && startRestTime != null && endRestTime != null && startTime.getTime() == startRestTime.getTime() && endTime.getTime() == endRestTime.getTime()) {
                    times = 0.0;
                }
                this.kdtFrequency.getRow(rowIndex).getCell(TB_TIMES).setValue((Object)new BigDecimal(times));
            }
        }
    }

    private void setTimeFieldStatus() {
        if ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState())) {
            for (int i = 0; i < this.kdtFrequency.getRowCount(); ++i) {
                Date startTime = (Date)this.kdtFrequency.getRow(i).getCell(TB_STARTTIME).getValue();
                Date endTime = (Date)this.kdtFrequency.getRow(i).getCell(TB_ENDTIME).getValue();
                Date startRestTime = (Date)this.kdtFrequency.getRow(i).getCell(TB_RESTSTART).getValue();
                if (startTime != null && endTime != null) {
                    if (startRestTime != null) continue;
                    this.kdtFrequency.getCell(i, TB_RESTEND).getStyleAttributes().setLocked(true);
                    continue;
                }
                this.kdtFrequency.getCell(i, TB_RESTSTART).getStyleAttributes().setLocked(true);
                this.kdtFrequency.getCell(i, TB_RESTEND).getStyleAttributes().setLocked(true);
            }
        }
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        this.setTimeFieldStatus();
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
        this.setTimeFieldStatus();
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) {
        try {
            KDTSelectManager selectManger = this.kdtFrequency.getSelectManager();
            ArrayList blocks = selectManger.getBlocks();
            int rowCount = 0;
            for (int i = 0; i < blocks.size(); ++i) {
                KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
                rowCount += block.getEndRow() - block.getBeginRow() + 1;
            }
            if (this.kdtFrequency.getRowCount() == 1 || rowCount == this.kdtFrequency.getRowCount()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)EQMCLASSTEAM_RESOURCE_PATH, (String)"RemoveLineWarn"));
                SysUtil.abort();
            }
            super.actionRemoveLine_actionPerformed(e);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.isSubmitAction(e) && this.kdtFrequency.getRowCount() != 0) {
            String errorInfo = "";
            for (int i = 0; i < this.kdtFrequency.getRowCount(); ++i) {
                if (this.kdtFrequency.getRow(i).getCell(TB_RESTSTART).getValue() == null || this.kdtFrequency.getRow(i).getCell(TB_RESTEND).getValue() != null) continue;
                errorInfo = errorInfo + MessageFormat.format(EASResource.getString((String)EQMCLASSTEAM_RESOURCE_PATH, (String)"REST_ENDTIME_WARN"), "" + (i + 1)) + "\n";
            }
            if (!"".equals(errorInfo)) {
                MsgBox.showInfo((Component)((Object)this), (String)errorInfo);
                SysUtil.abort();
            }
        }
    }

    protected boolean isSubmitAction(ActionEvent e) {
        if (e != null) {
            ItemAction action = this.getActionFromActionEvent(e);
            return action.equals(this.actionSubmit);
        }
        return false;
    }

    private Date cutSecond(Date date) {
        long time = date.getTime() - date.getTime() % 60000L;
        return new Date(time);
    }

    private long cutDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        long minutes = calendar.get(11) * 60 + calendar.get(12);
        return minutes;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EqmClassTeamFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        return this.doCreateNewData(null);
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        EqmClassTeamFrequencyInfo info = new EqmClassTeamFrequencyInfo();
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = this.getInnerSelectors();
        sic.add(new SelectorItemInfo("CU.id"));
        return sic;
    }

    protected IObjectValue newInstanceData() {
        EqmClassTeamInfo info = new EqmClassTeamInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        info.setCheckedStatus(GeneCheckedStatusEnum.getEnum((int)1));
        EqmClassTeamFrequencyInfo frequency = new EqmClassTeamFrequencyInfo();
        info.getFrequency().add(frequency);
        return info;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            KDTEditManager editManager = this.kdtFrequency.getEditManager();
            for (int i = 0; i < this.kdtFrequency.getRowCount() - 1; ++i) {
                IRow row = this.kdtFrequency.getRow(i);
                for (int j = i + 1; j < this.kdtFrequency.getRowCount(); ++j) {
                    IRow rowCpr = this.kdtFrequency.getRow(j);
                    if (row.getCell(TB_NUM).getValue() == null || row.getCell(TB_NUM).getValue().equals(rowCpr.getCell(TB_NUM).getValue())) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)EQMCLASSTEAM_RESOURCE_PATH, (String)"DuplicateFrequencyNum"));
                        editManager.editCellAt(i, row.getCell(TB_NUM).getColumnIndex());
                        SysUtil.abort();
                    }
                    if (row.getCell(TB_NAME).getValue() != null && !row.getCell(TB_NAME).getValue().equals(rowCpr.getCell(TB_NAME).getValue())) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)EQMCLASSTEAM_RESOURCE_PATH, (String)"DuplicateFrequencyName"));
                    editManager.editCellAt(i, row.getCell(TB_NAME).getColumnIndex());
                    SysUtil.abort();
                }
            }
            super.actionSubmit_actionPerformed(e);
        }
        catch (EQMBaseDataException ex) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)EQMCLASSTEAM_RESOURCE_PATH, (String)"SystemTimeMustNotOver24H"));
        }
    }

    protected void kdtMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        if (!"VIEW".equals(this.getOprtState())) {
            if (e.getRowIndex() == -1) {
                return;
            }
            IRow row = this.kdtFrequency.getRow(e.getRowIndex());
            if (e.getColumnIndex() == this.kdtFrequency.getColumnIndex(TB_ISREST)) {
                Boolean oldValue = (Boolean)row.getCell(TB_ISREST).getValue();
                row.getCell(TB_ISREST).setValue((Object)new Boolean(oldValue == false));
            }
            if (row.getCell(TB_ISREST).getValue() != null) {
                if (Boolean.TRUE.equals((Boolean)row.getCell(TB_ISREST).getValue())) {
                    this.setTimeFieldStatus();
                } else {
                    row.getCell(TB_RESTSTART).setValue(null);
                    row.getCell(TB_RESTEND).setValue(null);
                    this.checkDateTime(row.getRowIndex(), row.getCell(TB_ENDTIME).getColumnIndex(), TB_ENDTIME);
                    row.getCell(TB_RESTSTART).getStyleAttributes().setLocked(true);
                    row.getCell(TB_RESTEND).getStyleAttributes().setLocked(true);
                }
            }
        }
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        super.loadLineFields(table, row, obj);
        if (!"VIEW".equals(this.getOprtState())) {
            row.getCell(TB_RESTSTART).getStyleAttributes().setLocked(false);
            row.getCell(TB_RESTEND).getStyleAttributes().setLocked(false);
        }
    }
}

