/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.client.AbstractIsolationTempFilterUI;
import com.kingdee.eas.eqm.common.core.filter.CompositeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.SingleFilterElement;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.eas.eqm.common.eqmcore.client.util.ControlledItems;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import java.awt.Component;
import org.apache.log4j.Logger;

public class IsolationTempFilterUI
extends AbstractIsolationTempFilterUI {
    private static final long serialVersionUID = -3518678112151867547L;
    private static final Logger logger = CoreUIObject.getLogger(IsolationTempFilterUI.class);

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        rootElement.add((IFilterElement)new SingleFilterElement("assets.eqmArchives.id", (Component)this.prmtEquipment));
        rootElement.add((IFilterElement)new SingleFilterElement("assets.location.id", (Component)this.prmtLocation));
        rootElement.add((IFilterElement)new SingleFilterElement("isolationType.id", (Component)this.prmtIsolationType));
        rootElement.add((IFilterElement)new SingleFilterElement("id", (Component)this.prmtIsolationTemp));
    }

    protected void initListener() {
        super.initListener();
        this.prmtLocation.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    IsolationTempFilterUI.this.prmtEquipmentLocation_dataChanged(e);
                }
                catch (Exception exc) {
                    IsolationTempFilterUI.this.handUIException(exc);
                }
            }
        });
        this.prmtEquipment.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    IsolationTempFilterUI.this.prmtEquipmentArchives_dataChanged(e);
                }
                catch (Exception exc) {
                    IsolationTempFilterUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void prmtEquipmentArchives_dataChanged(DataChangeEvent e) throws Exception {
        EquipmentArchivesInfo newObject = (EquipmentArchivesInfo)e.getNewValue();
        if (null != newObject) {
            EquipmentLocationInfo equipmentLocation = newObject.getLocation();
            if (equipmentLocation == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("location.id"));
                sic.add(new SelectorItemInfo("location.number"));
                sic.add(new SelectorItemInfo("location.name"));
                try {
                    EquipmentArchivesInfo remoteInfo = (EquipmentArchivesInfo)EquipmentArchivesFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(newObject.getId().toString()), sic);
                    if (remoteInfo.getLocation() != null) {
                        equipmentLocation = remoteInfo.getLocation();
                    }
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                }
            }
            if (equipmentLocation == null) {
                this.prmtLocation.setDataNoNotify(null);
            } else {
                this.prmtLocation.setDataNoNotify((Object)equipmentLocation);
                if (this.prmtOrgUnit.getValue() != null) {
                    String storageOrg = ((OrgUnitInfo)this.prmtOrgUnit.getValue()).getId().toString();
                    this.filterArchivesByLocation(equipmentLocation, storageOrg);
                }
            }
        }
    }

    protected void prmtEquipmentLocation_dataChanged(DataChangeEvent e) throws Exception {
        EquipmentLocationInfo newObject = (EquipmentLocationInfo)e.getNewValue();
        if (GeneEqualsUtils.equals((Object)e.getOldValue(), (Object)e.getNewValue())) {
            return;
        }
        if (null != newObject) {
            this.prmtEquipment.setValue(null);
        }
        if (this.prmtOrgUnit.getValue() != null) {
            String storageOrg = ((OrgUnitInfo)this.prmtOrgUnit.getValue()).getId().toString();
            this.filterArchivesByLocation(newObject, storageOrg);
        }
    }

    public FilterInfo getFilterInfo() {
        if (super.getFilterInfo() == null) {
            return null;
        }
        FilterInfo filter = super.getFilterInfo();
        EquipmentArchivesInfo archivesInfo = (EquipmentArchivesInfo)this.prmtEquipment.getValue();
        EquipmentLocationInfo locationInfo = (EquipmentLocationInfo)this.prmtLocation.getValue();
        FilterInfo appendFilterInfo = new FilterInfo();
        if (null != archivesInfo) {
            appendFilterInfo.getFilterItems().add(new FilterItemInfo("assets.eqmArchives.id", (Object)archivesInfo.getId().toString()));
        }
        if (null == archivesInfo && null != locationInfo) {
            appendFilterInfo.getFilterItems().add(new FilterItemInfo("assets.location.id", (Object)locationInfo.getId().toString()));
            appendFilterInfo.getFilterItems().add(new FilterItemInfo("assets.eqmArchives.id", null));
            appendFilterInfo.setMaskString("#0 AND #1");
        }
        try {
            if (filter != null) {
                filter.mergeFilter(appendFilterInfo, "AND");
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (filter != null) {
            return filter;
        }
        return appendFilterInfo;
    }

    public KDBizPromptBox getMainBizOrg() {
        return this.prmtOrgUnit;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtOrgUnit;
    }

    protected void setDefaultValue() {
        OrgUnitInfo defaultOrgUnit = this.getDefaultMainBizOrg();
        this.prmtOrgUnit.setValue((Object)defaultOrgUnit);
    }

    public ControlledItems[] getNeedMainOrgControl() {
        return new ControlledItems[]{new ControlledItems(this.prmtIsolationTemp, "storageOrgUnit.id")};
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        try {
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtIsolationType, (String)"com.kingdee.eas.eqm.basedata.app.F7IsolationTypeQuery", (String[])new String[]{"checkedStatus"}, (Object[])new Object[]{new Integer(2)});
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo org) {
        super.afterMainOrgChanged(oldOrg, org);
        try {
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipment, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery", (String[])new String[]{"planOrgUnit.id", "initial", "bizStatus"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString(), Boolean.TRUE, new Integer(10)}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS, CompareType.EQUALS});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtLocation, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentLocationQuery", (String[])new String[]{"planOrgUnit.id", "checkedStatus"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString(), new Integer(2)}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS});
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    protected void filterArchivesByLocation(EquipmentLocationInfo location, String storageOrgUnitID) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("initial", (Object)Boolean.TRUE, CompareType.EQUALS));
        items.add(new FilterItemInfo("bizStatus", (Object)new Integer(10), CompareType.EQUALS));
        items.add(new FilterItemInfo("planOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        items.add(new FilterItemInfo("maintainOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        items.add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        if (location != null) {
            items.add(new FilterItemInfo("location.id", (Object)location.getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and (#2 or #3 or #4) and #5");
        } else {
            filter.setMaskString("#0 and #1 and (#2 or #3 or #4)");
        }
        view.setFilter(filter);
        this.prmtEquipment.setEntityViewInfo(view);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("planOrgUnit.*"));
        selector.add(new SelectorItemInfo("maintainOrgUnit.*"));
        selector.add(new SelectorItemInfo("maintainDept.*"));
        selector.add(new SelectorItemInfo("location.*"));
        selector.add(new SelectorItemInfo("*"));
        this.prmtEquipment.setSelectorCollection(selector);
    }
}

