/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentDangerActionCollection;
import com.kingdee.eas.eqm.basedata.EquipmentDangerActionInfo;
import com.kingdee.eas.eqm.basedata.EquipmentDangerFactory;
import com.kingdee.eas.eqm.basedata.EquipmentDangerInfo;
import com.kingdee.eas.eqm.basedata.EquipmentDangerMaterialCollection;
import com.kingdee.eas.eqm.basedata.EquipmentDangerMaterialInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.SecurityPlanAssetInfo;
import com.kingdee.eas.eqm.basedata.SecurityPlanDangerCollection;
import com.kingdee.eas.eqm.basedata.SecurityPlanDangerInfo;
import com.kingdee.eas.eqm.basedata.SecurityPlanFactory;
import com.kingdee.eas.eqm.basedata.SecurityPlanInfo;
import com.kingdee.eas.eqm.basedata.client.AbstractSecurityPlanEditUI;
import com.kingdee.eas.eqm.common.core.GeneCodingRuleManageFacadeFactory;
import com.kingdee.eas.eqm.common.core.GeneUsableStatusEnum;
import com.kingdee.eas.eqm.common.core.IGeneDataBase;
import com.kingdee.eas.eqm.common.core.client.listener.AbstractGeneTableColumnListener;
import com.kingdee.eas.eqm.common.core.client.listener.GeneKDTable;
import com.kingdee.eas.eqm.common.core.client.listener.GeneTableColumnListener;
import com.kingdee.eas.eqm.common.core.codingrule.GeneCodingRuleData;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.framework.client.multiDetail.HMDUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SecurityPlanEditUI
extends AbstractSecurityPlanEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SecurityPlanEditUI.class);
    private static final String SECURITYPLAN_RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.SecurityPlanResource";
    private static final String PROP_GENRESOURCE_FILE = "com.kingdee.eas.eqm.common.core.GeneResource";
    private static final String PROP_FORBIDDEN = ".forbidden";
    private static final String PROP_USE = ".use";
    private static final String ARCHIVEQUERY = "com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery";
    private GeneCodingRuleData codingRuleData = null;
    public static final String COL_ARCHIVES = "eqmArchives";
    public static final String COL_ARCHIVESNAME = "eqmArchivesName";
    public static final String COL_ARCHIVESTYPE = "eqmCategory";
    public static final String COL_ARCHIVESSTATUS = "eqmStatus";
    public static final String COL_LOCATION = "eqmLocation";
    public static final String COL_LOCATIONNAME = "eqmLocationName";
    public static final String COL_LOCATIONREMARK = "eqmremark";
    public static final String COL_DANGER = "eqmDanger";
    public static final String COL_DANGERNAME = "eqmDangerName";
    public static final String COL_DANGERTYPE = "dangerType";
    public static final String COL_DANGERREMARK = "eqmremark";
    public static final String COL_ACTION = "actionNumber";
    public static final String COL_ACTIONNUMBER = "actionNumber";
    public static final String COL_ACTIONNAME = "actionName";
    public static final String COL_ACTIONREMARK = "actionremark";
    public static final String COL_MATERIALNUMBER = "materialNumber";
    public static final String COL_MATERIALNAME = "materialName";
    public static final String COL_MATERIALREMARK = "materialremark";
    public static final String COL_MATERIALMODEL = "materialModel";
    private GeneKDTable geneKdtAssets = new GeneKDTable(this.kdtAssets);
    private GeneKDTable geneKdtDanger = new GeneKDTable(this.kdtDanger);
    private GeneTableColumnListener eqmArchivesListener = null;
    private GeneTableColumnListener eqmLocationListener = null;
    private GeneTableColumnListener eqmDangerListener = null;
    int rowIndex_ = 0;
    int colIndex_ = 0;

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SecurityPlanFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        return this.doCreateNewData(null);
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected IObjectValue newInstanceData() {
        SecurityPlanInfo info = new SecurityPlanInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        info.setUsableStatus(GeneUsableStatusEnum.UNCHECKED);
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        super.getSelectors();
        SelectorItemCollection sic = this.getInnerSelectors();
        sic.add("danger.eqmDanger.*");
        sic.add("danger.eqmDanger.dangerType.name");
        sic.add("danger.eqmDanger.action.*");
        sic.add("danger.eqmDanger.material.*");
        sic.add(new SelectorItemInfo("usableStatus"));
        sic.add(new SelectorItemInfo("assets.eqmArchives.category.*"));
        sic.add(new SelectorItemInfo("assets.eqmArchives.bizStatus"));
        return sic;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.initCustomerUIContentLayout();
    }

    protected void initCustomerUIContentLayout() {
        this.buildPlanPanel();
        this.adjustLayoutPanel();
    }

    private void buildPlanPanel() {
        this.addTableToolbar("kdtAssets_detailPanel", this.pnlAsssets, this.kdtAssets);
        this.addTableToolbar("kdtDanger_detailPanel", this.pnlDangerEntry, this.kdtDanger);
    }

    private void adjustLayoutPanel() {
        this.pnlAsssets.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 987, 400));
        this.pnlDangerEntry.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 987, 400));
    }

    protected void addTableToolbar(String detailPanelName, KDPanel container, KDTable table) {
        int i;
        container.removeAll();
        DetailPanel detailPanel = (DetailPanel)HMDUtils.buildDetail((CoreUI)this, (DataBinder)this.dataBinder, (KDTable)table, (AbstractObjectValue)((AbstractObjectValue)this.createNewDetailData(table)), null, (boolean)false);
        detailPanel.setName(detailPanelName);
        container.add((Component)detailPanel);
        KDTableUtils.setEntryTitleVisible((DetailPanel)detailPanel, (boolean)false);
        ActionListener[] oldListeners = detailPanel.getAddNewLineButton().getActionListeners();
        for (i = 0; i < oldListeners.length; ++i) {
            detailPanel.getAddNewLineButton().removeActionListener(oldListeners[i]);
        }
        detailPanel.getAddNewLineButton().addActionListener((ActionListener)this.actionAddLine);
        oldListeners = detailPanel.getInsertLineButton().getActionListeners();
        for (i = 0; i < oldListeners.length; ++i) {
            detailPanel.getInsertLineButton().removeActionListener(oldListeners[i]);
        }
        detailPanel.getInsertLineButton().addActionListener((ActionListener)this.actionInsertLine);
        oldListeners = detailPanel.getRemoveLinesButton().getActionListeners();
        for (i = 0; i < oldListeners.length; ++i) {
            detailPanel.getRemoveLinesButton().removeActionListener(oldListeners[i]);
        }
        detailPanel.getRemoveLinesButton().addActionListener((ActionListener)this.actionRemoveLine);
        try {
            Field detailPanelField = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(detailPanelName);
            detailPanelField.set((Object)this, detailPanel);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void registerCustomerBindings() {
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtPlanOrgUnit, null, (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
        this.kdtAssets.setColumnMoveable(true);
        this.kdtAssets.setActiveCellStatus(1);
        this.kdtAssets.getActionMap().remove("AddRow");
        this.kdtAssets.getActionMap().remove("RemoveRow");
        this.kdtAssets.getActionMap().remove("Delete");
        this.kdtAssets.getActionMap().remove("Paste");
        this.kdtDanger.setColumnMoveable(true);
        this.kdtDanger.setActiveCellStatus(1);
        this.kdtDanger.getActionMap().remove("AddRow");
        this.kdtDanger.getActionMap().remove("RemoveRow");
        this.kdtDanger.getActionMap().remove("Delete");
        this.kdtDanger.getActionMap().remove("Paste");
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("dangerType.name"));
            sic.add(new SelectorItemInfo("storageOrgUnit.name"));
            sic.add(new SelectorItemInfo("description"));
            sic.add(new SelectorItemInfo("checkedStatus"));
            FilterItemCollection f = filter.getFilterItems();
            f.add(new FilterItemInfo("checkedStatus", (Object)String.valueOf(2), CompareType.EQUALS));
            f.add(new FilterItemInfo("storageOrgUnit.id", (Object)this.editData.getStorageOrgUnit().getId(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            viewInfo.setSelector(sic);
            EQMPromptDialogFactory.createPrmptList((KDTable)this.kdtDanger, (String)COL_DANGER, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentDangerForPlanQuery", (EntityViewInfo)viewInfo);
            ((ObjectValueRender)this.kdtDanger.getColumn(COL_DANGER).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
            ((ObjectValueRender)this.kdtAssets.getColumn(COL_ARCHIVES).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
            ((ObjectValueRender)this.kdtAssets.getColumn(COL_LOCATION).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtPlanOrgUnit, (String)this.getAddNewPermItemName(), (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        if (newOrgId == null) {
            return;
        }
        try {
            EQMPromptDialogFactory.createPrmptList((KDTable)this.kdtAssets, (String)COL_ARCHIVES, (String)ARCHIVEQUERY, (String[])new String[]{"planOrgUnit.id", "initial", "bizStatus"}, (Object[])new Object[]{newOrgId, Boolean.TRUE, new Integer(10)}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS, CompareType.EQUALS});
            EQMPromptDialogFactory.createPrmptList((KDTable)this.kdtAssets, (String)COL_LOCATION, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentLocationQuery", (String[])new String[]{"planOrgUnit.id", "checkedStatus"}, (Object[])new Object[]{newOrgId, new Integer(2)}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS});
            EQMPromptDialogFactory.createPrmptList((KDTable)this.kdtDanger, (String)COL_DANGER, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentDangerForPlanQuery", (String[])new String[]{"storageOrgUnit.id", "checkedStatus"}, (Object[])new Object[]{newOrgId, new Integer(2)}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS});
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtPlanOrgUnit;
    }

    @Override
    protected KDTable getDetailTable() {
        KDTable detailTable = this.kdtAssets;
        if (this.kDTabbedPane1.getSelectedComponent().equals(this.pnlAsssets)) {
            detailTable = this.kdtAssets;
        } else if (this.kDTabbedPane1.getSelectedComponent().equals(this.pnlDanger)) {
            detailTable = this.kdtDanger;
        }
        return detailTable;
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        super.actionRemoveLine_actionPerformed(e);
        if (this.getDetailTable() == this.kdtDanger && (rowIndex = this.kdtDanger.getSelectManager().getActiveColumnIndex()) > -1) {
            SecurityPlanDangerInfo securityPlanDangerInfo;
            EquipmentDangerInfo dangerInfo;
            this.kdtDangerMaterial.refresh();
            this.kdtDangerActions.refresh();
            if (null != this.kdtDanger.getRow(0) && null != (dangerInfo = (securityPlanDangerInfo = (SecurityPlanDangerInfo)this.kdtDanger.getRow(0).getUserObject()).getEqmDanger())) {
                EquipmentDangerMaterialCollection entrys;
                EquipmentDangerActionCollection actions = dangerInfo.getAction();
                if (null != actions) {
                    this.fillKdtDangerActions(actions);
                }
                if (null != (entrys = dangerInfo.getMaterial())) {
                    this.fillkdtDangerMaterial(entrys);
                }
            }
        }
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        CoreBillEntryBaseInfo objValue = null;
        if (table.equals(this.kdtAssets)) {
            objValue = new SecurityPlanAssetInfo();
        } else if (table.equals(this.kdtDanger)) {
            objValue = new SecurityPlanDangerInfo();
        }
        return objValue;
    }

    @Override
    public void loadFields() {
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_LOCATION).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_ARCHIVES).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        super.loadFields();
        if (!this.getOprtState().equals("ADDNEW") && null != this.kdtDanger) {
            SecurityPlanInfo info = this.editData;
            SecurityPlanDangerCollection dangerInfos = info.getDanger();
            if (null != dangerInfos && dangerInfos.size() != 0) {
                Iterator it = dangerInfos.iterator();
                while (it.hasNext()) {
                    SecurityPlanDangerInfo securityPlanDangerInfo = (SecurityPlanDangerInfo)it.next();
                    EquipmentDangerInfo dangerInfo = securityPlanDangerInfo.getEqmDanger();
                    if (null != dangerInfo && null != dangerInfo.getAction()) {
                        EquipmentDangerActionCollection actions = dangerInfo.getAction();
                        this.fillKdtDangerActions(actions);
                    }
                    if (null == dangerInfo || null == dangerInfo.getMaterial()) continue;
                    EquipmentDangerMaterialCollection entrys = dangerInfo.getMaterial();
                    this.fillkdtDangerMaterial(entrys);
                }
            }
            if (this.kdtAssets.getRowCount() > 0) {
                this.kdtDanger.getSelectManager().select(0, 0);
            }
        }
        if (this.getOprtState().equals("EDIT")) {
            ((ObjectValueRender)this.kdtAssets.getColumn(COL_LOCATION).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
            ((ObjectValueRender)this.kdtAssets.getColumn(COL_ARCHIVES).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
            this.prmtPlanOrgUnit.setEnabled(false);
            if (this.editData.getUsableStatus() == GeneUsableStatusEnum.UNCHECKED) {
                this.btnAudit.setVisible(true);
                this.btnAudit.setEnabled(true);
                this.btnUnAudit.setVisible(true);
                this.btnUnAudit.setEnabled(false);
                this.btnCancel.setVisible(true);
                this.btnCancel.setEnabled(false);
                this.btnCancelCancel.setVisible(true);
                this.btnCancelCancel.setEnabled(false);
            } else if (this.editData.getUsableStatus() == GeneUsableStatusEnum.USABLE) {
                this.btnUnAudit.setVisible(true);
                this.btnUnAudit.setEnabled(true);
                this.btnAudit.setVisible(true);
                this.btnAudit.setEnabled(false);
                this.btnCancel.setVisible(true);
                this.btnCancel.setEnabled(true);
                this.btnCancelCancel.setVisible(true);
                this.btnCancelCancel.setEnabled(false);
            } else if (this.editData.getUsableStatus() == GeneUsableStatusEnum.FORBIDDEN) {
                this.btnCancelCancel.setVisible(true);
                this.btnCancelCancel.setEnabled(true);
                this.btnUnAudit.setVisible(true);
                this.btnUnAudit.setEnabled(false);
                this.btnAudit.setVisible(true);
                this.btnAudit.setEnabled(false);
                this.btnCancel.setVisible(true);
                this.btnCancel.setEnabled(false);
            }
            if (this.editData.getUsableStatus() == GeneUsableStatusEnum.UNCHECKED) {
                this.btnAudit.setVisible(true);
                this.btnAudit.setEnabled(true);
            } else if (this.editData.getUsableStatus() == GeneUsableStatusEnum.USABLE) {
                MsgBox.showWarning((String)this.getResourceMsg("SECURITYPLAN_USABLE"));
                SysUtil.abort();
            } else if (this.editData.getUsableStatus() == GeneUsableStatusEnum.FORBIDDEN) {
                MsgBox.showWarning((String)this.getResourceMsg("SECURITYPLAN_FORBIDDEN"));
                SysUtil.abort();
            }
        } else if (this.getOprtState().equals("VIEW")) {
            this.editData.setSyncOldValue(true);
            this.prmtPlanOrgUnit.setEnabled(false);
            if (this.editData.getUsableStatus() == GeneUsableStatusEnum.UNCHECKED) {
                this.btnAudit.setVisible(true);
                this.btnAudit.setEnabled(true);
                this.btnUnAudit.setVisible(true);
                this.btnUnAudit.setEnabled(false);
                this.btnCancel.setVisible(true);
                this.btnCancel.setEnabled(false);
                this.btnCancelCancel.setVisible(true);
                this.btnCancelCancel.setEnabled(false);
            } else if (this.editData.getUsableStatus() == GeneUsableStatusEnum.USABLE) {
                this.btnUnAudit.setVisible(true);
                this.btnUnAudit.setEnabled(true);
                this.btnAudit.setVisible(true);
                this.btnAudit.setEnabled(false);
                this.btnCancel.setVisible(true);
                this.btnCancel.setEnabled(true);
                this.btnCancelCancel.setVisible(true);
                this.btnCancelCancel.setEnabled(false);
            } else if (this.editData.getUsableStatus() == GeneUsableStatusEnum.FORBIDDEN) {
                this.btnCancelCancel.setVisible(true);
                this.btnCancelCancel.setEnabled(true);
                this.btnUnAudit.setVisible(true);
                this.btnUnAudit.setEnabled(false);
                this.btnAudit.setVisible(true);
                this.btnAudit.setEnabled(false);
                this.btnCancel.setVisible(true);
                this.btnCancel.setEnabled(false);
            }
        } else if (this.getOprtState().equals("ADDNEW")) {
            this.btnCancel.setVisible(true);
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setVisible(true);
            this.btnCancelCancel.setEnabled(false);
            this.kdtDangerMaterial.refresh();
            this.kdtDangerActions.refresh();
        }
        this.setNumberEnableByCodingRule();
        for (int rowIndex = 0; rowIndex < this.kdtAssets.getRowCount(); ++rowIndex) {
            IRow row = this.kdtAssets.getRow(rowIndex);
            EquipmentLocationInfo location = (EquipmentLocationInfo)row.getCell(COL_LOCATION).getValue();
            String storageOrg = ((StorageOrgUnitInfo)this.prmtPlanOrgUnit.getValue()).getId().toString();
            this.filterArchivesByLocation(location, storageOrg, this.kdtAssets, row.getRowIndex());
        }
    }

    protected void initListener() {
        super.initListener();
        this.registerListener();
    }

    private void registerListener() {
        if (this.eqmArchivesListener == null) {
            this.eqmArchivesListener = new AbstractGeneTableColumnListener(COL_ARCHIVES, true){

                public void tableColumnChanged(KDTEditEvent e) {
                    SecurityPlanEditUI.this.eqmArchives_ColumnChanged(e);
                }
            };
            this.geneKdtAssets.removeTableColumnListener(this.eqmArchivesListener);
            this.geneKdtAssets.addTableColumnListener(this.eqmArchivesListener);
        }
        if (this.eqmLocationListener == null) {
            this.eqmLocationListener = new AbstractGeneTableColumnListener(COL_LOCATION, true){

                public void tableColumnChanged(KDTEditEvent e) {
                    SecurityPlanEditUI.this.eqmLocation_ColumnChanged(e);
                }
            };
            this.geneKdtAssets.removeTableColumnListener(this.eqmLocationListener);
            this.geneKdtAssets.addTableColumnListener(this.eqmLocationListener);
        }
        if (this.eqmDangerListener == null) {
            this.eqmDangerListener = new AbstractGeneTableColumnListener(COL_DANGER){

                public void tableColumnChanged(KDTEditEvent e) {
                    SecurityPlanEditUI.this.eqmDanger_ColumnChanged(e);
                }
            };
            this.geneKdtDanger.removeTableColumnListener(this.eqmDangerListener);
            this.geneKdtDanger.addTableColumnListener(this.eqmDangerListener);
        }
        this.prmtPlanOrgUnit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SecurityPlanEditUI.this.createPlanOrgUnitPrmt();
            }
        });
    }

    protected void eqmArchives_ColumnChanged(KDTEditEvent e) {
        IRow row;
        if (GeneEqualsUtils.equals((Object)e.getOldValue(), (Object)e.getValue())) {
            return;
        }
        if (this.isLoading()) {
            return;
        }
        if (e.getValue() == null) {
            row = this.kdtAssets.getRow(e.getRowIndex());
            row.getCell(COL_ARCHIVESNAME).setValue(null);
            row.getCell(COL_ARCHIVESTYPE).setValue(null);
            row.getCell(COL_ARCHIVESSTATUS).setValue(null);
        }
        if (e.getValue() != null && e.getValue() instanceof EquipmentArchivesInfo) {
            row = this.kdtAssets.getRow(e.getRowIndex());
            EquipmentArchivesInfo archivesInfo = (EquipmentArchivesInfo)e.getValue();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("category.*"));
            sic.add(new SelectorItemInfo("location.*"));
            try {
                archivesInfo = EquipmentArchivesFactory.getRemoteInstance().getEquipmentArchivesInfo((IObjectPK)new ObjectUuidPK(archivesInfo.getId().toString()), sic);
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
            row.getCell(COL_ARCHIVESNAME).setValue((Object)archivesInfo.getName());
            row.getCell(COL_ARCHIVESTYPE).setValue((Object)archivesInfo.getCategory());
            row.getCell(COL_ARCHIVESSTATUS).setValue((Object)archivesInfo.getBizStatus());
            ((ObjectValueRender)this.kdtAssets.getColumn(COL_ARCHIVES).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
            if (null != archivesInfo.getLocation()) {
                row.getCell(COL_LOCATION).setValue((Object)archivesInfo.getLocation());
                row.getCell(COL_LOCATIONNAME).setValue((Object)archivesInfo.getLocation().getName());
                ((ObjectValueRender)this.kdtAssets.getColumn(COL_LOCATION).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
                String storageOrg = ((StorageOrgUnitInfo)this.prmtPlanOrgUnit.getValue()).getId().toString();
                this.filterArchivesByLocation(archivesInfo.getLocation(), storageOrg, this.kdtAssets, e.getRowIndex());
            } else {
                row.getCell(COL_LOCATION).setValue(null);
                row.getCell(COL_LOCATIONNAME).setValue(null);
                row.getCell("eqmremark").setValue(null);
            }
        }
    }

    protected void eqmLocation_ColumnChanged(KDTEditEvent e) {
        IRow row;
        if (this.isLoading()) {
            return;
        }
        if (e.getValue() == null) {
            row = this.kdtAssets.getRow(e.getRowIndex());
            row.getCell(COL_LOCATION).setValue(null);
            row.getCell(COL_LOCATIONNAME).setValue(null);
            row.getCell("eqmremark").setValue(null);
        }
        if (e.getValue() != null && e.getValue() instanceof EquipmentLocationInfo) {
            row = this.kdtAssets.getRow(e.getRowIndex());
            EquipmentLocationInfo locationInfo = (EquipmentLocationInfo)e.getValue();
            row.getCell(COL_LOCATIONNAME).setValue((Object)locationInfo.getName());
            ((ObjectValueRender)this.kdtAssets.getColumn(COL_LOCATION).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
            if (!e.getValue().equals(e.getOldValue())) {
                row.getCell(COL_ARCHIVES).setValue(null);
                row.getCell(COL_ARCHIVESNAME).setValue(null);
                row.getCell(COL_ARCHIVESTYPE).setValue(null);
                row.getCell(COL_ARCHIVESSTATUS).setValue(null);
            }
        }
        EquipmentLocationInfo locationInfo = (EquipmentLocationInfo)e.getValue();
        String storageOrg = ((StorageOrgUnitInfo)this.prmtPlanOrgUnit.getValue()).getId().toString();
        this.filterArchivesByLocation(locationInfo, storageOrg, this.kdtAssets, e.getRowIndex());
    }

    protected void eqmDanger_ColumnChanged(KDTEditEvent e) {
        IRow row;
        if (this.isLoading()) {
            return;
        }
        if (e.getValue() == null) {
            row = this.kdtDanger.getRow(e.getRowIndex());
            row.getCell(COL_DANGERNAME).setValue(null);
            row.getCell(COL_DANGERTYPE).setValue(null);
            row.getCell("eqmremark").setValue(null);
            this.kdtDangerMaterial.refresh();
            this.kdtDangerActions.refresh();
        }
        if (e.getValue() != null && e.getValue() instanceof EquipmentDangerInfo) {
            row = this.kdtDanger.getRow(e.getRowIndex());
            EquipmentDangerInfo dangerInfo = (EquipmentDangerInfo)e.getValue();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("action.*"));
            sic.add(new SelectorItemInfo("material.*"));
            sic.add(new SelectorItemInfo("dangerType.*"));
            try {
                dangerInfo = EquipmentDangerFactory.getRemoteInstance().getEquipmentDangerInfo((IObjectPK)new ObjectUuidPK(dangerInfo.getId().toString()), sic);
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
            row.getCell(COL_DANGERNAME).setValue((Object)dangerInfo.getName());
            row.getCell(COL_DANGERTYPE).setValue((Object)dangerInfo.getDangerType());
            row.getCell("eqmremark").setValue((Object)dangerInfo.getDescription());
            ((ObjectValueRender)this.kdtDanger.getColumn(COL_DANGER).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
            EquipmentDangerActionCollection actions = dangerInfo.getAction();
            this.fillKdtDangerActions(actions);
            EquipmentDangerMaterialCollection entrys = dangerInfo.getMaterial();
            this.fillkdtDangerMaterial(entrys);
        }
    }

    private void fillKdtDangerActions(EquipmentDangerActionCollection actions) {
        this.kdtDangerActions.removeRows();
        if (actions == null) {
            return;
        }
        if (null != actions && actions.size() != 0) {
            Iterator it = actions.iterator();
            while (it.hasNext()) {
                EquipmentDangerActionInfo info = (EquipmentDangerActionInfo)it.next();
                IRow row = this.kdtDangerActions.addRow();
                row.getCell("actionNumber").setValue((Object)info.getNumber());
                row.getCell(COL_ACTIONNAME).setValue((Object)info.getName());
                row.getCell(COL_ACTIONREMARK).setValue((Object)info.getRemark());
            }
        }
    }

    private void fillkdtDangerMaterial(EquipmentDangerMaterialCollection entrys) {
        this.kdtDangerMaterial.removeRows();
        if (entrys == null) {
            return;
        }
        if (null != entrys && entrys.size() != 0) {
            Iterator it = entrys.iterator();
            while (it.hasNext()) {
                EquipmentDangerMaterialInfo entryInfo = (EquipmentDangerMaterialInfo)it.next();
                IRow row = this.kdtDangerMaterial.addRow();
                row.getCell(COL_MATERIALNUMBER).setValue((Object)entryInfo.getNumber());
                row.getCell(COL_MATERIALNAME).setValue((Object)entryInfo.getName());
                row.getCell(COL_MATERIALMODEL).setValue((Object)entryInfo.getModel());
                row.getCell(COL_MATERIALREMARK).setValue((Object)entryInfo.getRemark());
            }
        }
    }

    @Override
    protected void kdtAssets_editStopped(KDTEditEvent e) throws Exception {
        super.kdtAssets_editStopped(e);
        this.rowIndex_ = e.getRowIndex();
        IRow row = this.kdtAssets.getRow(e.getRowIndex());
        int colIndex = e.getColIndex();
        this.colIndex_ = e.getColIndex();
    }

    @Override
    protected void kdtDanger_editStopped(KDTEditEvent e) throws Exception {
        EquipmentDangerInfo itemInfo;
        super.kdtDanger_editStopped(e);
        IRow row = this.kdtDanger.getRow(e.getRowIndex());
        int colIndex = e.getColIndex();
        if (this.kdtDanger.getColumnIndex(COL_DANGER) == colIndex && (itemInfo = (EquipmentDangerInfo)row.getCell(COL_DANGER).getValue()) != null && this.isDangerItemDup(itemInfo, e.getRowIndex())) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResourceMsg("DANGERNUMBERONLY"));
            row.getCell(COL_DANGER).setValue(null);
            row.getCell(COL_DANGERTYPE).setValue(null);
            row.getCell(COL_DANGERNAME).setValue(null);
            row.getCell("eqmremark").setValue(null);
            return;
        }
    }

    private boolean isDangerItemDup(EquipmentDangerInfo itemInfo, int rowIndex) {
        boolean dup = false;
        int n = this.kdtDanger.getRowCount();
        for (int i = 0; i < n && !dup; ++i) {
            EquipmentDangerInfo entryInfo;
            if (i == rowIndex || (entryInfo = (EquipmentDangerInfo)this.kdtDanger.getRow(i).getCell(COL_DANGER).getValue()) == null || !entryInfo.getId().toString().equals(itemInfo.getId().toString())) continue;
            dup = true;
        }
        return dup;
    }

    private boolean isArchivesItemDup(EquipmentArchivesInfo itemInfo, int rowIndex) {
        boolean dup = false;
        int n = this.kdtAssets.getRowCount();
        for (int i = 0; i < n && !dup; ++i) {
            EquipmentArchivesInfo entryInfo;
            if (i == rowIndex || (entryInfo = (EquipmentArchivesInfo)this.kdtAssets.getRow(i).getCell(COL_ARCHIVES).getValue()) == null || !entryInfo.getId().toString().equals(itemInfo.getId().toString())) continue;
            dup = true;
        }
        return dup;
    }

    private boolean isLocationItemDup(EquipmentLocationInfo itemInfo, int rowIndex) {
        boolean dup = false;
        int n = this.kdtAssets.getRowCount();
        for (int i = 0; i < n && !dup; ++i) {
            if (i == rowIndex) continue;
            EquipmentLocationInfo entryInfo = (EquipmentLocationInfo)this.kdtAssets.getRow(i).getCell(COL_LOCATION).getValue();
            EquipmentArchivesInfo equipmentArchivesEntryInfo = (EquipmentArchivesInfo)this.kdtAssets.getRow(i).getCell(COL_ARCHIVES).getValue();
            if (entryInfo == null || !entryInfo.getId().toString().equals(itemInfo.getId().toString()) || null != equipmentArchivesEntryInfo) continue;
            dup = true;
        }
        return dup;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.btnAddLine.setVisible(false);
        this.btnAddLine.setEnabled(false);
        this.btnInsertLine.setVisible(false);
        this.btnInsertLine.setEnabled(false);
        this.btnCopyLine.setVisible(false);
        this.btnCopyLine.setEnabled(false);
        this.btnRemoveLine.setVisible(false);
        this.btnRemoveLine.setEnabled(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemCancelCancel.setAccelerator(KeyStroke.getKeyStroke("shift F9"));
        this.menuItemCancel.setAccelerator(KeyStroke.getKeyStroke("shift F8"));
        this.btnCancel.setTextIconDisStyle((short)3);
        this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.eqm.common.core.GeneResource.forbidden"));
        this.btnCancelCancel.setTextIconDisStyle((short)3);
        this.btnCancelCancel.setText(EASResource.getString((String)"com.kingdee.eas.eqm.common.core.GeneResource.use"));
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)SECURITYPLAN_RESOURCE_PATH, (String)key);
    }

    @Override
    protected void kdtDanger_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.kdtDanger_tableSelectChanged(e);
        KDTable table = this.kdtDanger;
        int rowIndex = table.getSelectManager().getActiveRowIndex();
        if (rowIndex > -1) {
            SecurityPlanDangerInfo securityPlanDangerInfo = (SecurityPlanDangerInfo)table.getRow(rowIndex).getUserObject();
            EquipmentDangerInfo dangerInfo = securityPlanDangerInfo.getEqmDanger();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("action.*"));
            sic.add(new SelectorItemInfo("material.*"));
            if (null != dangerInfo) {
                EquipmentDangerMaterialCollection entrys;
                try {
                    dangerInfo = EquipmentDangerFactory.getRemoteInstance().getEquipmentDangerInfo((IObjectPK)new ObjectUuidPK(dangerInfo.getId().toString()), sic);
                }
                catch (Exception e1) {
                    this.handleException(e1);
                }
                EquipmentDangerActionCollection actions = dangerInfo.getAction();
                if (null != actions) {
                    this.fillKdtDangerActions(actions);
                }
                if (null != (entrys = dangerInfo.getMaterial())) {
                    this.fillkdtDangerMaterial(entrys);
                }
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.getDetailTable() == this.kdtDanger) {
            this.kdtDangerMaterial.refresh();
            this.kdtDangerActions.refresh();
        }
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_LOCATION).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_ARCHIVES).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtDanger.getColumn(COL_DANGER).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        SecurityPlanInfo securityPlanInfo = this.editData;
        SecurityPlanDangerCollection dangerInfos = securityPlanInfo.getDanger();
        if (null != dangerInfos && dangerInfos.size() != 0) {
            Iterator it = dangerInfos.iterator();
            while (it.hasNext()) {
                SecurityPlanDangerInfo securityPlanDangerInfo = (SecurityPlanDangerInfo)it.next();
                EquipmentDangerInfo dangerInfo = securityPlanDangerInfo.getEqmDanger();
                if (null != dangerInfo && null != dangerInfo.getAction()) {
                    EquipmentDangerActionCollection actions = dangerInfo.getAction();
                    this.fillKdtDangerActions(actions);
                }
                if (null == dangerInfo || null == dangerInfo.getMaterial()) continue;
                EquipmentDangerMaterialCollection entrys = dangerInfo.getMaterial();
                this.fillkdtDangerMaterial(entrys);
            }
        }
        if (this.kdtAssets.getRowCount() > 0) {
            this.kdtDanger.getSelectManager().select(0, 2);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.editData.setSyncOldValue(false);
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        SecurityPlanInfo info = (SecurityPlanInfo)newData;
        info.setUsableStatus(GeneUsableStatusEnum.UNCHECKED);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_LOCATION).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_ARCHIVES).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtDanger.getColumn(COL_DANGER).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        SecurityPlanInfo securityPlanInfo = this.editData;
        SecurityPlanDangerCollection dangerInfos = securityPlanInfo.getDanger();
        if (null != dangerInfos && dangerInfos.size() != 0) {
            Iterator it = dangerInfos.iterator();
            while (it.hasNext()) {
                SecurityPlanDangerInfo securityPlanDangerInfo = (SecurityPlanDangerInfo)it.next();
                EquipmentDangerInfo dangerInfo = securityPlanDangerInfo.getEqmDanger();
                if (null != dangerInfo && null != dangerInfo.getAction()) {
                    EquipmentDangerActionCollection actions = dangerInfo.getAction();
                    this.fillKdtDangerActions(actions);
                }
                if (null == dangerInfo || null == dangerInfo.getMaterial()) continue;
                EquipmentDangerMaterialCollection entrys = dangerInfo.getMaterial();
                this.fillkdtDangerMaterial(entrys);
            }
        }
        if (this.kdtAssets.getRowCount() > 0) {
            this.kdtDanger.getSelectManager().select(0, 1);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.validateDupAchieve();
        this.validateDupLocation();
        if (this.kdtAssets.getRowCount() > 0) {
            for (int rowIndex = 0; rowIndex < this.kdtAssets.getRowCount(); ++rowIndex) {
                IRow row = this.kdtAssets.getRow(rowIndex);
                EquipmentArchivesInfo equipmentArchivesInfo = (EquipmentArchivesInfo)row.getCell(COL_ARCHIVES).getValue();
                EquipmentLocationInfo equipmentLocationInfo = (EquipmentLocationInfo)row.getCell(COL_LOCATION).getValue();
                if (null != equipmentArchivesInfo || null != equipmentLocationInfo) continue;
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"98_SecurityPlanEditUI"));
                SysUtil.abort();
            }
        }
    }

    private void validateDupAchieve() {
        ArrayList<String> achieveList = new ArrayList<String>();
        for (int i = 0; i < this.kdtAssets.getRowCount(); ++i) {
            IRow row = this.kdtAssets.getRow(i);
            if (row.getCell(COL_ARCHIVES).getValue() == null) continue;
            String achieve = row.getCell(COL_ARCHIVES).getValue().toString();
            if (achieveList.contains(achieve)) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getResourceMsg("archivesNumberOnly"));
                row.getCell(COL_ARCHIVES).setValue(null);
                row.getCell(COL_ARCHIVESNAME).setValue(null);
                row.getCell(COL_ARCHIVESTYPE).setValue(null);
                row.getCell(COL_ARCHIVESSTATUS).setValue(null);
                row.getCell(COL_LOCATION).setValue(null);
                row.getCell(COL_LOCATIONNAME).setValue(null);
                row.getCell("eqmremark").setValue(null);
                SysUtil.abort();
                this.kDTabbedPane1.setSelectedComponent((Component)this.pnlAsssets);
                SysUtil.abort();
                continue;
            }
            achieveList.add(achieve);
        }
        achieveList.clear();
    }

    private void validateDupLocation() {
        ArrayList<String> locationList = new ArrayList<String>();
        for (int i = 0; i < this.kdtAssets.getRowCount(); ++i) {
            IRow row = this.kdtAssets.getRow(i);
            if (row.getCell(COL_LOCATION).getValue() == null || null != row.getCell(COL_ARCHIVES).getValue()) continue;
            String location = row.getCell(COL_LOCATION).getValue().toString();
            if (locationList.contains(location)) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getResourceMsg("locationNumberOnly"));
                row.getCell(COL_LOCATION).setValue(null);
                row.getCell(COL_LOCATIONNAME).setValue(null);
                row.getCell("eqmremark").setValue(null);
                row.getCell(COL_ARCHIVES).setValue(null);
                row.getCell(COL_ARCHIVESNAME).setValue(null);
                row.getCell(COL_ARCHIVESTYPE).setValue(null);
                row.getCell(COL_ARCHIVESSTATUS).setValue(null);
                SysUtil.abort();
                continue;
            }
            locationList.add(location);
        }
        locationList.clear();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        this.checkPermission("ACTION_CANCEL", this.editData.getCU().getId().toString());
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IGeneDataBase biz = (IGeneDataBase)this.getBizInterface();
        biz.cancel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoActionCancel(e, (IObjectPK)pk);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        this.checkPermission("ACTION_CANCELCANCEL", this.editData.getCU().getId().toString());
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IGeneDataBase biz = (IGeneDataBase)this.getBizInterface();
        biz.cancelCancel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoActionCancelCancel(e, (IObjectPK)pk);
    }

    public static void showSuccessMessageCancel(CoreUI ui, ActionEvent e) {
        if (e == null || !(e.getSource() instanceof Component)) {
            return;
        }
        Component component = (Component)e.getSource();
        SecurityPlanEditUI.showSuccessInfoCancel((Component)ui, component);
    }

    public static void showSuccessMessageCancelCancel(CoreUI ui, ActionEvent e) {
        if (e == null || !(e.getSource() instanceof Component)) {
            return;
        }
        Component component = (Component)e.getSource();
        SecurityPlanEditUI.showSuccessInfoCancelCancel((Component)ui, component);
    }

    public static void showSuccessInfoCancel(Component ui, Component component) {
        if (!(component instanceof KDWorkButton)) {
            return;
        }
        String text = ((KDWorkButton)component).getText();
        MsgBox.showInfo((Component)ui, (String)(text + EASResource.getString((String)SECURITYPLAN_RESOURCE_PATH, (String)"SUCCESS")));
    }

    public static void showSuccessInfoCancelCancel(Component ui, Component component) {
        if (!(component instanceof KDWorkButton)) {
            return;
        }
        String text = ((KDWorkButton)component).getText();
        MsgBox.showInfo((Component)ui, (String)(text + EASResource.getString((String)SECURITYPLAN_RESOURCE_PATH, (String)"CancelCancel_SUCCESS")));
    }

    private void afterDoActionCancel(ActionEvent e, IObjectPK pk) throws Exception {
        SecurityPlanEditUI.showSuccessMessageCancel((CoreUI)this, e);
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    private void afterDoActionCancelCancel(ActionEvent e, IObjectPK pk) throws Exception {
        SecurityPlanEditUI.showSuccessMessageCancelCancel((CoreUI)this, e);
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    public void createPlanOrgUnitPrmt() {
        this.kdtDangerMaterial.refresh();
        this.kdtDangerActions.refresh();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_LOCATION).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_ARCHIVES).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtDanger.getColumn(COL_DANGER).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_LOCATION).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_ARCHIVES).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtDanger.getColumn(COL_DANGER).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_LOCATION).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_ARCHIVES).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtDanger.getColumn(COL_DANGER).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_LOCATION).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtAssets.getColumn(COL_ARCHIVES).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
        ((ObjectValueRender)this.kdtDanger.getColumn(COL_DANGER).getRenderer()).setFormat((IDataFormat)new BizDataFormat("$number$"));
    }

    protected GeneCodingRuleData getCodingRuleData(Context context, IObjectValue bizObject, String orgId) throws EASBizException, BOSException {
        if (bizObject == null) {
            return null;
        }
        GeneCodingRuleData data = GeneCodingRuleManageFacadeFactory.getRemoteInstance().getCodingRuleData(bizObject, orgId);
        return data;
    }

    private void setNumberEnableByCodingRule() {
        if (this.codingRuleData == null) {
            String orgId = this.editData.getMainOrgUnit().getId().toString();
            try {
                this.codingRuleData = this.getCodingRuleData(this.getMainOrgContext(), (IObjectValue)this.editData, orgId);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if ("EDIT".equals(this.getOprtState())) {
            this.txtNumber.setEnabled(true);
            return;
        }
        if (this.codingRuleData.isExistRule()) {
            if (this.codingRuleData.isUseIntermitNumber()) {
                this.txtNumber.setEnabled(false);
            } else if (this.codingRuleData.isAddView() && !this.codingRuleData.isModifable()) {
                this.txtNumber.setEnabled(false);
            } else if (this.codingRuleData.isAddView() && this.codingRuleData.isModifable()) {
                this.txtNumber.setEnabled(true);
            } else if (this.codingRuleData.isAddView() && !this.codingRuleData.isUseIntermitNumber()) {
                this.txtNumber.setEnabled(false);
            } else if (!this.codingRuleData.isAddView()) {
                this.txtNumber.setEnabled(false);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setNumberEnableByCodingRule();
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        if (this.txtNumber.isEnabled()) {
            this.txtNumber.requestFocusInWindow();
            this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{this.txtNumber, this.comboName, this.prmtPlanOrgUnit, this.comboUsableStatus, this.comboxDescription, this.kdtAssets, this.kdtDanger, this.kdtDangerActions, this.kdtDangerMaterial}));
            this.setFocusCycleRoot(true);
        } else {
            this.comboName.requestFocusInWindow();
            this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{this.comboName, this.prmtPlanOrgUnit, this.comboUsableStatus, this.comboxDescription, this.kdtAssets, this.kdtDanger, this.kdtDangerActions, this.kdtDangerMaterial}));
            this.setFocusCycleRoot(true);
        }
    }

    protected void filterArchivesByLocation(EquipmentLocationInfo location, String storageOrgUnitID, KDTable table, int rowIndex) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("initial", (Object)Boolean.TRUE, CompareType.EQUALS));
        items.add(new FilterItemInfo("bizStatus", (Object)new Integer(10), CompareType.EQUALS));
        items.add(new FilterItemInfo("planOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        items.add(new FilterItemInfo("maintainOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        items.add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        if (location != null) {
            items.add(new FilterItemInfo("location.id", (Object)location.getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and (#2 or #3 or #4) and #5");
        } else {
            filter.setMaskString("#0 and #1 and (#2 or #3 or #4)");
        }
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("location.name"));
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("location.number"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("storageOrgUnit.name"));
        selector.add(new SelectorItemInfo("planOrgUnit.name"));
        selector.add(new SelectorItemInfo("maintainOrgUnit.name"));
        selector.add(new SelectorItemInfo("bizStatus"));
        selector.add(new SelectorItemInfo("abcIdentify"));
        selector.add(new SelectorItemInfo("logic"));
        selector.add(new SelectorItemInfo("special"));
        selector.add(new SelectorItemInfo("initial"));
        selector.add(new SelectorItemInfo("billStatus"));
        selector.add(new SelectorItemInfo("storageOrgUnit.id"));
        view.setSelector(selector);
        try {
            EQMPromptDialogFactory.createPrmptList((KDTable)table, (int)table.getColumnIndex(COL_ARCHIVES), (int)rowIndex, (String)ARCHIVEQUERY, (EntityViewInfo)view);
            ObjectValueRender numberRender = new ObjectValueRender();
            numberRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
            table.getCell(rowIndex, table.getColumnIndex(COL_ARCHIVES)).setRenderer((IBasicRender)numberRender);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }
}

