/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client.staopr;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.basedata.client.staopr.AbstractTaskRelatedEntryPanel;
import com.kingdee.eas.eqm.basedata.client.staopr.ICellPromptViewInfoModifer;
import com.kingdee.eas.eqm.basedata.client.staopr.MaterialAmountCellsBinder;
import com.kingdee.eas.eqm.basedata.client.staopr.StandardOperationUtils;
import com.kingdee.eas.eqm.basedata.client.staopr.TableCellsPromptBoxBinder;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;

public abstract class AbstractMaterialEntryPanel
extends AbstractTaskRelatedEntryPanel {
    MaterialAmountCellsBinder amountCellsBinder;

    @Override
    protected void setColumnFormater() {
        super.setColumnFormater();
        StandardOperationUtils.setMoneyFormatByMaterial(this.table, this.getMaterialUnitPriceColumnName(), this.getMaterialColumnName(), true);
    }

    @Override
    protected void bindCell() {
        super.bindCell();
        this.amountCellsBinder = new MaterialAmountCellsBinder(this, this.getMaterialColumnName());
        this.amountCellsBinder.bind();
        new TableCellsPromptBoxBinder(this.table, "measureUnit", "com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery").setEditFormat("$number$").addSelector("qtyPrecision").addModifer(new MeasureUnitViewModifer()).bind();
        new TableCellsPromptBoxBinder(this.table, "storageOrgUnit", "com.kingdee.eas.basedata.org.app.StorageItemQuery").setEditFormat("$number$").addModifer(new StorageUnitOrgViewModifer()).bind();
        new TableCellsPromptBoxBinder(this.table, "warehouse", "com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery").setEditFormat("$number$").addModifer(new WareHouseViewModifer()).bind();
    }

    public void materailChanged(KDTPropertyChangeEvent e) {
        IRow row = this.table.getRow(e.getRowIndex());
        this.clearMeasureUnit(row);
        row.getCell(this.getMaterialNameColumnName()).setValue(null);
        row.getCell(this.getMaterialModelColumnName()).setValue(null);
        row.getCell("storageOrgUnit").setValue(null);
        row.getCell("warehouse").setValue(null);
        this.clearUnitPriceAndLineCost(row);
        if (row.getCell(this.getMaterialColumnName()).getValue() == null) {
            row.getCell(this.getMaterialUnitPriceColumnName()).setValue((Object)new BigDecimal("0"));
            return;
        }
        if (!(row.getCell(this.getMaterialColumnName()).getValue() instanceof MaterialInfo)) {
            return;
        }
        MaterialInfo material = (MaterialInfo)row.getCell(this.getMaterialColumnName()).getValue();
        if (material != null) {
            row.getCell(this.getMaterialNameColumnName()).setValue((Object)material.getName());
            row.getCell(this.getMaterialModelColumnName()).setValue((Object)material.getModel());
            this.fillMeasureUnit(row, material);
            int precision = material.getPricePrecision();
            StandardOperationUtils.setRowNumberEditor(precision, this.table, row.getRowIndex(), new String[]{this.getMaterialUnitPriceColumnName()}, new BigDecimal("999999999999.9999999999"), new BigDecimal("0.0"), true);
        }
        StorageOrgUnitInfo storageOrgUnitInfo = this.getPlanOrgUnit();
        this.initStandardPrice(row, storageOrgUnitInfo, material);
    }

    protected void fillMeasureUnit(IRow row, MaterialInfo material) {
        row.getCell("measureUnit").setValue((Object)material.getBaseUnit());
    }

    protected void clearMeasureUnit(IRow row) {
        row.getCell("measureUnit").setValue(null);
    }

    public void storageOrgUnitChanged(KDTPropertyChangeEvent e) {
        IRow row = this.table.getRow(e.getRowIndex());
        row.getCell("warehouse").setValue(null);
        MaterialInfo material = (MaterialInfo)row.getCell(this.getMaterialColumnName()).getValue();
        if (row.getCell("storageOrgUnit").getValue() == null) {
            StorageOrgUnitInfo storageOrgUnitInfo = this.getPlanOrgUnit();
            this.initStandardPrice(row, storageOrgUnitInfo, material);
            row.getCell("currency").setValue((Object)this.getCurrencyInfo((OrgUnitInfo)storageOrgUnitInfo));
            if (this.getCurrencyInfo((OrgUnitInfo)storageOrgUnitInfo) != null) {
                this.caculateLineCost(e);
                return;
            }
        }
        row.getCell("warehouse").setValue(null);
        StorageOrgUnitInfo storageInfo = (StorageOrgUnitInfo)row.getCell("storageOrgUnit").getValue();
        this.initStandardPrice(row, storageInfo, material);
        CurrencyInfo currencyInfo = this.getCurrencyInfo((OrgUnitInfo)storageInfo);
        if (currencyInfo != null) {
            row.getCell("currency").setValue((Object)currencyInfo);
            this.caculateLineCost(e);
        } else {
            currencyInfo = this.getCurrencyInfo((OrgUnitInfo)this.getPlanOrgUnit());
            row.getCell("currency").setValue((Object)currencyInfo);
            if (currencyInfo != null) {
                this.caculateLineCost(e);
            }
        }
    }

    public void caculateLineCost(KDTPropertyChangeEvent e) {
    }

    protected void clearUnitPriceAndLineCost(IRow row) {
    }

    protected void initStandardPrice(IRow row, StorageOrgUnitInfo storageOrgUnitInfo, MaterialInfo materialInfo) {
    }

    public void measureUnitChanged(KDTPropertyChangeEvent e) {
        this.amountCellsBinder.setPrecision(e.getRowIndex());
        IRow row = this.table.getRow(e.getRowIndex());
        MaterialInfo materialInfo = (MaterialInfo)row.getCell(this.getMaterialColumnName()).getValue();
        if (materialInfo == null) {
            return;
        }
        MeasureUnitInfo newUnitInfo = (MeasureUnitInfo)row.getCell("measureUnit").getValue();
        BigDecimal unitPrice = (BigDecimal)row.getCell(this.getMaterialUnitPriceColumnName()).getValue();
        MeasureUnitInfo oldUnitInfo = (MeasureUnitInfo)e.getOldValue();
        try {
            row.getCell(this.getMaterialUnitPriceColumnName()).setValue((Object)this.getExchangeUnitPrice(unitPrice, oldUnitInfo, newUnitInfo, materialInfo));
        }
        catch (Exception exp) {
            this.parent.handUIException(exp);
        }
    }

    protected abstract String getMaterialUnitPriceColumnName();

    protected abstract String getMaterialColumnName();

    protected abstract String getMaterialNameColumnName();

    protected abstract String getMaterialModelColumnName();

    protected void setAmountNullCellValue(IRow row) {
        if (row.getCell("amount").getValue() == null) {
            MeasureUnitInfo unitInfo;
            int precision;
            BigDecimal value = new BigDecimal("0");
            if (row.getCell("measureUnit").getValue() != null && (precision = (unitInfo = (MeasureUnitInfo)row.getCell("measureUnit").getValue()).getQtyPrecision()) > 0) {
                String str = "0.";
                for (int j = 0; j < precision; ++j) {
                    str = str + "0";
                }
                value = new BigDecimal(str);
            }
            row.getCell("amount").setValue((Object)value);
        }
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        this.parent.getVerifyManager().addVerifyItem((IVerifyItem)new AbstractTaskRelatedEntryPanel.LineCostTooLongVerifyItem(this));
    }

    protected void setAssignF7EntityView(KDBizPromptBox kdBizPromptBox) throws BOSException {
        kdBizPromptBox.setCurrentMainBizOrgUnit((OrgUnitInfo)this.getPlanOrgUnit(), OrgType.Storage);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        MetaDataPK meterPK = kdBizPromptBox.getQueryAgent().getQueryInfoPK();
        QueryInfo query = loader.getQuery((IMetaDataPK)meterPK);
        if (query == null || query instanceof UnionQueryInfo) {
            return;
        }
        EntityObjectInfo mainObjectInfo = (EntityObjectInfo)query.getMainObject().get("entityRef");
        if (mainObjectInfo == null) {
            return;
        }
        EntityViewInfo view = kdBizPromptBox.getEntityViewInfo();
        view.setFilter(this.getBaseFilterInfo(mainObjectInfo.getType().toString()));
        kdBizPromptBox.getQueryAgent().resetRuntimeEntityView();
        kdBizPromptBox.setEntityViewInfo(view);
    }

    protected FilterInfo getBaseFilterInfo(String bosType) throws BOSException {
        StorageOrgUnitInfo org = this.getPlanOrgUnit();
        String cuid = org != null && org.getCU() != null && org.getCU().getId() != null ? org.getCU().getId().toString() : SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        FilterInfo baseFilter = new FilterInfo();
        baseFilter.setMaskString("#0 or #1");
        baseFilter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuid, CompareType.EQUALS));
        baseFilter.getFilterItems().add(new FilterItemInfo("id", (Object)("SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '" + bosType + "' AND FAssignCUID = '" + cuid + "')"), CompareType.INNER));
        return baseFilter;
    }

    @Override
    public void add(ActionEvent e) {
        if (this.table == null) {
            return;
        }
        IObjectValue detailData = this.createNewData(true);
        IRow row = this.table.addRow();
        this.parent.getUILifeCycleHandler().fireOnAddNewLine((Object)this.table, detailData);
        this.parent.getDataBinder().loadLineFields(this.table, row, detailData);
        this.bindCell();
        if (detailData.get(this.getMaterialColumnName()) == null) {
            StandardOperationUtils.setRowNumberEditor(2, this.table, row.getRowIndex(), new String[]{this.getMaterialUnitPriceColumnName()}, StandardOperationUtils.BigDecimal_MaxValue, StandardOperationUtils.BigDecimal_Zero, true);
        }
    }

    @Override
    public void insert(ActionEvent e) {
        if (this.table == null) {
            return;
        }
        IObjectValue detailData = this.createNewData(false);
        IRow row = null;
        if (this.table.getSelectManager().size() > 0) {
            int top = this.table.getSelectManager().get().getTop();
            row = this.parent.isTableSelected(this.table) ? this.table.addRow() : this.table.addRow(top);
        } else {
            row = this.table.addRow();
        }
        this.parent.getUILifeCycleHandler().fireOnAddNewLine((Object)this.table, detailData);
        this.parent.getDataBinder().loadLineFields(this.table, row, detailData);
        this.bindCell();
        if (detailData.get(this.getMaterialColumnName()) == null) {
            StandardOperationUtils.setRowNumberEditor(2, this.table, row.getRowIndex(), new String[]{this.getMaterialUnitPriceColumnName()}, StandardOperationUtils.BigDecimal_MaxValue, StandardOperationUtils.BigDecimal_Zero, true);
        }
    }

    @Override
    protected void afterCurrencyChanged(KDTPropertyChangeEvent e) {
        this.caculateLineCost(e);
    }

    protected BigDecimal getExchangeUnitPrice(BigDecimal unitprice, MeasureUnitInfo oldMeasureUnitInfo, MeasureUnitInfo measureUnitInfo, MaterialInfo material) throws EASBizException, BOSException {
        if (unitprice == null) {
            return null;
        }
        int precision = unitprice.scale();
        if (measureUnitInfo == null) {
            return unitprice.divide(GeneCommonUtils.getExchangeRateQty(null, (MaterialInfo)material, (MeasureUnitInfo)oldMeasureUnitInfo), 5).setScale(precision, 5);
        }
        if (oldMeasureUnitInfo == null) {
            return unitprice.multiply(GeneCommonUtils.getExchangeRateQty(null, (MaterialInfo)material, (MeasureUnitInfo)measureUnitInfo)).setScale(precision, 5);
        }
        BigDecimal baseUnitprice = unitprice.divide(GeneCommonUtils.getExchangeRateQty(null, (MaterialInfo)material, (MeasureUnitInfo)oldMeasureUnitInfo), 5).setScale(precision, 5);
        return baseUnitprice.multiply(GeneCommonUtils.getExchangeRateQty(null, (MaterialInfo)material, (MeasureUnitInfo)measureUnitInfo)).setScale(precision, 5);
    }

    private final class MeasureUnitViewModifer
    implements ICellPromptViewInfoModifer {
        private MeasureUnitViewModifer() {
        }

        @Override
        public void modify(KDTable table, String columnName, int rowIndex, EntityViewInfo viewInfo) {
            Object materialCellValue = table.getRow(rowIndex).getCell(AbstractMaterialEntryPanel.this.getMaterialColumnName()).getValue();
            if (materialCellValue == null) {
                return;
            }
            MaterialInfo materialInfo = (MaterialInfo)materialCellValue;
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId()));
        }
    }

    private final class StorageUnitOrgViewModifer
    implements ICellPromptViewInfoModifer {
        private StorageUnitOrgViewModifer() {
        }

        @Override
        public void modify(KDTable table, String columnName, int rowIndex, EntityViewInfo viewInfo) {
            if (table.getRow(rowIndex).getCell(AbstractMaterialEntryPanel.this.getMaterialColumnName()).getValue() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.mustSelectMaterialAtFirst"));
                SysUtil.abort();
            } else {
                Object obj = AbstractMaterialEntryPanel.this.parent.getPlanOrgUnitPromptBox().getValue();
                if (obj != null) {
                    StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)obj;
                    viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("CU.id", (Object)orgUnitInfo.getCU().getId()));
                    Object objMaterial = table.getRow(rowIndex).getCell(AbstractMaterialEntryPanel.this.getMaterialColumnName()).getValue();
                    if (objMaterial != null) {
                        String materialId = ((MaterialInfo)objMaterial).getId().toString();
                        FilterItemInfo item = new FilterItemInfo("id in (select t.FORGUNIT from T_BD_MATERIALINVENTORY t where t.FMATERIALID='" + materialId + "' and fstatus = 1)");
                        viewInfo.getFilter().getFilterItems().add(item);
                    }
                }
            }
        }
    }

    private final class WareHouseViewModifer
    implements ICellPromptViewInfoModifer {
        private WareHouseViewModifer() {
        }

        @Override
        public void modify(KDTable table, String columnName, int rowIndex, EntityViewInfo viewInfo) {
            Object maintainOrgCellValue = table.getRow(rowIndex).getCell("storageOrgUnit").getValue();
            StorageOrgUnitInfo storageOrgUnitInfo = null;
            if (maintainOrgCellValue != null) {
                storageOrgUnitInfo = (StorageOrgUnitInfo)maintainOrgCellValue;
            }
            if (storageOrgUnitInfo != null) {
                FilterItemInfo filterItem = new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS);
                viewInfo.getFilter().getFilterItems().add(filterItem);
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.mustSelectStorageOrg"));
                SysUtil.abort();
            }
        }
    }
}

