/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client.staopr;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprAssetInfo;
import com.kingdee.eas.eqm.basedata.client.staopr.AbstractEntryPanel;
import com.kingdee.eas.eqm.basedata.client.staopr.IColumnPromptViewInfoModifer;
import com.kingdee.eas.eqm.basedata.client.staopr.StandardOperationUtils;
import com.kingdee.eas.eqm.basedata.client.staopr.TableColumnPromptBoxBinder;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.util.client.EASResource;

public class AssetEntryPanel
extends AbstractEntryPanel {
    private int editingColumnIndex = -1;

    @Override
    protected void setColumnFormater() {
        super.setColumnFormater();
    }

    @Override
    protected IObjectValue createNewData(boolean maxOrderNumber) {
        EquipmentStaOprAssetInfo assetInfo = new EquipmentStaOprAssetInfo();
        return assetInfo;
    }

    @Override
    protected void afterInitLayout() {
        this.detailPanel.setTitle(EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.archivesAndLocation"));
        StandardOperationUtils.setEntryTitleStyle(this.detailPanel, 2);
        StandardOperationUtils.setEntryTitleWidth(this.detailPanel, 150);
    }

    @Override
    protected void bindColumn() {
        TableColumnPromptBoxBinder binder = new TableColumnPromptBoxBinder(this.table, "equipmnetArchives", "com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery");
        binder.addSelector("id").addSelector("name").addSelector("category.name").addSelector("bizStatus").addSelector("location.id").addSelector("location.name").addSelector("location.number");
        binder.setDisplayFormat("$number$");
        binder.addModifer(new ArchivesViewInfoModifer());
        binder.bind();
        new TableColumnPromptBoxBinder(this.table, "equipmentLocation", "com.kingdee.eas.eqm.basedata.app.F7EquipmentLocationQuery").setDisplayFormat("$number$").addModifer(new LocationViewInfoModifer()).bind();
    }

    public void equipmnetArchivesChanged(KDTPropertyChangeEvent e) {
        IRow row = this.table.getRow(e.getRowIndex());
        if (row.getCell("equipmnetArchives").getValue() != null && !(row.getCell("equipmnetArchives").getValue() instanceof EquipmentArchivesInfo)) {
            return;
        }
        EquipmentArchivesInfo archives = (EquipmentArchivesInfo)row.getCell("equipmnetArchives").getValue();
        if (archives == null) {
            row.getCell("equipmentArchivesName").setValue(null);
            row.getCell("equipmentArchivesCategory").setValue(null);
            row.getCell("equipmentArchivesStatus").setValue(null);
        } else {
            row.getCell("equipmentArchivesName").setValue((Object)archives.getName());
            if (archives.getCategory() != null) {
                row.getCell("equipmentArchivesCategory").setValue((Object)archives.getCategory().getName());
            } else {
                row.getCell("equipmentArchivesCategory").setValue(null);
            }
            row.getCell("equipmentArchivesStatus").setValue((Object)archives.getBizStatus());
            if (this.isEditingArchives()) {
                row.getCell("equipmentLocation").setValue((Object)archives.getLocation());
                this.createPromptArchives(archives.getLocation(), this.table, row.getCell("equipmnetArchives").getColumnIndex(), e.getRowIndex());
            }
        }
    }

    public void equipmentLocationChanged(KDTPropertyChangeEvent e) {
        IRow row = this.table.getRow(e.getRowIndex());
        if (row.getCell("equipmentLocation").getValue() != null && !(row.getCell("equipmentLocation").getValue() instanceof EquipmentLocationInfo)) {
            return;
        }
        EquipmentLocationInfo location = (EquipmentLocationInfo)e.getNewValue();
        if (location == null) {
            row.getCell("equipmentLocationName").setValue(null);
            this.createPromptArchives(null, this.table, row.getCell("equipmnetArchives").getColumnIndex(), e.getRowIndex());
            return;
        }
        row.getCell("equipmentLocationName").setValue((Object)location.getName());
        if (this.isEditingLocation()) {
            row.getCell("equipmnetArchives").setValue(null);
            this.createPromptArchives(location, this.table, row.getCell("equipmnetArchives").getColumnIndex(), e.getRowIndex());
        }
    }

    private void createPromptArchives(EquipmentLocationInfo info, KDTable tbl, int colIndex, int rowIndex) {
        if (info == null) {
            try {
                EQMPromptDialogFactory.createPrmptList((KDTable)tbl, (int)colIndex, (int)rowIndex, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery", (String[])new String[]{"planOrgUnit.id", "bizStatus"}, (Object[])new Object[]{this.getPlanOrgUnit() == null ? null : this.getPlanOrgUnit().getId().toString(), new Integer(10)}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS});
                ObjectValueRender numberRender = new ObjectValueRender();
                numberRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
                tbl.getCell(rowIndex, colIndex).setRenderer((IBasicRender)numberRender);
            }
            catch (BOSException e) {}
        } else {
            try {
                EQMPromptDialogFactory.createPrmptList((KDTable)tbl, (int)colIndex, (int)rowIndex, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery", (String[])new String[]{"planOrgUnit.id", "bizStatus", "location.id"}, (Object[])new Object[]{this.getPlanOrgUnit() == null ? null : this.getPlanOrgUnit().getId().toString(), new Integer(10), info.getId().toString()}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS, CompareType.EQUALS});
                ObjectValueRender numberRender = new ObjectValueRender();
                numberRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
                tbl.getCell(rowIndex, colIndex).setRenderer((IBasicRender)numberRender);
            }
            catch (BOSException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        this.bindColumn();
    }

    @Override
    public void beforeLoadData() {
        this.editingColumnIndex = -1;
    }

    @Override
    public void afterLoadData() {
        super.afterLoadData();
        if (this.table.getRowCount() > 0) {
            this.table.getSelectManager().select(0, 0);
        }
    }

    @Override
    public void initListener() {
        super.initListener();
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopping(KDTEditEvent e) {
                AssetEntryPanel.this.editingColumnIndex = e.getColIndex();
            }
        });
    }

    private boolean isEditingArchives() {
        return this.editingColumnIndex == this.table.getColumnIndex("equipmnetArchives");
    }

    private boolean isEditingLocation() {
        return this.editingColumnIndex == this.table.getColumnIndex("equipmentLocation");
    }

    private final class ArchivesViewInfoModifer
    implements IColumnPromptViewInfoModifer {
        private ArchivesViewInfoModifer() {
        }

        @Override
        public void modify(KDTable table, String columnName, EntityViewInfo viewInfo) {
            if (AssetEntryPanel.this.getPlanOrgUnit() == null) {
                return;
            }
            FilterItemInfo item = new FilterItemInfo("planOrgUnit.id", (Object)AssetEntryPanel.this.getPlanOrgUnit().getId());
            viewInfo.getFilter().getFilterItems().add(item);
            item = new FilterItemInfo("bizStatus", (Object)new Integer(10));
            viewInfo.getFilter().getFilterItems().add(item);
        }
    }

    private final class LocationViewInfoModifer
    implements IColumnPromptViewInfoModifer {
        private LocationViewInfoModifer() {
        }

        @Override
        public void modify(KDTable table, String columnName, EntityViewInfo viewInfo) {
            if (AssetEntryPanel.this.parent.getPlanOrgUnitPromptBox().getValue() == null) {
                return;
            }
            FilterItemInfo item = new FilterItemInfo("planOrgUnit.id", (Object)AssetEntryPanel.this.getPlanOrgUnit().getId());
            viewInfo.getFilter().getFilterItems().add(item);
        }
    }
}

