/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client.staopr;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprToolInfo;
import com.kingdee.eas.eqm.basedata.client.staopr.AbstractMaterialEntryPanel;
import com.kingdee.eas.eqm.basedata.client.staopr.IColumnPromptViewInfoModifer;
import com.kingdee.eas.eqm.basedata.client.staopr.StandardOperationUtils;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.eqm.common.eqmcore.EqmMaterialFacadeFactory;
import com.kingdee.eas.eqm.common.eqmcore.IEqmMaterialFacade;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;

public class ToolEntryPanel
extends AbstractMaterialEntryPanel {
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.WorkOrderResource";

    @Override
    public void initListener() {
        super.initListener();
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    ToolEntryPanel.this.planMaterialEntry_editStarting(e);
                }
                catch (Exception exc) {
                    ToolEntryPanel.this.parent.handUIException(exc);
                }
            }
        });
    }

    protected void planMaterialEntry_editStarting(KDTEditEvent e) throws Exception {
        ICell cell;
        int rowIndex = e.getRowIndex();
        if (!(e.getColIndex() != this.table.getColumnIndex("storageOrgUnit") && e.getColIndex() != this.table.getColumnIndex("measureUnit") || null != (cell = this.table.getCell(rowIndex, "tool")) && null != cell.getValue())) {
            MsgBox.showInfo((Component)((Object)this.parent), (String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"MATERIAL_FIRST", null));
            e.setCancel(true);
            this.table.getEditManager().editCellAt(rowIndex, this.table.getColumnIndex("tool"));
            SysUtil.abort();
        }
    }

    @Override
    protected IObjectValue createNewData(boolean maxOrderNumber) {
        EquipmentStaOprToolInfo toolInfo = new EquipmentStaOprToolInfo();
        toolInfo.setAmount(new BigDecimal("0"));
        toolInfo.setHours(new BigDecimal("0"));
        toolInfo.setRate(new BigDecimal("0.00"));
        toolInfo.setLineCost(new BigDecimal("0.00"));
        if (this.getPlanOrgUnit() != null) {
            toolInfo.setCurrency(this.getCurrencyInfo((OrgUnitInfo)this.getPlanOrgUnit()));
        }
        return toolInfo;
    }

    @Override
    protected void afterInitLayout() {
        KDTableUtils.setEntryTitleVisible((DetailPanel)this.detailPanel, (boolean)false);
    }

    @Override
    protected void setColumnFormater() {
        super.setColumnFormater();
        StandardOperationUtils.setColHoursFormat(this.table, "hours");
    }

    @Override
    protected void bindColumn() {
    }

    @Override
    protected void bindCell() {
        super.bindCell();
    }

    @Override
    protected void initColumnPropertyChangeProcessor() {
        this.registerColumnPropertyChangeProcessor(this.getMaterialUnitPriceColumnName(), "caculateLineCost");
        this.registerColumnPropertyChangeProcessor("amount", "caculateLineCost");
        this.registerColumnPropertyChangeProcessor("hours", "caculateLineCost");
    }

    public void toolChanged(KDTPropertyChangeEvent e) {
        super.materailChanged(e);
    }

    @Override
    public void caculateLineCost(KDTPropertyChangeEvent e) {
        IRow row = this.table.getRow(e.getRowIndex());
        if (row.getCell("amount").getValue() != null && row.getCell(this.getMaterialUnitPriceColumnName()).getValue() != null && row.getCell("hours").getValue() != null) {
            BigDecimal amount = (BigDecimal)row.getCell("amount").getValue();
            BigDecimal price = (BigDecimal)row.getCell(this.getMaterialUnitPriceColumnName()).getValue();
            BigDecimal hours = (BigDecimal)row.getCell("hours").getValue();
            BigDecimal result = amount.multiply(price).multiply(hours);
            if (result.longValue() > 999999999999L) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"110_ToolEntryPanel"));
            }
            CurrencyInfo currency = (CurrencyInfo)row.getCell("currency").getValue();
            int precision = 2;
            if (currency != null) {
                precision = currency.getPrecision();
            }
            row.getCell("lineCost").setValue((Object)StandardOperationUtils.formatMoney(result, precision));
        } else {
            row.getCell("lineCost").setValue(null);
        }
    }

    @Override
    protected void initStandardPrice(IRow row, StorageOrgUnitInfo storageOrgUnitInfo, MaterialInfo materialInfo) {
        BigDecimal toolRate = new BigDecimal("0");
        if (storageOrgUnitInfo == null || materialInfo == null) {
            row.getCell("rate").setValue((Object)toolRate);
            return;
        }
        try {
            IEqmMaterialFacade facade = EqmMaterialFacadeFactory.getRemoteInstance();
            toolRate = facade.getToolRate(materialInfo.getId().toString(), storageOrgUnitInfo.getId().toString());
            row.getCell("rate").setValue((Object)toolRate);
        }
        catch (Exception e1) {
            this.parent.handUIException(e1);
        }
    }

    @Override
    protected String getMaterialColumnName() {
        return "tool";
    }

    @Override
    protected String getMaterialNameColumnName() {
        return "toolName";
    }

    @Override
    protected String getMaterialModelColumnName() {
        return "toolModel";
    }

    @Override
    protected String getMaterialUnitPriceColumnName() {
        return "rate";
    }

    @Override
    public void beforeSubmit() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            this.setAmountNullCellValue(row);
            if (row.getCell("hours").getValue() == null) {
                row.getCell("hours").setValue((Object)new BigDecimal("0.0"));
            }
            if (row.getCell("rate").getValue() != null) continue;
            row.getCell("rate").setValue((Object)new BigDecimal("0.00"));
        }
    }

    @Override
    public void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        try {
            EQMPromptDialogFactory.createPrmptList((KDTable)this.table, (String)"tool", (String)"com.kingdee.eas.eqm.archives.app.F7MaterialQuery", (EntityViewInfo)this.getMaterialFilterInfo(), (String)"$number$", (String)"$number$");
            KDTDefaultCellEditor partMaterialCell = (KDTDefaultCellEditor)this.table.getColumn("tool").getEditor();
            KDBizPromptBox partMaterial = (KDBizPromptBox)partMaterialCell.getComponent();
            partMaterial.setCurrentMainBizOrgUnit(this.getCurrentOrgInfo(), OrgType.Storage);
        }
        catch (BOSException e) {
            this.parent.handUIException(e);
        }
    }

    private EntityViewInfo getMaterialFilterInfo() throws BOSException {
        EntityViewInfo entityViewInfo1 = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new MaterialInfo().getBOSType(), (String)"", (boolean)false, (boolean)true, (boolean)true));
        sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        entityViewInfo1.setSelector(sic);
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("equipProperty", (Object)new Integer(2), CompareType.EQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
        filter1.mergeFilter(this.getBaseFilterInfo("4409E7F0"), "and");
        entityViewInfo1.setFilter(filter1);
        return entityViewInfo1;
    }

    private final class ToolViewInfoModifer
    implements IColumnPromptViewInfoModifer {
        private ToolViewInfoModifer() {
        }

        @Override
        public void modify(KDTable table, String columnName, EntityViewInfo viewInfo) {
            if (ToolEntryPanel.this.getPlanOrgUnit() != null) {
                KDBizPromptBox toolF7 = (KDBizPromptBox)table.getColumn("tool").getEditor().getComponent();
                toolF7.setCurrentMainBizOrgUnit((OrgUnitInfo)ToolEntryPanel.this.getPlanOrgUnit(), OrgType.Storage);
                FilterItemInfo item = new FilterItemInfo("CU.id", (Object)ToolEntryPanel.this.getCUId());
                viewInfo.getFilter().getFilterItems().add(item);
                item = new FilterItemInfo("equipProperty", (Object)Integer.valueOf("2"));
                viewInfo.getFilter().getFilterItems().add(item);
            }
        }
    }
}

