/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.client.staopr.SOEditUI;
import com.kingdee.eas.eqm.basedata.client.staopr.StandardOperationUtils;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class NotDupAssetVerifyItem
extends AbstractVerifyItem {
    private KDTable kdtAssets;
    private String archirvesColName;
    private String locationColName;
    private SOEditUI editUI;

    public NotDupAssetVerifyItem(SOEditUI editUI, KDTable kdtAssets, String archivesColName, String locationColName) {
        this.kdtAssets = kdtAssets;
        this.archirvesColName = archivesColName;
        this.locationColName = locationColName;
        this.editUI = editUI;
    }

    public boolean verify() throws EASBizException, BOSException {
        ArrayList<String[]> archivesList = new ArrayList<String[]>();
        ArrayList<String[]> locationList = new ArrayList<String[]>();
        for (int i = 0; i < this.kdtAssets.getRowCount(); ++i) {
            String[] pair;
            IRow currentRow = this.kdtAssets.getRow(i);
            if (currentRow.getCell(this.archirvesColName).getValue() != null) {
                pair = new String[]{((EquipmentArchivesInfo)currentRow.getCell(this.archirvesColName).getValue()).getNumber(), ((EquipmentArchivesInfo)currentRow.getCell(this.archirvesColName).getValue()).getName()};
                archivesList.add(pair);
                continue;
            }
            if (currentRow.getCell(this.locationColName).getValue() == null) continue;
            pair = new String[]{((EquipmentLocationInfo)currentRow.getCell(this.locationColName).getValue()).getNumber(), ((EquipmentLocationInfo)currentRow.getCell(this.locationColName).getValue()).getName()};
            locationList.add(pair);
        }
        String[] dupArchives = this.findFirstDupElement(archivesList);
        int rowIndex = archivesList.indexOf(dupArchives);
        if (dupArchives != null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"113_NotDupAssetVerifyItem");
            MessageFormat mf = new MessageFormat(msg);
            MsgBox.showWarning((String)mf.format(new String[]{dupArchives[1]}));
            if (this.editUI != null) {
                this.editUI.selectCell(this.kdtAssets, this.archirvesColName, rowIndex);
            } else {
                StandardOperationUtils.selectCell(this.kdtAssets, this.archirvesColName, rowIndex);
            }
            SysUtil.abort();
        }
        String[] dupLocation = this.findFirstDupElement(locationList);
        rowIndex = locationList.indexOf(dupLocation);
        if (dupLocation != null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"114_NotDupAssetVerifyItem");
            MessageFormat mf = new MessageFormat(msg);
            MsgBox.showWarning((String)mf.format(new String[]{dupLocation[1]}));
            if (this.editUI != null) {
                this.editUI.selectCell(this.kdtAssets, this.locationColName, rowIndex);
            } else {
                StandardOperationUtils.selectCell(this.kdtAssets, this.locationColName, rowIndex);
            }
            SysUtil.abort();
        }
        return true;
    }

    private String[] findFirstDupElement(List list) {
        if (list.size() < 2) {
            return null;
        }
        String[] result = null;
        block0: for (int i = 0; i < list.size() - 1; ++i) {
            String[] current = (String[])list.get(i);
            if (current == null) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                String[] other = (String[])list.get(j);
                if (current[0] == null || !current[0].equals(other[0])) continue;
                result = current;
                break block0;
            }
        }
        return result;
    }
}

