/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyInfo;
import com.kingdee.eas.eqm.basedata.MeterTypeEnum;
import com.kingdee.eas.eqm.basedata.ReadingWayEnum;
import com.kingdee.eas.eqm.basedata.datatask.DataImportEqmLocationMeterTools;
import com.kingdee.eas.eqm.basedata.util.DataImportUtils;
import com.kingdee.eas.eqm.common.core.ActivedStatusEnum;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportEqmLocationMeter
extends EQMBaseDataTransmission {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.EquipmentLocationResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentMeterApplyFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return false;
    }

    public int getSubmitType() {
        return 1;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        StorageOrgUnitInfo storageInfo = null;
        EquipmentMeterApplyInfo info = new EquipmentMeterApplyInfo();
        Hashtable baseData = (Hashtable)hsData.get(new Integer(0));
        String meter_number = this.getDataString(baseData, "FMeter_number");
        String location_number = this.getDataString(baseData, "FLocation_number");
        String dayAverageValue = this.getDataString(baseData, "FDayAverageValue");
        String readingWay = this.getDataString(baseData, "FReadingWay");
        String activedStatus = this.getDataString(baseData, "FActivedStatus");
        String storageOrgNumber = this.getDataString(baseData, "FStorageOrgUnit_number");
        if (storageOrgNumber == null || "".equals(storageOrgNumber.trim())) {
            throw new TaskExternalException(DataImportEqmLocationMeter.getResourceMsg("storageOrgUnit_CanNotNull"));
        }
        if (meter_number == null || "".equals(meter_number.trim())) {
            throw new TaskExternalException(DataImportEqmLocationMeter.getResourceMsg("meter_CanNotNull"));
        }
        if (location_number == null || "".equals(location_number.trim())) {
            throw new TaskExternalException(DataImportEqmLocationMeter.getResourceMsg("number_CanNotNull"));
        }
        this.isAuthorizedOrgUnit(ctx, storageOrgNumber);
        try {
            storageInfo = DataImportTools.getStorageOrgUnitInfoFromNumber((Context)ctx, (String)storageOrgNumber);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        info = DataImportEqmLocationMeterTools.getMeterApplyInfo(ctx, location_number, meter_number, storageInfo.getId().toString());
        if (ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"117_DataImportEqmLocationMeter").equals(activedStatus)) {
            info.setActivedStatus(false);
        } else {
            info.setActivedStatus(true);
        }
        if (info.getMeter() != null && info.getMeter().getMeterType() != null) {
            if (info.getMeter().getMeterType().getValue() == 10) {
                if (dayAverageValue == null || "".equals(dayAverageValue.trim())) {
                    throw new TaskExternalException(DataImportEqmLocationMeter.getResourceMsg("dayAverageValue_IsNotNull"));
                }
                if (readingWay == null || "".equals(readingWay.trim())) {
                    throw new TaskExternalException(DataImportEqmLocationMeter.getResourceMsg("readingWay_IsNotNull"));
                }
                int description = info.getMeter().getUnit().getQtyPrecision();
                BigDecimal dayAverage = DataImportEqmTools.getNumByPrecision((String)dayAverageValue, (int)description, (String)ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"118_DataImportEqmLocationMeter"), (boolean)true, (boolean)false);
                ReadingWayEnum readingWayEnum = null;
                try {
                    readingWayEnum = DataImportUtils.getReadingWay(readingWay);
                }
                catch (TaskExternalException e) {
                    throw new TaskExternalException(ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"119_DataImportEqmLocationMeter"));
                }
                info.setDayAverageValue(dayAverage);
                info.setReadingWay(readingWayEnum);
            } else {
                info.setReadingWay(ReadingWayEnum.Actural);
                info.setDayAverageValue(new BigDecimal("0"));
            }
        }
        info.setMainOrgUnit((OrgUnitInfo)storageInfo);
        return info;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.ExpEquipmentLocationMeterQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("meterQuery");
        return viewInfo.getFilter();
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            int precision = Integer.parseInt(rs.getString("unit.qtyPrecision") != null && !"".equals(rs.getString("unit.qtyPrecision")) ? rs.getString("unit.qtyPrecision") : "4");
            this.putTable(result, "FLocation_number", rs.getString("number"));
            this.putTable(result, "FLocation_name", rs.getString("name"));
            this.putTable(result, "FMeter_checkContent", rs.getString("meter.checkContent"));
            this.putTable(result, "FMeter_meterType", MeterTypeEnum.getEnum(rs.getInt("meter.meterType")) != null ? MeterTypeEnum.getEnum(rs.getInt("meter.meterType")).getAlias(locale) : "");
            this.putTable(result, "FMeter$unit_name", rs.getString("unit.name"));
            this.putTable(result, "FMeter$unit_number", rs.getString("unit.number"));
            this.putTable(result, "FMeter_name", rs.getString("meter.name"));
            this.putTable(result, "FMeter_number", rs.getString("meter.number"));
            String currentValue = null;
            currentValue = 30 == rs.getInt("meter.meterType") ? rs.getString("currentValue") : DataImportEqmTools.getNumByPrecision((String)rs.getString("currentValue"), (int)precision);
            this.putTable(result, "FCurrentValue", currentValue);
            String accumulatedValue = DataImportEqmTools.getNumByPrecision((String)rs.getString("accumulatedValue"), (int)precision);
            this.putTable(result, "FAccumulatedValue", accumulatedValue);
            this.putTable(result, "FReadingDate", rs.getString("readingDate"));
            this.putTable(result, "FActivedStatus", ActivedStatusEnum.getEnum((int)rs.getInt("activedStatus")) != null ? ActivedStatusEnum.getEnum((int)rs.getInt("activedStatus")).getAlias(locale) : ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"117_DataImportEqmLocationMeter"));
            String averageValues = DataImportEqmTools.getNumByPrecision((String)rs.getString("dayAverageValue"), (int)precision);
            this.putTable(result, "FDayAverageValue", averageValues);
            this.putTable(result, "FReadingWay", ReadingWayEnum.getEnum(rs.getInt("readingWay")) != null ? ReadingWayEnum.getEnum(rs.getInt("readingWay")).getAlias(locale) : "");
            this.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FStorageOrgUnit_name", rs.getString("storageOrgUnit.name"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void putTable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            EquipmentMeterApplyInfo info = (EquipmentMeterApplyInfo)coreBaseInfo;
            this.getController(ctx).addnew((CoreBaseInfo)info);
            DataImportEqmLocationMeterTools.saveReadingInfo(ctx, info.getMeter(), info.getLocation(), info, (StorageOrgUnitInfo)info.getMainOrgUnit());
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getImportPermItemName() {
        return "eqm_equipmentLocationMeter_09import";
    }

    public static String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RESOURCE_PATH, (String)key);
    }
}

