/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationTreeCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationTreeFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationTreeInfo;
import com.kingdee.eas.eqm.basedata.datatask.DataImportEqmStaOprTools;
import com.kingdee.eas.eqm.common.core.GeneUsableStatusEnum;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportEqmStaOpr
extends EQMBaseDataTransmission {
    private static final int DURATION_PRECISION = 2;
    private DataImportEqmStaOprTools tools = new DataImportEqmStaOprTools();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentStandardOperationFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Locale locale = ctx.getLocale();
        EquipmentStandardOperationInfo excelInfo = new EquipmentStandardOperationInfo();
        Hashtable baseData = (Hashtable)hsData.get(new Integer(0));
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FStorageOrgUnit_number"))) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("PlanOrg_Is_Null"));
        }
        try {
            excelInfo.setStorageOrgUnit(this.getStorageOrgUnit(ctx, this.getDataString(baseData, "FStorageOrgUnit_number")));
        }
        catch (BOSException e) {
            throw new TaskExternalException("");
        }
        this.isAuthorizedOrgUnit(ctx, this.getDataString(baseData, "FStorageOrgUnit_number"));
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FNumber"))) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Number_IsNull"));
        }
        excelInfo.setNumber(this.getDataString(baseData, "FNumber"));
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FName_" + locale))) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Name_IsNull"));
        }
        excelInfo.setName(this.getDataString(baseData, "FName_" + locale), locale);
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FParent_number"))) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Group_Is_Null"));
        }
        try {
            excelInfo.setParent(this.getParent(ctx, this.getDataString(baseData, "FParent_number"), this.getDataString(baseData, "FParent_name_" + locale)));
        }
        catch (BOSException e) {
            throw new TaskExternalException("");
        }
        catch (TaskExternalException e) {
            throw e;
        }
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FDuration"))) {
            excelInfo.setDuration(new BigDecimal("0"));
        } else {
            excelInfo.setDuration(DataImportEqmTools.getNumByPrecision((String)this.getDataString(baseData, "FDuration"), (int)2, (String)DataImportEqmStaOprTools.getStaOprResourceMsg("Duration"), (boolean)true));
        }
        excelInfo.setUsableStatus(this.tools.getUsableStatus(this.getDataString(baseData, "FUsableStatus")));
        excelInfo.setDescription(this.getDataString(baseData, "FDescription_" + locale), locale);
        DataImportEqmStaOprTools.checkOverMaxSize((DataBaseInfo)excelInfo, locale);
        return excelInfo;
    }

    private StorageOrgUnitInfo getStorageOrgUnit(Context ctx, String excelNumber) throws BOSException, TaskExternalException {
        StorageOrgUnitInfo storageOrgUnit = this.tools.getStorageOrgUnitInfoFromNumber(ctx, excelNumber);
        this.virifyStorageOrgUnit(ctx, storageOrgUnit);
        return storageOrgUnit;
    }

    private void virifyStorageOrgUnit(Context ctx, StorageOrgUnitInfo storageOrgUnit) throws TaskExternalException {
        if (storageOrgUnit == null) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("PlanOrg_Not_Exist"));
        }
    }

    private EquipmentStandardOperationTreeInfo getParent(Context ctx, String number, String excelName) throws BOSException, TaskExternalException {
        EquipmentStandardOperationTreeCollection treeInfos = EquipmentStandardOperationTreeFactory.getLocalInstance(ctx).getEquipmentStandardOperationTreeCollection(this.getParentView(number));
        EquipmentStandardOperationTreeInfo treeInfo = treeInfos.get(0);
        this.virifyParentInfo(ctx, treeInfo, excelName);
        return treeInfo;
    }

    private void virifyParentInfo(Context ctx, EquipmentStandardOperationTreeInfo treeInfo, String excelName) throws TaskExternalException {
        if (treeInfo == null) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Group_Not_Exist"));
        }
        if (!treeInfo.isIsLeaf()) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("virtualGroupNotAddSO"));
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FName_" + locale, rs.getString("name"));
            this.putTable(result, "FParent_number", rs.getString("parent.number"));
            this.putTable(result, "FParent_name_" + locale, rs.getString("parent.name"));
            this.putTable(result, "FDuration", DataImportEqmTools.getNumByPrecision((String)rs.getString("duration"), (int)2));
            this.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FStorageOrgUnit_name_" + locale, rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FUsableStatus", GeneUsableStatusEnum.getEnum((int)rs.getInt("usableStatus")).getAlias(locale));
            this.putTable(result, "FDescription_" + locale, rs.getString("description"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.EquipmentStandardOperationQuery";
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return false;
    }

    private EntityViewInfo getParentView(String number) {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("isLeaf"));
        view.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        return view;
    }

    public String getDataString(Hashtable hsData, String fieldName) {
        return (String)((DataToken)hsData.get((Object)fieldName)).data;
    }

    public void putTable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    protected String getImportPermItemName() {
        return "eqm_equipmentstandardoperation_20baseImport";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("mainQuery");
        return viewInfo.getFilter();
    }
}

