/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesCollection;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.EquipmentBizStatus;
import com.kingdee.eas.eqm.basedata.EquipmentLocationCollection;
import com.kingdee.eas.eqm.basedata.EquipmentLocationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprAssetCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprAssetFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprAssetInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.basedata.datatask.DataImportEqmStaOprTools;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportEqmStaOprAsset
extends EQMBaseDataTransmission {
    private DataImportEqmStaOprTools tools = new DataImportEqmStaOprTools();
    private static final int DESCRIPTION_MAX_SIZE = 255;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentStaOprAssetFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Hashtable baseData = (Hashtable)hsData.get(new Integer(0));
        EquipmentStaOprAssetInfo excelInfo = new EquipmentStaOprAssetInfo();
        StorageOrgUnitInfo orgInfo = this.tools.getMainStorageOrgUnit(ctx, this.getDataString(baseData, "FParent_storageOrgUnit_number"), this.cache_storageInfo, this._cacheAuthorizedOrgUnits);
        EquipmentStandardOperationInfo staOprInfo = this.tools.getStaOpr(ctx, orgInfo, this.getDataString(baseData, "FParent_number"));
        excelInfo.setStandardOperation(staOprInfo);
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FArchives_number")) && DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FLoaction_number"))) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Asset_Eqm_Loa_Both_Null"));
        }
        EquipmentArchivesInfo archive = this.getArchive(ctx, orgInfo.getId().toString(), this.getDataString(baseData, "FArchives_number"));
        excelInfo.setEquipmentArchives(archive);
        if (archive == null) {
            EquipmentLocationInfo location = this.getLoaction(ctx, orgInfo.getId().toString(), this.getDataString(baseData, "FLoaction_number"));
            excelInfo.setEquipmentLocation(location);
            this.virifyExistedLocation(ctx, staOprInfo.getId().toString(), location, archive);
        }
        this.virifyExistedArchive(ctx, staOprInfo.getId().toString(), archive);
        if (excelInfo.getEquipmentArchives() != null && !DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FLoaction_number"))) {
            excelInfo.setEquipmentLocation(excelInfo.getEquipmentArchives().getLocation());
        }
        DataImportEqmStaOprTools.checkOverMaxSize(this.getDataString(baseData, "FRemark"), 255, "Descriptin_Over_Max_Size");
        excelInfo.setRemark(this.getDataString(baseData, "FRemark"));
        return excelInfo;
    }

    private EquipmentLocationInfo getLoaction(Context ctx, String planOrgUnitID, String number) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(number)) {
            return null;
        }
        EquipmentLocationCollection locations = null;
        try {
            EntityViewInfo view = this.tools.getNumFilterView(number);
            view.getSelector().add(new SelectorItemInfo("planOrgUnit.id"));
            locations = EquipmentLocationFactory.getLocalInstance(ctx).getEquipmentLocationCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Asset_Location_Num_Error"));
        }
        return this.getVirifiedLocation(locations, planOrgUnitID);
    }

    private void virifyExistedLocation(Context ctx, String staOprID, EquipmentLocationInfo location, EquipmentArchivesInfo archive) throws TaskExternalException {
        if (location == null || archive != null) {
            return;
        }
        EquipmentStaOprAssetCollection assets = null;
        try {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("equipmentLocation.id", (Object)location.getId().toString());
            filter.appendFilterItem("standardOperation.id", (Object)staOprID);
            filter.appendFilterItem("equipmentArchives.id", null);
            assets = EquipmentStaOprAssetFactory.getLocalInstance(ctx).getEquipmentStaOprAssetCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Asset_Location_Num_Error"));
        }
        if (assets != null && assets.size() > 0) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Asset_Location_Existed"));
        }
    }

    private EquipmentLocationInfo getVirifiedLocation(EquipmentLocationCollection locations, String planOrgUnitID) throws TaskExternalException {
        EquipmentLocationInfo locationInfo = null;
        if (locations != null && locations.size() > 0) {
            boolean isMatch = false;
            for (int i = 0; i < locations.size(); ++i) {
                locationInfo = locations.get(i);
                if (!locationInfo.getPlanOrgUnit().getId().toString().equals(planOrgUnitID)) continue;
                isMatch = true;
            }
            if (!isMatch) {
                throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Asset_PlanOrg_Not_Contain_Location"));
            }
        } else {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Asset_Location_Num_Error"));
        }
        return locationInfo;
    }

    private EquipmentArchivesInfo getArchive(Context ctx, String planOrgUnitID, String number) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(number)) {
            return null;
        }
        EquipmentArchivesCollection archives = null;
        try {
            EntityViewInfo view = this.tools.getNumFilterView(number);
            view.getSelector().add(new SelectorItemInfo("planOrgUnit.id"));
            view.getSelector().add(new SelectorItemInfo("category.id"));
            view.getSelector().add(new SelectorItemInfo("initial"));
            view.getSelector().add(new SelectorItemInfo("location.id"));
            archives = EquipmentArchivesFactory.getLocalInstance((Context)ctx).getEquipmentArchivesCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Asset_Archive_Num_Error"));
        }
        return this.getVirifiedArchive(archives, planOrgUnitID);
    }

    private void virifyExistedArchive(Context ctx, String staOprID, EquipmentArchivesInfo archive) throws TaskExternalException {
        if (archive == null) {
            return;
        }
        EquipmentStaOprAssetCollection assets = null;
        try {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("standardOperation.id", (Object)staOprID);
            filter.appendFilterItem("equipmentArchives.id", (Object)archive.getId().toString());
            assets = EquipmentStaOprAssetFactory.getLocalInstance(ctx).getEquipmentStaOprAssetCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Asset_Archive_Num_Error"));
        }
        if (assets != null && assets.size() > 0) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Asset_Archive_Existed"));
        }
    }

    private EquipmentArchivesInfo getVirifiedArchive(EquipmentArchivesCollection archives, String planOrgUnitID) throws TaskExternalException {
        EquipmentArchivesInfo archiveInfo = null;
        if (archives != null && archives.size() > 0) {
            boolean isMatch = false;
            for (int i = 0; i < archives.size(); ++i) {
                archiveInfo = archives.get(i);
                if (!archiveInfo.getPlanOrgUnit().getId().toString().equals(planOrgUnitID)) continue;
                isMatch = true;
            }
            if (!isMatch) {
                throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Asset_PlanOrg_Not_Contain_Archive"));
            }
            if (!archiveInfo.isInitial()) {
                throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Asset_Archive_Not_Init"));
            }
        } else {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Asset_Archive_Num_Error"));
        }
        return archiveInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            if (DataImportEqmStaOprTools.isExcelCellValueNull(rs.getString("equipmentArchives.number")) && DataImportEqmStaOprTools.isExcelCellValueNull(rs.getString("equipmentLocation.number"))) {
                return null;
            }
            this.putTable(result, "FParent_storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FParent_storageOrgUnit_name_" + locale, rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FParent_number", rs.getString("number"));
            this.putTable(result, "FParent_name_" + locale, rs.getString("name"));
            this.putTable(result, "FArchives_number", rs.getString("equipmentArchives.number"));
            this.putTable(result, "FArchives_name_" + locale, rs.getString("equipmentArchives.name"));
            this.putTable(result, "FArchivesCategory_number", rs.getString("equipment.category.number"));
            this.putTable(result, "FArchivesCategory_name_" + locale, rs.getString("equipment.category.name"));
            this.putTable(result, "FArchivesStatus", EquipmentBizStatus.getEnum((int)rs.getInt("equipmentArchives.bizStatus")));
            this.putTable(result, "FLoaction_number", rs.getString("equipmentLocation.number"));
            this.putTable(result, "FLoaction_name_" + locale, rs.getString("equipmentLocation.name"));
            this.putTable(result, "FRemark", rs.getString("assets.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("mainQuery");
        return viewInfo.getFilter();
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.EquipmentStaOprAssetImExQuery";
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return false;
    }
}

