/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.DataBaseDAssignCollection;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.master.material.EquipmentPropertyEnum;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprMaterialFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprMaterialInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.basedata.datatask.DataImportEqmStaOprTools;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;

public class DataImportEqmStaOprMaterial
extends EQMBaseDataTransmission {
    private static final int DESCRIPTION_MAX_SIZE = 255;
    private DataImportEqmStaOprTools staOprTools = new DataImportEqmStaOprTools();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentStaOprMaterialFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Hashtable baseData = (Hashtable)hsData.get(new Integer(0));
        EquipmentStaOprMaterialInfo excelInfo = new EquipmentStaOprMaterialInfo();
        StorageOrgUnitInfo orgInfo = this.staOprTools.getMainStorageOrgUnit(ctx, this.getDataString(baseData, "FParent_storageOrgUnit_number"), this.cache_storageInfo, this._cacheAuthorizedOrgUnits);
        EquipmentStandardOperationInfo staOprInfo = this.staOprTools.getStaOpr(ctx, orgInfo, this.getDataString(baseData, "FParent_number"));
        excelInfo.setStandardOperation(staOprInfo);
        this.staOprTools.virifyEntryTaskNumber(ctx, this.getDataString(baseData, "FTaskNumber"), staOprInfo);
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FTaskNumber"))) {
            excelInfo.setTaskNumber(null);
        } else {
            excelInfo.setTaskNumber(this.getDataString(baseData, "FTaskNumber"));
        }
        DataImportEqmStaOprTools.virifyExcelCellValueNull(this.getDataString(baseData, "FMaterial_number"), "Material_Num_Is_Null");
        MaterialInfo material = this.getMaterialInfo(ctx, this.getDataString(baseData, "FMaterial_number"), orgInfo);
        excelInfo.setMaterial(material);
        excelInfo.setBaseUnit(excelInfo.getMaterial().getBaseUnit());
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FUnit_number"))) {
            this.setBaseUnitByPrecision(ctx, excelInfo);
            excelInfo.setMeasureUnit(excelInfo.getBaseUnit());
        } else {
            excelInfo.setMeasureUnit(this.getMeasureUnit(ctx, this.getDataString(baseData, "FUnit_number"), material));
        }
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FAmount"))) {
            excelInfo.setAmount(new BigDecimal("0"));
        } else {
            excelInfo.setAmount(DataImportEqmTools.getNumByPrecision((String)this.getDataString(baseData, "FAmount"), (int)excelInfo.getMeasureUnit().getQtyPrecision(), (String)DataImportEqmStaOprTools.getStaOprResourceMsg("Amount"), (boolean)true));
        }
        StorageOrgUnitInfo materialStorageOrgInfo = this.getMaterialStorageOrg(ctx, material.getId().toString(), orgInfo.getCU().getId().toString(), this.getDataString(baseData, "FStorageOrgUnit_number"));
        excelInfo.setStorageOrgUnit(materialStorageOrgInfo);
        excelInfo.setWarehouse(this.getWarehose(ctx, this.getDataString(baseData, "FWarehouse_number"), materialStorageOrgInfo));
        excelInfo.setMaintainable(this.staOprTools.getBooleanData(this.getDataString(baseData, "FMaintainable")));
        excelInfo.setUnitPrice(DataImportEqmTools.getNumByPrecision((String)this.getDataString(baseData, "FUnitPrice"), (int)material.getPricePrecision(), (String)DataImportEqmStaOprTools.getStaOprResourceMsg("UnitPrice"), (boolean)true));
        String storageOrgUnitColName = this.getPropertyAlias(ctx, (AbstractObjectValue)excelInfo, "storageOrgUnit");
        CurrencyInfo currencyInfo = this.staOprTools.getCurrencyInfo(ctx, (OrgUnitInfo)materialStorageOrgInfo, (OrgUnitInfo)orgInfo, storageOrgUnitColName);
        excelInfo.setCurrency(currencyInfo);
        BigDecimal lineCost = DataImportEqmStaOprTools.calculate(new BigDecimal[]{excelInfo.getUnitPrice(), excelInfo.getAmount()});
        lineCost = new BigDecimal(this.staOprTools.getNumByPrecision(lineCost.toString(), currencyInfo.getPrecision()));
        excelInfo.setLineCost(lineCost);
        DataImportEqmStaOprTools.checkOverMaxSize(this.getDataString(baseData, "FRemark"), 255, "Descriptin_Over_Max_Size");
        excelInfo.setRemark(this.getDataString(baseData, "FRemark"));
        excelInfo.setBaseAmount(this.getBaseAmount(ctx, excelInfo));
        return excelInfo;
    }

    private void setBaseUnitByPrecision(Context ctx, EquipmentStaOprMaterialInfo excelInfo) throws TaskExternalException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("qtyPrecision"));
        try {
            MeasureUnitInfo baseUnit = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(excelInfo.getBaseUnit().getId().toString()), sic);
            excelInfo.setBaseUnit(baseUnit);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Unit_Num_Error"));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Unit_Num_Error"));
        }
    }

    private BigDecimal getBaseAmount(Context ctx, EquipmentStaOprMaterialInfo excelInfo) throws TaskExternalException {
        MultiMeasureUnitInfo multiUnit = null;
        try {
            multiUnit = this.getMultiMeasureUnit(ctx, excelInfo.getMaterial(), excelInfo.getMeasureUnit());
        }
        catch (TaskExternalException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Unit_Num_Error"));
        }
        if (multiUnit != null) {
            return excelInfo.getAmount().multiply(multiUnit.getBaseConvsRate()).setScale(excelInfo.getMeasureUnit().getQtyPrecision(), 1);
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Unit_Num_Error"));
    }

    private WarehouseInfo getWarehose(Context ctx, String number, StorageOrgUnitInfo materialStorageOrgInfo) throws TaskExternalException {
        if (!DataImportEqmStaOprTools.isExcelCellValueNull(number) && materialStorageOrgInfo == null) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Material_StorageOrgUnit_Is_Null"));
        }
        if (DataImportEqmStaOprTools.isExcelCellValueNull(number)) {
            return null;
        }
        WarehouseCollection warehouses = null;
        try {
            EntityViewInfo view = this.staOprTools.getNumFilterView(number);
            view.getSelector().add(new SelectorItemInfo("storageOrg.id"));
            warehouses = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Warehouse_Num_Error"));
        }
        if (warehouses != null && warehouses.size() > 0) {
            for (int i = 0; i < warehouses.size(); ++i) {
                if (!materialStorageOrgInfo.getId().toString().equals(warehouses.get(i).getStorageOrg().getId().toString())) continue;
                return warehouses.get(i);
            }
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Material_StorageOrgUnit_Not_Contain_Warehouse"));
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Warehouse_Num_Error"));
    }

    private StorageOrgUnitInfo getMaterialStorageOrg(Context ctx, String materialID, String cuID, String number) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(number)) {
            return null;
        }
        StorageOrgUnitCollection storages = null;
        try {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("number", (Object)number);
            filter.appendFilterItem("CU.id", (Object)cuID);
            filter.appendFilterItem("isBizUnit", (Object)new Boolean(true));
            storages = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("StorageOrg_Num_Error"));
        }
        if (storages != null && storages.size() > 0) {
            if (this.createMaterialStorageIDList(ctx, materialID).contains(storages.get(0).getId().toString())) {
                return storages.get(0);
            }
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaterialStOrg_Not_Contain_StorageOrg"));
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("StorageOrg_Num_Error"));
    }

    private List createMaterialStorageIDList(Context ctx, String materialID) throws TaskExternalException {
        ArrayList<String> idList = new ArrayList<String>();
        MaterialInventoryCollection materialInventorys = null;
        try {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("material.id", (Object)materialID);
            filter.appendFilterItem("status", (Object)UsedStatusEnum.APPROVED);
            EntityViewInfo view = DataImportEqmTools.getViewInfo((FilterInfo)filter);
            view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
            materialInventorys = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("StorageOrg_Num_Error"));
        }
        if (materialInventorys != null) {
            for (int i = 0; i < materialInventorys.size(); ++i) {
                idList.add(materialInventorys.get(i).getOrgUnit().getId().toString());
            }
        }
        return idList;
    }

    private MeasureUnitInfo getMeasureUnit(Context ctx, String number, MaterialInfo material) throws TaskExternalException {
        MeasureUnitCollection measureUnits = null;
        try {
            EntityViewInfo view = this.staOprTools.getNumFilterView(number);
            view.getSelector().add(new SelectorItemInfo("material.id"));
            view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
            measureUnits = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Unit_Num_Error"));
        }
        if (measureUnits != null && measureUnits.size() > 0) {
            MeasureUnitInfo info = measureUnits.get(0);
            this.virifyMeasureUnit(ctx, material, info);
            return info;
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Unit_Num_Error"));
    }

    private MultiMeasureUnitInfo getMultiMeasureUnit(Context ctx, MaterialInfo material, MeasureUnitInfo measureUnit) throws TaskExternalException {
        MultiMeasureUnitCollection materialUnitRel = null;
        try {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("material.id", (Object)material.getId().toString());
            filter.appendFilterItem("measureUnit.id", (Object)measureUnit.getId().toString());
            EntityViewInfo view = DataImportEqmTools.getViewInfo((FilterInfo)filter);
            view.getSelector().add(new SelectorItemInfo("baseConvsRate"));
            view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
            materialUnitRel = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Unit_Num_Error"));
        }
        if (materialUnitRel != null && materialUnitRel.size() > 0) {
            return materialUnitRel.get(0);
        }
        return null;
    }

    private void virifyMeasureUnit(Context ctx, MaterialInfo material, MeasureUnitInfo measureUnit) throws TaskExternalException {
        if (this.getMultiMeasureUnit(ctx, material, measureUnit) == null) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Meaterial_Not_Contain_Unit"));
        }
    }

    private MaterialInfo getMaterialInfo(Context ctx, String number, StorageOrgUnitInfo orgInfo) throws TaskExternalException {
        MaterialCollection materials = null;
        try {
            EntityViewInfo view = this.staOprTools.getNumFilterView(number);
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("CU.id"));
            view.getSelector().add(new SelectorItemInfo("baseUnit.id"));
            view.getSelector().add(new SelectorItemInfo("pricePrecision"));
            view.getFilter().getFilterItems().add(new FilterItemInfo("equipProperty", (Object)EquipmentPropertyEnum.TOOL, CompareType.NOTEQUALS));
            materials = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Material_Num_Error"));
        }
        if (materials != null && materials.size() > 0) {
            for (int i = 0; i < materials.size(); ++i) {
                MaterialInfo material = materials.get(i);
                if (!this.createCUIDList(ctx, orgInfo.getCU().getId().toString(), material.getId().toString()).contains(material.getCU().getId().toString())) continue;
                return material;
            }
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("PlanOrgCU_Not_Contain_MaterialCU"));
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Material_Num_Error"));
    }

    private List createCUIDList(Context ctx, String planOrgCUID, String materialID) throws TaskExternalException {
        ArrayList<String> CUList = new ArrayList<String>();
        CUList.add(planOrgCUID);
        DataBaseDAssignCollection assings = null;
        try {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("dataBaseDID", (Object)materialID);
            filter.appendFilterItem("bosObjectType", (Object)"4409E7F0");
            EntityViewInfo view = DataImportEqmTools.getViewInfo((FilterInfo)filter);
            view.getSelector().add(new SelectorItemInfo("assignCU.id"));
            assings = DataBaseDAssignFactory.getLocalInstance((Context)ctx).getDataBaseDAssignCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Material_Num_Error"));
        }
        if (assings != null) {
            for (int i = 0; i < assings.size(); ++i) {
                CUList.add(assings.get(i).getAssignCU().getId().toString());
            }
        }
        return CUList;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            if (DataImportEqmStaOprTools.isExcelCellValueNull(rs.getString("material.number"))) {
                return null;
            }
            this.putTable(result, "FParent_storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FParent_storageOrgUnit_name_" + locale, rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FParent_number", rs.getString("number"));
            this.putTable(result, "FParent_name_" + locale, rs.getString("name"));
            this.putTable(result, "FTaskNumber", rs.getString("materials.taskNumber"));
            this.putTable(result, "FMaterial_number", rs.getString("material.number"));
            this.putTable(result, "FMaterial_name_" + locale, rs.getString("material.name"));
            this.putTable(result, "FAmount", DataImportEqmTools.getNumByPrecision((String)rs.getString("materials.amount"), (int)rs.getInt("measureUnit.qtyPrecision")));
            this.putTable(result, "FUnit_number", rs.getString("measureUnit.number"));
            this.putTable(result, "FUnit_name_" + locale, rs.getString("measureUnit.name"));
            if (rs.getBoolean("materials.maintainable")) {
                this.putTable(result, "FMaintainable", ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"122_DataImportEqmStaOprMaterial"));
            } else {
                this.putTable(result, "FMaintainable", ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"117_DataImportEqmLocationMeter"));
            }
            this.putTable(result, "FStorageOrgUnit_number", rs.getString("materialStorageOrgUnit.number"));
            this.putTable(result, "FStorageOrgUnit_name_" + locale, rs.getString("materialStorageOrgUnit.name"));
            this.putTable(result, "FWarehouse_number", rs.getString("warehouse.number"));
            this.putTable(result, "FWarehouse_name_" + locale, rs.getString("warehouse.name"));
            this.putTable(result, "FUnitPrice", DataImportEqmTools.getNumByPrecision((String)rs.getString("materials.unitPrice"), (int)rs.getInt("material.pricePrecision")));
            this.putTable(result, "FLineCost", DataImportEqmTools.getNumByPrecision((String)rs.getString("materials.lineCost"), (int)rs.getInt("currency.precision")));
            this.putTable(result, "FCurrency_name", rs.getString("currency.name"));
            this.putTable(result, "FRemark", rs.getString("materials.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("mainQuery");
        return viewInfo.getFilter();
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.EquipmentStaOprMaterialImExQuery";
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return false;
    }
}

