/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprTaskCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprTaskFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.common.core.GeneUsableStatusEnum;
import com.kingdee.eas.eqm.common.eqmcore.EqmFinanceFacadeFactory;
import com.kingdee.eas.eqm.common.eqmcore.IEqmFinanceFacade;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DataImportEqmStaOprTools {
    private static final int NUM_MAX_SIZE = 80;
    private static final int NAME_MAX_SIZE = 80;
    private static final int DESCRIPTION_MAX_SIZE = 255;
    private static final int TASKNUM_MAX_SIZE = 44;
    private static final String StaOpr_RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource";
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.common.core.GeneResource";
    public HashMap cache_Info = new HashMap();

    private static void checkNameOverMaxSize(DataBaseInfo info, Locale local) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(info.getName(local))) {
            return;
        }
        if (info.getName(local).length() > 80) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Name_Over_Max_Size"));
        }
    }

    private static void checkDescriptionOverMaxSize(DataBaseInfo info, Locale local) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(info.getDescription(local))) {
            return;
        }
        if (info.getDescription(local).length() > 255) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Descriptin_Over_Max_Size"));
        }
    }

    public static void checkOverMaxSize(DataBaseInfo info, Locale local) throws TaskExternalException {
        DataImportEqmStaOprTools.checkNumOverMaxSize(info);
        DataImportEqmStaOprTools.checkNameOverMaxSize(info, local);
        DataImportEqmStaOprTools.checkDescriptionOverMaxSize(info, local);
    }

    private static void checkNumOverMaxSize(DataBaseInfo info) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(info.getNumber())) {
            return;
        }
        if (info.getNumber().length() > 80) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Num_Over_Max_Size"));
        }
    }

    public static String getStaOprResourceMsg(String key) {
        return ResourceBase.getString((String)StaOpr_RESOURCE_PATH, (String)key, (Locale)ContextUtils.getLocaleFromEnv());
    }

    public static String getStaOprResourceMsg(String key, String[] parameters) {
        return ResourceBase.getString((String)StaOpr_RESOURCE_PATH, (String)key, (Locale)ContextUtils.getLocaleFromEnv(), (Object[])parameters);
    }

    public static boolean isExcelCellValueNull(Object data) {
        String str;
        boolean isNull = false;
        if (data == null) {
            isNull = true;
        }
        if (data instanceof String && ((str = (String)data) == null || "".equals(str.trim()))) {
            isNull = true;
        }
        return isNull;
    }

    public static boolean isOverMaxSize(String data, int maxSize) {
        return data.length() > maxSize;
    }

    public static void checkOverMaxSize(String data, int maxSize, String msg) throws TaskExternalException {
        if (data.length() > maxSize) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg(msg));
        }
    }

    public static void virifyExcelCellValueNull(Object data, String msg) throws TaskExternalException {
        String str;
        if (data == null) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg(msg));
        }
        if (data instanceof String && ((str = (String)data) == null || "".equals(str.trim()))) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg(msg));
        }
    }

    public StorageOrgUnitInfo getMainStorageOrgUnit(Context ctx, String number, Map cache_storageInfo, Set _cacheAuthorizedOrgUnits) throws TaskExternalException {
        DataImportEqmStaOprTools.virifyExcelCellValueNull(number, "PlanOrg_Is_Null");
        StorageOrgUnitInfo orgInfo = null;
        try {
            orgInfo = this.getStorageOrgUnitInfoFromNumber(ctx, number, cache_storageInfo);
        }
        catch (BOSException e2) {
            throw new TaskExternalException("PlanOrg_Not_Exist");
        }
        this.isAuthorizedOrgUnit(ctx, number, _cacheAuthorizedOrgUnits);
        return orgInfo;
    }

    public EquipmentStandardOperationInfo getStaOpr(Context ctx, StorageOrgUnitInfo orgInfo, String number) throws TaskExternalException {
        DataImportEqmStaOprTools.virifyExcelCellValueNull(number, "StaOpr_Num_Is_Null");
        EquipmentStandardOperationCollection staOprs = null;
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
            staOprs = EquipmentStandardOperationFactory.getLocalInstance(ctx).getEquipmentStandardOperationCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("StaOpr_Num_Error"));
        }
        if (staOprs.get(0) != null) {
            DataImportEqmStaOprTools.checkNumOverMaxSize((DataBaseInfo)staOprs.get(0));
            return staOprs.get(0);
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("StaOpr_Num_Error"));
    }

    protected boolean isAuthorizedOrgUnit(Context ctx, String storageOrgNumber, Set _cacheAuthorizedOrgUnits) throws TaskExternalException {
        if (_cacheAuthorizedOrgUnits == null) {
            try {
                OrgUnitInfo[] orgUnits = DataImportEqmTools.getAuthorizedBizOrgUnits((Context)ctx, (OrgType)OrgType.Storage, (String)this.getImportPermItemName());
                if (orgUnits != null && orgUnits.length > 0) {
                    _cacheAuthorizedOrgUnits = new HashSet<String>();
                    for (int i = 0; i < orgUnits.length; ++i) {
                        _cacheAuthorizedOrgUnits.add(orgUnits[i].getNumber());
                    }
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (_cacheAuthorizedOrgUnits == null || !_cacheAuthorizedOrgUnits.contains(storageOrgNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)RESOURCE_PATH, (String)"notUserImportPermissionOrg", (Locale)ContextUtils.getLocaleFromEnv()));
        }
        return true;
    }

    protected String getImportPermItemName() {
        return "eqm_equipmentstandardoperation_20baseImport";
    }

    protected StorageOrgUnitInfo getStorageOrgUnitInfoFromNumber(Context ctx, String storageOrgNumber, Map cache_storageInfo) throws BOSException {
        if (storageOrgNumber == null || storageOrgNumber.trim().length() == 0) {
            return null;
        }
        String ckey = storageOrgNumber;
        if (cache_storageInfo.get(ckey) != null) {
            return (StorageOrgUnitInfo)cache_storageInfo.get(ckey);
        }
        StorageOrgUnitInfo info = this.getStorageOrgUnitInfoFromNumber(ctx, storageOrgNumber);
        cache_storageInfo.put(ckey, info);
        return info;
    }

    public void virifyEntryTaskNumber(Context ctx, String taskNumber, EquipmentStandardOperationInfo staOpr) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isOverMaxSize(taskNumber, 44)) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("TaskNum_Over_Max_Size"));
        }
        if (!DataImportEqmStaOprTools.isExist(ctx, taskNumber, staOpr)) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Entry_TaskNumber_Not_Exist", new String[]{taskNumber}));
        }
    }

    private static boolean isExist(Context ctx, String taskNumber, EquipmentStandardOperationInfo staOpr) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(taskNumber)) {
            return true;
        }
        EquipmentStaOprTaskCollection tasks = null;
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taskNumber", (Object)taskNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("standardOperation.id", (Object)staOpr.getId().toString(), CompareType.EQUALS));
            tasks = EquipmentStaOprTaskFactory.getLocalInstance(ctx).getEquipmentStaOprTaskCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("TaskNum_Over_Max_Size"));
        }
        return tasks != null && tasks.size() > 0;
    }

    public EntityViewInfo getNumFilterView(String number) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        return DataImportEqmTools.getViewInfo((FilterInfo)filter);
    }

    public static BigDecimal calculate(BigDecimal[] items) {
        BigDecimal result = new BigDecimal("1");
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) {
                items[i] = new BigDecimal("0");
            }
            result = result.multiply(items[i]);
        }
        return result;
    }

    public boolean getBooleanData(String data) {
        return DataImportEqmStaOprTools.getStaOprResourceMsg("YES").equals(data);
    }

    public GeneUsableStatusEnum getUsableStatus(String value) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return GeneUsableStatusEnum.USABLE;
        }
        if (DataImportEqmTools.enumEqualByAlias((String)value, (Enum)GeneUsableStatusEnum.UNCHECKED)) {
            return GeneUsableStatusEnum.UNCHECKED;
        }
        if (DataImportEqmTools.enumEqualByAlias((String)value, (Enum)GeneUsableStatusEnum.USABLE)) {
            return GeneUsableStatusEnum.USABLE;
        }
        if (DataImportEqmTools.enumEqualByAlias((String)value, (Enum)GeneUsableStatusEnum.FORBIDDEN)) {
            return GeneUsableStatusEnum.FORBIDDEN;
        }
        return GeneUsableStatusEnum.USABLE;
    }

    public StorageOrgUnitInfo getStorageOrgUnitInfoFromNumber(Context ctx, String number) throws BOSException {
        IStorageOrgUnit iStorageOrgUnit;
        StorageOrgUnitCollection collection;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitInfo info = null;
        if (number != null && number.trim().length() > 0 && (collection = (iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx)).getStorageOrgUnitCollection(viewInfo)) != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public String getNumByPrecision(String num, int precision) {
        if (num == null || "".equals(num.trim())) {
            return num;
        }
        return new BigDecimal(num).setScale(precision, 4).toString();
    }

    public CurrencyInfo getCurrencyInfo(Context ctx, OrgUnitInfo orgInfo) throws TaskExternalException {
        if (orgInfo == null || orgInfo.getId() == null) {
            return null;
        }
        String ckey = orgInfo.getId().toString();
        if (this.cache_Info.get(ckey) != null) {
            return (CurrencyInfo)this.cache_Info.get(ckey);
        }
        CurrencyInfo currencyInfo = null;
        try {
            IEqmFinanceFacade facade = EqmFinanceFacadeFactory.getLocalInstance((Context)ctx);
            if (new StorageOrgUnitInfo().getBOSType().equals((Object)orgInfo.getBOSType())) {
                currencyInfo = facade.getCurrency(orgInfo.getId().toString(), 4);
            } else if (new PurchaseOrgUnitInfo().getBOSType().equals((Object)orgInfo.getBOSType())) {
                currencyInfo = facade.getCurrency(orgInfo.getId().toString(), 3);
            }
            if (currencyInfo != null) {
                this.cache_Info.put(ckey, currencyInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return currencyInfo;
    }

    public CurrencyInfo getCurrencyInfo(Context ctx, OrgUnitInfo orgInfo1, OrgUnitInfo orgInfo2, String orgUnitName1) throws TaskExternalException {
        CurrencyInfo currencyInfo = null;
        if (orgInfo1 != null && (currencyInfo = this.getCurrencyInfo(ctx, orgInfo1)) != null) {
            return currencyInfo;
        }
        if (orgInfo2 != null && (currencyInfo = this.getCurrencyInfo(ctx, orgInfo2)) != null) {
            return currencyInfo;
        }
        if (currencyInfo == null) {
            throw new TaskExternalException(DataImportEqmTools.getResourceMsg((String)StaOpr_RESOURCE_PATH, (String)"CURRENCY_CANNOT_NULL", (Object[])new Object[]{orgUnitName1}));
        }
        return currencyInfo;
    }
}

