/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.EquipmentDangerFactory;
import com.kingdee.eas.eqm.basedata.EquipmentDangerMaterialFactory;
import com.kingdee.eas.eqm.basedata.EquipmentDangerMaterialInfo;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Locale;

public class EquipmentDangerMaterialTransmission
extends EQMBaseDataTransmission {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.EquipmentDangerResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentDangerMaterialFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String orgNum;
        String str = null;
        StorageOrgUnitInfo storageInfo = null;
        EquipmentDangerMaterialInfo equipmentDangerMaterialnfo = new EquipmentDangerMaterialInfo();
        Hashtable baseData = hsData;
        String storageOrgNumber = this.getDataString(baseData, "FParent_storageOrgUnit_number");
        if (storageOrgNumber == null || "".equals(storageOrgNumber.trim())) {
            throw new TaskExternalException(this.getResourceMsg("storageOrgUnit_CanNotNull"));
        }
        if (this.isAuthorizedOrgUnit(ctx, storageOrgNumber)) {
            try {
                storageInfo = this.getStorageOrgUnitInfoFromNumber(ctx, storageOrgNumber);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (!storageOrgNumber.equals(orgNum = storageInfo.getNumber())) {
            throw new TaskExternalException("");
        }
        String dangerNumber = this.getDataString(baseData, "FParent_number");
        if (dangerNumber == null || "".equals(dangerNumber.trim())) {
            throw new TaskExternalException(this.getResourceMsg("number_CanNotNull"));
        }
        try {
            CoreBaseInfo equipmentDangerInfo = this.getInfoByNumber(ctx, (ICoreBase)EquipmentDangerFactory.getLocalInstance(ctx), dangerNumber, storageOrgNumber, null);
            equipmentDangerInfo.put("storageOrgUnit", (Object)storageInfo);
            equipmentDangerMaterialnfo.put("parent", equipmentDangerInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        String dangerMaterialNumber = this.getDataString(baseData, "FNumber");
        DataImportEqmTools.checkIsNull((Context)ctx, (AbstractObjectValue)equipmentDangerMaterialnfo, (String)dangerMaterialNumber, (String)"number");
        try {
            CoreBaseInfo entryInfo = this.getEntryInfoByNumber(ctx, this.getController(ctx), dangerNumber, storageOrgNumber, dangerMaterialNumber, null);
            if (entryInfo != null && dangerMaterialNumber.equals((String)entryInfo.get("number"))) {
                throw new TaskExternalException(this.getResourceMsg("duplicateMaterialNumber"));
            }
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)equipmentDangerMaterialnfo, (String)dangerMaterialNumber, (String)"number", (int)80);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        equipmentDangerMaterialnfo.setNumber(dangerMaterialNumber);
        str = this.getDataString(baseData, "FName");
        DataImportEqmTools.checkIsNull((Context)ctx, (AbstractObjectValue)equipmentDangerMaterialnfo, (String)str, (String)"name");
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)equipmentDangerMaterialnfo, (String)str, (String)"name", (int)255);
        equipmentDangerMaterialnfo.setName(str);
        str = this.getDataString(baseData, "FModel");
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)equipmentDangerMaterialnfo, (String)str, (String)"model", (int)100);
        equipmentDangerMaterialnfo.setModel(str);
        str = this.getDataString(baseData, "FRemark");
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)equipmentDangerMaterialnfo, (String)str, (String)"remark", (int)255);
        equipmentDangerMaterialnfo.setRemark(str);
        return equipmentDangerMaterialnfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FParent_storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FParent_storageOrgUnit_name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FParent_number", rs.getString("number"));
            this.putTable(result, "FParent_name", rs.getString("name"));
            this.putTable(result, "FNumber", rs.getString("dangerMaterialNumber"));
            this.putTable(result, "FName", rs.getString("dangerMaterialName"));
            this.putTable(result, "FModel", rs.getString("dangerMaterialModel"));
            this.putTable(result, "FRemark", rs.getString("dangerMaterialRemark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getResourceMsg(String key) {
        return ResourceBase.getString((String)RESOURCE_PATH, (String)key, (Locale)ContextUtils.getLocaleFromEnv());
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.ExpEquipmentDangerMaterialQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("dangerMaterialMainQuery");
        FilterInfo filter = viewInfo.getFilter();
        return filter;
    }

    protected String getImportPermItemName() {
        return "eqm_EquipmentDanger_09import";
    }
}

