/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.IsolationTempFactory;
import com.kingdee.eas.eqm.basedata.IsolationTempPermTypeFactory;
import com.kingdee.eas.eqm.basedata.IsolationTempPermTypeInfo;
import com.kingdee.eas.eqm.basedata.PermissionTypeFactory;
import com.kingdee.eas.eqm.basedata.PermissionTypeInfo;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Locale;

public class IsolationTempPermTypeTransmission
extends EQMBaseDataTransmission {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.IsolationtempResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return IsolationTempPermTypeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String orgNum;
        StorageOrgUnitInfo storageInfo = null;
        IsolationTempPermTypeInfo entryInfo = new IsolationTempPermTypeInfo();
        Hashtable baseData = hsData;
        String storageOrgNumber = this.getDataString(baseData, "FParent_storageOrgUnit_number");
        if (storageOrgNumber == null || "".equals(storageOrgNumber.trim())) {
            throw new TaskExternalException(this.getResourceMsg("storageOrgUnit_CanNotNull"));
        }
        if (this.isAuthorizedOrgUnit(ctx, storageOrgNumber)) {
            try {
                storageInfo = this.getStorageOrgUnitInfoFromNumber(ctx, storageOrgNumber);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (!storageOrgNumber.equals(orgNum = storageInfo.getNumber())) {
            throw new TaskExternalException("");
        }
        String number = this.getDataString(baseData, "FParent_number");
        if (number == null || "".equals(number.trim())) {
            throw new TaskExternalException(this.getResourceMsg("number_CanNotNull"));
        }
        try {
            CoreBaseInfo headInfo = this.getInfoByNumber(ctx, (ICoreBase)IsolationTempFactory.getLocalInstance(ctx), number, storageOrgNumber, null);
            headInfo.put("storageOrgUnit", (Object)storageInfo);
            entryInfo.put("parent", headInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        String permTypeNumber = this.getDataString(baseData, "FPermissionType_number");
        if (permTypeNumber != null && permTypeNumber.trim().length() > 0) {
            try {
                PermissionTypeInfo permTypeInfo = (PermissionTypeInfo)this.getInfoByNumber(ctx, (ICoreBase)PermissionTypeFactory.getLocalInstance(ctx), permTypeNumber, null, null);
                CoreBaseInfo entryInfoByNumber = this.getPermTypeInfoByNumber(ctx, this.getController(ctx), number, storageOrgNumber, permTypeNumber);
                if (entryInfoByNumber != null) {
                    throw new TaskExternalException(this.getResourceMsg("permTypeisDup"));
                }
                entryInfo.setPermissionType(permTypeInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new TaskExternalException(this.getResourceMsg("CheckPermType"));
        }
        return entryInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FParent_storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FParent_storageOrgUnit_name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FParent_number", rs.getString("number"));
            this.putTable(result, "FParent_name", rs.getString("name"));
            this.putTable(result, "FPermissionType_number", rs.getString("permissionType.number"));
            this.putTable(result, "FPermissionType_name", rs.getString("permissionType.name"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getResourceMsg(String key) {
        return ResourceBase.getString((String)RESOURCE_PATH, (String)key, (Locale)ContextUtils.getLocaleFromEnv());
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.ExpIsolationTempPermTypeQuery";
    }

    protected String getImportPermItemName() {
        return "eqm_isolationtemp_10import";
    }

    protected CoreBaseInfo getPermTypeInfoByNumber(Context ctx, ICoreBase biz, String number, String storageOrgNumber, String permTypeNumber) throws BOSException {
        if (biz == null) {
            return null;
        }
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        if (permTypeNumber == null || permTypeNumber.toString().trim().length() == 0) {
            return null;
        }
        String ckey = biz.getType() + number + storageOrgNumber + permTypeNumber;
        if (this.cache_entryInfo.get(ckey) != null) {
            return (CoreBaseInfo)this.cache_entryInfo.get(ckey);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("permissionType.number", (Object)permTypeNumber));
        filter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)number));
        if (storageOrgNumber != null) {
            filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.number", (Object)storageOrgNumber));
        }
        ev.setFilter(filter);
        CoreBaseCollection coll = biz.getCollection(ev);
        CoreBaseInfo voInfo = null;
        if (coll != null && coll.size() > 0) {
            voInfo = coll.get(0);
            this.cache_entryInfo.put(ckey, voInfo);
        }
        return voInfo;
    }
}

