/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.IsolationTempFactory;
import com.kingdee.eas.eqm.basedata.IsolationTempInfo;
import com.kingdee.eas.eqm.basedata.IsolationTypeFactory;
import com.kingdee.eas.eqm.basedata.IsolationTypeInfo;
import com.kingdee.eas.eqm.common.core.GeneCheckedStatusEnum;
import com.kingdee.eas.eqm.common.core.util.GeneStringUtils;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Locale;

public class IsolationTempTransmission
extends EQMBaseDataTransmission {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.IsolationtempResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return IsolationTempFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String orgNum;
        String str = null;
        StorageOrgUnitInfo storageInfo = null;
        IsolationTempInfo info = new IsolationTempInfo();
        info.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        Hashtable baseData = hsData;
        String storageOrgNumber = this.getDataString(baseData, "FStorageOrgUnit_number");
        if (storageOrgNumber == null || "".equals(storageOrgNumber.trim())) {
            throw new TaskExternalException(this.getResourceMsg("storageOrgUnit_CanNotNull"));
        }
        if (this.isAuthorizedOrgUnit(ctx, storageOrgNumber)) {
            try {
                storageInfo = this.getStorageOrgUnitInfoFromNumber(ctx, storageOrgNumber);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (!storageOrgNumber.equals(orgNum = storageInfo.getNumber())) {
            throw new TaskExternalException("");
        }
        info.setStorageOrgUnit(storageInfo);
        str = this.getDataString(baseData, "FNumber");
        if (str == null || "".equals(str.trim())) {
            throw new TaskExternalException(this.getResourceMsg("number_CanNotNull"));
        }
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)"number", (int)80);
        info.setNumber(str);
        str = this.getDataString(baseData, "FName");
        if (str == null || "".equals(str.trim())) {
            throw new TaskExternalException(this.getResourceMsg("name_CanNotNull"));
        }
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)"name", (int)255);
        info.setName(str);
        String isolationTypeNumber = this.getDataString(baseData, "FIsolationType_number");
        if (isolationTypeNumber != null && isolationTypeNumber.trim().length() > 0) {
            try {
                IsolationTypeInfo itInfo = (IsolationTypeInfo)this.getInfoByNumber(ctx, (ICoreBase)IsolationTypeFactory.getLocalInstance(ctx), isolationTypeNumber, null, null);
                info.setIsolationType(itInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        str = this.getDataString(baseData, "FDuration");
        info.setDuration(DataImportEqmTools.getNumByPrecision((String)str, (int)2, (String)this.getPropertyAlias(ctx, (AbstractObjectValue)info, "duration"), (boolean)true));
        str = this.getDataString(baseData, "FRestoreTime");
        info.setRestoreTime(DataImportEqmTools.getNumByPrecision((String)str, (int)2, (String)this.getPropertyAlias(ctx, (AbstractObjectValue)info, "restoreTime"), (boolean)true));
        str = this.getDataString(baseData, "FCheckedStatus");
        if (GeneStringUtils.isEmpty((String)str)) {
            info.setCheckedStatus(GeneCheckedStatusEnum.AUDITED);
        } else {
            info.setCheckedStatus(DataImportEqmTools.getCheckedStatus((String)str));
        }
        str = this.getDataString(baseData, "FDescription");
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)"description", (int)255);
        info.setDescription(str);
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FName", rs.getString("name"));
            this.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FStorageOrgUnit_name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FIsolationType_number", rs.getString("isolationType.number"));
            this.putTable(result, "FIsolationType_name", rs.getString("isolationType.name"));
            this.putTable(result, "FDuration", DataImportEqmTools.getNumByPrecision((String)rs.getString("duration"), (int)2));
            this.putTable(result, "FRestoreTime", DataImportEqmTools.getNumByPrecision((String)rs.getString("restoreTime"), (int)2));
            this.putTable(result, "FCheckedStatus", GeneCheckedStatusEnum.getEnum((int)rs.getInt("checkedStatus")).getAlias(locale));
            this.putTable(result, "FDescription", rs.getString("description"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getResourceMsg(String key) {
        return ResourceBase.getString((String)RESOURCE_PATH, (String)key, (Locale)ContextUtils.getLocaleFromEnv());
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.IsolationTempQuery";
    }

    protected String getImportPermItemName() {
        return "eqm_isolationtemp_10import";
    }
}

