/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.eqm.common.core.IGeneCoreTreeBaseInfo;
import com.kingdee.eas.eqm.common.core.client.AbstractGeneBillTreeEditUI;
import com.kingdee.eas.eqm.common.core.client.GeneBillBaseEditUI;
import com.kingdee.eas.eqm.common.core.client.tree.GeneLNTreeBuilder;
import com.kingdee.eas.eqm.common.core.client.tree.GeneLNTreeNodeCtrl;
import com.kingdee.eas.eqm.common.core.client.tree.IGeneLNTreeNodeCtrl;
import com.kingdee.eas.eqm.common.core.client.tree.ITreeBuilder;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public abstract class GeneBillTreeEditUI
extends AbstractGeneBillTreeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(GeneBillTreeEditUI.class);
    protected GeneBillBaseEditUI billBaseEditUI = null;
    protected ITreeBuilder treeBuilder;
    private DefaultKingdeeTreeNode currentNode = null;
    private IGeneCoreTreeBaseInfo currentData = null;
    private TreeSelectionListener treeSelectionListener;

    public abstract String getEditUIName();

    @Override
    public void onLoad() throws Exception {
        this.initEditPanel();
        super.onLoad();
        this.initTree();
    }

    protected void initListener() {
        super.initListener();
        this.treeMain.addTreeSelectionListener(new TreeSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    GeneBillTreeEditUI.this.treeMain_valueChanged(e);
                }
                catch (Exception exc) {
                    GeneBillTreeEditUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) {
        try {
            this.checkModified();
        }
        catch (Exception e2) {
            logger.error((Object)"checkModified() error:", (Throwable)e2);
            TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
            TreeSelectionListener treeSelectionListener = this.treeSelectionListener = listeners.length > 0 ? listeners[0] : null;
            if (this.treeSelectionListener != null) {
                this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
            }
            this.treeMain.setSelectionNode(this.currentNode);
            if (this.treeSelectionListener != null) {
                this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
            }
            this.abort();
        }
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof IGeneCoreTreeBaseInfo) {
            boolean expendFlag = true;
            this.currentData = (IGeneCoreTreeBaseInfo)this.getSelectedTreeNode().getUserObject();
            this.currentNode = this.getSelectedTreeNode();
            String selID = "";
            selID = this.currentData.getId().toString();
            if (null == selID || "".equals(selID.trim())) {
                expendFlag = false;
                try {
                    this.billBaseEditUI.setOprtState("VIEW");
                    this.billBaseEditUI.actionAddNew_actionPerformed(null);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            } else {
                IObjectValue objValue = null;
                ObjectUuidPK pk = new ObjectUuidPK(selID);
                try {
                    objValue = this.getValue((IObjectPK)pk);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
                if (null != objValue) {
                    this.billBaseEditUI.setOprtState("VIEW");
                    this.billBaseEditUI.setDataObject(objValue);
                    this.billBaseEditUI.loadFields();
                } else {
                    expendFlag = false;
                }
            }
            if (expendFlag) {
                try {
                    this.treeBuilder.refreshTreeNode(this.treeMain, this.getSelectedTreeNode());
                }
                catch (Exception e1) {
                    logger.error((Object)"error treeMain_valueChanged: get expend result", (Throwable)e1);
                }
            }
            this.treeMain.expandAllNodes(true, (TreeNode)this.getSelectedTreeNode());
        }
    }

    protected void initTree() {
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        TreeSelectionListener treeSelectionListener = this.treeSelectionListener = listeners.length > 0 ? listeners[0] : null;
        if (this.treeSelectionListener != null) {
            this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        }
        try {
            this.treeBuilder = this.createTreeBuilder(this.getLNTreeNodeCtrl(), this.getTreeInitialLevel(), this.getTreeExpandLevel(), this.getDefaultFilterForTree(), this.getSelectorForTree(), this.getDefaultFilterForTree());
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootName());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        }
        try {
            this.treeBuilder.buildTree(this.treeMain);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (this.treeSelectionListener != null) {
            this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeMain.setShowPopMenuDefaultItem(true);
        this.treeMain.expandOnLevel(3);
    }

    public ITreeBuilder createTreeBuilder(IGeneLNTreeNodeCtrl ctrl, int initialLevel, int expandLevel, FilterInfo filter, SelectorItemCollection selector, FilterInfo defaultFilter) throws BOSException {
        GeneLNTreeBuilder treeBuilder = null;
        treeBuilder = new GeneLNTreeBuilder(ctrl, initialLevel, expandLevel, filter, selector, defaultFilter);
        return treeBuilder;
    }

    private Object getRootName() {
        return "test";
    }

    private SelectorItemCollection getSelectorForTree() {
        return GeneSelectorUtils.getSelector(this.createNewData().getBOSType(), "", false);
    }

    private FilterInfo getDefaultFilterForTree() {
        return null;
    }

    private int getTreeExpandLevel() {
        return 1;
    }

    private int getTreeInitialLevel() {
        return 1;
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    protected abstract ICoreBase getBizInterface() throws Exception;

    private IGeneLNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new GeneLNTreeNodeCtrl(this.getBizInterface());
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.billBaseEditUI.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.billBaseEditUI.storeFields();
        this.billBaseEditUI.actionSave_actionPerformed(e);
        this.refreshTree();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.billBaseEditUI.actionAudit_actionPerformed(e);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.billBaseEditUI.actionUnAudit_actionPerformed(e);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        IGeneCoreTreeBaseInfo baseInfo = (IGeneCoreTreeBaseInfo)this.createNewData();
        baseInfo.innerSetParent((IGeneCoreTreeBaseInfo)this.getSelectedTreeNode().getUserObject());
        baseInfo.put("NOCover", Boolean.TRUE);
        this.billBaseEditUI.setDataObject(baseInfo);
        this.billBaseEditUI.loadFields();
        this.billBaseEditUI.unLockUI();
        this.billBaseEditUI.setOprtState("ADDNEW");
        this.billBaseEditUI.actionAddNew_actionPerformed(e);
    }

    private void refreshTree() {
        if (this.currentNode.isRoot()) {
            this.treeMain.setSelectionNode(this.currentNode);
        }
        if ("ADDNEW".equals(this.billBaseEditUI.getOprtState())) {
            this.treeMain.setSelectionNode(this.currentNode);
            this.closeOtherBranch(this.currentNode);
        } else if ("EDIT".equals(this.billBaseEditUI.getOprtState())) {
            DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)this.currentNode.getParent();
            this.treeMain.setSelectionNode(parentNode);
            this.treeMain_valueChanged(null);
            this.closeOtherBranch(parentNode);
        }
    }

    private void closeOtherBranch(DefaultKingdeeTreeNode node) {
        if (null == node || node.isRoot()) {
            return;
        }
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
        DefaultKingdeeTreeNode tmpNode = null;
        for (int i = parentNode.getChildCount() - 1; i >= 0; --i) {
            tmpNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (((IGeneCoreTreeBaseInfo)tmpNode.getUserObject()).getId().equals((Object)((IGeneCoreTreeBaseInfo)node.getUserObject()).getId())) continue;
            this.treeMain.removeAllChildrenFromParent((MutableTreeNode)((DefaultKingdeeTreeNode)parentNode.getChildAt(i)));
        }
        if (null != parentNode) {
            this.closeOtherBranch(parentNode);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.billBaseEditUI.storeFields();
        this.billBaseEditUI.actionSubmit_actionPerformed(e);
        this.refreshTree();
    }

    public KDToolBar getUIToolBar() {
        return this.billBaseEditUI.getUIToolBar();
    }

    public KDMenuBar getUIMenuBar() {
        return this.billBaseEditUI.getUIMenuBar();
    }

    protected void initEditPanel() {
        if (GeneCommonUtils.isEmpty(this.getEditUIName())) {
            return;
        }
        UIContext map = new UIContext((Object)this);
        try {
            map.put("InitDataObject", this.createNewData());
            MetaDataPK meta = new MetaDataPK("com.kingdee.eas.eqm.archives.client", "EquipmentArchivesEditUI");
            IUIWindow uiWindow = UIFactory.createUIFactory().create(meta.getFullName(), (Map)map, null, OprtState.ADDNEW);
            this.billBaseEditUI = (GeneBillBaseEditUI)uiWindow.getUIObject();
            this.editPanel.add((Component)this.billBaseEditUI.getUIContentPane());
            this.billBaseEditUI.onLoad();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    protected void inOnload() throws Exception {
    }

    @Override
    public boolean checkBeforeWindowClosing() {
        return true;
    }
}

