/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.common.core.GeneException;
import com.kingdee.eas.eqm.common.core.IGeneDataBaseD;
import com.kingdee.eas.eqm.common.core.client.AbstractGeneDataBaseDReferenceUI;
import com.kingdee.eas.eqm.common.core.client.util.GeneClinetOrgUtils;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class GeneDataBaseDReferenceUI
extends AbstractGeneDataBaseDReferenceUI {
    private static final Logger logger = CoreUIObject.getLogger(GeneDataBaseDReferenceUI.class);
    protected static final String STATUS_ALL = "STATUS_ALL";
    protected static final String STATUS_IMPORTED = "STATUS_IMPORTED";
    protected static final String STATUS_UNIMPORTED = "STATUS_UNIMPORTED";
    protected OrgUnitInfo assignedOrgUnitInfo = null;
    protected OrgUnitInfo currentOrgUnitInfo = null;
    protected EntityViewInfo eviCommonFilting;
    protected FilterInfo fiRadioButtonsRelated;
    private boolean hasDoneSomething = false;
    protected Set assignedTabData = new HashSet();
    protected Set unAssignedTabData = new HashSet();
    protected boolean selAll = false;
    private String sql = null;

    public GeneDataBaseDReferenceUI() throws Exception {
        this.initCtrls();
    }

    public void onLoad() throws Exception {
        this.assignedOrgUnitInfo = (OrgUnitInfo)this.getUIContext().get("CurrentOrgan");
        this.currentOrgUnitInfo = this.getDefaultMainBizOrg();
        this.prmptOrgUnit.setData((Object)this.currentOrgUnitInfo);
        super.onLoad();
        this.initTable();
        this.kDButtonGroup1.setSelected(this.rb_unassigned.getModel(), true);
        this.initDataStatus();
    }

    protected void initContextOrg() {
    }

    protected void initCtrls() {
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneDataBaseDReferenceUI.this.onClickForRefresh();
            }
        });
        this.btnAllSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneDataBaseDReferenceUI.this.onClickForBtnAllSel();
            }
        });
        this.btnAllClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneDataBaseDReferenceUI.this.onClickForBtnAllClr();
            }
        });
        this.btnFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneDataBaseDReferenceUI.this.onClickForFilter();
            }
        });
        this.rb_all.setActionCommand(STATUS_ALL);
        this.rb_assigned.setActionCommand(STATUS_IMPORTED);
        this.rb_unassigned.setActionCommand(STATUS_UNIMPORTED);
        this.rb_all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneDataBaseDReferenceUI.this.onClickForRadioButtons();
            }
        });
        this.rb_assigned.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneDataBaseDReferenceUI.this.onClickForRadioButtons();
            }
        });
        this.rb_unassigned.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneDataBaseDReferenceUI.this.onClickForRadioButtons();
            }
        });
        this.kDButtonGroup1.add((AbstractButton)this.rb_all);
        this.kDButtonGroup1.add((AbstractButton)this.rb_assigned);
        this.kDButtonGroup1.add((AbstractButton)this.rb_unassigned);
        this.btnReference.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GeneDataBaseDReferenceUI.this.onClickForReference();
                }
                catch (Exception ex) {
                    GeneDataBaseDReferenceUI.this.setCursorOfDefault();
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GeneDataBaseDReferenceUI.this.onClickForExit();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
    }

    private void initTable() {
        QueryFieldInfo field;
        SelectorInfo selector = this.getQueryInfoFromUIContext().getSelector();
        int size = selector.getFields().size();
        String[] bindContents = new String[size + 1];
        Map exProperties = this.getQueryInfoFromUIContext().getExtendedProperties();
        this.tblData.getIndexColumn().getStyleAttributes().setHided(true);
        this.tblData.addColumn(0).setWidth(30);
        for (int i = 1; i < size + 1; ++i) {
            String sTemp;
            IColumn col = this.tblData.addColumn(i);
            col.getStyleAttributes().setLocked(true);
            field = (QueryFieldInfo)selector.getFields().get(i - 1);
            exProperties = field.getExtendedProperties();
            bindContents[i] = field.getName();
            col.setKey(bindContents[i]);
            if (exProperties == null) continue;
            Object visible = exProperties.get("isVisibleForKDTable");
            if (visible instanceof Boolean) {
                col.getStyleAttributes().setHided((Boolean)visible == false);
            } else if (visible instanceof String) {
                col.getStyleAttributes().setHided(!KDCommonPromptDialog.stringToboolean((String)((String)visible)));
            }
            Object colWidth = exProperties.get("ColWidthInKDTable");
            if (colWidth == null) {
                colWidth = exProperties.get("colWidthInKDTable");
            }
            if (colWidth instanceof Integer) {
                col.setWidth(((Integer)colWidth).intValue());
            } else if (colWidth instanceof String) {
                col.setWidth(KDCommonPromptDialog.stringToint((String)((String)colWidth)));
            }
            Object colFormat = exProperties.get("displayFormat");
            if (!(colFormat instanceof String) || StringUtil.isEmptyString((String)(sTemp = (String)colFormat))) continue;
            col.getStyleAttributes().setNumberFormat(sTemp);
        }
        this.tblData.putBindContents("query", bindContents);
        this.tblData.setFormatXml("");
        this.tblData.checkParsed(true);
        IRow row = this.tblData.addHeadRow();
        row.getCell(0).setValue((Object)this.getMultiLangString("SelColName"));
        for (int i = 1; i < size + 1; ++i) {
            field = (QueryFieldInfo)selector.getFields().get(i - 1);
            String displayName = field.getDisplayName(SysContext.getSysContext().getLocale());
            row.getCell(i).setValue((Object)displayName);
        }
        this.tblData.getDataRequestManager().setDataRequestMode(1);
        this.tblData.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                try {
                    GeneDataBaseDReferenceUI.this.onRequestRowSetForTable(e);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.tblData.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                GeneDataBaseDReferenceUI.this.onAfterTableFilledData(e.getFirstRow(), e.getLastRow());
            }
        });
        this.tblData.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                GeneDataBaseDReferenceUI.this.onEditValueChangedForKDTable(e);
            }
        });
        this.tblData.getColumn("id").getStyleAttributes().setHided(true);
    }

    protected void onRequestRowSetForTable(RequestRowSetEvent e) throws Exception {
        this.setCursorOfWair();
        IRowSet rsToSet = null;
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        rsToSet = this.kDButtonGroup1.getSelection().getActionCommand().equals(STATUS_ALL) ? this.getRSAll(start, length) : (this.kDButtonGroup1.getSelection().getActionCommand().equals(STATUS_IMPORTED) ? this.getRSImported(start, length) : this.getRSUnimported(start, length));
        e.setRowSet(rsToSet);
        this.setCursorOfDefault();
    }

    protected void onEditValueChangedForKDTable(KDTEditEvent e) {
        boolean isSlted = (Boolean)e.getValue();
        String rowID = this.tblData.getRow(e.getRowIndex()).getCell("id").getValue().toString();
        this.tableChanged(rowID, isSlted);
    }

    private void tableChanged(String id, boolean isSigleSlted) {
        if (this.kDButtonGroup1.getSelection().getActionCommand().equals(STATUS_IMPORTED)) {
            if (this.selAll) {
                if (isSigleSlted) {
                    this.assignedTabData.remove(id);
                } else {
                    this.assignedTabData.add(id);
                }
            } else if (isSigleSlted) {
                this.assignedTabData.add(id);
            } else {
                this.assignedTabData.remove(id);
            }
        } else if (this.selAll) {
            if (isSigleSlted) {
                this.unAssignedTabData.remove(id);
            } else {
                this.unAssignedTabData.add(id);
            }
        } else if (isSigleSlted) {
            this.unAssignedTabData.add(id);
        } else {
            this.unAssignedTabData.remove(id);
        }
    }

    protected void onAfterTableFilledData(int firstRow, int lastRow) {
        for (int i = firstRow; i <= lastRow; ++i) {
            this.tblData.getCell(i, 0).setValue((Object)new Boolean(this.kDButtonGroup1.getSelection().getActionCommand().equals(STATUS_IMPORTED)));
        }
    }

    protected void onClickForExit() {
        this.getUIWindow().close();
    }

    protected void onClickForReference() throws Exception {
        if (this.kDButtonGroup1.getSelection().getActionCommand().equals(STATUS_IMPORTED)) {
            this.doUnimport();
        } else {
            this.doImport();
        }
        this.hasDoneSomething = true;
    }

    protected void doImport() throws Exception {
        if (!(this.unAssignedTabData != null && this.unAssignedTabData.size() > 0 || this.selAll)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("NO_SELECTREFEREDATABASES"));
            return;
        }
        this.checkReference();
        this.setCursorOfWair();
        IGeneDataBaseD idbd = this.getBizInterfaceFromUIContext();
        this.sql = StringUtils.replace((String)this.sql, (String)("" + this.getQueryInfoFromUIContext().getMainObject().toString().toUpperCase() + ""), (String)"v");
        idbd.batchRefer(this.currentOrgUnitInfo.getId().toString(), this.assignedOrgUnitInfo.getId().toString(), this.selAll, this.sql, this.unAssignedTabData.toArray(new String[this.unAssignedTabData.size()]));
        this.setCursorOfDefault();
        MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("ImportingFinished"));
        this.refreshRowsInTable();
    }

    private void checkReference() throws Exception {
        if (this.prmptOrgUnit.getData() == null) {
            throw new GeneException(GeneException.REFERORGNOTNULL);
        }
        if (this.currentOrgUnitInfo.getId().toString().equals(this.assignedOrgUnitInfo.getId().toString())) {
            throw new GeneException(GeneException.NOREFERSAMEORG);
        }
    }

    private void doUnimport() throws Exception {
        if ((this.assignedTabData == null || this.assignedTabData.size() <= 0) && this.selAll) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("NO_SELECTUNREFERDATABASES"));
            return;
        }
        this.checkReference();
        this.setCursorOfWair();
        IGeneDataBaseD idbd = this.getBizInterfaceFromUIContext();
        this.sql = StringUtils.replace((String)this.sql, (String)("" + this.getQueryInfoFromUIContext().getMainObject().toString().toUpperCase() + ""), (String)"v");
        idbd.unBatchRefer(this.currentOrgUnitInfo.getId().toString(), this.assignedOrgUnitInfo.getId().toString(), this.selAll, this.sql, this.assignedTabData.toArray(new String[this.assignedTabData.size()]));
        this.setCursorOfDefault();
        MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("UnimportingFinished"));
        this.refreshRowsInTable();
    }

    protected void onClickForRadioButtons() {
        if (this.kDButtonGroup1.getSelection().getActionCommand().equals(STATUS_IMPORTED)) {
            this.selAll = true;
        } else if (this.kDButtonGroup1.getSelection().getActionCommand().equals(STATUS_UNIMPORTED)) {
            this.selAll = false;
        }
        this.setStatus();
    }

    protected void onClickForFilter() {
        CommonQueryDialog cqd = new CommonQueryDialog();
        cqd.setOwner((Component)((Object)this));
        cqd.setQueryObjectPK((IMetaDataPK)this.getQueryPKFromUIContext());
        cqd.setShowToolbar(false);
        cqd.setWidth(640);
        MetaDataPK meta = new MetaDataPK("com.kingdee.eas.eqm.common.core.client", "GeneDataBaseDReferenceUI");
        cqd.setParentUIClassName(meta.getFullName());
        cqd.setTitle(this.getQueryInfoFromUIContext().getAlias());
        if (this.eviCommonFilting != null) {
            cqd.setEntityViewInfo(this.eviCommonFilting);
        }
        if (cqd.show()) {
            this.eviCommonFilting = cqd.getEntityViewInfoResult();
            this.refreshRowsInTable();
        }
    }

    protected void onClickForBtnAllClr() {
        this.selAll = false;
        this.assignedTabData.clear();
        this.unAssignedTabData.clear();
        this.refreshRowsInTable();
        this.setSelChk(false);
    }

    protected void onClickForBtnAllSel() {
        this.selAll = true;
        this.assignedTabData.clear();
        this.unAssignedTabData.clear();
        this.refreshRowsInTable();
        this.setSelChk(true);
    }

    private void setSelChk(boolean sel) {
        if (this.tblData.getRowCount() <= 0) {
            return;
        }
        for (int i = 0; i < this.tblData.getRowCount(); ++i) {
            this.tblData.getRow(i).getCell(0).setValue((Object)new Boolean(sel));
        }
    }

    protected void onClickForRefresh() {
        this.eviCommonFilting = null;
        this.refreshRowsInTable();
    }

    protected void setStatus() {
        this.tblData.getColumn(0).getStyleAttributes().setHided(STATUS_ALL.equals(this.kDButtonGroup1.getSelection().getActionCommand()));
        this.refreshRowsInTable();
        this.initDataStatus();
    }

    private void refreshRowsInTable() {
        this.tblData.removeRows();
        this.assignedTabData.clear();
        this.unAssignedTabData.clear();
    }

    @Override
    protected void prmptOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.currentOrgUnitInfo = (OrgUnitInfo)this.prmptOrgUnit.getData();
        this.assignedTabData.clear();
        this.unAssignedTabData.clear();
        this.tblData.removeRows();
    }

    protected IGeneDataBaseD getBizInterfaceFromUIContext() {
        Object o = this.getUIContext().get("BizInterface");
        return (IGeneDataBaseD)o;
    }

    private MetaDataPK getQueryPKFromUIContext() {
        Object o = this.getUIContext().get("QueryPK");
        return (MetaDataPK)o;
    }

    private QueryInfo getQueryInfoFromUIContext() {
        Object o = this.getUIContext().get("QueryInfo");
        return (QueryInfo)o;
    }

    protected void initDataStatus() {
        if (this.kDButtonGroup1.getSelection().getActionCommand().equals(STATUS_ALL)) {
            this.btnReference.setVisible(false);
        } else if (this.kDButtonGroup1.getSelection().getActionCommand().equals(STATUS_IMPORTED)) {
            this.btnReference.setVisible(true);
            this.btnReference.setText(this.getMultiLangString("cancel") + this.getMultiLangString("reference"));
            this.selAll = true;
        } else {
            this.btnReference.setVisible(true);
            this.btnReference.setText(this.getMultiLangString("reference"));
            this.selAll = false;
        }
    }

    protected IRowSet getRowSet(int start, int length) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.getQueryPKFromUIContext());
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(this.buildEntityViewInfo());
        this.sql = exec.getSQL();
        return exec.executeQuery(start, length);
    }

    protected EntityViewInfo buildEntityViewInfo() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        if (this.isOptimizedQuery()) {
            fi.getFilterItems().add(new FilterItemInfo("dataAssign.assignOrgUnit.id", (Object)((OrgUnitInfo)this.prmptOrgUnit.getData()).getId().toString()));
        } else {
            fi.getFilterItems().add(new FilterItemInfo(this.getMainBizOrgFieldFromUIContext() + ".id", (Object)((OrgUnitInfo)this.prmptOrgUnit.getData()).getId().toString()));
        }
        if (this.fiRadioButtonsRelated != null) {
            fi.mergeFilter(this.fiRadioButtonsRelated, "and");
        }
        if (this.eviCommonFilting != null) {
            FilterInfo fii = this.eviCommonFilting.getFilter();
            if (fi != null && fii.getFilterItems() != null && fii.getFilterItems().size() != 0) {
                fi.mergeFilter(fii, "and");
            }
            SorterItemCollection sicc = this.eviCommonFilting.getSorter();
            SorterItemCollection sic = evi.getSorter();
            if (sicc != null && sicc.size() != 0) {
                int size = sicc.size();
                for (int i = 0; i < size; ++i) {
                    sic.add(sicc.get(i));
                }
            }
        }
        this.fiRadioButtonsRelated = null;
        return evi;
    }

    protected IRowSet getRSAll(int start, int length) throws Exception {
        this.fiRadioButtonsRelated = null;
        return this.getRowSet(start, length);
    }

    protected IRowSet getRSImported(int start, int length) throws Exception {
        this.fiRadioButtonsRelated = this.getFIRadioButtonsRelated(CompareType.INNER);
        return this.getRowSet(start, length);
    }

    protected IRowSet getRSUnimported(int start, int length) throws Exception {
        this.fiRadioButtonsRelated = this.getFIRadioButtonsRelated(CompareType.NOTINNER);
        return this.getRowSet(start, length);
    }

    private FilterInfo getFIRadioButtonsRelated(CompareType ct) throws Exception {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)this.getSqlForAllAssigned(), ct));
        return fi;
    }

    private String getSqlForAllAssigned() {
        String sql = "select distinct FDataBaseDID from T_EQM_GeneDataBaseDAssign where FAssignOrgUnitID='" + this.assignedOrgUnitInfo.getId().toString() + "' " + "and FBOSObjectType='" + this.getBizInterfaceFromUIContext().getType().toString() + "'";
        return sql;
    }

    public boolean destroyWindow() {
        Object obj;
        boolean result = super.destroyWindow();
        if (this.hasDoneSomething && (obj = this.getUIContext().get("Owner")) instanceof ListUI) {
            try {
                ((ListUI)obj).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                logger.debug((Object)"Exception:", (Throwable)e);
            }
        }
        return result;
    }

    protected String getMultiLangString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.eqm.common.core.GeneResource", (String)key);
    }

    private String getMainBizOrgFieldFromUIContext() {
        Object o = this.getUIContext().get("MainBizOrgField");
        return o == null ? null : (String)o;
    }

    private boolean isOptimizedQuery() {
        Object o = this.getUIContext().get("IsOptimizedQuery");
        return (Boolean)o;
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        if (this.currentOrgUnitInfo != null) {
            return this.currentOrgUnitInfo;
        }
        try {
            this.currentOrgUnitInfo = GeneClinetOrgUtils.getDefaultMainBizOrg((OrgType)this.getUIContext().get("OrgType"));
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return this.currentOrgUnitInfo;
    }

    protected void initWorkButton() {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnAllSelect.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnAllClear.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }
}

