/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.client.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.master.cssp.CSOptionInfo;
import com.kingdee.eas.basedata.master.cssp.CSType;
import com.kingdee.eas.basedata.master.cssp.client.CSUtils;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.eqm.common.core.client.f7.AbstractGeneralF7TreeListUI;
import com.kingdee.eas.eqm.common.core.client.f7.IF7Provider;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class GeneralF7TreeListUI
extends AbstractGeneralF7TreeListUI {
    private static final Logger logger = CoreUIObject.getLogger(GeneralF7TreeListUI.class);
    private Component adaptee;
    public static final int IDYES = 1;
    public static final int IDNO = 2;
    private int retVal;
    private String[] filterDisplayName;
    private String[] filterName;
    private static final int SELECTED = 1;
    private String value;
    private String queryInfoName;
    private String queryProperty;
    private String compareType;
    private boolean isQuickQuery = false;
    private static final int OBJECT_LISTUI_WIDTH = 800;
    private static final int OBJECT_LISTUI_HEIGHT = 500;

    public GeneralF7TreeListUI() throws Exception {
        this.txtInput.setMaxLength(60);
    }

    public Object getData() {
        if (this.adaptee instanceof IF7Provider) {
            return ((IF7Provider)((Object)this.adaptee)).getData();
        }
        if (this.adaptee instanceof KDPromptSelector) {
            return ((KDPromptSelector)this.adaptee).getData();
        }
        return null;
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.retVal = 1;
        this.uiWindow.close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.retVal = 2;
        this.uiWindow.close();
    }

    public void clickCancelBtn() throws Exception {
        this.btnCancel_actionPerformed(new ActionEvent((Object)this, 0, null));
    }

    public void clickOKBtn() throws Exception {
        this.btnOK_actionPerformed(new ActionEvent((Object)this, 0, null));
    }

    public void onLoad() throws Exception {
        this.adaptee = (Component)this.getUIContext().get("InnerWindow");
        this.filterDisplayName = (String[])this.getUIContext().get("FilterDisplayName");
        this.filterName = (String[])this.getUIContext().get("FilterName");
        this.value = (String)this.getUIContext().get("value");
        if (this.getUIContext().get("queryProperty") != null) {
            this.queryProperty = this.getUIContext().get("queryProperty").toString();
        }
        if (this.getUIContext().get("compareType") != null) {
            this.compareType = this.getUIContext().get("compareType").toString();
        }
        try {
            this.initInterface();
            this.initData();
            this.initComboCondition();
            this.treePanel.add(this.adaptee, (Object)"Center");
            ((ListUI)this.adaptee).initUIContentLayout();
            ((ListUI)this.adaptee).onLoad();
            this.setUITitle(((ListUI)this.adaptee).getUITitle());
        }
        catch (Exception er) {
            ExceptionHandler.handle((Throwable)er);
            SysUtil.abort();
        }
    }

    private void initComboCondition() throws BOSException, EASBizException {
        CSOptionInfo cSOptionInfo;
        if (this.adaptee instanceof F7CustomerTreeDetailListUI && (cSOptionInfo = CSUtils.getCSOptionInfo((CSType)CSType.CUSTOMER)) != null) {
            if (cSOptionInfo.isCsNumber()) {
                this.comboCondition.setSelectedIndex(0);
            } else if (cSOptionInfo.isCsName()) {
                this.comboCondition.setSelectedIndex(1);
            } else if (cSOptionInfo.isCsAssistNumber()) {
                this.comboCondition.setSelectedIndex(3);
            } else {
                this.comboCondition.setSelectedIndex(2);
            }
        }
        if (this.adaptee instanceof F7SupplierTreeDetailListUI && (cSOptionInfo = CSUtils.getCSOptionInfo((CSType)CSType.SUPPLIER)) != null) {
            if (cSOptionInfo.isCsNumber()) {
                this.comboCondition.setSelectedIndex(0);
            } else if (cSOptionInfo.isCsName()) {
                this.comboCondition.setSelectedIndex(1);
            } else if (cSOptionInfo.isCsAssistNumber()) {
                this.comboCondition.setSelectedIndex(2);
            }
        }
    }

    public int getRetVal() {
        return this.retVal;
    }

    private void initInterface() {
        this.btnRefresh.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.btnMaintenance.setEnabled(true);
        this.btnQuickQuery.setEnabled(true);
        this.btnQuery.setVisible(false);
        this.kDSelect.setEnabled(true);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnMaintenance.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.btnQuickQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.txtInput.setText(null);
        this.kDSelect.setToolTipText(null);
        this.btnQuickQuery.setToolTipText(null);
        this.txtInput.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != null && !GeneralF7TreeListUI.this.txtInput.getText().equals("") && e.getOppositeComponent().equals(GeneralF7TreeListUI.this.btnQuickQuery)) {
                    try {
                        GeneralF7TreeListUI.this.actionQuickQuery_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1);
                    }
                }
            }
        });
        if (this.getUIContext().get("Owner") instanceof Component && this.getUIContext().get("Owner") instanceof CoreUIObject) {
            if ((((CoreUIObject)this.getUIContext().get("Owner")).getOprtState() != null && ((CoreUIObject)this.getUIContext().get("Owner")).getOprtState().equals(OprtState.VIEW) || this.getUIContext().get("Owner") instanceof CustomerQueryPanel || ((Boolean)this.getUIContext().get("isShowUnUsed")).booleanValue()) && this.getUIContext().get("QueryName").toString().toLowerCase().indexOf(".master.cssp.") >= 0) {
                this.chkIncludeUnUsed.setVisible(true);
                this.chkIncludeUnUsed.setEnabled(true);
                this.chkIncludeUnUsed.setSelected(true);
            } else {
                this.chkIncludeUnUsed.setSelected(false);
            }
        }
    }

    @Override
    public void actionIncludeUnUsed_actionPerformed(ActionEvent e) throws Exception {
        ((ListUI)this.adaptee).refreshList();
    }

    private void initData() {
        if (this.filterDisplayName != null) {
            this.comboCondition.removeAllItems();
            this.comboCondition.addItems((Object[])this.filterDisplayName);
        } else {
            this.filterName = new String[]{"number", "name"};
        }
        this.setFilterInfo();
    }

    private void setFilterInfo() {
        FilterInfo customerFilterInfo = null;
        if (this.getUIContext().get("CustomerFilterInfo") == null) {
            customerFilterInfo = null;
        } else {
            customerFilterInfo = new FilterInfo();
            FilterInfo tempFilterInfo = (FilterInfo)this.getUIContext().get("CustomerFilterInfo");
            int c = tempFilterInfo.getFilterItems().size();
            for (int i = 0; i < c; ++i) {
                customerFilterInfo.getFilterItems().add(tempFilterInfo.getFilterItems().get(i));
            }
            if (tempFilterInfo.getMaskString() != null && !tempFilterInfo.getMaskString().equals("")) {
                customerFilterInfo.setMaskString(tempFilterInfo.getMaskString());
            }
        }
        FilterInfo quickFilterInfo = null;
        if (!this.txtInput.getText().trim().equals("") && this.kDSelect.isSelected()) {
            String compareValue = ParamHelper.getMatchString((String)this.txtInput.getText().trim());
            quickFilterInfo = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo(this.filterName[this.comboCondition.getSelectedIndex()], (Object)compareValue, CompareType.LIKE);
            quickFilterInfo.getFilterItems().add(filterItem);
        }
        if (!this.txtInput.getText().trim().equals("") && !this.kDSelect.isSelected()) {
            quickFilterInfo = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo(this.filterName[this.comboCondition.getSelectedIndex()], (Object)this.txtInput.getText().trim(), CompareType.EQUALS);
            quickFilterInfo.getFilterItems().add(filterItem);
        }
        if (!this.value.trim().equals("") && this.txtInput.getText().trim().equals("")) {
            this.queryInfoName = (String)this.getUIContext().get("QueryName");
            String queryName = "number";
            quickFilterInfo = new FilterInfo();
            if (this.queryInfoName.indexOf("F7MaterialSpecialQuery") > 0 || this.queryInfoName.indexOf("MeterialComQuery") > 0 || this.queryInfoName.indexOf("F7MeterialComQuery") > 0) {
                queryName = "mateial.number";
            }
            this.isQuickQuery = true;
            FilterItemInfo filterItem = new FilterItemInfo(queryName, (Object)(this.value.trim() + "%"), CompareType.LIKE);
            quickFilterInfo.getFilterItems().add(filterItem);
        }
        if (this.adaptee instanceof IF7Provider) {
            ((IF7Provider)((Object)this.adaptee)).setFilterInfo(customerFilterInfo, quickFilterInfo);
        }
    }

    @Override
    public void actionMaintenance_actionPerformed(ActionEvent e) throws Exception {
        IUIFactory uiFactory = null;
        try {
            UIContext uic = new UIContext((Object)this);
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
            IUIWindow ui = this.adaptee instanceof F7CustomerTreeDetailListUI ? uiFactory.create("com.kingdee.eas.basedata.master.cssp.client.CustomerInfoListUI", (Map)uic) : (this.adaptee instanceof F7SupplierTreeDetailListUI ? uiFactory.create("com.kingdee.eas.basedata.master.cssp.client.SupplierListUI", (Map)uic) : uiFactory.create(((ListUI)this.adaptee).getClass().getSuperclass().getName(), (Map)uic));
            ((JPanel)((JDialog)ui).getContentPane()).setPreferredSize(new Dimension(800, 500));
            ui.show();
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionQuickQuery_actionPerformed(ActionEvent e) throws Exception {
        this.setFilterInfo();
        this.isQuickQuery = true;
        if (((ListUI)this.adaptee).getMainTable() != null) {
            ((ListUI)this.adaptee).getMainTable().removeRows();
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        ListUI lstAdaptee = (ListUI)this.adaptee;
        lstAdaptee.refreshList();
    }

    public void setSearchValue(String value) {
        this.value = value;
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.retVal != 1) {
            this.retVal = 2;
        }
        return super.checkBeforeWindowClosing();
    }

    public void setSearchProperty(String property, String compareType) {
        this.queryProperty = property;
        this.compareType = compareType;
    }

    public boolean getChkIncludeUnUsedValue() {
        return this.chkIncludeUnUsed.isSelected() && this.chkIncludeUnUsed.isVisible();
    }

    public boolean isQuickQuery() {
        if (this.value.equals("")) {
            return !this.txtInput.getText().trim().equals("");
        }
        return true;
    }

    public boolean getQuickQuery() {
        return this.isQuickQuery;
    }

    public void setQuickQuery(boolean isQuickQuery) {
        this.isQuickQuery = isQuickQuery;
    }

    public void setFocus() {
        this.txtInput.requestFocus();
    }
}

