/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.print;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.eqm.common.core.print.GeneDataSourceProviderProxy;
import com.kingdee.eas.eqm.common.core.print.GeneQueryExecutorFactory;
import com.kingdee.eas.eqm.common.core.print.IGeneCustomFilterMaker;
import com.kingdee.eas.eqm.common.core.print.IGeneCustomQueryExecutorFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class GenePrintDataProvider
extends AbstractPrintDataProvider {
    public static final Logger log = LogUtil.getPackageLogger(GeneDataSourceProviderProxy.class);
    private IMetaDataPK _defaultMetaDataPk = null;
    private AbstractPrintDataProvider _defaultDataProvider = null;
    private Map _proxyTargetMap = new HashMap();
    private Map _metaDataPkMap = new HashMap();
    private IGeneCustomFilterMaker _defaultCustomFilterMaker = null;
    private Map _customFilterMakers = new HashMap();
    private IGeneCustomQueryExecutorFactory _cuExecuteFacotry = null;

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        AbstractPrintDataProvider refProxyTarget;
        String dsId = dataSource.getId();
        AbstractPrintDataProvider proxyTarget = this.getProxyTarget(dsId);
        if (proxyTarget != null) {
            return proxyTarget.getData(dataSource);
        }
        if (!StringUtil.isEmptyString((String)dataSource.getReference()) && (refProxyTarget = this.getProxyTarget(dataSource.getReference())) != null) {
            return refProxyTarget.getData(dataSource);
        }
        AbstractPrintDataProvider defaultProxyTarget = this.getDefaultDataProvider();
        if (defaultProxyTarget != null) {
            return defaultProxyTarget.getData(dataSource);
        }
        IMetaDataPK pk = null;
        if (!StringUtil.isEmptyString((String)dataSource.getReference())) {
            pk = MetaDataPKFactory.getMetaDataPK((String)dataSource.getReference());
        }
        if (pk == null) {
            pk = this.getMetaDataPk(dsId);
        }
        if (pk == null) {
            pk = this.getDefaultMetaDataPK();
        }
        if (pk == null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.eqm.common.COMMONAutoGenerateResource", (String)"14_GenePrintDataProvider");
            MessageFormat mf = new MessageFormat(msg);
            throw new R1PrintRuntimeException(mf.format(new String[]{dsId}));
        }
        IQueryExecutor exec = this.createExecutor(pk, dsId, dataSource);
        IRowSet rowSet = exec.executeQuery();
        rowSet = this.afterExecuteQuery(rowSet);
        return rowSet;
    }

    public IRowSet afterExecuteQuery(IRowSet rowSet) throws Exception {
        return rowSet;
    }

    public IQueryExecutor createExecutor(IMetaDataPK pk, String ds, R1PrintDataSource dataSource) throws Exception {
        IQueryExecutor exec = this.getCustomQueryExecutorFactory().getQueryExecutor(pk);
        exec.option().isAutoTranslateEnum = true;
        exec.option().isAutoTranslateBoolean = true;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        IGeneCustomFilterMaker filterMaker = this.getCustomFilterMaker(ds);
        if (filterMaker != null) {
            filterMaker.customizeFilter(filter, dataSource.getParams());
        }
        ev.setFilter(filter);
        exec.setObjectView(ev);
        return exec;
    }

    protected IMetaDataPK getDefaultMetaDataPK() {
        return this._defaultMetaDataPk;
    }

    public void setDefaultMetaDataPK(IMetaDataPK pk) {
        this._defaultMetaDataPk = pk;
    }

    public void setDefaultDataProvider(AbstractPrintDataProvider provider) {
        this._defaultDataProvider = provider;
    }

    protected AbstractPrintDataProvider getDefaultDataProvider() {
        return this._defaultDataProvider;
    }

    protected AbstractPrintDataProvider getProxyTarget(String dsId) {
        return (AbstractPrintDataProvider)this._proxyTargetMap.get(dsId);
    }

    public void addProxyTarget(String dsId, AbstractPrintDataProvider provider) {
        this._proxyTargetMap.put(dsId, provider);
    }

    protected IMetaDataPK getMetaDataPk(String dsId) {
        return (IMetaDataPK)this._metaDataPkMap.get(dsId);
    }

    public void addMetaDataPk(String dsId, IMetaDataPK pk) {
        this._metaDataPkMap.put(dsId, pk);
    }

    public void setCustomFilterMaker(IGeneCustomFilterMaker customFilterMaker) {
        this._defaultCustomFilterMaker = customFilterMaker;
    }

    public void addCustomFilterMaker(String ds, IGeneCustomFilterMaker customFilterMaker) {
        this._customFilterMakers.put(ds, customFilterMaker);
    }

    protected IGeneCustomFilterMaker getCustomFilterMaker(String ds) {
        IGeneCustomFilterMaker filter = (IGeneCustomFilterMaker)this._customFilterMakers.get(ds);
        if (filter == null) {
            filter = this._defaultCustomFilterMaker;
        }
        return filter;
    }

    public void setCustomQueryExecutorFactory(IGeneCustomQueryExecutorFactory customQueryExecutorFactory) {
        this._cuExecuteFacotry = customQueryExecutorFactory;
    }

    public IGeneCustomQueryExecutorFactory getCustomQueryExecutorFactory() {
        if (this._cuExecuteFacotry == null) {
            this._cuExecuteFacotry = new GeneQueryExecutorFactory();
        }
        return this._cuExecuteFacotry;
    }
}

