/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentWorkOrderModelInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.client.GeneBillBaseFilterUI;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.maintain.FaultReportEntryInfo;
import com.kingdee.eas.eqm.maintain.TaskReqCollection;
import com.kingdee.eas.eqm.maintain.TaskReqFactory;
import com.kingdee.eas.eqm.maintain.TaskReqInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderException;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderSrcTypeEnum;
import com.kingdee.eas.eqm.maintain.WorkOrderTypeEnum;
import com.kingdee.eas.eqm.maintain.client.AbstractCreateFromTaskReqListUI;
import com.kingdee.eas.eqm.maintain.client.CreateFromTaskReqFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class CreateFromTaskReqListUI
extends AbstractCreateFromTaskReqListUI {
    private static final Logger logger = CoreUIObject.getLogger(CreateFromTaskReqListUI.class);
    private static final String TB_ID = "id";
    private static final String TB_SELECTED = "isSelected";

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor checkBoxEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.tblMain.getColumn(TB_SELECTED).setEditor((ICellEditor)checkBoxEditor);
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("completeDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("findDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.toolBar.remove((Component)this.btnAuditResult);
        this.toolBar.remove((Component)this.btnAttachment);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setWidth(580);
        this.commonQueryDialog.setHeight(435);
        return this.commonQueryDialog;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (this.tblMain.getCell(i, TB_SELECTED) == null) continue;
            this.tblMain.getCell(i, TB_SELECTED).setValue((Object)Boolean.FALSE);
            this.tblMain.getCell(i, TB_SELECTED).getStyleAttributes().setLocked(false);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaskReqFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected GeneBillBaseFilterUI newInstanceFilterUI() throws Exception {
        CreateFromTaskReqFilterUI taskReqFilterUI = new CreateFromTaskReqFilterUI();
        return taskReqFilterUI;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        WorkOrderInfo workOrderInfo = new WorkOrderInfo();
        Set set = this.getSelectedRows(this.tblMain);
        if (set.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        TaskReqCollection taskReqCollection = TaskReqFactory.getRemoteInstance().getCollectionByIds(set);
        int n = taskReqCollection.size();
        for (int i = 0; i < n; ++i) {
            TaskReqInfo taskReqInfo = taskReqCollection.get(i);
            StorageOrgUnitInfo maintainOrgUnitInfo = taskReqInfo.getMaintainOrgUnit();
            EquipmentLocationInfo equipmentLocation = taskReqInfo.getEquipmentLocation();
            EquipmentArchivesInfo equipmentArchives = taskReqInfo.getEquipmentArchives();
            EquipmentWorkOrderModelInfo equipmentWorkOrderModel = taskReqInfo.getWorkOrderModel();
            AdminOrgUnitInfo maintainWorkShop = taskReqInfo.getMaintainWorkShop();
            Date completeDate = taskReqInfo.getCompleteDate();
            String accessoryDetails = taskReqInfo.getAccessoryDetails();
            if (i == 0) {
                workOrderInfo.setPlanOrgunit(maintainOrgUnitInfo);
                workOrderInfo.setMaintainOrgUnit(maintainOrgUnitInfo);
                workOrderInfo.setEqmLocation(equipmentLocation);
                workOrderInfo.setEquipmentArchives(equipmentArchives);
                workOrderInfo.setWorkOrderModel(equipmentWorkOrderModel);
                workOrderInfo.setMaintainDept(maintainWorkShop);
                workOrderInfo.setPlanEndTime(completeDate);
                workOrderInfo.setDescription(accessoryDetails);
                workOrderInfo.setTaskType(WorkOrderTypeEnum.WORKORDER);
                workOrderInfo.setBillStatus(GeneBillBaseStatusEnum.AddNew);
                workOrderInfo.setSourcetype(WorkOrderSrcTypeEnum.MAINTAINTASKREQ);
                workOrderInfo.setPlanStartTime(GeneDateUtils.now());
                workOrderInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                Calendar cal = Calendar.getInstance();
                workOrderInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
            } else {
                String description;
                Date planEndTime;
                AdminOrgUnitInfo maintainDept;
                EquipmentWorkOrderModelInfo eqmWorkOrderModel;
                EquipmentArchivesInfo eqmArchives;
                EquipmentLocationInfo eqmLocation;
                StorageOrgUnitInfo orgUnit = workOrderInfo.getMaintainOrgUnit();
                if (!(orgUnit == null || maintainOrgUnitInfo != null && orgUnit.getId().toString().equals(maintainOrgUnitInfo.getId().toString()))) {
                    StorageOrgUnitInfo defaultMainBizOrg = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
                    workOrderInfo.setMaintainOrgUnit(defaultMainBizOrg);
                    workOrderInfo.setPlanOrgunit(defaultMainBizOrg);
                }
                if (!((eqmLocation = workOrderInfo.getEqmLocation()) == null || equipmentLocation != null && eqmLocation.getId().toString().equals(equipmentLocation.getId().toString()))) {
                    workOrderInfo.setEqmLocation(null);
                }
                if (!((eqmArchives = workOrderInfo.getEquipmentArchives()) == null || equipmentArchives != null && eqmArchives.getId().toString().equals(equipmentArchives.getId().toString()))) {
                    workOrderInfo.setEquipmentArchives(null);
                }
                if (!((eqmWorkOrderModel = workOrderInfo.getWorkOrderModel()) == null || equipmentWorkOrderModel != null && eqmWorkOrderModel.getId().toString().equals(equipmentWorkOrderModel.getId().toString()))) {
                    workOrderInfo.setWorkOrderModel(null);
                }
                if (!((maintainDept = workOrderInfo.getMaintainDept()) == null || maintainWorkShop != null && maintainDept.getId().toString().equals(maintainWorkShop.getId().toString()))) {
                    workOrderInfo.setMaintainDept(null);
                }
                if ((planEndTime = workOrderInfo.getPlanEndTime()) != null && (completeDate == null || planEndTime.compareTo(completeDate) != 0)) {
                    workOrderInfo.setPlanEndTime(null);
                }
                if (!((description = workOrderInfo.getDescription()) == null || accessoryDetails != null && description.equals(accessoryDetails))) {
                    workOrderInfo.setDescription(null);
                }
            }
            FaultReportEntryInfo faultReportEntryInfo = new FaultReportEntryInfo();
            faultReportEntryInfo.setFaultLevel(taskReqInfo.getFaultLevel());
            faultReportEntryInfo.setFaultSort(taskReqInfo.getFaultSort());
            faultReportEntryInfo.setQuestionDesc(taskReqInfo.getMainReqOrFault());
            faultReportEntryInfo.setFinder(taskReqInfo.getFinder());
            faultReportEntryInfo.setFindDate(taskReqInfo.getFindDate());
            faultReportEntryInfo.setWorkTel(taskReqInfo.getWorkTel());
            faultReportEntryInfo.setTaskReq(taskReqInfo);
            workOrderInfo.getFaultReportEntry().add(faultReportEntryInfo);
        }
        StorageOrgUnitInfo orgUnit = workOrderInfo.getMaintainOrgUnit();
        if (orgUnit != null) {
            Context ctx = this.getMainOrgContext();
            UserInfo caller = SysContext.getSysContext().getCurrentUserInfo();
            IPermission perm = PermissionFactory.getRemoteInstanceWithObjectContext((Context)ctx);
            ObjectStringPK userPk = new ObjectStringPK(caller.getId().toString());
            ObjectStringPK orgPK = new ObjectStringPK(orgUnit.getId().toString());
            if (!"00000000-0000-0000-0000-00000000000013B7DE7F".equals(caller.getId().toString()) && !perm.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPK, "eqm_maintain_workorderplan_02addnew")) {
                throw new WorkOrderException(WorkOrderException.ADDNEW_USERNOPERMISSION, new String[]{orgUnit.getName()});
            }
        }
        this.getUIContext().put("workOrderInfo", workOrderInfo);
        this.disposeUIWindow();
    }

    private Set getSelectedRows(KDTable table) throws Exception {
        HashSet<String> set = new HashSet<String>();
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object o = table.getRow(i).getCell(TB_SELECTED).getValue();
            if (o == null || !((Boolean)o).booleanValue()) continue;
            String id = this.tblMain.getCell(i, TB_ID).getValue().toString();
            set.add(id);
        }
        return set;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (this.tblMain.getCell(i, TB_SELECTED).getValue() == null) {
                this.tblMain.getCell(i, TB_SELECTED).setValue((Object)Boolean.FALSE);
            }
            this.tblMain.getCell(i, TB_SELECTED).getStyleAttributes().setLocked(false);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String getOnloadPermItemName() {
        return "eqm_maintain_taskreq_01view";
    }

    protected boolean isSupportDynQuery() {
        return true;
    }
}

