/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.agent.AgentException;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.framework.client.UILifeCycleEvent;
import com.kingdee.eas.framework.client.UILifeCycleImp;
import com.kingdee.eas.framework.client.multiDetail.DetailPanelEvent;
import com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class CustomerPanel
extends JPanel {
    private static final long serialVersionUID = 8270496064249825738L;
    private static final Logger logger = Logger.getLogger(CustomerPanel.class);
    protected KDPanel controlPanel;
    protected KDTable entryTable;
    protected KDPanel entryPanel;
    protected KDContainer kdConTitle;
    protected HashMap resourceMap = null;
    protected DataBinder dataBinder = null;
    private AbstractObjectValue newDetailInfo = null;
    protected Rectangle rect = null;
    private boolean isAgent = false;
    protected CoreUI ui = null;
    protected KDWorkButton btnAddnewLine;
    protected KDWorkButton btnInsertLine;
    protected KDWorkButton btnRemoveLines;
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.WorkOrderResource";
    private Set addListeners = new HashSet();
    private Set removeListeners = new HashSet();
    private Set insertListeners = new HashSet();

    public CustomerPanel(CoreUI ui, DataBinder binder, KDTable kdt, AbstractObjectValue newVO, HashMap resourceMap, boolean isAgent) throws Exception {
        this(binder, kdt, newVO, resourceMap, isAgent);
        this.ui = ui;
        this.ui.getUILifeCycleHandler().addRuleListener((IUILifeCycleListener)new UILifeListener());
        actionBackListener backListener = new actionBackListener();
        this.addAddListener(backListener);
        this.addInsertListener(backListener);
        this.addRemoveListener(backListener);
    }

    public abstract KDWorkButton getPlanButton();

    public CustomerPanel(DataBinder binder, KDTable kdt, AbstractObjectValue newVO, HashMap resourceMap, boolean isAgent) throws Exception {
        CtrlUIEnv.setKingdeeLAF();
        this.jbInit();
        if (binder == null) {
            logger.debug((Object)"databinder is not null!");
            return;
        }
        this.dataBinder = binder;
        this.entryTable = kdt;
        this.rect = this.entryTable.getBounds();
        this.newDetailInfo = newVO;
        if (this.newDetailInfo == null) {
            logger.debug((Object)"detailinfo is not null!");
        }
        this.resourceMap = resourceMap;
        this.isAgent = isAgent;
        this.initKDWorkButtion();
        this.initUIContentLayout();
    }

    public void initStatus(String oprtStatus) {
    }

    public void jbInit() throws Exception {
        this.kdConTitle = new KDContainer();
        this.kdConTitle.setName("kdDetailCon");
        this.kdConTitle.setBounds(0, 5, 100, 24);
        this.kdConTitle.setContainerType(2);
        this.kdConTitle.setTitleStyle(1);
        this.controlPanel = new KDPanel();
        this.entryTable = new KDTable();
        this.entryPanel = new KDPanel();
        this.btnAddnewLine = new KDWorkButton();
        this.btnInsertLine = new KDWorkButton();
        this.btnRemoveLines = new KDWorkButton();
        this.controlPanel.setName("controlPanel");
        this.entryTable.setName("entryTable");
        this.entryPanel.setName("entryPanel");
        this.btnAddnewLine.setName("btnAddnewLine");
        this.btnInsertLine.setName("btnInsertLine");
        this.btnRemoveLines.setName("btnRemoveLines");
        this.registerBindings();
        this.registerUIState();
    }

    public void initKDWorkButtion() {
        this.btnAddnewLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_AddLine"));
        this.btnAddnewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_InsertLine"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLines.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_RemoveLine"));
        this.btnRemoveLines.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public void initUIContentLayout() {
        this.setBounds(this.entryTable.getBounds());
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, this.rect.width, this.rect.height));
        this.setBounds(this.entryTable.getBounds());
        Rectangle controlRect = new Rectangle(0, 0, this.rect.width, 24);
        this.controlPanel.setBounds(controlRect);
        this.controlPanel.putClientProperty((Object)"OriginalBounds", (Object)controlRect);
        Rectangle entryRect = new Rectangle(0, 29, this.rect.width, this.rect.height - 29);
        this.entryPanel.setBounds(entryRect);
        this.entryPanel.putClientProperty((Object)"OriginalBounds", (Object)entryRect);
        this.add((Component)this.controlPanel, new KDLayout.Constraints(13, controlRect));
        this.add((Component)this.entryPanel, new KDLayout.Constraints(15, entryRect));
        this.entryPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.entryTable.setBounds(entryRect);
        this.entryPanel.add((Component)this.entryTable, (Object)"Center");
    }

    public KDWorkButton getAddNewLineButton() {
        return this.btnAddnewLine;
    }

    public KDWorkButton getInsertLineButton() {
        return this.btnInsertLine;
    }

    public KDWorkButton getRemoveLinesButton() {
        return this.btnRemoveLines;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "sdfdfsdf";
        }
        this.kdConTitle.setTitle(title);
    }

    private void registerBindings() {
    }

    private void registerUIState() {
    }

    public void loadFields() {
    }

    public void storeFields() {
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        if (table == null) {
            return null;
        }
        if (this.isAgent) {
            EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.newDetailInfo.getBOSType());
            try {
                Class<?> agentClz = Class.forName(entity.getBusinessAgent());
                Method method = agentClz.getMethod("copyOvAsNewAgent", IObjectValue.class);
                Object obj = method.invoke(agentClz, this.newDetailInfo);
                if (obj instanceof IObjectValue) {
                    return (IObjectValue)obj;
                }
                return null;
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e);
                throw new AgentException("Exception at creating agent instance from BOS value object:" + this.newDetailInfo, e.getCause());
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new AgentException("Exception at creating agent instance from BOS value object:" + this.newDetailInfo, (Throwable)e);
            }
        }
        return (IObjectValue)this.newDetailInfo.clone();
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected IObjectCollection getBindData(KDTable table) {
        return (IObjectCollection)table.getUserObject();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.storeLineFields(table, row, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAddListener(IDetailPanelListener listener) {
        Set set = this.addListeners;
        synchronized (set) {
            this.addListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInsertListener(IDetailPanelListener listener) {
        Set set = this.insertListeners;
        synchronized (set) {
            this.insertListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoveListener(IDetailPanelListener listener) {
        Set set = this.removeListeners;
        synchronized (set) {
            this.removeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddLineBeforeAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.addListeners;
        synchronized (set) {
            iterator = new HashSet(this.addListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent((Object)this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.beforeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddLineAfterAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.addListeners;
        synchronized (set) {
            iterator = new HashSet(this.addListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent((Object)this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.afterEvent(event);
        }
        this.entryTable.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInsertLineBeforeAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.insertListeners;
        synchronized (set) {
            iterator = new HashSet(this.insertListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent((Object)this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.beforeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInsertLineAfterAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.insertListeners;
        synchronized (set) {
            iterator = new HashSet(this.insertListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent((Object)this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.afterEvent(event);
        }
        this.entryTable.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveLineBeforeAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.removeListeners;
        synchronized (set) {
            iterator = new HashSet(this.removeListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent((Object)this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.beforeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveLineAfterAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.removeListeners;
        synchronized (set) {
            iterator = new HashSet(this.removeListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent((Object)this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.afterEvent(event);
        }
        this.entryTable.repaint();
    }

    class UILifeListener
    extends UILifeCycleImp {
        UILifeListener() {
        }

        public void beforeOnload(UILifeCycleEvent event) {
            CoreUI ui = (CoreUI)event.getSource();
            CustomerPanel.this.initStatus(ui.getOprtState());
        }

        public void onSetDataObject(UILifeCycleEvent event) {
            this.beforeOnload(event);
        }
    }

    class actionBackListener
    implements IDetailPanelListener {
        actionBackListener() {
        }

        public void beforeEvent(DetailPanelEvent event) throws Exception {
        }

        public void afterEvent(DetailPanelEvent event) throws Exception {
            if (CustomerPanel.this.ui == null) {
                return;
            }
            if (CustomerPanel.this.ui instanceof EditUI) {
                EditUI editUI = (EditUI)CustomerPanel.this.ui;
                editUI.refreshFootROw(CustomerPanel.this.entryTable);
            }
        }
    }
}

