/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.client.listener.AbstractGeneTableColumnListener;
import com.kingdee.eas.eqm.common.core.client.listener.GeneKDTable;
import com.kingdee.eas.eqm.common.core.client.listener.GeneTableColumnListener;
import com.kingdee.eas.eqm.common.core.client.util.GeneClientUtils;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.common.eqmcore.client.util.ControlledItems;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.MaintainNotifyException;
import com.kingdee.eas.eqm.maintain.MaintainReturningNotifyEntryInfo;
import com.kingdee.eas.eqm.maintain.MaintainReturningNotifyFactory;
import com.kingdee.eas.eqm.maintain.MaintainReturningNotifyInfo;
import com.kingdee.eas.eqm.maintain.NotifyTypeEnum;
import com.kingdee.eas.eqm.maintain.SourceBillTypeEnum;
import com.kingdee.eas.eqm.maintain.client.AbstractMaintainReturningNotifyEditUI;
import com.kingdee.eas.eqm.maintain.client.MultiMeasureUnitUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MaintainReturningNotifyEditUI
extends AbstractMaintainReturningNotifyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MaintainReturningNotifyEditUI.class);
    private MultiMeasureUnitUtil multiMeasureUnitUtil;
    public static final String TBL_KDTENTRYS = "kdtEntrys";
    public static final String COL_ID = "id";
    public static final String COL_IDENTIFICATION = "identification";
    public static final String COL_MATERIAL = "material";
    public static final String COL_MATERIALNAME = "materialName";
    public static final String COL_MODEL = "model";
    public static final String COL_UNIT = "unit";
    public static final String COL_REQQTY = "reqQty";
    public static final String COL_REQDATE = "reqDate";
    public static final String COL_WAREHOUSE = "wareHouse";
    public static final String COL_OUTQTY = "outQty";
    public static final String COL_REMARK = "remark";
    GeneKDTable geneKDTable = null;
    Map map = new HashMap();
    private ChangeListener locationListener = null;
    private ChangeListener equipmentListener = null;
    private GeneTableColumnListener materialListener = null;
    private PropertyChangeListener loadLineListener = null;
    private GeneTableColumnListener unitListener = null;

    public MaintainReturningNotifyEditUI() throws Exception {
        this.multiMeasureUnitUtil = new MultiMeasureUnitUtil();
        this.geneKDTable = new GeneKDTable(this.kdtEntrys);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MaintainReturningNotifyFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.remove((Component)this.kdtEntrys_detailPanel);
        this.add((Component)this.kdtEntrys, new KDLayout.Constraints(10, 117, 870, 456, 15));
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.toolBar.remove((Component)this.btnClose);
        this.toolBar.remove((Component)this.btnForceClose);
        this.toolBar.add((Component)this.btnClose);
        this.toolBar.add((Component)this.btnForceClose);
    }

    @Override
    protected IObjectValue createNewData() {
        return this.doCreateNewData(null);
    }

    protected IObjectValue createNewDetailData(KDTable table, IRow srcrow) {
        MaintainReturningNotifyEntryInfo entryInfo = new MaintainReturningNotifyEntryInfo();
        entryInfo.setReqDate(new Date());
        entryInfo.setReqQty(new BigDecimal(0));
        entryInfo.setOutQty(new BigDecimal(0));
        return entryInfo;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected IObjectValue newInstanceData() throws EASBizException, BOSException {
        MaintainReturningNotifyInfo info = new MaintainReturningNotifyInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        info.setNotifyType(NotifyTypeEnum.returningMaterial);
        info.setBillStatus(GeneBillBaseStatusEnum.AddNew);
        info.setSourceBillType(SourceBillTypeEnum.self);
        return info;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtOrgUnit;
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        super.loadLineFields(table, row, obj);
        MaintainReturningNotifyEntryInfo entryInfo = (MaintainReturningNotifyEntryInfo)obj;
        this.entryStatus(row, entryInfo);
    }

    private void entryStatus(IRow row, MaintainReturningNotifyEntryInfo entryInfo) {
        boolean entryBotp = entryInfo.getSourceBillID() != null && entryInfo.getMaterial() != null;
        row.getCell(COL_IDENTIFICATION).getStyleAttributes().setLocked(entryBotp || !this.isBotp());
        row.getCell(COL_UNIT).getStyleAttributes().setLocked(entryBotp);
        row.getCell(COL_REQDATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        row.getCell(COL_MATERIAL).getStyleAttributes().setLocked(entryBotp);
        MeasureUnitInfo baseUnitInfo = (MeasureUnitInfo)row.getCell(COL_UNIT).getValue();
        MultiMeasureUnitInfo multiUnitInfo = null;
        MaterialInfo material = (MaterialInfo)row.getCell(COL_MATERIAL).getValue();
        if (material != null && material.getId() != null && baseUnitInfo != null) {
            try {
                this.setPrmpMeasuteUnitDialog(material.getId().toString(), row.getRowIndex());
                multiUnitInfo = this.multiMeasureUnitUtil.getMutiMeasureUnitInfo(material, baseUnitInfo);
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
        }
        int qtyPrecision = 4;
        if (multiUnitInfo != null) {
            qtyPrecision = multiUnitInfo.getQtyPrecision();
        } else if (baseUnitInfo != null) {
            qtyPrecision = baseUnitInfo.getQtyPrecision();
        }
        if (row.getCell(COL_REQQTY).getValue() == null) {
            row.getCell(COL_REQQTY).setValue((Object)new BigDecimal("0"));
        } else {
            row.getCell(COL_REQQTY).setValue((Object)new BigDecimal(row.getCell(COL_REQQTY).getValue().toString()).setScale(qtyPrecision, 4));
        }
        if (row.getCell(COL_OUTQTY).getValue() == null) {
            row.getCell(COL_OUTQTY).setValue((Object)new BigDecimal("0"));
        } else {
            row.getCell(COL_OUTQTY).setValue((Object)new BigDecimal(row.getCell(COL_OUTQTY).getValue().toString()).setScale(qtyPrecision, 4));
        }
        EQMPromptDialogFactory.createNumberic((KDTable)this.kdtEntrys, (int)this.kdtEntrys.getColumnIndex(COL_REQQTY), (int)row.getRowIndex(), (int)qtyPrecision);
        EQMPromptDialogFactory.createNumberic((KDTable)this.kdtEntrys, (int)this.kdtEntrys.getColumnIndex(COL_OUTQTY), (int)row.getRowIndex(), (int)qtyPrecision);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionClose.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_closing"));
        this.actionForceClose.putValue("SmallIcon", EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_hardclosing", (Locale)SysContext.getSysContext().getLocale()));
        this.actionMultiapprove.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.actionClose.setVisible(false);
        this.actionClose.setEnabled(false);
        this.actionTraceDown.setVisible(true);
        this.actionTraceDown.setEnabled(true);
        this.actionTraceUp.setVisible(true);
        this.actionTraceUp.setEnabled(true);
        this.actionCreateFrom.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.actionTDPrint.setVisible(false);
        this.actionTDPrint.setEnabled(false);
        this.actionTDPrintPreview.setVisible(false);
        this.actionTDPrintPreview.setEnabled(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.initUIStatus();
        this.actionCreateFrom.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.menuItemMaterialView.setVisible(true);
        this.menuItemEquipmentView.setVisible(true);
        this.menuItemMaterialView.setEnabled(true);
        this.menuItemEquipmentView.setEnabled(true);
    }

    private void initUIStatus() {
        MaintainReturningNotifyInfo info = (MaintainReturningNotifyInfo)this.getDataObject();
        if (info != null) {
            boolean canOpt = !this.isBotp();
            this.prmtequipment.setEnabled(canOpt);
            this.prmtlocation.setEnabled(canOpt);
            this.prmtdepart.setEnabled(true);
            this.prmtclassGroup.setEnabled(canOpt);
            this.prmtworkOrder.setEnabled(false);
        }
    }

    private boolean isBotp() {
        MaintainReturningNotifyInfo info = (MaintainReturningNotifyInfo)this.getDataObject();
        return info.getWorkOrder() != null;
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        try {
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtdepart, (String)"com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Admin, (OrgUnitInfo)this.getMainOrgInfo());
            this.regesiterMaterial();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected ControlledItems[] getNeedMainOrgControl() {
        return new ControlledItems[]{new ControlledItems(this.prmtequipment, "maintainOrgUnit.id"), new ControlledItems(this.prmtlocation, "maintainOrgUnit.id"), new ControlledItems(this.prmtworkOrder), new ControlledItems(this.prmtclassGroup), new ControlledItems(this.kdtEntrys, COL_WAREHOUSE, "com.kingdee.eas.basedata.scm.im.inv.app.F7AllWarehouseQuery", "storageOrg.id"), new ControlledItems(this.kdtEntrys, COL_MATERIAL, "com.kingdee.eas.eqm.archives.app.F7MaterialInventoryNoGroupQuery", "StorageOrgUnit.id")};
    }

    public void registerCustomerBindings() {
        super.registerCustomerBindings();
        this.cboBillStatus.addItems((Object[])new GeneBillBaseStatusEnum[]{GeneBillBaseStatusEnum.AddNew, GeneBillBaseStatusEnum.SAVE, GeneBillBaseStatusEnum.Submit, GeneBillBaseStatusEnum.Audit, GeneBillBaseStatusEnum.CLOSED, GeneBillBaseStatusEnum.ForceClosed});
        MaintainReturningNotifyInfo info = (MaintainReturningNotifyInfo)this.getDataObject();
        if (info != null && info.getBillStatus() != null) {
            this.cboBillStatus.setSelectedItem((Object)info.getBillStatus());
        }
        try {
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtdepart, (String)"com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Admin, (OrgUnitInfo)((OrgUnitInfo)this.prmtOrgUnit.getValue()));
            this.regesiterMaterial();
            EQMPromptDialogFactory.createRemark((KDTable)this.kdtEntrys, (String)COL_REMARK, (int)80);
            this.setPrmtArchives(this.prmtlocation.getValue() == null || !(this.prmtlocation.getValue() instanceof EquipmentLocationInfo) ? null : (EquipmentLocationInfo)this.prmtlocation.getValue());
            EQMPromptDialogFactory.createPrmptList((KDTable)this.kdtEntrys, (String)COL_UNIT, (String)"com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtOrgUnit, (String)this.getAddNewPermItemName(), (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        if (this.txtNumber.isEnabled()) {
            this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{this.prmtOrgUnit, this.txtNumber, this.dateBizDate, this.prmtequipment, this.prmtdepart, this.prmtlocation, this.prmtclassGroup, this.txtDescription, this.kdtEntrys}));
            this.setFocusCycleRoot(true);
        } else {
            this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{this.prmtOrgUnit, this.dateBizDate, this.prmtequipment, this.prmtdepart, this.prmtlocation, this.prmtclassGroup, this.txtDescription, this.kdtEntrys}));
            this.setFocusCycleRoot(true);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        if (this.txtNumber.isEnabled()) {
            this.txtNumber.requestFocusInWindow();
        } else {
            this.prmtequipment.requestFocusInWindow();
        }
    }

    private void regesiterMaterial() throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new MaterialInfo().getBOSType(), (String)"", (boolean)false, (boolean)true, (boolean)true));
        sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        entityViewInfo.setSelector(sic);
        OrgUnitInfo org = (OrgUnitInfo)this.prmtOrgUnit.getValue();
        if (org == null) {
            org = this.getMainOrgInfo();
        }
        if (org.getCU() == null || org.getCU() != null && org.getCU().getNumber() == null || org.getCU() != null && org.getCU().getLongNumber() == null) {
            try {
                if (this.map.get(org.getId()) == null) {
                    if (org.getCU() == null) {
                        IStorageOrgUnit iStorage = StorageOrgUnitFactory.getRemoteInstance();
                        StorageOrgUnitInfo org1 = iStorage.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId()), GeneSelectorUtils.getSelector((BOSObjectType)new StorageOrgUnitInfo().getBOSType(), (String)"", (boolean)false, (boolean)true, (boolean)false));
                        org.setCU(org1.getCU());
                        this.map.put(org.getId(), org);
                    } else {
                        CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(org.getCU().getId()));
                        org.setCU(ctrlUnitInfo);
                        this.map.put(org.getId(), org);
                    }
                } else {
                    org = (OrgUnitInfo)this.map.get(org.getId());
                }
            }
            catch (EASBizException e) {
                // empty catch block
            }
        }
        FilterInfo baseFilter = new FilterInfo();
        if (org != null && org.getId() != null) {
            baseFilter.getFilterItems().add(new FilterItemInfo("Inventory.StorageOrgUnit.id", (Object)org.getId().toString()));
        }
        baseFilter.getFilterItems().add(new FilterItemInfo("equipProperty", (Object)new Integer(2), CompareType.NOTEQUALS));
        entityViewInfo.setFilter(baseFilter);
        EQMPromptDialogFactory.createPrmptList((KDTable)this.kdtEntrys, (String)COL_MATERIAL, (String)"com.kingdee.eas.eqm.archives.app.F7MaterialInventoryNoGroupQuery", (EntityViewInfo)entityViewInfo, (String)"$number$", (String)"$number$");
        KDTDefaultCellEditor materialce = (KDTDefaultCellEditor)this.kdtEntrys.getColumn(COL_MATERIAL).getEditor();
        KDBizPromptBox material = (KDBizPromptBox)materialce.getComponent();
        material.setCurrentMainBizOrgUnit(org, OrgType.Storage);
    }

    protected void initListener() {
        super.initListener();
        this.registerListener();
    }

    protected void applyBillDefaultValue(GeneBillBaseInfo vo) {
        super.applyBillDefaultValue(vo);
        MaintainReturningNotifyInfo info = (MaintainReturningNotifyInfo)vo;
        info.setSourceBillType(SourceBillTypeEnum.self);
        info.setWorkOrder(null);
        if (info.getEntrys() != null && info.getEntrys().size() > 0) {
            Iterator it = info.getEntrys().iterator();
            while (it.hasNext()) {
                MaintainReturningNotifyEntryInfo entryInfo = (MaintainReturningNotifyEntryInfo)it.next();
                entryInfo.setSourceBillEntryID(null);
                entryInfo.setSourceBillID(null);
                entryInfo.setOutQty(new BigDecimal(0));
            }
        }
    }

    private void registerListener() {
        if (this.equipmentListener == null) {
            this.equipmentListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    MaintainReturningNotifyEditUI.this.prmtequipment_stateChanged(e);
                }
            };
        }
        this.prmtequipment.removeChangeListener(this.equipmentListener);
        this.prmtequipment.addChangeListener(this.equipmentListener);
        if (this.locationListener == null) {
            this.locationListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    MaintainReturningNotifyEditUI.this.prmtlocation_stateChanged(e);
                }
            };
        }
        this.prmtlocation.removeChangeListener(this.locationListener);
        this.prmtlocation.addChangeListener(this.locationListener);
        if (this.materialListener == null) {
            this.materialListener = new AbstractGeneTableColumnListener(COL_MATERIAL){

                public void tableColumnChanged(KDTEditEvent e) {
                    MaintainReturningNotifyEditUI.this.material_ColumnChanged(e);
                }
            };
        }
        this.geneKDTable.removeTableColumnListener(this.materialListener);
        this.geneKDTable.addTableColumnListener(this.materialListener);
        if (this.unitListener == null) {
            this.unitListener = new AbstractGeneTableColumnListener(COL_UNIT){

                public void tableColumnChanged(KDTEditEvent e) {
                    MaintainReturningNotifyEditUI.this.unit_ColumnChanged(e);
                }
            };
        }
        this.geneKDTable.removeTableColumnListener(this.unitListener);
        this.geneKDTable.addTableColumnListener(this.unitListener);
        if (this.loadLineListener == null) {
            this.loadLineListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MaintainReturningNotifyEditUI.this.loadLine_propertyChange(evt);
                }
            };
        } else {
            this.dataBinder.removePropertyChangeListener(this.loadLineListener);
        }
        this.dataBinder.addPropertyChangeListener("loadLine", this.loadLineListener);
    }

    public void onLoad() throws Exception {
        this.kdtEntrys.checkParsed();
        if (this.loadLineListener == null) {
            this.loadLineListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MaintainReturningNotifyEditUI.this.loadLine_propertyChange(evt);
                }
            };
        } else {
            this.dataBinder.removePropertyChangeListener(this.loadLineListener);
        }
        this.dataBinder.addPropertyChangeListener("loadLine", this.loadLineListener);
        super.onLoad();
    }

    protected void unit_ColumnChanged(KDTEditEvent e) {
        if (this.isLoading()) {
            return;
        }
        if (e.getValue() != null && e.getValue() instanceof MeasureUnitInfo) {
            IRow row = this.kdtEntrys.getRow(e.getRowIndex());
            MeasureUnitInfo unitInfo = (MeasureUnitInfo)e.getValue();
            MaintainReturningNotifyEntryInfo currentEntryInfo = (MaintainReturningNotifyEntryInfo)row.getUserObject();
            currentEntryInfo.setUnit(unitInfo);
            this.entryStatus(row, currentEntryInfo);
        }
    }

    protected void loadLine_propertyChange(PropertyChangeEvent evt) {
        Integer rowIndex = (Integer)evt.getNewValue();
        IRow row = this.kdtEntrys.getRow(rowIndex.intValue());
        MaintainReturningNotifyEntryInfo entryInfo = (MaintainReturningNotifyEntryInfo)row.getUserObject();
        this.entryStatus(row, entryInfo);
    }

    protected void material_ColumnChanged(KDTEditEvent e) {
        IRow row;
        if (this.isLoading()) {
            return;
        }
        if (e.getValue() != null && e.getValue() instanceof MaterialInfo) {
            row = this.kdtEntrys.getRow(e.getRowIndex());
            MaterialInfo materialInfo = (MaterialInfo)e.getValue();
            row.getCell(COL_UNIT).setValue((Object)materialInfo.getBaseUnit());
            row.getCell(COL_MODEL).setValue((Object)materialInfo.getModel());
            row.getCell(COL_MATERIALNAME).setValue((Object)materialInfo.getName());
            MaintainReturningNotifyEntryInfo currentEntryInfo = (MaintainReturningNotifyEntryInfo)row.getUserObject();
            currentEntryInfo.setBaseUnit(materialInfo.getBaseUnit());
            this.entryStatus(row, currentEntryInfo);
            if (materialInfo.getId() != null) {
                try {
                    this.setPrmpMeasuteUnitDialog(materialInfo.getId().toString(), row.getRowIndex());
                }
                catch (BOSException e1) {
                    this.handleException((Exception)((Object)e1));
                }
            }
        }
        if (e.getValue() == null && e.getColIndex() == this.kdtEntrys.getColumnIndex(COL_MATERIAL)) {
            row = this.kdtEntrys.getRow(e.getRowIndex());
            row.getCell(COL_UNIT).setValue(null);
            row.getCell(COL_MODEL).setValue(null);
            row.getCell(COL_MATERIALNAME).setValue(null);
            row.getCell(COL_REQQTY).setValue((Object)"0.0000");
        }
    }

    private void setPrmpMeasuteUnitDialog(String materialId, int rowIndex) throws BOSException {
        try {
            if (materialId != null && materialId.length() > 0) {
                EQMPromptDialogFactory.createPrmptList((KDTable)this.kdtEntrys, (int)this.kdtEntrys.getColumnIndex(COL_UNIT), (int)rowIndex, (String)"com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery", (String[])new String[]{"material.id"}, (Object[])new Object[]{materialId}, (CompareType[])new CompareType[]{CompareType.EQUALS});
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFields() {
        try {
            this.setLoading(true);
            super.loadFields();
            this.setPrmtArchives((EquipmentLocationInfo)this.prmtlocation.getValue());
        }
        finally {
            this.setLoading(false);
        }
    }

    protected void prmtlocation_stateChanged(ChangeEvent e) {
        if (this.isLoading()) {
            return;
        }
        EquipmentLocationInfo locationInfo = (EquipmentLocationInfo)this.prmtlocation.getValue();
        if (locationInfo != null) {
            this.txtlocationName.setText(locationInfo.getName());
            this.prmtequipment.setValue(null);
            this.txtequipmentName.setText(null);
            this.setPrmtArchives(locationInfo);
        } else {
            this.txtlocationName.setText(null);
            this.setPrmtArchives(null);
        }
    }

    private void setPrmtArchives(EquipmentLocationInfo location) {
        if (location == null) {
            try {
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtequipment, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery", (String[])new String[]{"maintainOrgUnit.id", "bizStatus"}, (Object[])new Object[]{this.prmtOrgUnit.getValue() == null ? null : ((StorageOrgUnitInfo)this.prmtOrgUnit.getValue()).getId().toString(), new Integer(10)}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS}, (boolean)true);
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        } else {
            try {
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtequipment, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery", (String[])new String[]{"maintainOrgUnit.id", "bizStatus", "location.id"}, (Object[])new Object[]{this.prmtOrgUnit.getValue() == null ? null : ((StorageOrgUnitInfo)this.prmtOrgUnit.getValue()).getId().toString(), new Integer(10), location.getId().toString()}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS, CompareType.EQUALS}, (boolean)true);
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
        }
    }

    protected void prmtequipment_stateChanged(ChangeEvent e) {
        if (this.isLoading()) {
            return;
        }
        EquipmentArchivesInfo archivesInfo = (EquipmentArchivesInfo)this.prmtequipment.getValue();
        if (archivesInfo != null) {
            this.txtequipmentName.setText(archivesInfo.getName());
            this.prmtlocation.removeChangeListener(this.locationListener);
            this.prmtlocation.setValue((Object)(archivesInfo.getLocation() == null ? null : archivesInfo.getLocation()));
            this.txtlocationName.setText(archivesInfo.getLocation() == null || archivesInfo.getLocation().getName() == null ? null : archivesInfo.getLocation().getName());
            this.setPrmtArchives(archivesInfo.getLocation());
            this.prmtlocation.addChangeListener(this.locationListener);
        } else {
            this.txtequipmentName.setText(null);
        }
    }

    protected void checkCanEdit(GeneBillBaseInfo editData) throws Exception {
        super.checkCanEdit(editData);
        if (editData.getBillStatus() == GeneBillBaseStatusEnum.CLOSED || editData.getBillStatus() == GeneBillBaseStatusEnum.ForceClosed) {
            MsgBox.showWarning((Component)((Object)this), (String)(GeneClientUtils.getResource((String)"BillAt") + editData.getBillStatus().getAlias() + GeneClientUtils.getResource((String)"CantBeEdited")));
            SysUtil.abort();
        }
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
    }

    @Override
    public void actionForceClose_actionPerformed(ActionEvent e) throws Exception {
        MaintainReturningNotifyInfo info = (MaintainReturningNotifyInfo)this.getDataObject();
        if (info.getBillStatus() != GeneBillBaseStatusEnum.Audit) {
            throw new MaintainNotifyException(MaintainNotifyException.FORCECLOSEVERIFY, new String[]{info.getBillStatus().getAlias()});
        }
        int result = MsgBox.showConfirm2((String)GeneResourceUtil.getMsg((String)"com.kingdee.eas.eqm.maintain.client.MaintainNotifyResource", (String)"ForceCloseInfoEdit", null));
        if (result != 0) {
            SysUtil.abort();
        }
        MaintainReturningNotifyFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).forceClose((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.refreshCurPage();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = this.getInnerSelectors();
        sic.add(new SelectorItemInfo("entrys.unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entrys.material.model"));
        sic.add(new SelectorItemInfo("entrys.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("entrys.material.baseUnit.name"));
        return sic;
    }

    public void kdtEntrys_Changed(int rowIndex, int colIndex) throws Exception {
    }

    public String getResourceName() {
        return "com.kingdee.eas.eqm.maintain.client.MaintainNotifyResource";
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.refreshCurPage();
        MaintainReturningNotifyInfo info = (MaintainReturningNotifyInfo)this.getDataObject();
        if (info.getBillStatus().getValue() == 30) {
            super.actionCreateTo_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.maintain.client.MaintainNotifyResource", (String)"MatainReturningNotifyCreateTO"));
            SysUtil.abort();
        }
    }

    protected void setFieldsNull(AbstractObjectValue arg0) {
        super.setFieldsNull(arg0);
        MaintainReturningNotifyInfo p = (MaintainReturningNotifyInfo)arg0;
        if (p.getEntrys() != null && p.getEntrys().size() > 0) {
            Iterator it = p.getEntrys().iterator();
            while (it.hasNext()) {
                MaintainReturningNotifyEntryInfo entry = (MaintainReturningNotifyEntryInfo)it.next();
                entry.setOutQty(new BigDecimal(0));
                entry.setBaseOutQty(new BigDecimal(0));
            }
        }
    }

    protected String getEquipmentIDForView() {
        return this.prmtequipment.getValue() == null ? null : ((EquipmentArchivesInfo)this.prmtequipment.getValue()).getId().toString();
    }

    protected String getMaterialIDForView() {
        KDTable mainTable = this.kdtEntrys;
        if (mainTable.getSelectManager().get(0) == null) {
            return null;
        }
        int rowIndex = mainTable.getSelectManager().get(0).getBeginRow();
        if (rowIndex <= -1) {
            return null;
        }
        IRow row = mainTable.getRow(rowIndex);
        for (int i = 0; i < mainTable.getColumns().size(); ++i) {
            if (!(row.getCell(i).getValue() instanceof MaterialInfo)) continue;
            return ((MaterialInfo)row.getCell(i).getValue()).getId().toString();
        }
        return null;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.prmtdepart.getValue() == null && !this.editData.getBillStatus().equals((Object)GeneBillBaseStatusEnum.AddNew) && !this.isSaveAction(e)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.maintain.MAINTAINAutoGenerateResource", (String)"3_MaintainReturningNotifyEditUI"));
            SysUtil.abort();
        }
        super.verifyInput(e);
    }
}

