/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.client.GeneBillBaseFilterUI;
import com.kingdee.eas.eqm.common.core.client.action.LongTimeAction;
import com.kingdee.eas.eqm.common.core.client.util.GeneClientUtils;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.maintain.MaintainReturningNotifyFactory;
import com.kingdee.eas.eqm.maintain.client.AbstractMaintainReturningNotifyListUI;
import com.kingdee.eas.eqm.maintain.client.MaintainReturningNotifyFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MaintainReturningNotifyListUI
extends AbstractMaintainReturningNotifyListUI {
    private static final Logger logger = CoreUIObject.getLogger(MaintainReturningNotifyListUI.class);

    protected GeneBillBaseFilterUI newInstanceFilterUI() throws Exception {
        MaintainReturningNotifyFilterUI filterUI = new MaintainReturningNotifyFilterUI();
        return filterUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaintainReturningNotifyFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String getEditUIName() {
        MetaDataPK meta = new MetaDataPK("com.kingdee.eas.eqm.maintain.client", "MaintainReturningNotifyEditUI");
        return meta.getFullName();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.toolBar.remove((Component)this.btnClose);
        this.toolBar.remove((Component)this.btnForceClose);
        this.toolBar.add((Component)this.btnClose);
        this.toolBar.add((Component)this.btnForceClose);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionClose.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_closing"));
        this.actionForceClose.putValue("SmallIcon", EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_hardclosing", (Locale)SysContext.getSysContext().getLocale()));
        this.menuItemForceClose.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_hardclosing", (Locale)SysContext.getSysContext().getLocale()));
        this.actionTDPrint.setVisible(false);
        this.actionTDPrint.setEnabled(false);
        this.actionTDPrintPreview.setVisible(false);
        this.actionTDPrintPreview.setEnabled(false);
        this.actionClose.setVisible(false);
        this.actionClose.setEnabled(false);
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        CloseAction action = new CloseAction(false);
        action.doIt((CoreUI)this, this.actionClose);
    }

    @Override
    public void actionForceClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CloseAction action = new CloseAction(true);
        action.doIt((CoreUI)this, this.actionForceClose);
    }

    protected void checkCanEdit(GeneBillBaseInfo billInfo) throws Exception {
        super.checkCanEdit(billInfo);
        if (billInfo.getBillStatus() == GeneBillBaseStatusEnum.CLOSED || billInfo.getBillStatus() == GeneBillBaseStatusEnum.ForceClosed) {
            MsgBox.showWarning((Component)((Object)this), (String)(GeneClientUtils.getResource((String)"BillAt") + billInfo.getBillStatus().getAlias() + GeneClientUtils.getResource((String)"CantBeEdited")));
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    public class CloseAction
    extends LongTimeAction {
        private boolean forceClose = false;
        List ids = new ArrayList();

        public CloseAction(boolean force) {
            this.forceClose = force;
        }

        protected Object actionDoIt(CoreUI ui, ItemAction e) throws Exception {
            this.ids = MaintainReturningNotifyListUI.this.getSelectedIdValues();
            Class[] parameTypes = new Class[]{IObjectPK.class};
            BatchExecuteParamsEntry[] paramEntries = MaintainReturningNotifyListUI.this.prepareParams(this.ids, parameTypes);
            return MaintainReturningNotifyListUI.this.getBizInterface().batchExecute(this.forceClose ? "forceClose" : "close", parameTypes, paramEntries);
        }

        protected void afterDoIt(CoreUI ui, ItemAction action, Object value) throws Exception {
            BatchExecuteResult rst = (BatchExecuteResult)value;
            GeneClientUtils.handleBatchExcuteResult((CoreUI)ui, (KDTable)MaintainReturningNotifyListUI.this.tblMain, (ItemAction)action, (List)this.ids, (BatchExecuteResult)rst, (String)"number");
            MaintainReturningNotifyListUI.this.refresh(null);
        }

        protected void beforeDoIt(CoreUI ui, ItemAction e) throws Exception {
            MaintainReturningNotifyListUI.this.checkSelected();
            int result = MsgBox.showConfirm2((String)GeneResourceUtil.getMsg((String)"com.kingdee.eas.eqm.maintain.client.MaintainNotifyResource", (String)"ForceCloseInfoEdit", null));
            if (result != 0) {
                SysUtil.abort();
            }
        }
    }
}

