/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Hashtable;
import java.util.Map;

public class MultiMeasureUnitUtil {
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.WorkOrderResource";
    private Map mutiMeasureUnitCache = new Hashtable();

    public MultiMeasureUnitInfo getMutiMeasureUnitInfo(String materialId, String mateiralNumber, String materialName, String unitId) {
        MaterialInfo material = new MaterialInfo();
        material.setId(BOSUuid.read((String)materialId));
        material.setNumber(mateiralNumber);
        material.setName(materialName);
        MeasureUnitInfo unit = new MeasureUnitInfo();
        unit.setId(BOSUuid.read((String)unitId));
        return this.getMutiMeasureUnitInfo(material, unit);
    }

    public MultiMeasureUnitInfo getMutiMeasureUnitInfo(MaterialInfo materialInfo, MeasureUnitInfo measureUnitInfo) {
        String key = materialInfo.getId().toString() + "_" + measureUnitInfo.getId().toString();
        MultiMeasureUnitInfo mutiMeasureUnitInfo = (MultiMeasureUnitInfo)this.mutiMeasureUnitCache.get(key);
        if (null == mutiMeasureUnitInfo) {
            mutiMeasureUnitInfo = this.createMultiMeasureUnitInfo(key, materialInfo);
        }
        return mutiMeasureUnitInfo;
    }

    private MultiMeasureUnitInfo createMultiMeasureUnitInfo(String key, MaterialInfo materialInfo) {
        MultiMeasureUnitInfo mutiMeasureUnitInfo = null;
        MultiMeasureUnitCollection rs = null;
        String materialId = materialInfo.getId().toString();
        try {
            rs = MultiMeasureUnitFactory.getRemoteInstance().getDataByMaterial(materialId);
        }
        catch (Exception e) {
            MsgBox.showError((String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"FETCH_MUTIUNIT_ERROR", (Object[])new Object[]{materialInfo.getName(), materialInfo.getNumber()}));
        }
        if (null != rs && rs.size() > 0) {
            String newKey = null;
            for (MultiMeasureUnitInfo element : rs) {
                if (null == element || null == element.getMaterial() || null == element.getMeasureUnit()) continue;
                newKey = element.getMaterial().getId().toString() + "_" + element.getMeasureUnit().getId().toString();
                if (newKey.equals(key)) {
                    mutiMeasureUnitInfo = element;
                }
                this.mutiMeasureUnitCache.put(newKey, element);
            }
        }
        return mutiMeasureUnitInfo;
    }
}

