/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.common.core.GeneCheckedStatusEnum;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.common.eqmcore.client.util.ControlledItems;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.IReportStopTime;
import com.kingdee.eas.eqm.maintain.ReportStopTimeCollection;
import com.kingdee.eas.eqm.maintain.ReportStopTimeFactory;
import com.kingdee.eas.eqm.maintain.ReportStopTimeInfo;
import com.kingdee.eas.eqm.maintain.StopTimeTypeEnum;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.client.AbstractReportStopTimeEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ReportStopTimeEditUI
extends AbstractReportStopTimeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ReportStopTimeEditUI.class);
    private static final String STOPTIME_RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.ReportStopTimeResource";

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReportStopTimeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        return this.doCreateNewData(null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getOprtState().equals("ADDNEW")) {
            this.endDate.setValue((Object)GeneDateUtils.now());
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionAudit.setVisible(false);
        this.actionUnAudit.setVisible(false);
        this.actionAudit.setEnabled(false);
        this.actionUnAudit.setEnabled(false);
    }

    public KDTextField getNumTextField() {
        return null;
    }

    protected IObjectValue newInstanceData() {
        ReportStopTimeInfo info = new ReportStopTimeInfo();
        info.setCheckedStatus(GeneCheckedStatusEnum.AUDITED);
        info.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setPerson(SysContext.getSysContext().getCurrentUserInfo().getPerson());
        info.setStorageOrgUnit((StorageOrgUnitInfo)this.getMainOrgInfo());
        info.setNumber(BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
        info.setName(BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = this.getInnerSelectors();
        sic.add("equipmentNumber.name");
        return sic;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.getVerifyManager().verify();
        this.editData.setNumber(BOSUuid.create((BOSObjectType)new ReportStopTimeInfo().getBOSType()).toString());
        if (this.runnable.isSelected()) {
            this.editData.setType(StopTimeTypeEnum.runnable);
        } else {
            this.editData.setType(StopTimeTypeEnum.unrunnable);
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String start = sd.format(this.startDate.getTimestamp());
        String end = sd.format(this.endDate.getTimestamp());
        this.startDate.setValue((Object)Timestamp.valueOf(start));
        this.endDate.setValue((Object)Timestamp.valueOf(end));
        if (this.startDate.getTimestamp() == null || this.endDate.getTimestamp() == null || this.startDate.getTimestamp().getTime() >= this.endDate.getTimestamp().getTime()) {
            MsgBox.showWarning((String)this.getResourceMsg("MEG_START_END"));
            SysUtil.abort();
        }
        if (this.hours == null || this.hours.getText().trim().equals("")) {
            MsgBox.showWarning((String)this.getResourceMsg("HOURS_NOTNULL"));
            SysUtil.abort();
        }
        if (this.hours.getBigDecimalValue() != null && this.hours.getBigDecimalValue().floatValue() == 0.0f) {
            MsgBox.showWarning((String)this.getResourceMsg("HOURS_NOTZERO"));
            SysUtil.abort();
        }
        if (this.hours.getBigDecimalValue() != null && this.hours.getBigDecimalValue().floatValue() < 0.0f) {
            MsgBox.showWarning((String)this.getResourceMsg("HOURS_NOTNEGIVATE"));
            SysUtil.abort();
        }
        if (!(GeneCommonUtils.isEmpty((Object)this.prmtEquipmentArchives.getValue()) || GeneCommonUtils.isEmpty((Object)this.startDate.getValue()) || GeneCommonUtils.isEmpty((Object)this.endDate.getValue()))) {
            IReportStopTime rst = (IReportStopTime)this.getBizInterface();
            EntityViewInfo entryViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            EquipmentArchivesInfo archivesInfo = (EquipmentArchivesInfo)this.prmtEquipmentArchives.getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("equipmentNumber", (Object)archivesInfo.getId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)this.getMainOrgInfo().getId()));
            entryViewInfo.setFilter(filterInfo);
            ReportStopTimeCollection rstCollection = rst.getReportStopTimeCollection(entryViewInfo);
            for (int i = 0; i < rstCollection.size(); ++i) {
                ReportStopTimeInfo rstInfo = rstCollection.get(i);
                if (this.editData.getId() != null && this.editData.getId().toString().equals(rstInfo.getId().toString()) || !(GeneDateUtils.compareByAccurateDate((Date)this.startDate.getTimestamp(), (Date)rstInfo.getStartDate()) >= 0 && GeneDateUtils.compareByAccurateDate((Date)this.startDate.getTimestamp(), (Date)rstInfo.getEndDate()) <= 0 || GeneDateUtils.compareByAccurateDate((Date)this.endDate.getTimestamp(), (Date)rstInfo.getStartDate()) >= 0 && GeneDateUtils.compareByAccurateDate((Date)this.endDate.getTimestamp(), (Date)rstInfo.getEndDate()) <= 0) && (GeneDateUtils.compareByAccurateDate((Date)this.startDate.getTimestamp(), (Date)rstInfo.getStartDate()) > 0 || GeneDateUtils.compareByAccurateDate((Date)this.endDate.getTimestamp(), (Date)rstInfo.getEndDate()) < 0)) continue;
                MsgBox.showWarning((String)this.getResourceMsg("DATE_NOTCROSS"));
                SysUtil.abort();
            }
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void initListener() {
        super.initListener();
        this.maintainOrgUnit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ReportStopTimeEditUI.this.person_stateChanged();
                ReportStopTimeEditUI.this.prmtArchives_changed(e);
            }
        });
        this.prmtEquipmentArchives.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ReportStopTimeEditUI.this.equipmentName_stateChanged(e);
            }
        });
        this.startDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ReportStopTimeEditUI.this.calculateHours();
            }
        });
        this.endDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ReportStopTimeEditUI.this.calculateHours();
            }
        });
    }

    protected void prmtArchives_changed(ChangeEvent e) {
        this.prmtEquipmentArchives.setData(null);
        this.equipmentName.setText(null);
    }

    protected void person_stateChanged() {
        if (GeneCommonUtils.isEmpty((Object)this.maintainOrgUnit.getValue())) {
            return;
        }
        try {
            EQMPromptDialogFactory.createPeoplePrmptList((KDBizPromptBox)this.prmtPerson, (String)"com.kingdee.eas.eqm.basedata.app.F7PersonQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Admin, (OrgUnitInfo)((OrgUnitInfo)this.maintainOrgUnit.getValue()));
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    protected void equipmentName_stateChanged(ChangeEvent e) {
        EquipmentArchivesInfo archives;
        if ((this.getOprtState().equals("EDIT") || this.getOprtState().equals("ADDNEW")) && !GeneCommonUtils.isEmpty((CoreBaseInfo)(archives = (EquipmentArchivesInfo)this.prmtEquipmentArchives.getValue()))) {
            this.equipmentName.setText(archives.getName());
        }
    }

    protected void calculateHours() {
        Timestamp start_date = this.startDate.getTimestamp();
        Timestamp end_date = this.endDate.getTimestamp();
        if (start_date != null && end_date != null) {
            try {
                if (GeneDateUtils.compareByDate((Date)start_date, (Date)end_date) > 0) {
                    return;
                }
                long hours = GeneDateUtils.dateDiff((Date)start_date, (Date)end_date);
                double hour = (double)hours / 3600000.0;
                DecimalFormat df = new DecimalFormat("#0.00");
                this.hours.setText(df.format(hour));
            }
            catch (ParseException e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public void loadFields() {
        String entityType;
        super.loadFields();
        if (!this.getOprtState().equals("ADDNEW")) {
            if (this.editData.getType().getValue() == 1) {
                this.runnable.setSelected(true);
            } else {
                this.unrunnable.setSelected(true);
            }
            WorkOrderInfo workOrder = (WorkOrderInfo)this.workOrderNumber.getValue();
            if (workOrder != null) {
                this.workOrderDescription.setText(workOrder.getName());
            }
        }
        if ("WORKORDER".equals(entityType = (String)this.getUIContext().get("ENTITYTYPE"))) {
            WorkOrderInfo workOrder = (WorkOrderInfo)this.getUIContext().get("ENTITYVALUE");
            this.maintainOrgUnit.setValue((Object)workOrder.getMaintainOrgUnit());
            this.prmtEquipmentArchives.setValue((Object)workOrder.getEquipmentArchives());
            this.equipmentName.setText(workOrder.getEquipmentArchives().getName());
            this.prmtPerson.setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getPerson());
            this.workOrderNumber.setValue((Object)workOrder);
            this.workOrderDescription.setText(workOrder.getName());
        }
    }

    protected ControlledItems[] getNeedMainOrgControl() {
        return new ControlledItems[]{new ControlledItems(this.prmtEquipmentArchives, "maintainOrgUnit.id")};
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.maintainOrgUnit;
    }

    protected boolean isIgnoreOrgFilter() {
        return false;
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        this.startDate.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
        this.endDate.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
        this.entryDate.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
        try {
            EQMPromptDialogFactory.createPeoplePrmptList((KDBizPromptBox)this.prmtPerson, (String)"com.kingdee.eas.eqm.basedata.app.F7PersonQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Admin, (OrgUnitInfo)this.getMainOrgInfo());
            FilterInfo filter = this.prmtPerson.getEntityViewInfo().getFilter();
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
            this.prmtPerson.getEntityViewInfo().setFilter(filter);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.getMainBizOrg().addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent arg0) {
                if (arg0.getData() == null) {
                    ReportStopTimeEditUI.this.getMainBizOrg().setDataNoNotify(arg0.getOldData());
                    MsgBox.showWarning((String)GeneResourceUtil.getMsg((String)"MAINBIZORG_REQUIRED"));
                    arg0.setResult(0);
                    return;
                }
            }
        });
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        if (newOrgId == null) {
            return;
        }
        try {
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentArchives, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesForMaintainOrgQuery", (String[])new String[]{"maintainOrgUnit.id", "initial", "bizStatus"}, (Object[])new Object[]{newOrgId, Boolean.TRUE, new Integer(10)}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS, CompareType.EQUALS});
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)STOPTIME_RESOURCE_PATH, (String)key);
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
        arg0.put("endDate", (Object)GeneDateUtils.now());
        super.setFieldsNull(arg0);
    }
}

