/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneCommonFacadeFactory;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.IWorkOrderPlanMaterialEntry;
import com.kingdee.eas.eqm.maintain.WorkOrderFactory;
import com.kingdee.eas.eqm.maintain.WorkOrderPlanMaterialEntryCollection;
import com.kingdee.eas.eqm.maintain.WorkOrderPlanMaterialEntryFactory;
import com.kingdee.eas.eqm.maintain.WorkOrderPlanMaterialEntryInfo;
import com.kingdee.eas.eqm.maintain.client.AbstractTaskMaterialStockQueryUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMLockInvDataVO;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaskMaterialStockQueryUI
extends AbstractTaskMaterialStockQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(TaskMaterialStockQueryUI.class);
    public static final String TBL_TBLPSBILL = "tblPSBill";
    public static final String COL_MATERIAL_ID = "id";
    public static final String COL_MATERIAL_TASKNUMBER = "taskNumber";
    public static final String COL_MATERIAL_MATERIAL_NUMBER = "material.number";
    public static final String COL_MATERIAL_MATERIAL_NAME = "material.name";
    public static final String COL_MATERIAL_MATERIAL_MODEL = "material.model";
    public static final String COL_MATERIAL_MEASUREUNIT_NAME = "measureunit.name";
    public static final String COL_MATERIAL_AMOUNT = "amount";
    public static final String COL_MATERIAL_STORAGEORGUNIT_NAME = "storageOrgUnit.name";
    public static final String COL_MATERIAL_WAREHOUSE_NAME = "warehouse.name";
    public static final String TBL_TBLINVENTORY = "tblInventory";
    public static final String COL_STOCK_SELECT = "select";
    public static final String COL_STOCK_FSTORAGEORG = "FStorageOrg";
    public static final String COL_STOCK_FWAREHOUSE = "FWareHouse";
    public static final String COL_STOCK_FLOCATION = "FLocation";
    public static final String COL_STOCK_FUNIT = "FUnit";
    public static final String COL_STOCK_FCURQTY = "FCurQty";
    public static final String COL_STOCK_FCURLOCKQTY = "FCurLockQty";
    public static final String COL_STOCK_FCURLOCKDATE = "FCurLockDate";
    public static final String COL_STOCK_FLOT = "FLot";
    public static final String COL_STOCK_FSTORETYPE = "FStoreType";
    public static final String COL_STOCK_FSTORESTATE = "FStoreState";
    public static final String COL_STOCK_ID = "id";
    private Set userStorOrgSet = null;
    private DataChangeListener prmtWarehouseDataChange = null;
    private static final String INVENTORY_PERMISSION = "inventory";

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadUserStorOrgSet();
        this.initWarehouseF7();
        this.initTbl();
        this.loadMaterialData();
        this.tblInventory.getColumn(COL_STOCK_FCURLOCKDATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    private void loadMaterialData() throws EASBizException, BOSException {
        this.tblPSBill.removeRows();
        ArrayList idList = (ArrayList)this.getUIContext().get("idList");
        WorkOrderPlanMaterialEntryCollection poseCol = null;
        if (idList != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("parent.number"));
            sic.add(new SelectorItemInfo("warehouse.id"));
            sic.add(new SelectorItemInfo("warehouse.number"));
            sic.add(new SelectorItemInfo(COL_MATERIAL_WAREHOUSE_NAME));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo(COL_MATERIAL_MATERIAL_NUMBER));
            sic.add(new SelectorItemInfo(COL_MATERIAL_MATERIAL_NAME));
            sic.add(new SelectorItemInfo(COL_MATERIAL_MATERIAL_MODEL));
            sic.add(new SelectorItemInfo("baseUnit.id"));
            sic.add(new SelectorItemInfo("baseUnit.number"));
            sic.add(new SelectorItemInfo("baseUnit.name"));
            sic.add(new SelectorItemInfo("measureunit.id"));
            sic.add(new SelectorItemInfo("measureunit.number"));
            sic.add(new SelectorItemInfo(COL_MATERIAL_MEASUREUNIT_NAME));
            sic.add(new SelectorItemInfo("parent.storageOrgUnit.*"));
            viewInfo.setSelector(sic);
            HashSet idSet = new HashSet();
            for (int i = 0; i < idList.size(); ++i) {
                idSet.add(idList.get(i));
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            SorterItemInfo sorter = new SorterItemInfo("parent.number");
            SorterItemInfo sorter2 = new SorterItemInfo("seq");
            sorter.setSortType(SortType.ASCEND);
            viewInfo.getSorter().add(sorter);
            viewInfo.getSorter().add(sorter2);
            IWorkOrderPlanMaterialEntry ipsbe = WorkOrderPlanMaterialEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            poseCol = ipsbe.getWorkOrderPlanMaterialEntryCollection(viewInfo);
        } else {
            poseCol = (WorkOrderPlanMaterialEntryCollection)((Object)this.getUIContext().get("EntryCol"));
        }
        MaterialInfo[] materialInfos = null;
        MeasureUnitInfo[] measureUnitInfos = null;
        int[] rowIndexs = null;
        Iterator it = poseCol.iterator();
        int psCount = poseCol.size();
        if (psCount > 0) {
            materialInfos = new MaterialInfo[psCount];
            measureUnitInfos = new MeasureUnitInfo[psCount];
            rowIndexs = new int[psCount];
        }
        int rowIndex = 0;
        while (it.hasNext()) {
            WorkOrderPlanMaterialEntryInfo poseInfo = (WorkOrderPlanMaterialEntryInfo)it.next();
            if (poseInfo.getMaterial() == null) continue;
            IRow newRow = this.tblPSBill.addRow();
            newRow.getCell("id").setValue((Object)poseInfo.getMaterial().getId());
            newRow.getCell(COL_MATERIAL_TASKNUMBER).setValue((Object)poseInfo.getTaskNumber());
            newRow.getCell(COL_MATERIAL_MATERIAL_NUMBER).setValue((Object)poseInfo.getMaterial().getNumber());
            newRow.getCell(COL_MATERIAL_MATERIAL_NAME).setValue((Object)poseInfo.getMaterial().getName());
            newRow.getCell(COL_MATERIAL_MATERIAL_MODEL).setValue((Object)poseInfo.getMaterial().getModel());
            newRow.getCell(COL_MATERIAL_MEASUREUNIT_NAME).setValue((Object)poseInfo.getMeasureunit().getName());
            newRow.getCell(COL_MATERIAL_AMOUNT).setValue((Object)poseInfo.getAmount());
            newRow.getCell(COL_MATERIAL_STORAGEORGUNIT_NAME).setValue((Object)poseInfo.getStorageOrgUnit().getName());
            newRow.getCell(COL_MATERIAL_WAREHOUSE_NAME).setValue(poseInfo.getWarehouse() == null ? null : poseInfo.getWarehouse().getName());
            materialInfos[rowIndex] = poseInfo.getMaterial();
            measureUnitInfos[rowIndex] = poseInfo.getMeasureunit();
            rowIndexs[rowIndex] = rowIndex;
            ++rowIndex;
        }
        SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo[])materialInfos, (MeasureUnitInfo[])measureUnitInfos, (KDTable)this.tblPSBill, (String[])new String[]{COL_MATERIAL_AMOUNT}, (int[])rowIndexs);
        this.tblPSBill.getSelectManager().select(0, 0);
    }

    private void initTbl() {
        this.tblPSBill.checkParsed(true);
        this.tblInventory.checkParsed(true);
        this.tblPSBill.getSelectManager().setSelectMode(2);
        this.tblPSBill.getStyleAttributes().setLocked(true);
        this.tblInventory.getSelectManager().setSelectMode(2);
        this.tblInventory.getStyleAttributes().setLocked(true);
        this.kDContainer1.setContainerType(1);
    }

    private void loadUserStorOrgSet() throws BOSException {
        OrgUnitInfo[] orgs = null;
        HashSet<String> orgSet = new HashSet<String>();
        try {
            orgs = GeneCommonFacadeFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getAuthorizedBizOrgUnits(OrgType.Storage, INVENTORY_PERMISSION);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        if (orgs != null) {
            for (int i = 0; i < orgs.length; ++i) {
                orgSet.add(orgs[i].getId().toString());
            }
        }
        this.userStorOrgSet = orgSet;
    }

    private void initWarehouseF7() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.userStorOrgSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("transState", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("transState", (Object)"2", CompareType.EQUALS));
        filter.setMaskString("#0 and (#1 or #2)");
        viewInfo.setFilter(filter);
        this.prmtWareHouse.setEntityViewInfo(viewInfo);
    }

    @Override
    public void actionQueryInventory_actionPerformed(ActionEvent e) throws Exception {
        Object[] locationArr;
        HashSet<BOSUuid> warehouseIdSet = null;
        HashSet<BOSUuid> locationIdSet = null;
        int tblpsRowIndex = this.tblPSBill.getSelectManager().getActiveRowIndex();
        Object[] warehouseArr = (Object[])this.prmtWareHouse.getData();
        if (warehouseArr != null && warehouseArr.length > 0) {
            warehouseIdSet = new HashSet<BOSUuid>();
            for (int i = 0; i < warehouseArr.length; ++i) {
                warehouseIdSet.add(((WarehouseInfo)warehouseArr[i]).getId());
            }
        }
        if ((locationArr = (Object[])this.prmtLocation.getValue()) != null && locationArr.length > 0) {
            locationIdSet = new HashSet<BOSUuid>();
            for (int i = 0; i < locationArr.length; ++i) {
                locationIdSet.add(((LocationInfo)locationArr[i]).getId());
            }
        }
        this.tblInventoryinsertRow(tblpsRowIndex, warehouseIdSet, locationIdSet);
    }

    @Override
    protected void tblPSBill_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.prmtWareHouse.removeDataChangeListener(this.prmtWarehouseDataChange);
        this.prmtWareHouse.setValue(null);
        this.prmtWareHouse.addDataChangeListener(this.prmtWarehouseDataChange);
        this.prmtLocation.setValue(null);
        this.tblInventoryinsertRow(e.getSelectBlock().getBeginRow(), null, null);
    }

    protected void initListener() {
        super.initListener();
        this.prmtWarehouseDataChange = new DataChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dataChanged(DataChangeEvent e) {
                try {
                    TaskMaterialStockQueryUI.this.prmtWareHouse_dataChanged(e);
                }
                catch (Exception exc) {
                    TaskMaterialStockQueryUI.this.handUIException(exc);
                }
            }
        };
        this.prmtWareHouse.addDataChangeListener(this.prmtWarehouseDataChange);
    }

    protected void prmtWareHouse_dataChanged(DataChangeEvent e) {
        Object warehouse = this.prmtWareHouse.getData();
        HashSet<String> warehouseSet = new HashSet<String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.prmtLocation.setValue(null);
        if (warehouse == null) {
            this.prmtLocation.setEnabled(false);
        } else if (warehouse instanceof Object[]) {
            Object[] warehouseArr = (Object[])warehouse;
            if (warehouseArr.length == 1) {
                filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)((WarehouseInfo)warehouseArr[0]).getId().toString(), CompareType.EQUALS));
            } else if (warehouseArr.length > 1) {
                for (int i = 0; i < warehouseArr.length; ++i) {
                    warehouseSet.add(((WarehouseInfo)warehouseArr[i]).getId().toString());
                }
                filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", warehouseSet, CompareType.INCLUDE));
            }
            this.prmtLocation.setEnabled(true);
            viewInfo.setFilter(filter);
            this.prmtLocation.setEntityViewInfo(viewInfo);
        }
    }

    private void tblInventoryinsertRow(int rowIndex, Set warehouseIdSet, Set locationIdSet) throws Exception {
        this.tblInventory.removeRows();
        if (this.tblPSBill.getRowCount() == 0) {
            return;
        }
        IRow aRow = this.tblPSBill.getRow(rowIndex);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo orgUnitFilter = new FilterItemInfo("STORAGEORGUNIT.ID", (Object)this.userStorOrgSet, CompareType.INCLUDE);
        FilterItemInfo materialFilter = new FilterItemInfo("MATERIAL.ID", aRow.getCell("id").getValue(), CompareType.EQUALS);
        FilterItemInfo storeTypeFilter = new FilterItemInfo("STORETYPE.ID", (Object)"181875d5-0105-1000-e000-0111c0a812fd97D461A6", CompareType.EQUALS);
        FilterItemInfo storeStatusFilter = new FilterItemInfo("STORESTATUS.ID", (Object)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5", CompareType.EQUALS);
        FilterItemInfo warehouseStateFilter1 = new FilterItemInfo("WAREHOUSE.transState", (Object)"1", CompareType.EQUALS);
        FilterItemInfo warehouseStateFilter2 = new FilterItemInfo("WAREHOUSE.transState", (Object)"2", CompareType.EQUALS);
        filter.getFilterItems().add(orgUnitFilter);
        filter.getFilterItems().add(materialFilter);
        filter.getFilterItems().add(storeTypeFilter);
        filter.getFilterItems().add(storeStatusFilter);
        filter.getFilterItems().add(warehouseStateFilter1);
        filter.getFilterItems().add(warehouseStateFilter2);
        filter.setMaskString("#0 and #1 and #2 and #3 and (#4 or #5)");
        FilterInfo conditionfilter = new FilterInfo();
        if (warehouseIdSet != null && warehouseIdSet.size() > 0) {
            FilterItemInfo warehouseFilter = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseIdSet, CompareType.INCLUDE);
            conditionfilter.getFilterItems().add(warehouseFilter);
        }
        if (locationIdSet != null && locationIdSet.size() > 0) {
            FilterItemInfo locationFilter = new FilterItemInfo("LOCATION.ID", (Object)locationIdSet, CompareType.INCLUDE);
            conditionfilter.getFilterItems().add(locationFilter);
        }
        if (conditionfilter.getFilterItems().size() > 0) {
            filter.mergeFilter(conditionfilter, "and");
        }
        ev.setFilter(filter);
        SCMLockInvDataVO vo = new SCMLockInvDataVO();
        vo.setTableNether(true);
        vo.setViewInfo(ev);
        vo.setType("bottom");
        Date reqDate = (Date)this.getUIContext().get("reqDate");
        SCMLockInvDataVO tblInventoryVO = WorkOrderFactory.getRemoteInstance().getMaterialStock(vo, reqDate, false);
        IObjectPK[] invIdList = tblInventoryVO.getInvIdList();
        Map wareHouseMap = tblInventoryVO.getWareHouseMap();
        Map locationMap = tblInventoryVO.getLocationMap();
        Map storeTypeMap = tblInventoryVO.getStoreTypeMap();
        Map storeStateMap = tblInventoryVO.getStoreStateMap();
        Map storageMap = tblInventoryVO.getStorageMap();
        Map invUnitMap = tblInventoryVO.getInvUnitMap();
        Map inventoryMap = tblInventoryVO.getInventoryMap();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        String invID = null;
        int n = invIdList.length;
        for (int i = 0; i < n; ++i) {
            invID = invIdList[i].toString();
            InventoryInfo aInventoryInfo = (InventoryInfo)inventoryMap.get(invID);
            if (aInventoryInfo.getCurStoreQty() != null && aInventoryInfo.getCurStoreQty().doubleValue() == 0.0) continue;
            IRow newRow = this.tblInventory.addRow();
            StorageOrgUnitInfo aStorageOrgUnitInfo = (StorageOrgUnitInfo)storageMap.get(invID);
            newRow.getCell(COL_STOCK_FSTORAGEORG).setValue((Object)aStorageOrgUnitInfo.getName());
            newRow.getCell(COL_STOCK_FSTORAGEORG).setUserObject((Object)aStorageOrgUnitInfo);
            newRow.getCell("id").setValue((Object)invIdList[i]);
            if (aInventoryInfo.getWarehouse() != null) {
                WarehouseInfo aWarehouseInfo = (WarehouseInfo)wareHouseMap.get(invID);
                newRow.getCell(COL_STOCK_FWAREHOUSE).setValue((Object)aWarehouseInfo.getName());
                newRow.getCell(COL_STOCK_FWAREHOUSE).setUserObject((Object)aWarehouseInfo);
            }
            if (aInventoryInfo.getLocation() != null) {
                LocationInfo aLocationInfo = (LocationInfo)locationMap.get(invID);
                newRow.getCell(COL_STOCK_FLOCATION).setValue((Object)aLocationInfo.getName());
                newRow.getCell(COL_STOCK_FLOCATION).setUserObject((Object)aLocationInfo);
            }
            if (aInventoryInfo.getUnit() != null) {
                SelectorItemCollection sic4Unit = new SelectorItemCollection();
                sic4Unit.add(new SelectorItemInfo("*"));
                int qtyPrecision = MeasureUnitFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getUnit().getId().toString()), sic4Unit).getQtyPrecision();
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblInventory, (int)this.tblInventory.getColumnIndex(COL_STOCK_FCURQTY), (int)newRow.getRowIndex(), (int)qtyPrecision);
            } else {
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblInventory, (int)this.tblInventory.getColumnIndex(COL_STOCK_FCURQTY), (int)newRow.getRowIndex(), (int)4);
            }
            newRow.getCell(COL_STOCK_FCURQTY).setValue((Object)aInventoryInfo.getCurStoreQty());
            if (aInventoryInfo.getLot() != null) {
                newRow.getCell(COL_STOCK_FLOT).setValue((Object)aInventoryInfo.getLot());
            }
            if (aInventoryInfo.getStoretype() != null) {
                StoreTypeInfo aStoreTypeInfo = (StoreTypeInfo)storeTypeMap.get(invID);
                newRow.getCell(COL_STOCK_FSTORETYPE).setValue((Object)aStoreTypeInfo.getName());
                newRow.getCell(COL_STOCK_FSTORETYPE).setUserObject((Object)aStoreTypeInfo);
            }
            if (aInventoryInfo.getStorestatus() != null) {
                StoreStateInfo aStoreStateInfo = (StoreStateInfo)storeStateMap.get(invID);
                newRow.getCell(COL_STOCK_FSTORESTATE).setValue((Object)aStoreStateInfo.getName());
                newRow.getCell(COL_STOCK_FSTORESTATE).setUserObject((Object)aStoreStateInfo);
            }
            if (aInventoryInfo.getUnit() != null) {
                MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)invUnitMap.get(invID);
                newRow.getCell(COL_STOCK_FUNIT).setValue((Object)measureUnitInfo.getName());
                newRow.getCell(COL_STOCK_FUNIT).setUserObject((Object)measureUnitInfo);
            }
            newRow.getCell(COL_STOCK_FCURLOCKQTY).getStyleAttributes().setLocked(true);
        }
    }
}

