/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.maintain.WorkOrderException;
import com.kingdee.eas.eqm.maintain.WorkOrderFactory;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.security.SecurityMeasureInfo;
import com.kingdee.eas.eqm.security.WorkPermitInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WorkOrderHelper {
    public WorkOrderInfo editData = null;
    public CoreUI coreUI = null;
    public Context mainOrgCtx = null;
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.WorkOrderResource";

    public WorkOrderHelper(CoreUI coreUI, WorkOrderInfo editData, Context mainOrgContext) {
        this.editData = editData;
        this.coreUI = coreUI;
        this.mainOrgCtx = mainOrgContext;
    }

    public WorkOrderHelper(CoreUI coreUI, Context mainOrgContext) {
        this.coreUI = coreUI;
        this.mainOrgCtx = mainOrgContext;
    }

    public boolean release() throws Exception {
        try {
            String functionName = this.getFunctionName(this.editData.getId().toString());
            if (this.isDispActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).dispChangeStatus(this.editData, GeneBillBaseStatusEnum.Release);
            } else if (this.isFinishActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).finishChangeStatus(this.editData, GeneBillBaseStatusEnum.Release);
            } else if (this.isAcceptActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).acceptChangeStatus(this.editData, GeneBillBaseStatusEnum.Release);
            } else if (this.isCloseActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).closeChangeStatus(this.editData, GeneBillBaseStatusEnum.Release);
            } else if (this.isPlanActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).planChangeStatus(this.editData, GeneBillBaseStatusEnum.Release, Boolean.FALSE);
            } else {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).release((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof WorkOrderException) {
                if (((WorkOrderException)((Object)e)).getSubCode() != null && ((WorkOrderException)((Object)e)).getSubCode().equals("200")) {
                    MsgBox.showDetailAndOK((Component)this.coreUI, (String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"VERIFYWORKPERMITERROR", (Object[])new Object[]{GeneBillBaseStatusEnum.StartWork.getAlias()}), (String)((WorkOrderException)((Object)e)).getMessage(), (int)2);
                } else {
                    this.coreUI.handUIException((Throwable)e);
                }
            } else {
                this.coreUI.handUIException((Throwable)e);
            }
            return false;
        }
    }

    protected boolean startWork() throws Exception {
        try {
            String functionName = this.getFunctionName(this.editData.getId().toString());
            if (this.isDispActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).dispChangeStatus(this.editData, GeneBillBaseStatusEnum.StartWork);
            } else if (this.isFinishActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).finishChangeStatus(this.editData, GeneBillBaseStatusEnum.StartWork);
            } else if (this.isAcceptActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).acceptChangeStatus(this.editData, GeneBillBaseStatusEnum.StartWork);
            } else if (this.isCloseActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).closeChangeStatus(this.editData, GeneBillBaseStatusEnum.StartWork);
            } else if (this.isPlanActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).planChangeStatus(this.editData, GeneBillBaseStatusEnum.StartWork, Boolean.FALSE);
            } else {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).startWork((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof WorkOrderException) {
                if (((WorkOrderException)((Object)e)).getSubCode() != null && ((WorkOrderException)((Object)e)).getSubCode().equals("200")) {
                    MsgBox.showDetailAndOK((Component)this.coreUI, (String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"VERIFYWORKPERMITERROR", (Object[])new Object[]{GeneBillBaseStatusEnum.StartWork.getAlias()}), (String)((WorkOrderException)((Object)e)).getMessage(), (int)2);
                } else {
                    this.coreUI.handUIException((Throwable)e);
                }
            } else {
                this.coreUI.handUIException((Throwable)e);
            }
            return false;
        }
    }

    protected boolean finish() throws Exception {
        try {
            String functionName = this.getFunctionName(this.editData.getId().toString());
            if (this.isDispActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).dispChangeStatus(this.editData, GeneBillBaseStatusEnum.Finish);
            } else if (this.isFinishActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).finishChangeStatus(this.editData, GeneBillBaseStatusEnum.Finish);
            } else if (this.isAcceptActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).acceptChangeStatus(this.editData, GeneBillBaseStatusEnum.Finish);
            } else if (this.isCloseActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).closeChangeStatus(this.editData, GeneBillBaseStatusEnum.Finish);
            } else if (this.isPlanActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).planChangeStatus(this.editData, GeneBillBaseStatusEnum.Finish, Boolean.FALSE);
            } else {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).finish((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof WorkOrderException) {
                if (((WorkOrderException)((Object)e)).getSubCode() != null && ((WorkOrderException)((Object)e)).getSubCode().equals("200")) {
                    MsgBox.showDetailAndOK((Component)this.coreUI, (String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"VERIFYWORKPERMITERROR", (Object[])new Object[]{GeneBillBaseStatusEnum.StartWork.getAlias()}), (String)((WorkOrderException)((Object)e)).getMessage(), (int)2);
                } else {
                    this.coreUI.handUIException((Throwable)e);
                }
            } else {
                this.coreUI.handUIException((Throwable)e);
            }
            return false;
        }
    }

    protected boolean acceptance() throws Exception {
        try {
            String functionName = this.getFunctionName(this.editData.getId().toString());
            if (this.isDispActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).dispChangeStatus(this.editData, GeneBillBaseStatusEnum.Check);
            } else if (this.isFinishActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).finishChangeStatus(this.editData, GeneBillBaseStatusEnum.Check);
            } else if (this.isAcceptActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).acceptChangeStatus(this.editData, GeneBillBaseStatusEnum.Check);
            } else if (this.isCloseActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).closeChangeStatus(this.editData, GeneBillBaseStatusEnum.Check);
            } else if (this.isPlanActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).planChangeStatus(this.editData, GeneBillBaseStatusEnum.Check, Boolean.FALSE);
            } else {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).acceptance((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof WorkOrderException) {
                if (((WorkOrderException)((Object)e)).getSubCode() != null && ((WorkOrderException)((Object)e)).getSubCode().equals("200")) {
                    MsgBox.showDetailAndOK((Component)this.coreUI, (String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"VERIFYWORKPERMITERROR", (Object[])new Object[]{GeneBillBaseStatusEnum.StartWork.getAlias()}), (String)((WorkOrderException)((Object)e)).getMessage(), (int)2);
                } else {
                    this.coreUI.handUIException((Throwable)e);
                }
            } else {
                this.coreUI.handUIException((Throwable)e);
            }
            return false;
        }
    }

    protected boolean closed() throws Exception {
        try {
            String functionName = this.getFunctionName(this.editData.getId().toString());
            if (this.isDispActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).dispChangeStatus(this.editData, GeneBillBaseStatusEnum.CLOSED);
            } else if (this.isFinishActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).finishChangeStatus(this.editData, GeneBillBaseStatusEnum.CLOSED);
            } else if (this.isAcceptActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).acceptChangeStatus(this.editData, GeneBillBaseStatusEnum.CLOSED);
            } else if (this.isCloseActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).closeChangeStatus(this.editData, GeneBillBaseStatusEnum.CLOSED);
            } else if (this.isPlanActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).planChangeStatus(this.editData, GeneBillBaseStatusEnum.CLOSED, Boolean.FALSE);
            } else {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).closed((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof WorkOrderException) {
                if (((WorkOrderException)((Object)e)).getSubCode() != null && ((WorkOrderException)((Object)e)).getSubCode().equals("200")) {
                    MsgBox.showDetailAndOK((Component)this.coreUI, (String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"VERIFYWORKPERMITERROR", (Object[])new Object[]{GeneBillBaseStatusEnum.StartWork.getAlias()}), (String)((WorkOrderException)((Object)e)).getMessage(), (int)2);
                } else {
                    this.coreUI.handUIException((Throwable)e);
                }
            } else {
                this.coreUI.handUIException((Throwable)e);
            }
            return false;
        }
    }

    protected boolean forceClosed() throws Exception {
        try {
            String functionName = this.getFunctionName(this.editData.getId().toString());
            if (this.isDispActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).dispChangeStatus(this.editData, GeneBillBaseStatusEnum.ForceClosed);
            } else if (this.isFinishActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).finishChangeStatus(this.editData, GeneBillBaseStatusEnum.ForceClosed);
            } else if (this.isAcceptActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).acceptChangeStatus(this.editData, GeneBillBaseStatusEnum.ForceClosed);
            } else if (this.isCloseActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).closeChangeStatus(this.editData, GeneBillBaseStatusEnum.ForceClosed);
            } else if (this.isPlanActivity(functionName)) {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).planChangeStatus(this.editData, GeneBillBaseStatusEnum.ForceClosed, Boolean.FALSE);
            } else {
                WorkOrderFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx).forceClosed((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof WorkOrderException) {
                if (((WorkOrderException)((Object)e)).getSubCode() != null && ((WorkOrderException)((Object)e)).getSubCode().equals("200")) {
                    MsgBox.showDetailAndOK((Component)this.coreUI, (String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"VERIFYWORKPERMITERROR", (Object[])new Object[]{GeneBillBaseStatusEnum.StartWork.getAlias()}), (String)((WorkOrderException)((Object)e)).getMessage(), (int)2);
                } else {
                    this.coreUI.handUIException((Throwable)e);
                }
            } else {
                this.coreUI.handUIException((Throwable)e);
            }
            return false;
        }
    }

    public String getFunctionName(String bosID) {
        List functions = this.getCurrentFunctionNameOfWorkFlow(bosID);
        if (!GeneCommonUtils.isEmpty((Collection)functions)) {
            String currentFunction = (String)functions.get(0);
            return currentFunction;
        }
        return null;
    }

    public List getCurrentFunctionNameOfWorkFlow(String bosID) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
            ProcessInstInfo[] ps = service.getAllProcessInstancesByBizobjId(bosID);
            if (ps != null && ps.length > 0) {
                for (int i = 0; i < ps.length; ++i) {
                    ActivityInstInfo[] acts = service.getActInstMetaArrayByProcInstId(ps[0].getProcInstId());
                    for (int j = 0; j < acts.length; ++j) {
                        ActivityDef p;
                        if (!acts[j].getState().equals("open.not_running.not_started") || !((p = service.getActDefByActInstInfo(acts[j])) instanceof ManpowerActivityDef)) continue;
                        ManpowerActivityDef man = (ManpowerActivityDef)p;
                        FunctionDef fun = man.getRelatedApplication().getFunction();
                        result.add(fun.getOperation());
                    }
                }
            }
        }
        catch (BOSException e1) {
            this.coreUI.handUIException((Throwable)e1);
        }
        return result;
    }

    public boolean isPlanActivity(String functionName) {
        return functionName != null && "ActionPlanSubmitChangeStatus".equals(functionName);
    }

    public boolean isDispActivity(String functionName) {
        return functionName != null && "ActionDispChangeStatus".equals(functionName);
    }

    public boolean isFinishActivity(String functionName) {
        return functionName != null && "ActionFinishChangeStatus".equals(functionName);
    }

    public boolean isAcceptActivity(String functionName) {
        return functionName != null && "ActionAcceptChangeStatus".equals(functionName);
    }

    public boolean isCloseActivity(String functionName) {
        return functionName != null && "ActionCloseChangeStatus".equals(functionName);
    }

    public List getCategoryParameter(List ids, GeneBillBaseStatusEnum status) {
        BatchParam param;
        ArrayList<BatchExecuteParamsEntry> dispParams = new ArrayList<BatchExecuteParamsEntry>();
        ArrayList<BatchExecuteParamsEntry> finishParams = new ArrayList<BatchExecuteParamsEntry>();
        ArrayList<BatchExecuteParamsEntry> acceptrams = new ArrayList<BatchExecuteParamsEntry>();
        ArrayList<BatchExecuteParamsEntry> closeParams = new ArrayList<BatchExecuteParamsEntry>();
        ArrayList<BatchExecuteParamsEntry> planParams = new ArrayList<BatchExecuteParamsEntry>();
        ArrayList<BatchParam> ret = new ArrayList<BatchParam>();
        for (int i = 0; i < ids.size(); ++i) {
            WorkOrderInfo order;
            BatchExecuteParamsEntry p;
            Class[] parameTypes;
            String bosid = (String)ids.get(i);
            String functionName = this.getFunctionName(bosid);
            if (this.isDispActivity(functionName)) {
                parameTypes = new Class[]{WorkOrderInfo.class, GeneBillBaseStatusEnum.class};
                p = new BatchExecuteParamsEntry(parameTypes);
                order = new WorkOrderInfo();
                order.setId(BOSUuid.read((String)ids.get(i).toString()));
                p.add((Object)order);
                p.add((Object)status);
                dispParams.add(p);
                continue;
            }
            if (this.isFinishActivity(functionName)) {
                parameTypes = new Class[]{WorkOrderInfo.class, GeneBillBaseStatusEnum.class};
                p = new BatchExecuteParamsEntry(parameTypes);
                order = new WorkOrderInfo();
                order.setId(BOSUuid.read((String)ids.get(i).toString()));
                p.add((Object)order);
                p.add((Object)status);
                finishParams.add(p);
                continue;
            }
            if (this.isAcceptActivity(functionName)) {
                parameTypes = new Class[]{WorkOrderInfo.class, GeneBillBaseStatusEnum.class};
                p = new BatchExecuteParamsEntry(parameTypes);
                order = new WorkOrderInfo();
                order.setId(BOSUuid.read((String)ids.get(i).toString()));
                p.add((Object)order);
                p.add((Object)status);
                acceptrams.add(p);
                continue;
            }
            if (this.isCloseActivity(functionName)) {
                parameTypes = new Class[]{WorkOrderInfo.class, GeneBillBaseStatusEnum.class};
                p = new BatchExecuteParamsEntry(parameTypes);
                order = new WorkOrderInfo();
                order.setId(BOSUuid.read((String)ids.get(i).toString()));
                p.add((Object)order);
                p.add((Object)status);
                closeParams.add(p);
                continue;
            }
            if (this.isPlanActivity(functionName)) {
                parameTypes = new Class[]{WorkOrderInfo.class, GeneBillBaseStatusEnum.class, Boolean.class};
                p = new BatchExecuteParamsEntry(parameTypes);
                order = new WorkOrderInfo();
                order.setId(BOSUuid.read((String)ids.get(i).toString()));
                p.add((Object)order);
                p.add((Object)status);
                p.add((Object)Boolean.FALSE);
                planParams.add(p);
                continue;
            }
            BatchParam param2 = new BatchParam();
            param2.setAbnoraml(true);
            ret.add(param2);
        }
        if (!GeneCommonUtils.isEmpty(dispParams)) {
            Class[] parameTypes = new Class[]{WorkOrderInfo.class, GeneBillBaseStatusEnum.class};
            param = new BatchParam("dispChangeStatus", parameTypes, dispParams.toArray(new BatchExecuteParamsEntry[dispParams.size()]));
            ret.add(param);
        }
        if (!GeneCommonUtils.isEmpty(finishParams)) {
            Class[] parameTypes = new Class[]{WorkOrderInfo.class, GeneBillBaseStatusEnum.class};
            param = new BatchParam("finishChangeStatus", parameTypes, finishParams.toArray(new BatchExecuteParamsEntry[finishParams.size()]));
            ret.add(param);
        }
        if (!GeneCommonUtils.isEmpty(acceptrams)) {
            Class[] parameTypes = new Class[]{WorkOrderInfo.class, GeneBillBaseStatusEnum.class};
            param = new BatchParam("acceptChangeStatus", parameTypes, acceptrams.toArray(new BatchExecuteParamsEntry[acceptrams.size()]));
            ret.add(param);
        }
        if (!GeneCommonUtils.isEmpty(closeParams)) {
            Class[] parameTypes = new Class[]{WorkOrderInfo.class, GeneBillBaseStatusEnum.class};
            param = new BatchParam("closeChangeStatus", parameTypes, closeParams.toArray(new BatchExecuteParamsEntry[closeParams.size()]));
            ret.add(param);
        }
        if (!GeneCommonUtils.isEmpty(planParams)) {
            Class[] parameTypes = new Class[]{WorkOrderInfo.class, GeneBillBaseStatusEnum.class, Boolean.class};
            param = new BatchParam("planChangeStatus", parameTypes, planParams.toArray(new BatchExecuteParamsEntry[planParams.size()]));
            ret.add(param);
        }
        return ret;
    }

    public List getPermitCategoryParameter(List ids, GeneBillBaseStatusEnum status) {
        ArrayList<BatchExecuteParamsEntry> defaultParams = new ArrayList<BatchExecuteParamsEntry>();
        ArrayList<BatchParam> ret = new ArrayList<BatchParam>();
        for (int i = 0; i < ids.size(); ++i) {
            String bosid = (String)ids.get(i);
            String functionName = this.getFunctionName(bosid);
            if (functionName != null && functionName.length() > 0) {
                Class[] parameTypes = new Class[]{WorkPermitInfo.class, GeneBillBaseStatusEnum.class, String.class};
                BatchExecuteParamsEntry p = new BatchExecuteParamsEntry(parameTypes);
                WorkPermitInfo order = new WorkPermitInfo();
                order.setId(BOSUuid.read((String)ids.get(i).toString()));
                p.add((Object)order);
                p.add((Object)status);
                p.add((Object)"false");
                defaultParams.add(p);
                continue;
            }
            BatchParam param = new BatchParam();
            param.setAbnoraml(true);
            ret.add(param);
        }
        if (!GeneCommonUtils.isEmpty(defaultParams)) {
            Class[] parameTypes = new Class[]{WorkPermitInfo.class, GeneBillBaseStatusEnum.class, String.class};
            BatchParam param = new BatchParam("changeStatus", parameTypes, defaultParams.toArray(new BatchExecuteParamsEntry[defaultParams.size()]));
            ret.add(param);
        }
        return ret;
    }

    public List getSecurityMeasureCategoryParameter(List ids, GeneBillBaseStatusEnum status) {
        ArrayList<BatchExecuteParamsEntry> defaultParams = new ArrayList<BatchExecuteParamsEntry>();
        ArrayList<BatchParam> ret = new ArrayList<BatchParam>();
        for (int i = 0; i < ids.size(); ++i) {
            String bosid = (String)ids.get(i);
            String functionName = this.getFunctionName(bosid);
            if (functionName != null && functionName.length() > 0) {
                Class[] parameTypes = new Class[]{SecurityMeasureInfo.class, GeneBillBaseStatusEnum.class, String.class};
                BatchExecuteParamsEntry p = new BatchExecuteParamsEntry(parameTypes);
                SecurityMeasureInfo order = new SecurityMeasureInfo();
                order.setId(BOSUuid.read((String)ids.get(i).toString()));
                p.add((Object)order);
                p.add((Object)status);
                p.add((Object)"false");
                defaultParams.add(p);
                continue;
            }
            BatchParam param = new BatchParam();
            param.setAbnoraml(true);
            ret.add(param);
        }
        if (!GeneCommonUtils.isEmpty(defaultParams)) {
            Class[] parameTypes = new Class[]{SecurityMeasureInfo.class, GeneBillBaseStatusEnum.class, String.class};
            BatchParam param = new BatchParam("statusChange", parameTypes, defaultParams.toArray(new BatchExecuteParamsEntry[defaultParams.size()]));
            ret.add(param);
        }
        return ret;
    }

    public static class BatchParam {
        private String actionName = null;
        private Class[] parameTypes = null;
        private BatchExecuteParamsEntry[] paramEntries = null;
        private boolean abnoraml = false;

        public BatchParam() {
        }

        public BatchParam(String actionName, Class[] parameTypes, BatchExecuteParamsEntry[] paramEntries) {
            this.actionName = actionName;
            this.parameTypes = parameTypes;
            this.paramEntries = paramEntries;
        }

        public String getActionName() {
            return this.actionName;
        }

        public void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public Class[] getParameTypes() {
            return this.parameTypes;
        }

        public void setParameTypes(Class[] parameTypes) {
            this.parameTypes = parameTypes;
        }

        public BatchExecuteParamsEntry[] getParamEntries() {
            return this.paramEntries;
        }

        public void setParamEntries(BatchExecuteParamsEntry[] paramEntries) {
            this.paramEntries = paramEntries;
        }

        public boolean isAbnoraml() {
            return this.abnoraml;
        }

        public void setAbnoraml(boolean abnoraml) {
            this.abnoraml = abnoraml;
        }
    }
}

