/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.eqmcore.EqmFinanceFacadeFactory;
import com.kingdee.eas.eqm.common.eqmcore.IEqmFinanceFacade;
import com.kingdee.eas.eqm.maintain.client.WorkOrderEditUI;
import com.kingdee.eas.eqm.maintain.client.util.WorkOrderLineCostCalUtil;
import com.kingdee.eas.eqm.maintain.client.util.WorkOrderPrecisionUtil;
import java.util.HashMap;
import java.util.Map;

public class WorkOrderCurrencyUtil {
    protected static final String COL_CURRENCY = "currency";
    protected static final String COL_SELFCURRENCY = "selfCurrency";
    protected static final String COL_HOURS = "hours";
    protected static final String COL_AMOUNT = "amount";
    protected static final String COL_RATE = "rate";
    protected static final String COL_UNITPRICE = "unitPrice";
    protected static final String COL_PLANAMOUNT = "planAmount";
    protected static final String COL_REALCOSTAMOUNT = "realCostQty";
    protected static final String COL_LINECOST = "lineCost";
    protected static final String COL_STORAGEORGUNIT = "storageOrgUnit";
    protected static final String COL_MAINTAINORGUNIT = "maintainOrgUnit";
    protected static final String COL_PURCHASEORGUNIT = "purchaseOrgUnit";
    private Map tableOrgCalMap = new HashMap();
    private Map tableOrgTypeMap = new HashMap();
    private static WorkOrderPrecisionUtil precisionUtil = new WorkOrderPrecisionUtil();
    private static WorkOrderLineCostCalUtil lineCostUtil = new WorkOrderLineCostCalUtil();

    public WorkOrderCurrencyUtil() {
        this.initTbaleOrgCalmap();
        this.initTableOrgTypeMap();
    }

    private void initTableOrgTypeMap() {
        this.tableOrgTypeMap.put("planUserEntry", new Integer(4));
        this.tableOrgTypeMap.put("planMaterialEntry", new Integer(4));
        this.tableOrgTypeMap.put("planToolsEntry", new Integer(4));
        this.tableOrgTypeMap.put("planServiceEntry", new Integer(3));
        this.tableOrgTypeMap.put("realUserEntry", new Integer(4));
        this.tableOrgTypeMap.put("realMaterialEntry", new Integer(4));
        this.tableOrgTypeMap.put("realToolsEntry", new Integer(4));
        this.tableOrgTypeMap.put("realServiceEntry", new Integer(3));
    }

    private void initTbaleOrgCalmap() {
        this.tableOrgCalMap.put("planUserEntry", COL_MAINTAINORGUNIT);
        this.tableOrgCalMap.put("planMaterialEntry", COL_STORAGEORGUNIT);
        this.tableOrgCalMap.put("planToolsEntry", COL_STORAGEORGUNIT);
        this.tableOrgCalMap.put("planServiceEntry", COL_PURCHASEORGUNIT);
        this.tableOrgCalMap.put("realUserEntry", COL_MAINTAINORGUNIT);
        this.tableOrgCalMap.put("realMaterialEntry", COL_STORAGEORGUNIT);
        this.tableOrgCalMap.put("realToolsEntry", COL_STORAGEORGUNIT);
        this.tableOrgCalMap.put("realServiceEntry", COL_PURCHASEORGUNIT);
    }

    public void setDefaultCurrency(Context ctx, WorkOrderEditUI workOrderUI, String[] orgIDs) throws EASBizException, BOSException {
        CurrencyInfo oldCurrency = workOrderUI.getDefaultCurrency();
        IEqmFinanceFacade fainanceFacade = EqmFinanceFacadeFactory.getRemoteInstanceWithObjectContext((Context)ctx);
        workOrderUI.setDefaultCurrency(fainanceFacade.getCurrency(orgIDs, new int[]{4, 4}));
        if (this.checkCurrencyChanged(oldCurrency, workOrderUI.getDefaultCurrency())) {
            workOrderUI.setDefaultCurrencyChanged(true);
            precisionUtil.updateAllCellLineCostPrecision(workOrderUI);
        } else {
            workOrderUI.setDefaultCurrencyChanged(false);
        }
    }

    public void initDefaultCurrency(Context ctx, WorkOrderEditUI workOrderUI, String[] orgIDs) throws EASBizException, BOSException {
        CurrencyInfo oldCurrency = workOrderUI.getDefaultCurrency();
        IEqmFinanceFacade fainanceFacade = EqmFinanceFacadeFactory.getRemoteInstanceWithObjectContext((Context)ctx);
        workOrderUI.setDefaultCurrency(fainanceFacade.getCurrency(orgIDs, new int[]{4, 4}));
        if (this.checkCurrencyChanged(oldCurrency, workOrderUI.getDefaultCurrency())) {
            workOrderUI.setDefaultCurrencyChanged(true);
            precisionUtil.updateAllCellLineCostPrecision(workOrderUI);
        } else {
            workOrderUI.setDefaultCurrencyChanged(false);
        }
    }

    public boolean checkCurrencyChanged(CurrencyInfo oldObj, CurrencyInfo newObj) {
        if (oldObj == null && newObj == null) {
            return true;
        }
        if (oldObj == null && newObj != null) {
            return true;
        }
        if (oldObj != null && newObj == null) {
            return true;
        }
        return !oldObj.getId().toString().equals(newObj.getId().toString());
    }

    public void setPlanUserCurrency(Context ctx, KDTable planUserEntry, int rowIndex, CurrencyInfo defaultCurrency) throws EASBizException, BOSException {
        IRow row = planUserEntry.getRow(rowIndex);
        CurrencyInfo oldCurrency = (CurrencyInfo)planUserEntry.getCell(rowIndex, COL_CURRENCY).getValue();
        if (row.getCell(COL_MAINTAINORGUNIT).getValue() == null) {
            this.setLineCurrency(ctx, row, null, 4, defaultCurrency);
        } else {
            StorageOrgUnitInfo storageOrg = (StorageOrgUnitInfo)row.getCell(COL_MAINTAINORGUNIT).getValue();
            this.setLineCurrency(ctx, row, storageOrg.getId().toString(), 4, defaultCurrency);
        }
        CurrencyInfo newCurrency = (CurrencyInfo)planUserEntry.getCell(rowIndex, COL_CURRENCY).getValue();
        if (this.checkCurrencyChanged(oldCurrency, newCurrency)) {
            precisionUtil.setLineCostByCurrencyPrecision(planUserEntry, rowIndex);
        }
    }

    public void setPlanServiceCurrency(Context ctx, KDTable planServiceEntry, int rowIndex, CurrencyInfo defaultCurrency) throws EASBizException, BOSException {
        IRow row = planServiceEntry.getRow(rowIndex);
        CurrencyInfo oldCurrency = (CurrencyInfo)planServiceEntry.getCell(rowIndex, COL_CURRENCY).getValue();
        if (row.getCell(COL_PURCHASEORGUNIT).getValue() == null) {
            this.setLineCurrency(ctx, row, null, 3, defaultCurrency);
        } else {
            PurchaseOrgUnitInfo purchaseOrg = (PurchaseOrgUnitInfo)row.getCell(COL_PURCHASEORGUNIT).getValue();
            this.setLineCurrency(ctx, row, purchaseOrg.getId().toString(), 3, defaultCurrency);
        }
        CurrencyInfo newCurrency = (CurrencyInfo)planServiceEntry.getCell(rowIndex, COL_CURRENCY).getValue();
        if (this.checkCurrencyChanged(oldCurrency, newCurrency)) {
            precisionUtil.setLineCostByCurrencyPrecision(planServiceEntry, rowIndex);
        }
    }

    public void setRealServiceCurrency(Context ctx, KDTable realServiceEntry, int rowIndex, CurrencyInfo defaultCurrency) throws EASBizException, BOSException {
        IRow row = realServiceEntry.getRow(rowIndex);
        CurrencyInfo oldCurrency = (CurrencyInfo)realServiceEntry.getCell(rowIndex, COL_CURRENCY).getValue();
        if (row.getCell(COL_PURCHASEORGUNIT).getValue() == null) {
            this.setLineCurrency(ctx, row, null, 3, defaultCurrency);
        } else {
            PurchaseOrgUnitInfo purchaseOrg = (PurchaseOrgUnitInfo)row.getCell(COL_PURCHASEORGUNIT).getValue();
            this.setLineCurrency(ctx, row, purchaseOrg.getId().toString(), 3, defaultCurrency);
        }
        CurrencyInfo newCurrency = (CurrencyInfo)realServiceEntry.getCell(rowIndex, COL_CURRENCY).getValue();
        if (this.checkCurrencyChanged(oldCurrency, newCurrency)) {
            precisionUtil.setLineCostByCurrencyPrecision(realServiceEntry, rowIndex);
        }
    }

    public void updateLineCurrencyAfterMTOrgChanged(KDTable table, int rowIndex, CurrencyInfo defaultCurrency, boolean isDefaultCurrencyChanged) {
        if (isDefaultCurrencyChanged) {
            if (!((Boolean)table.getCell(rowIndex, COL_SELFCURRENCY).getValue()).booleanValue()) {
                table.getCell(rowIndex, COL_CURRENCY).setValue((Object)defaultCurrency);
            }
            precisionUtil.setLineCostCellPrecision(table, rowIndex, precisionUtil.getCurrencyPrecision(table, rowIndex));
            lineCostUtil.setLineCost(table, rowIndex);
        }
    }

    public CurrencyInfo getLineCurrency(Context ctx, String orgIDs, int orgType, CurrencyInfo defaultCurrency) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        IEqmFinanceFacade fainanceFacade = EqmFinanceFacadeFactory.getRemoteInstanceWithObjectContext((Context)ctx);
        currency = fainanceFacade.getCurrency(orgIDs, orgType);
        if (currency == null) {
            return defaultCurrency;
        }
        return currency;
    }

    private int getLineOrgType(KDTable table) {
        return (Integer)this.tableOrgTypeMap.get(table.getName());
    }

    private String getLineOrgID(KDTable table, int rowIndex) {
        ICell cell = table.getCell(rowIndex, table.getColumnIndex((String)this.tableOrgCalMap.get(table.getName())));
        if (cell == null) {
            return null;
        }
        if (cell.getValue() == null) {
            return null;
        }
        String orgID = ((OrgUnitInfo)cell.getValue()).getId().toString();
        return orgID;
    }

    protected void setLineCurrency(Context ctx, IRow row, String orgID, int orgType, CurrencyInfo defaultCurrency) throws EASBizException, BOSException {
        if (orgID == null) {
            row.getCell(COL_CURRENCY).setValue((Object)defaultCurrency);
            row.getCell(COL_SELFCURRENCY).setValue((Object)new Boolean(false));
            return;
        }
        CurrencyInfo currency = null;
        IEqmFinanceFacade fainanceFacade = EqmFinanceFacadeFactory.getRemoteInstanceWithObjectContext((Context)ctx);
        currency = fainanceFacade.getCurrency(orgID, orgType);
        if (currency == null) {
            row.getCell(COL_CURRENCY).setValue((Object)defaultCurrency);
            row.getCell(COL_SELFCURRENCY).setValue((Object)new Boolean(false));
        } else {
            row.getCell(COL_CURRENCY).setValue((Object)currency);
            row.getCell(COL_SELFCURRENCY).setValue((Object)new Boolean(true));
        }
    }

    public void initCurrencyForNullLine(KDTable table, int rowIndex, CurrencyInfo defaultCurrency) {
        table.getCell(rowIndex, COL_CURRENCY).setValue((Object)defaultCurrency);
        precisionUtil.setLineCostCellPrecision(table, rowIndex, precisionUtil.getCurrencyPrecision(table, rowIndex));
    }
}

