/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.client.GeneBillBaseFilterUI;
import com.kingdee.eas.eqm.common.core.client.action.LongTimeAction;
import com.kingdee.eas.eqm.common.core.client.util.GeneClientUtils;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.planning.CheckingPlanningFactory;
import com.kingdee.eas.eqm.planning.CheckingPlanningInfo;
import com.kingdee.eas.eqm.planning.client.AbstractCheckingPlanningListUI;
import com.kingdee.eas.eqm.planning.client.CheckingPlanningFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CheckingPlanningListUI
extends AbstractCheckingPlanningListUI {
    private static final long serialVersionUID = 5299909991547111772L;
    private static final Logger logger = CoreUIObject.getLogger(CheckingPlanningListUI.class);
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.planning.CheckingPlanningResource";

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected IObjectValue createNewData() {
        CheckingPlanningInfo objectValue = new CheckingPlanningInfo();
        return objectValue;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return super.getMainBizOrg();
    }

    @Override
    public void actionRelease_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.isExistsRecord();
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"ALERT_RELEASE", null)))) {
            return;
        }
        BatchChangeStatusAction action = new BatchChangeStatusAction("release");
        action.doIt((CoreUI)this, this.actionRelease);
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.isExistsRecord();
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"ALERT_CLOSE", null)))) {
            return;
        }
        BatchChangeStatusAction action = new BatchChangeStatusAction("closed");
        action.doIt((CoreUI)this, this.actionClose);
    }

    private void isExistsRecord() throws EASBizException, BOSException, UuidException {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String boID = ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.tblMain, (String)"id");
        boolean flag = CheckingPlanningFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).exists((IObjectPK)new ObjectUuidPK(boID));
        if (!flag) {
            MsgBox.showInfo((Component)((Object)this), (String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"itemNotExist", null));
            SysUtil.abort();
        }
    }

    protected GeneBillBaseFilterUI newInstanceFilterUI() throws Exception {
        return new CheckingPlanningFilterUI();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.btnAuditResult.setEnabled(false);
        this.tblMain.getColumn("planningTime").setRenderer((IBasicRender)EQMPromptDialogFactory.dateRenderer);
        this.tblMain.getColumn("handlerTime").setRenderer((IBasicRender)EQMPromptDialogFactory.dateRenderer);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int last = e.getLastRow();
        for (int i = from; i <= last; ++i) {
            IRow row = this.getMainTable().getRow(i);
            if (row == null) continue;
            this.processKDTableRow(row);
        }
    }

    public void processKDTableRow(IRow row) {
        BizEnumValueInfo v;
        super.processKDTableRow(row);
        ICell cptypeC = row.getCell("cpType");
        if (cptypeC != null && (v = (BizEnumValueInfo)cptypeC.getValue()) != null && v.getInt() == 10) {
            row.getCell("turns").setValue(null);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.tblMain.getRowCount() > 0) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                if (row.getCell(17).getValue() == null || !row.getCell(17).getValue().toString().equals("0")) continue;
                row.getCell(17).setValue(null);
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CheckingPlanningFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnView.setEnabled(true);
        this.btnView.setVisible(true);
        this.btnRelease.setEnabled(true);
        this.btnClose.setEnabled(true);
        this.kDMenuClose.setEnabled(true);
        this.kDMenuRelease.setEnabled(true);
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnRelease.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.kDMenuClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.kDMenuRelease.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
    }

    protected void checkCanEdit(GeneBillBaseInfo billInfo) throws Exception {
        super.checkCanEdit(billInfo);
        GeneBillBaseStatusEnum baseStatus = billInfo.getBillStatus();
        if (baseStatus == GeneBillBaseStatusEnum.CLOSED) {
            MsgBox.showWarning((Component)((Object)this), (String)(GeneClientUtils.getResource((String)"BillAt") + baseStatus.getAlias() + GeneClientUtils.getResource((String)"CantBeEdited")));
            SysUtil.abort();
        }
    }

    protected boolean isLazyMode() {
        return true;
    }

    public class BatchChangeStatusAction
    extends LongTimeAction {
        protected ArrayList ids = null;
        protected String actionName = null;

        public BatchChangeStatusAction(String actionName) {
            this.actionName = actionName;
        }

        protected Object actionDoIt(CoreUI ui, ItemAction e) throws Exception {
            Class[] parameTypes = new Class[]{IObjectPK.class};
            this.ids = CheckingPlanningListUI.this.getSelectedIdValues();
            BatchExecuteParamsEntry[] paramEntries = CheckingPlanningListUI.this.prepareParams(this.ids, parameTypes);
            return CheckingPlanningListUI.this.getBizInterface().batchExecute(this.actionName, parameTypes, paramEntries);
        }

        protected void afterDoIt(CoreUI ui, ItemAction action, Object value) throws Exception {
            BatchExecuteResult rst = (BatchExecuteResult)value;
            GeneClientUtils.handleBatchExcuteResult((CoreUI)ui, (KDTable)CheckingPlanningListUI.this.tblMain, (ItemAction)action, (List)this.ids, (BatchExecuteResult)rst);
        }

        protected void beforeDoIt(CoreUI ui, ItemAction e) throws Exception {
            CheckingPlanningListUI.this.checkSelected();
        }
    }
}

