/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.common.core.filter.CompositeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.SingleFilterElement;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.planning.client.AbstractEquipmentCheckingRegulationFilterUI;
import java.awt.Component;
import org.apache.log4j.Logger;

public class EquipmentCheckingRegulationFilterUI
extends AbstractEquipmentCheckingRegulationFilterUI {
    private static final long serialVersionUID = -3518678112151867547L;
    private static final Logger logger = CoreUIObject.getLogger(EquipmentCheckingRegulationFilterUI.class);

    public KDBizPromptBox getMainBizOrg() {
        return this.prmtOrgUnit;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtOrgUnit;
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        rootElement.add((IFilterElement)new SingleFilterElement("equipment.id", (Component)this.prmtEquipment));
        rootElement.add((IFilterElement)new SingleFilterElement("location.id", (Component)this.prmtLocation));
        rootElement.add((IFilterElement)new SingleFilterElement("equipmentCheckingRegulation.id", (Component)this.prmtRegulation));
    }

    public FilterInfo getFilterInfo() {
        if (super.getFilterInfo() == null) {
            return null;
        }
        FilterInfo filter = super.getFilterInfo();
        EquipmentArchivesInfo archivesInfo = (EquipmentArchivesInfo)this.prmtEquipment.getValue();
        EquipmentLocationInfo locationInfo = (EquipmentLocationInfo)this.prmtLocation.getValue();
        FilterInfo appendFilterInfo = new FilterInfo();
        if (null != archivesInfo) {
            appendFilterInfo.getFilterItems().add(new FilterItemInfo("equipment.id", (Object)archivesInfo.getId().toString()));
        }
        if (null == archivesInfo && null != locationInfo) {
            appendFilterInfo.getFilterItems().add(new FilterItemInfo("location.id", (Object)locationInfo.getId().toString()));
            appendFilterInfo.getFilterItems().add(new FilterItemInfo("equipment.id", null));
            appendFilterInfo.setMaskString("#0 AND #1");
        }
        try {
            filter.mergeFilter(appendFilterInfo, "AND");
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return filter;
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo org) {
        if (org == null) {
            return;
        }
        try {
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtRegulation, (String)"com.kingdee.eas.eqm.planning.app.F7EquipmentCheckingRegulationQuery", (String[])new String[]{"storageOrgUnit.id"}, (Object[])new Object[]{org.getId()}, (CompareType[])new CompareType[]{CompareType.EQUALS});
            this.createPromptArchives(this.prmtLocation.getValue());
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtLocation, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentLocationQuery", (String[])new String[]{"planOrgUnit.id", "checkedStatus"}, (Object[])new Object[]{org.getId(), new Integer(2)}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS});
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void initListener() {
        super.initListener();
        this.prmtLocation.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    EquipmentCheckingRegulationFilterUI.this.prmtLocation_dataChanged(e);
                }
                catch (Exception exc) {
                    EquipmentCheckingRegulationFilterUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void prmtLocation_dataChanged(DataChangeEvent e) {
        this.createPromptArchives(e.getNewValue());
    }

    private void createPromptArchives(Object location) {
        if (location == null || !(location instanceof EquipmentLocationInfo)) {
            try {
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipment, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery", (String[])new String[]{"planOrgUnit.id", "initial", "bizStatus"}, (Object[])new Object[]{this.prmtOrgUnit.getValue() == null ? null : ((OrgUnitInfo)this.prmtOrgUnit.getValue()).getId(), Boolean.TRUE, new Integer(10)}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS, CompareType.EQUALS}, (boolean)true);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            EquipmentLocationInfo locationInfo = (EquipmentLocationInfo)location;
            try {
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipment, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery", (String[])new String[]{"planOrgUnit.id", "initial", "bizStatus", "location.id"}, (Object[])new Object[]{this.prmtOrgUnit.getValue() == null ? null : ((OrgUnitInfo)this.prmtOrgUnit.getValue()).getId(), Boolean.TRUE, new Integer(10), locationInfo == null || locationInfo.getId() == null ? null : locationInfo.getId().toString()}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS, CompareType.EQUALS, CompareType.EQUALS}, (boolean)true);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    protected void setDefaultValue() {
        this.prmtOrgUnit.setValue((Object)this.getDefaultMainBizOrg());
    }
}

