/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.common.core.client.GeneBillBaseFilterUI;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.planning.EquipmentCheckingRegulationFactory;
import com.kingdee.eas.eqm.planning.EquipmentCheckingRegulationInfo;
import com.kingdee.eas.eqm.planning.client.AbstractEquipmentCheckingRegulationListUI;
import com.kingdee.eas.eqm.planning.client.EquipmentCheckingRegulationFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.util.List;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class EquipmentCheckingRegulationListUI
extends AbstractEquipmentCheckingRegulationListUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentCheckingRegulationListUI.class);

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuFile.remove((JMenuItem)this.menuItemImportData);
        this.menuFile.remove((JMenuItem)this.menuItemExportData);
        this.btnAudit.setVisible(false);
        this.btnUnAudit.setVisible(false);
        this.menuBar.remove((Component)this.menuBiz);
        this.menuItemEquipmentView.setEnabled(true);
        this.menuItemEquipmentView.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
        this.menuItemEquipmentView.setEnabled(true);
        this.menuItemEquipmentView.setVisible(true);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EquipmentCheckingRegulationFactory.getRemoteInstanceWithObjectContext(super.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        EquipmentCheckingRegulationInfo objectValue = new EquipmentCheckingRegulationInfo();
        return objectValue;
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int last = e.getLastRow();
        for (int i = from; i <= last; ++i) {
            IRow row = this.getMainTable().getRow(i);
            if (row == null) continue;
            this.processKDTableRow(row);
        }
        if (this.isAutoChangeTableColWidth()) {
            KDTableUtils.autoChangeTableColWidth((KDTable)this.tblMain, (List)this.getUnAutoChangeTableColNameList());
        }
    }

    public void processKDTableRow(IRow row) {
        ICell cptypeC = row.getCell("cptype");
        if (cptypeC != null) {
            BizEnumValueInfo v = (BizEnumValueInfo)cptypeC.getValue();
            if (v != null && v.getInt() == 10) {
                row.getCell("turns").setValue(null);
            }
            if (v != null && v.getInt() == 20) {
                row.getCell("pointPeriod").setValue(null);
            }
        }
    }

    protected GeneBillBaseFilterUI newInstanceFilterUI() throws Exception {
        EquipmentCheckingRegulationFilterUI ecgfUI = new EquipmentCheckingRegulationFilterUI();
        return ecgfUI;
    }

    protected boolean isIgnoreOrgFilter() {
        return false;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected String getEquipmentIDForView() {
        KDTable mainTable = this.tblMain;
        if (mainTable.getSelectManager().get(0) == null) {
            return null;
        }
        int rowIndex = mainTable.getSelectManager().get(0).getBeginRow();
        if (rowIndex <= -1) {
            return null;
        }
        IRow row = mainTable.getRow(rowIndex);
        if (row.getCell("equipment.number").getValue() == null || row.getCell("equipment.number").getValue().toString().equals("")) {
            return null;
        }
        String number = row.getCell("equipment.number").getValue().toString();
        return this.getEquipmentIdFromNumber(number);
    }

    private String getEquipmentIdFromNumber(String number) {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            evi.setFilter(fi);
            EquipmentArchivesInfo info = EquipmentArchivesFactory.getRemoteInstance().getEquipmentArchivesCollection(evi).get(0);
            if (info == null) {
                return null;
            }
            return info.getId().toString();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
            return null;
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("lastPlanningTime").setRenderer((IBasicRender)EQMPromptDialogFactory.dateRenderer);
    }
}

