/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.client;

import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.common.core.client.action.LongTimeAction;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.planning.EquipmentMaintainSchemaFactory;
import com.kingdee.eas.eqm.planning.EquipmentMaintainSchemaInfo;
import com.kingdee.eas.eqm.planning.IEquipmentMaintainSchema;
import com.kingdee.eas.eqm.planning.PreMaintainOperationLogCollection;
import com.kingdee.eas.eqm.planning.PreMaintainOperationLogFactory;
import com.kingdee.eas.eqm.planning.PreMaintainOperationLogInfo;
import com.kingdee.eas.eqm.planning.RunningModeEnum;
import com.kingdee.eas.eqm.planning.client.AbstractEquipmentMaintainSchemaRunUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.text.Format;
import java.util.Date;
import java.util.GregorianCalendar;

public class EquipmentMaintainSchemaRunUI
extends AbstractEquipmentMaintainSchemaRunUI {
    private static final long serialVersionUID = 1L;
    private static final Format dateFormat = CtrlFormatUtilities.getDateTimeFormat();
    private static final String PROP_FILE = "com.kingdee.eas.eqm.planning.GenerateWorkOrderResource";
    private static int TOP_COUNT = 10000;

    protected IObjectValue createNewData() {
        return new EquipmentMaintainSchemaInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EquipmentMaintainSchemaFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.toolBar.setVisible(false);
        this.kDContainer1.setTitleStyle(2);
    }

    protected void initContextOrg() {
        super.initContextOrg();
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.getUIContext().get("PLANORGUNIT");
        if (orgUnitInfo != null && orgUnitInfo instanceof OrgUnitInfo) {
            this.initUIMainOrgContext(orgUnitInfo.getId().toString());
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.datePlanStart.setValue((Object)DateTimeUtils.addDay((Date)new Date(), (long)1L));
        if (this.editData.getDays() > 0) {
            this.datePlanEnd.setValue((Object)DateTimeUtils.addDay((Date)new Date(), (long)(1L + (long)this.editData.getDays())));
        } else {
            this.datePlanEnd.setValue((Object)DateTimeUtils.addDay((Date)new Date(), (long)2L));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        RunningModeEnum runningMode = this.editData.getRunningMode();
        if (runningMode == RunningModeEnum.FOREGROUND) {
            this.rdbBackground.setSelected(false);
            this.rdbForeground.setSelected(true);
        }
    }

    public void setGeneWOState(boolean enable) {
        this.datePlanEnd.setEnabled(enable);
        this.datePlanStart.setEnabled(enable);
        this.btnGenerateWorkOrder.setEnabled(enable);
        this.rdbBackground.setEnabled(enable);
        this.rdbForeground.setEnabled(enable);
        this.btnExit.setEnabled(enable);
    }

    public void validateInput() {
        if (this.datePlanStart.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.planStartSateNotEmpty"));
            SysUtil.abort();
        }
        if (this.datePlanEnd.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.planEndDateNotEmpty"));
            SysUtil.abort();
        }
        Date now = new Date();
        Date startDate = (Date)this.datePlanStart.getValue();
        Date endDate = (Date)this.datePlanEnd.getValue();
        if (startDate.compareTo(now) < 1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.planStartDateGreaterThanNow"));
            SysUtil.abort();
        }
        if (this.isNotGreator(endDate, startDate)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.planEndDateGreaterStart"));
            SysUtil.abort();
        }
    }

    private boolean isNotGreator(Date date1, Date date2) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date d1 = c.getTime();
        c.setTime(date2);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date d2 = c.getTime();
        return d1.compareTo(d2) < 1;
    }

    @Override
    public void actionGenerateWO_actionPerformed(ActionEvent e) throws Exception {
        this.validateInput();
        final Date startDate = (Date)this.datePlanStart.getValue();
        final Date endDate = (Date)this.datePlanEnd.getValue();
        final RunningModeEnum runningModeEnum = this.rdbForeground.isSelected() ? RunningModeEnum.FOREGROUND : RunningModeEnum.BACKGROUND;
        LongTimeAction ltAction = new LongTimeAction(){
            private String processNumber = "";

            protected Object actionDoIt(CoreUI ui, ItemAction e) throws Exception {
                this.processNumber = ((IEquipmentMaintainSchema)EquipmentMaintainSchemaRunUI.this.getBizInterface()).generateWorkOrder(EquipmentMaintainSchemaRunUI.this.editData, startDate, endDate, runningModeEnum);
                return null;
            }

            protected void afterDoIt(CoreUI ui, ItemAction e, Object value) throws Exception {
                EquipmentMaintainSchemaRunUI.this.loadData();
                EquipmentMaintainSchemaRunUI.this.loadFields();
                EquipmentMaintainSchemaRunUI.this.txtProcessNumber.setText(this.processNumber);
                EntityViewInfo view = new EntityViewInfo();
                view.setTopCount(TOP_COUNT);
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemInfo item = new FilterItemInfo("processSequence", (Object)this.processNumber);
                filter.getFilterItems().add(item);
                SelectorItemCollection selectors = new SelectorItemCollection();
                view.setSelector(selectors);
                selectors.add(new SelectorItemInfo("equipment.name"));
                selectors.add(new SelectorItemInfo("eqmLocation.name"));
                selectors.add(new SelectorItemInfo("mainStandardOperation.name"));
                selectors.add(new SelectorItemInfo("workOrder.number"));
                selectors.add(new SelectorItemInfo("maintainRoute.name"));
                selectors.add(new SelectorItemInfo("preMaintainStrategy.name"));
                PreMaintainOperationLogCollection logs = PreMaintainOperationLogFactory.getRemoteInstance().getPreMaintainOperationLogCollection(view);
                StringBuffer sbLogs = new StringBuffer();
                sbLogs.append(EquipmentMaintainSchemaRunUI.this.kDTextArea1.getText());
                for (int i = 0; i < logs.size(); ++i) {
                    PreMaintainOperationLogInfo log = logs.get(i);
                    if (log.getWorkOrder().getNumber() == null) continue;
                    sbLogs.append("\n").append(this.processNumber);
                    if (log.getEqmSeqOfSchema() != null) {
                        if (sbLogs.length() > 0 && !sbLogs.substring(sbLogs.length() - 1).equals("\n")) {
                            sbLogs.append("\uff0c");
                        }
                        sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.seqNumber") + "[").append(log.getEqmSeqOfSchema()).append("]");
                    }
                    if (log.getPreMaintainStrategy() != null) {
                        if (sbLogs.length() > 0 && !sbLogs.substring(sbLogs.length() - 1).equals("\n")) {
                            sbLogs.append("\uff0c");
                        }
                        sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.strategy") + "[").append(log.getPreMaintainStrategy().getName()).append("]");
                    }
                    if (log.getEquipment() != null) {
                        if (sbLogs.length() > 0 && !sbLogs.substring(sbLogs.length() - 1).equals("\n")) {
                            sbLogs.append("\uff0c");
                        }
                        sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.equipment") + "[").append(log.getEquipment().getName()).append("]");
                    } else {
                        if (sbLogs.length() > 0 && !sbLogs.substring(sbLogs.length() - 1).equals("\n")) {
                            sbLogs.append("\uff0c");
                        }
                        sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.location") + "[").append(log.getEqmLocation().getName()).append("]");
                    }
                    if (log.getMaintainRoute() != null && log.getMaintainRoute().getName() != null) {
                        if (sbLogs.length() > 0 && !sbLogs.substring(sbLogs.length() - 1).equals("\n")) {
                            sbLogs.append("\uff0c");
                        }
                        sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.maintainroute") + "[").append(log.getMaintainRoute().getName()).append("]");
                    }
                    if (log.getMainStandardOperation() != null) {
                        if (sbLogs.length() > 0 && !sbLogs.substring(sbLogs.length() - 1).equals("\n")) {
                            sbLogs.append("\uff0c");
                        }
                        sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.mainSO") + "[").append(log.getMainStandardOperation().getName()).append("]");
                    }
                    if (log.getWorkOrder() != null) {
                        if (sbLogs.length() > 0 && !sbLogs.substring(sbLogs.length() - 1).equals("\n")) {
                            sbLogs.append("\uff0c");
                        }
                        sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.genWO") + "[").append(log.getWorkOrder().getNumber()).append("]");
                    }
                    sbLogs.append("\n");
                }
                sbLogs.append(dateFormat.format(new Date())).append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.complete") + "[").append(this.processNumber).append("]\u3002");
                EquipmentMaintainSchemaRunUI.this.kDTextArea1.setText(sbLogs.toString());
                EquipmentMaintainSchemaRunUI.this.setGeneWOState(true);
            }

            protected void beforeDoIt(CoreUI ui, ItemAction e) throws Exception {
                EquipmentMaintainSchemaRunUI.this.setGeneWOState(false);
                UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                StringBuffer sbLogs = new StringBuffer();
                sbLogs.append(dateFormat.format(new Date()));
                sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.beginGenWO")).append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.executor")).append("[").append(userInfo.getName()).append("]");
                sbLogs.append("\n");
                EquipmentMaintainSchemaRunUI.this.kDTextArea1.setText(sbLogs.toString());
            }
        };
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.genWOConfirm")) == 2) {
            return;
        }
        if (RunningModeEnum.FOREGROUND.equals((Object)runningModeEnum)) {
            ltAction.doIt((CoreUI)this, (ItemAction)this.actionGenerateWO);
        } else {
            ((IEquipmentMaintainSchema)this.getBizInterface()).generateWorkOrder(this.editData, startDate, endDate, runningModeEnum);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.genWOStarted"));
            this.getUIWindow().close();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = this.getInnerSelectors();
        return sic;
    }

    protected SelectorItemCollection getInnerSelectors() {
        try {
            return GeneSelectorUtils.getSelector((BOSObjectType)this.getBizType(), (String)"", (boolean)true, (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            this.handleException(e);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            return sic;
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }
}

