/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.client.IF7InnerUI;
import com.kingdee.eas.eqm.planning.client.AbstractF7BaseUI;
import com.kingdee.eas.framework.client.CoreUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class F7BaseUI
extends AbstractF7BaseUI {
    private static final Logger logger = CoreUIObject.getLogger(F7BaseUI.class);
    public static final String CTX_INNER_UI = "innerUI";
    public static final String CTX_IS_HIDE_DISPLAY = "isHideDisplay";
    public static final String CTX_IS_ADD_FILTER = "isAddFilterDisplayName";
    public static final String CTX_FILTER_DISPLAY_NAME = "filterDisplayName";
    public static final String CTX_FILTER_NAME = "filterName";
    public static final String CTX_FILTER_INDEX = "filterIndex";
    private String[] filterDisplayName;
    private String[] filterName = new String[]{"numberAndName", "number", "name"};
    private boolean isSupportQucikQuery = true;
    private boolean isUserDefinedFilter = false;
    private boolean isCanceled = true;
    private IF7InnerUI innerUI;
    public static final String CTX_F7_COMP = "f7comp";
    private KDBizPromptBox promptBox;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setEnabled(true);
        this.btnQuery.setVisible(true);
        this.btnQuery.setEnabled(true);
        this.btnMaintenance.setVisible(false);
        this.chkMHQurey.setEnabled(true);
        this.btnQuickQuery.setEnabled(true);
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContext();
        this.initInnerUI();
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtInput, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    F7BaseUI.this.actionQuickQuery_actionPerformed(null);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
        this.comboCondition.requestFocus();
    }

    private void initContext() {
        Boolean isHideDisplay;
        Integer index;
        this.filterDisplayName = (String[])this.getUIContext().get(CTX_FILTER_DISPLAY_NAME);
        String[] tempFilterName = (String[])this.getUIContext().get(CTX_FILTER_NAME);
        if (this.filterDisplayName != null && tempFilterName != null && this.filterDisplayName.length == tempFilterName.length) {
            Boolean isAddFilter = (Boolean)this.getUIContext().get(CTX_IS_ADD_FILTER);
            if (isAddFilter != null && isAddFilter.booleanValue()) {
                int i;
                this.comboCondition.addItems((Object[])this.filterDisplayName);
                String[] newFilterName = new String[this.filterName.length + tempFilterName.length];
                for (i = 0; i < this.filterName.length; ++i) {
                    newFilterName[i] = this.filterName[i];
                }
                for (i = 0; i < tempFilterName.length; ++i) {
                    newFilterName[this.filterName.length + i] = tempFilterName[i];
                }
                this.filterName = newFilterName;
            } else {
                this.isUserDefinedFilter = true;
                this.comboCondition.removeAllItems();
                this.comboCondition.addItems((Object[])this.filterDisplayName);
                this.filterName = tempFilterName;
            }
        }
        if ((index = (Integer)this.getUIContext().get(CTX_FILTER_INDEX)) != null && index >= 0 && index < this.comboCondition.getItemCount()) {
            this.comboCondition.setSelectedIndex(index.intValue());
        }
        if ((isHideDisplay = (Boolean)this.getUIContext().get(CTX_IS_HIDE_DISPLAY)) != null && isHideDisplay.booleanValue()) {
            this.isSupportQucikQuery = false;
            this.comboCondition.removeAllItems();
        }
    }

    public FilterInfo getQuickFilter() {
        String compareValue;
        CompareType compareType;
        FilterInfo quickFilterInfo = new FilterInfo();
        if (!this.isSupportQucikQuery || this.txtInput.getText().trim().equals("")) {
            return quickFilterInfo;
        }
        if (this.chkMHQurey.isSelected()) {
            compareType = CompareType.LIKE;
            compareValue = ParamHelper.getMatchString((String)this.txtInput.getText());
        } else {
            compareType = CompareType.EQUALS;
            compareValue = this.txtInput.getText();
        }
        if (this.comboCondition.getSelectedIndex() == 0 && !this.isUserDefinedFilter) {
            FilterItemInfo filterItemNumber = new FilterItemInfo(this.filterName[1], (Object)compareValue, compareType);
            FilterItemInfo filterItemName = new FilterItemInfo(this.filterName[2], (Object)compareValue, compareType);
            quickFilterInfo.getFilterItems().add(filterItemNumber);
            quickFilterInfo.getFilterItems().add(filterItemName);
            quickFilterInfo.setMaskString("#0 or #1");
        } else {
            FilterItemInfo filterItem = new FilterItemInfo(this.filterName[this.comboCondition.getSelectedIndex()], (Object)compareValue, compareType);
            quickFilterInfo.getFilterItems().add(filterItem);
        }
        return quickFilterInfo;
    }

    private void initInnerUI() throws Exception {
        this.promptBox = (KDBizPromptBox)this.getUIContext().get(CTX_F7_COMP);
        this.innerUI = (IF7InnerUI)this.getUIContext().get(CTX_INNER_UI);
        this.pnInnerUI.add((Component)this.innerUI, (Object)"Center");
        if (this.innerUI != null) {
            CoreUI ui = (CoreUI)this.innerUI;
            ui.initUIContentLayout();
            ui.onLoad();
            this.setUITitle(ui.getUITitle());
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.innerUI.refresh();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.innerUI.query();
    }

    @Override
    public void actionMaintenance_actionPerformed(ActionEvent e) throws Exception {
        this.innerUI.maintenance();
    }

    @Override
    public void actionQuickQuery_actionPerformed(ActionEvent e) throws Exception {
        this.innerUI.quickQuery();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.innerUI.confirmCheck()) {
            this.isCanceled = false;
            this.uiWindow.close();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.uiWindow.close();
    }

    public Object getData() {
        return this.innerUI.getData();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public KDBizPromptBox getPromptBox() {
        return this.promptBox;
    }

    public void setFocus() {
        this.txtInput.requestFocus();
    }
}

