/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneSysDefinedEnum;
import com.kingdee.eas.eqm.common.core.filter.CompositeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.DateCasterEnum;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.RangeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.SingleFilterElement;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.common.eqmcore.client.util.ControlledItems;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.WorkOrderTypeEnum;
import com.kingdee.eas.eqm.planning.PreMaintainStrategyInfo;
import com.kingdee.eas.eqm.planning.client.AbstractPMPlanFilterUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class PMPlanFilterUI
extends AbstractPMPlanFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PMPlanFilterUI.class);
    private static final String DATEPATTERN = CtrlFormatUtilities.getDateTimeFormatString();
    private static final String PMPLANRESOURCE_PATH = "com.kingdee.eas.eqm.planning.PMPlanResource";
    private static final String PERMISSION_VIEW = "eqm_maintain_workorderplan_01view";

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        rootElement.add((IFilterElement)new SingleFilterElement("planOrgunit.id", (Component)this.prmtplanOrgunit));
        rootElement.add((IFilterElement)new SingleFilterElement("maintainOrgUnit.id", (Component)this.prmtOrgUnit));
        rootElement.add((IFilterElement)new SingleFilterElement("pmstrategy.id", (Component)this.prmtPmstrategy));
        SingleFilterElement billStatusElement = new SingleFilterElement("billStatus", (Component)this.prmtBillStatus);
        billStatusElement.setBlankValue((Object)GeneSysDefinedEnum.SELECT_ALL);
        billStatusElement.setDefaultValue(String.valueOf(999));
        billStatusElement.setDataCaster(DateCasterEnum.IINTEGER_DC);
        rootElement.add((IFilterElement)billStatusElement);
        RangeFilterElement checkDateElement = new RangeFilterElement("createTime", (Component)this.pkStartCreateTime, (Component)this.pkEndCreateTime);
        rootElement.add((IFilterElement)checkDateElement);
        RangeFilterElement planDateElement = new RangeFilterElement("planStartTime", (Component)this.pkPlanStartDate, (Component)this.pkPlanEndDate);
        rootElement.add((IFilterElement)planDateElement);
        SingleFilterElement billStatus = new SingleFilterElement("parent.id", (Component)this.chkTipBill);
        billStatus.putUserInfo("falseEqualAll", "true");
        rootElement.add((IFilterElement)billStatus);
        SingleFilterElement taskType = new SingleFilterElement("taskType", (Component)this.prmtTaskType);
        taskType.setDefaultValue(String.valueOf(10));
        taskType.setDataCaster(DateCasterEnum.IINTEGER_DC);
        rootElement.add((IFilterElement)taskType);
    }

    public ControlledItems[] getNeedMainOrgControl() {
        ControlledItems archives = new ControlledItems(this.prmtEquipmentArchives, "StorageOrgUnit.id");
        ControlledItems location = new ControlledItems(this.prmtEqmLocation, "StorageOrgUnit.id");
        return new ControlledItems[]{archives, location};
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        this.pkPlanStartDate.setDatePattern(DATEPATTERN);
        this.pkPlanEndDate.setDatePattern(DATEPATTERN);
        this.prmtBillStatus.removeAllItems();
        this.prmtBillStatus.addItems(new Object[]{GeneSysDefinedEnum.SELECT_ALL, GeneBillBaseStatusEnum.SAVE, GeneBillBaseStatusEnum.Submit, GeneBillBaseStatusEnum.Audit, GeneBillBaseStatusEnum.Release, GeneBillBaseStatusEnum.StartWork, GeneBillBaseStatusEnum.Finish, GeneBillBaseStatusEnum.Check, GeneBillBaseStatusEnum.CLOSED, GeneBillBaseStatusEnum.ForceClosed});
        this.prmtTaskType.removeAllItems();
        this.prmtTaskType.addItem((Object)WorkOrderTypeEnum.WORKORDER);
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtOrgUnit, (String)this.getViewPermItemName(), (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
    }

    protected void setDefaultValue() {
        OrgUnitInfo org;
        super.setDefaultValue();
        this.pkStartCreateTime.setValue((Object)GeneDateUtils.getLastMonth());
        this.pkEndCreateTime.setValue((Object)new Date());
        this.chkTipBill.setSelected(true);
        PreMaintainStrategyInfo p = (PreMaintainStrategyInfo)this.getUIContext().get("strategy");
        if (p != null) {
            this.prmtPmstrategy.setValue((Object)p);
        }
        if ((org = (OrgUnitInfo)this.getUIContext().get("planOrg")) != null) {
            this.prmtplanOrgunit.setValue((Object)org);
        }
        EquipmentLocationInfo equipmentLocation = (EquipmentLocationInfo)this.getUIContext().get("equipmentLocation");
        this.prmtEqmLocation.setValue((Object)equipmentLocation);
        EquipmentArchivesInfo equipmentArchives = (EquipmentArchivesInfo)this.getUIContext().get("equipmentArchives");
        this.prmtEquipmentArchives.setValue((Object)equipmentArchives);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterItemInfo superParentFilterItem = new FilterItemInfo("parent.id", null);
        if (this.chkTipBill.isSelected()) {
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                FilterItemInfo filterItem = filterInfo.getFilterItems().get(i);
                if (!filterItem.getPropertyName().equals(superParentFilterItem.getPropertyName())) continue;
                filterInfo.getFilterItems().removeObject(i);
                filterInfo.getFilterItems().addObject(i, (IObjectValue)superParentFilterItem);
                break;
            }
        }
        return filterInfo;
    }

    public boolean verify() {
        boolean b = super.verify();
        if (!b) {
            return b;
        }
        Date startCreateDate = (Date)this.pkStartCreateTime.getValue();
        Date endCreateDate = (Date)this.pkEndCreateTime.getValue();
        if (startCreateDate != null && endCreateDate != null && startCreateDate.compareTo(endCreateDate) > 0) {
            MsgBox.showInfo((String)GeneResourceUtil.getMsg((String)PMPLANRESOURCE_PATH, (String)"CHECKCREATETIME", null));
            return false;
        }
        Date startPlanDate = (Date)this.pkPlanStartDate.getValue();
        Date endPlanDate = (Date)this.pkPlanEndDate.getValue();
        if (startPlanDate != null && endPlanDate != null && startPlanDate.compareTo(endPlanDate) > 0) {
            MsgBox.showInfo((String)GeneResourceUtil.getMsg((String)PMPLANRESOURCE_PATH, (String)"CHECKPLANTIME", null));
            return false;
        }
        return true;
    }

    public CustomerParams getCustomerParams2() {
        CustomerParams customerParams = super.getCustomerParams2();
        if (this.prmtEquipmentArchives.getValue() != null) {
            customerParams.addCustomerParam("equipmentArchives.id", ((EquipmentArchivesInfo)this.prmtEquipmentArchives.getValue()).getId().toString());
        }
        if (this.prmtEqmLocation.getValue() != null) {
            customerParams.addCustomerParam("eqmLocation.id", ((EquipmentLocationInfo)this.prmtEqmLocation.getValue()).getId().toString());
        }
        return customerParams;
    }

    public void setCustomerParams2(CustomerParams cp) {
        try {
            if (cp.getCustomerParam("equipmentArchives.id") != null) {
                this.prmtEquipmentArchives.setValue((Object)EquipmentArchivesFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getValue((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("equipmentArchives.id"))));
            }
            if (cp.getCustomerParam("eqmLocation.id") != null) {
                this.prmtEqmLocation.setValue((Object)EquipmentLocationFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getValue((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("eqmLocation.id"))));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        super.setCustomerParams2(cp);
    }

    public KDBizPromptBox getMainBizOrg() {
        return this.prmtplanOrgunit;
    }
}

