/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.client;

import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.common.core.client.action.LongTimeAction;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.planning.IPreMaintainStrategy;
import com.kingdee.eas.eqm.planning.PreMaintainOperationLogCollection;
import com.kingdee.eas.eqm.planning.PreMaintainOperationLogFactory;
import com.kingdee.eas.eqm.planning.PreMaintainOperationLogInfo;
import com.kingdee.eas.eqm.planning.PreMaintainStrategyFactory;
import com.kingdee.eas.eqm.planning.PreMaintainStrategyInfo;
import com.kingdee.eas.eqm.planning.RunningModeEnum;
import com.kingdee.eas.eqm.planning.client.AbstractPreMaintainStrategyRunUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.util.Date;
import java.util.GregorianCalendar;

public class PreMaintainStrategyRunUI
extends AbstractPreMaintainStrategyRunUI {
    private static final long serialVersionUID = 1L;
    private static final Format dateFormat = CtrlFormatUtilities.getDateTimeFormat();
    private static final int TOP_COUNT = 10000;
    private static final String PROP_FILE = "com.kingdee.eas.eqm.planning.GenerateWorkOrderResource";

    protected IObjectValue createNewData() {
        PreMaintainStrategyInfo info = new PreMaintainStrategyInfo();
        return info;
    }

    protected void initContextOrg() {
        super.initContextOrg();
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.getUIContext().get("PLANORGUNIT");
        if (orgUnitInfo != null && orgUnitInfo instanceof OrgUnitInfo) {
            this.initUIMainOrgContext(orgUnitInfo.getId().toString());
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PreMaintainStrategyFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void setGeneWOState(boolean enable) {
        if (enable) {
            if (this.rdbInvalid.isSelected()) {
                this.datePlanEnd.setEnabled(!enable);
                this.datePlanStart.setEnabled(!enable);
                this.dateSpecifyWorkOrderDate.setEnabled(enable);
            } else {
                this.dateSpecifyWorkOrderDate.setEnabled(!enable);
                this.datePlanEnd.setEnabled(enable);
                this.datePlanStart.setEnabled(enable);
            }
        } else {
            this.dateSpecifyWorkOrderDate.setEnabled(false);
            this.datePlanEnd.setEnabled(false);
            this.datePlanStart.setEnabled(false);
        }
        this.btnGenerate.setEnabled(enable);
        this.rdbBackground.setEnabled(enable);
        this.rdbForeground.setEnabled(enable);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.toolBar.setVisible(false);
        this.kDContainer1.setTitleStyle(2);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = this.getInnerSelectors();
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"parent");
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"mainStdOper", (String[])new String[]{"checkedStatus", "usableStatus", "duration"});
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"soSeqEntry.standardOperation", (String[])new String[]{"checkedStatus", "usableStatus", "duration"});
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"storageOrgUnit.CU", (String[])new String[]{"id"});
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"maintainRoute", (String[])new String[]{"usableStatus"});
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"maintainRoute.sites");
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"maintainRoute.sites", (String[])new String[]{"orderNumber"});
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"maintainRoute.sites.standardOperation");
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"maintainRoute.sites.standardOperation", (String[])new String[]{"usableStatus"});
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"maintainRoute.sites.equipmentArchives");
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"maintainRoute.sites.equipmentLocation");
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"meterSeqEntry.meter", (String[])new String[]{"countType"});
        return sic;
    }

    protected SelectorItemCollection getInnerSelectors() {
        try {
            return GeneSelectorUtils.getSelector((BOSObjectType)this.getBizType(), (String)"", (boolean)true, (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            this.handleException(e);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            return sic;
        }
    }

    protected void initListener() {
        super.initListener();
        this.rdbVlid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreMaintainStrategyRunUI.this.datePlanStart.setEnabled(true);
                PreMaintainStrategyRunUI.this.datePlanEnd.setEnabled(true);
                PreMaintainStrategyRunUI.this.dateSpecifyWorkOrderDate.setEnabled(false);
            }
        });
        this.rdbInvalid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreMaintainStrategyRunUI.this.datePlanStart.setEnabled(false);
                PreMaintainStrategyRunUI.this.datePlanEnd.setEnabled(false);
                PreMaintainStrategyRunUI.this.dateSpecifyWorkOrderDate.setEnabled(true);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.datePlanStart.setValue((Object)DateTimeUtils.addDay((Date)new Date(), (long)1L));
        this.datePlanEnd.setValue((Object)DateTimeUtils.addDay((Date)new Date(), (long)2L));
    }

    public void validateInput() {
        if (this.rdbVlid.isSelected()) {
            if (this.datePlanStart.getValue() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.planStartSateNotEmpty"));
                SysUtil.abort();
            }
            if (this.datePlanEnd.getValue() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.planEndDateNotEmpty"));
                SysUtil.abort();
            }
            Date now = new Date();
            Date startDate = (Date)this.datePlanStart.getValue();
            Date endDate = (Date)this.datePlanEnd.getValue();
            if (startDate.compareTo(now) < 1) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.planStartDateGreaterThanNow"));
                SysUtil.abort();
            }
            if (this.isNotGreator(endDate, startDate)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.planEndDateGreaterStart"));
                SysUtil.abort();
            }
        } else if (this.dateSpecifyWorkOrderDate.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.specDateNotEmpty"));
            SysUtil.abort();
        }
    }

    private boolean isNotGreator(Date date1, Date date2) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date d1 = c.getTime();
        c.setTime(date2);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date d2 = c.getTime();
        return d1.compareTo(d2) < 1;
    }

    @Override
    public void actionGenerateWO_actionPerformed(ActionEvent e) throws Exception {
        this.validateInput();
        final Date startDate = (Date)this.datePlanStart.getValue();
        final Date endDate = (Date)this.datePlanEnd.getValue();
        final Date planDate = (Date)this.dateSpecifyWorkOrderDate.getValue();
        final RunningModeEnum runningModeEnum = this.rdbForeground.isSelected() ? RunningModeEnum.FOREGROUND : RunningModeEnum.BACKGROUND;
        final boolean valid = this.rdbVlid.isSelected();
        LongTimeAction ltAction = new LongTimeAction(){
            String processNumber = "";

            protected Object actionDoIt(CoreUI ui, ItemAction e) throws Exception {
                this.processNumber = ((IPreMaintainStrategy)PreMaintainStrategyRunUI.this.getBizInterface()).generateWorkOrder(PreMaintainStrategyRunUI.this.editData, startDate, endDate, planDate, runningModeEnum, valid);
                return null;
            }

            protected void afterDoIt(CoreUI ui, ItemAction e, Object value) throws Exception {
                PreMaintainStrategyRunUI.this.loadData();
                PreMaintainStrategyRunUI.this.loadFields();
                PreMaintainStrategyRunUI.this.txtProcessNumber.setText(this.processNumber);
                EntityViewInfo view = new EntityViewInfo();
                view.setTopCount(10000);
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemInfo item = new FilterItemInfo("processSequence", (Object)this.processNumber);
                filter.getFilterItems().add(item);
                SelectorItemCollection selectors = new SelectorItemCollection();
                view.setSelector(selectors);
                selectors.add(new SelectorItemInfo("equipment.name"));
                selectors.add(new SelectorItemInfo("eqmLocation.name"));
                selectors.add(new SelectorItemInfo("mainStandardOperation.name"));
                selectors.add(new SelectorItemInfo("workOrder.number"));
                selectors.add(new SelectorItemInfo("maintainRoute.name"));
                selectors.add(new SelectorItemInfo("workOrder.planStartTime"));
                selectors.add(new SelectorItemInfo("workOrder.standardOp"));
                selectors.add(new SelectorItemInfo("workOrder.standardOp.name"));
                selectors.add(new SelectorItemInfo("workOrder.equipment"));
                selectors.add(new SelectorItemInfo("workOrder.standardOp.name"));
                PreMaintainOperationLogCollection logs = PreMaintainOperationLogFactory.getRemoteInstance().getPreMaintainOperationLogCollection(view);
                StringBuffer sbLogs = new StringBuffer();
                sbLogs.append(PreMaintainStrategyRunUI.this.txtLog.getText());
                for (int i = 0; i < logs.size(); ++i) {
                    PreMaintainOperationLogInfo log = logs.get(i);
                    if (log.getWorkOrder().getNumber() == null) continue;
                    if (log.getEquipment() != null) {
                        if (sbLogs.length() > 0 && !sbLogs.substring(sbLogs.length() - 1).equals("\n")) {
                            sbLogs.append("\uff0c");
                        }
                        sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.equipment")).append("[").append(log.getEquipment().getName()).append("]");
                    } else if (log.getEqmLocation() != null) {
                        if (sbLogs.length() > 0 && !sbLogs.substring(sbLogs.length() - 1).equals("\n")) {
                            sbLogs.append("\uff0c");
                        }
                        sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.location")).append("[").append(log.getEqmLocation().getName()).append("]");
                    }
                    if (log.getMaintainRoute() != null && log.getMaintainRoute().getName() != null) {
                        if (sbLogs.length() > 0 && !sbLogs.substring(sbLogs.length() - 1).equals("\n")) {
                            sbLogs.append("\uff0c");
                        }
                        sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.maintainroute")).append("[").append(log.getMaintainRoute().getName()).append("]");
                    }
                    if (log.getMainStandardOperation() != null) {
                        if (sbLogs.length() > 0 && !sbLogs.substring(sbLogs.length() - 1).equals("\n")) {
                            sbLogs.append("\uff0c");
                        }
                        sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.mainSO")).append("[").append(log.getMainStandardOperation().getName()).append("]");
                    }
                    if (log.getWorkOrder() != null) {
                        if (sbLogs.length() > 0 && !sbLogs.substring(sbLogs.length() - 1).equals("\n")) {
                            sbLogs.append("\uff0c");
                        }
                        sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.genWO")).append("[").append(log.getWorkOrder().getNumber()).append("]");
                    }
                    sbLogs.append("\n");
                }
                sbLogs.append(dateFormat.format(new Date())).append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.complete")).append(" [").append(this.processNumber).append("]\u3002");
                PreMaintainStrategyRunUI.this.txtLog.setText(sbLogs.toString());
                PreMaintainStrategyRunUI.this.setGeneWOState(true);
            }

            protected void beforeDoIt(CoreUI ui, ItemAction e) throws Exception {
                PreMaintainStrategyRunUI.this.setGeneWOState(false);
                UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                StringBuffer sbLogs = new StringBuffer();
                sbLogs.append(dateFormat.format(new Date()));
                sbLogs.append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.beginGenWO")).append(EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.executor")).append("[").append(userInfo.getName()).append("]");
                sbLogs.append("\n");
                PreMaintainStrategyRunUI.this.txtLog.setText(sbLogs.toString());
            }
        };
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.genWOConfirm")) == 2) {
            return;
        }
        if (RunningModeEnum.FOREGROUND.equals((Object)runningModeEnum)) {
            ltAction.doIt((CoreUI)this, (ItemAction)this.actionGenerateWO);
        } else {
            ((IPreMaintainStrategy)this.getBizInterface()).generateWorkOrder(this.editData, startDate, endDate, planDate, runningModeEnum, valid);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.GenerateWorkOrderResource.genWOStarted"));
            this.getUIWindow().close();
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }
}

