/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.common.core.GeneCommonFacadeFactory;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.SortUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class SparePartsPlanConst {
    private static final Logger logger = CoreUIObject.getLogger(SparePartsPlanConst.class);
    public static final int SHOW_EXCEP = 1;
    public static final int SHOW_STORAGE = 2;
    public static final int SHOW_ORDER = 3;

    public static String getBizNumber(IObjectValue bizObject, String orgID) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus(bizObject, orgID);
        String number = null;
        if (ruleStatus.isExist()) {
            number = codingRuleManager.getNumber(bizObject, orgID);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssss");
            number = "splog-" + sdf.format(new Date(System.currentTimeMillis()));
        }
        return number;
    }

    public static String formatNumericTypeData(int nPrecision, BigDecimal bdValue) throws Exception {
        DecimalFormat format = new DecimalFormat(PrecisionUtil.getFormatString((int)nPrecision));
        return format.format(bdValue).toString();
    }

    public static OrgUnitInfo getDefaultMainBizOrg(Context ctx, OrgType orgType, String strStatus) {
        OrgUnitInfo[] mainOrgs = null;
        int idxDefaultMainOrg = -1;
        try {
            mainOrgs = GeneCommonFacadeFactory.getRemoteInstanceWithObjectContext((Context)ctx).getAuthorizedBizOrgUnits(OrgType.Storage, strStatus);
            if (mainOrgs == null || mainOrgs.length == 0) {
                return null;
            }
            if (mainOrgs.length > 0) {
                mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(orgType);
        if (mainOrgs == null) {
            return currentMainOrg;
        }
        if (currentMainOrg != null && mainOrgs.length > 0) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(mainOrgs[i].getId().toString())) continue;
                idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (mainOrgs.length > 0) {
            idxDefaultMainOrg = 0;
            return mainOrgs[0];
        }
        return null;
    }
}

