/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.myeas.ToolBarStyleEnum;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanRunLogFactory;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanRunLogInfo;
import com.kingdee.eas.eqm.planning.spareparts.client.AbstractSparePartsPlanRunLogDetailUI;
import com.kingdee.eas.eqm.planning.spareparts.client.SparepartPlanOrderEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class SparePartsPlanRunLogDetailUI
extends AbstractSparePartsPlanRunLogDetailUI {
    public static final String RESOURCE_PATH = "com.kingdee.eas.eqm.planning.spareparts.SparepartsPlanRunLogResource";
    private String DATA_PATTERN = CtrlFormatUtilities.getDateTimeFormatString();
    private static String COLUMN_MATERIALID = "MaterialNumber.id";
    private static String COLUMN_MEASUREUNITID = "MeasureUnit.id";
    private static String COLUMN_PLANCOUNT = "PlanCount";
    private static String COLUMN_LAUNCHCOUNT = "LaunchCount";
    private static final Logger logger = CoreUIObject.getLogger(SparePartsPlanRunLogDetailUI.class);
    private Map mutiMeasureUnitCache = new Hashtable();

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnCopyLine.setVisible(false);
        this.btnRemoveLine.setVisible(false);
        this.btnPrint.setEnabled(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setEnabled(false);
        this.btnPrintPreview.setVisible(false);
        this.menuItemPrint.setEnabled(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.menuItemPrintPreview.setEnabled(false);
        this.btnViewLine.setEnabled(true);
        this.btnViewLine.setVisible(true);
        ToolBarStyleEnum toolStyle = null;
        toolStyle = (ToolBarStyleEnum)UIFrameContext.getInstance().getProperty((Object)"ToolbarStyle");
        if (toolStyle == null) {
            toolStyle = ToolBarStyleEnum.IconText;
        }
        if (ToolBarStyleEnum.OnlyIcon != toolStyle) {
            this.btnViewLine.setText(EASResource.getString((String)RESOURCE_PATH, (String)"TEXT_btnViewLine"));
            this.btnViewLine.setToolTipText(EASResource.getString((String)RESOURCE_PATH, (String)"TEXT_btnViewLine"));
        }
        this.menuItemViewLine.setEnabled(true);
        this.menuItemViewLine.setVisible(true);
        this.menuItemViewLine.setText(EASResource.getString((String)RESOURCE_PATH, (String)"TEXT_menuItemViewLine"));
        this.pkStartTime.setDatePattern(this.DATA_PATTERN);
        this.pkEndTime.setDatePattern(this.DATA_PATTERN);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.kdtEntries.getColumn("bizDate").setRenderer((IBasicRender)EQMPromptDialogFactory.dateRenderer);
        this.kdtEntries.getColumn("RequestDate").setRenderer((IBasicRender)EQMPromptDialogFactory.dateRenderer);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData != null && this.editData.getId() != null) {
            this.querySparepartPlanOrderQuery = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("SppPlanLog.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
            this.querySparepartPlanOrderQuery.setFilter(filterInfo);
            this.kdtEntries.refresh();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionViewLine_actionPerformed(ActionEvent e) throws Exception {
        this.showEditUI(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.kdtEntries.refresh();
        this.setOprtState(OprtState.VIEW);
        this.prmtStorageOrgUnit.setEnabled(false);
        this.txtNumber.setEnabled(false);
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected void setTitle() {
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SparePartsPlanRunLogFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected IObjectValue createNewData() {
        SparePartsPlanRunLogInfo objectValue = new SparePartsPlanRunLogInfo();
        return objectValue;
    }

    protected IObjectValue newInstanceData() {
        SparePartsPlanRunLogInfo objectValue = new SparePartsPlanRunLogInfo();
        return objectValue;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected void showEditUI(ActionEvent e) throws Exception {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntries);
        if (selectedRows == null || selectedRows.length < 1) {
            return;
        }
        String Id = ListUiHelper.getSelectedKeyValue((int[])selectedRows, (KDTable)this.kdtEntries, (String)"id");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)Id);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SparepartPlanOrderEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void setPrecisionByMaterial() {
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            String materialID = (String)this.kdtEntries.getCell(i, COLUMN_MATERIALID).getValue();
            String measureUnitID = (String)this.kdtEntries.getCell(i, COLUMN_MEASUREUNITID).getValue();
            if (materialID != null && measureUnitID != null) {
                MultiMeasureUnitInfo multiUnitInfo = this.getMutiMeasureUnitInfo(materialID, measureUnitID);
                if (multiUnitInfo == null) continue;
                EQMPromptDialogFactory.createNumberic((KDTable)this.kdtEntries, (int)this.kdtEntries.getColumnIndex(COLUMN_PLANCOUNT), (int)i, (int)multiUnitInfo.getQtyPrecision());
                EQMPromptDialogFactory.createNumberic((KDTable)this.kdtEntries, (int)this.kdtEntries.getColumnIndex(COLUMN_LAUNCHCOUNT), (int)i, (int)multiUnitInfo.getQtyPrecision());
                continue;
            }
            EQMPromptDialogFactory.createNumberic((KDTable)this.kdtEntries, (int)this.kdtEntries.getColumnIndex(COLUMN_PLANCOUNT), (int)i, (int)4);
            EQMPromptDialogFactory.createNumberic((KDTable)this.kdtEntries, (int)this.kdtEntries.getColumnIndex(COLUMN_LAUNCHCOUNT), (int)i, (int)4);
        }
    }

    private MultiMeasureUnitInfo getMutiMeasureUnitInfo(String materialID, String measureUnitID) {
        String key = materialID + "_" + measureUnitID;
        MultiMeasureUnitInfo mutiMeasureUnitInfo = (MultiMeasureUnitInfo)this.mutiMeasureUnitCache.get(key);
        if (null == mutiMeasureUnitInfo) {
            mutiMeasureUnitInfo = this.createMultiMeasureUnitInfo(key, materialID);
        }
        return mutiMeasureUnitInfo;
    }

    private MultiMeasureUnitInfo createMultiMeasureUnitInfo(String key, String materialID) {
        MultiMeasureUnitInfo mutiMeasureUnitInfo = null;
        MultiMeasureUnitCollection rs = null;
        try {
            rs = MultiMeasureUnitFactory.getRemoteInstance().getDataByMaterial(materialID);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (null != rs && rs.size() > 0) {
            String newKey = null;
            for (MultiMeasureUnitInfo element : rs) {
                if (null == element || null == element.getMaterial() || null == element.getMeasureUnit()) continue;
                newKey = element.getMaterial().getId().toString() + "_" + element.getMeasureUnit().getId().toString();
                if (newKey.equals(key)) {
                    mutiMeasureUnitInfo = element;
                }
                this.mutiMeasureUnitCache.put(newKey, element);
            }
        }
        return mutiMeasureUnitInfo;
    }
}

