/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.filter.CompositeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.RangeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.SingleFilterElement;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.planning.spareparts.client.AbstractSparePartsPlanRunLogListFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import org.apache.log4j.Logger;

public class SparePartsPlanRunLogListFilterUI
extends AbstractSparePartsPlanRunLogListFilterUI {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.planning.spareparts.SparepartsPlanRunLogResource";
    private static final Logger logger = CoreUIObject.getLogger(SparePartsPlanRunLogListFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrg() {
        return this.prmtOrgUnit;
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        SingleFilterElement planSchemaElement = new SingleFilterElement("planSchema.id", (Component)this.prmtPlanSchema);
        rootElement.add((IFilterElement)planSchemaElement);
        RangeFilterElement planDateElement = new RangeFilterElement("planDate", (Component)this.dpStartDate, (Component)this.dpEndDate);
        rootElement.add((IFilterElement)planDateElement);
        planDateElement.setDefaultValue((Object)new String[]{GeneDateUtils.getLastMonthString(), GeneDateUtils.getDayBeginString()});
        SingleFilterElement creatorElement = new SingleFilterElement("creator.name", (Component)this.txtCreator);
        creatorElement.setCompareType(CompareType.LIKE);
        rootElement.add((IFilterElement)creatorElement);
        rootElement.getVerifyManager().addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                if (SparePartsPlanRunLogListFilterUI.this.dpStartDate.getValue() != null && SparePartsPlanRunLogListFilterUI.this.dpEndDate.getValue() != null && SparePartsPlanRunLogListFilterUI.this.dpStartDate.getTimestamp().after(SparePartsPlanRunLogListFilterUI.this.dpEndDate.getTimestamp())) {
                    MsgBox.showWarning((String)EASResource.getString((String)SparePartsPlanRunLogListFilterUI.RESOURCE_PATH, (String)"CANNOT_StartAfterEnd"));
                    SysUtil.abort();
                }
                return true;
            }
        });
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo[] orgs) {
        super.afterMainOrgChanged(oldOrg, orgs);
        this.initPlanSchemaF7((IObjectValue[])orgs);
    }

    private void initPlanSchemaF7(IObjectValue[] infos) {
        if (null == infos || infos.length < 1) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer orgIds = new StringBuffer();
        for (int i = 0; i < infos.length; ++i) {
            orgIds.append(((OrgUnitInfo)infos[i]).getId());
            if (i == infos.length - 1) continue;
            orgIds.append(",");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgIds.toString(), CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)String.valueOf(2), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtPlanSchema.setEntityViewInfo(viewInfo);
    }
}

