/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.basedata.SparepartPlanSchemaInfo;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.planning.spareparts.ISparePartsPlanCalcFacade;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanCalcFacadeFactory;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanException;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanRunLogInfo;
import com.kingdee.eas.eqm.planning.spareparts.SparepartPlanOrderInfo;
import com.kingdee.eas.eqm.planning.spareparts.client.AbstractSparePartsPlanRunUI;
import com.kingdee.eas.eqm.planning.spareparts.client.ProgressDialog;
import com.kingdee.eas.eqm.planning.spareparts.client.SparePartsPlanConst;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SparePartsPlanRunUI
extends AbstractSparePartsPlanRunUI {
    private static final Logger logger = CoreUIObject.getLogger(SparePartsPlanRunUI.class);
    public boolean finished = false;
    protected String strPermissionItem = "eqm_SparePartsPlanCalc_01run";
    protected String strViewLogPermissionItem = "eqm_SparePartsPlanRunLog_01view";
    public static final String strResource = "com.kingdee.eas.eqm.planning.spareparts.SparepartsResource.";

    protected void setF7PlanVersion(String storageId) {
        this.setF7PlanVersion(this.prmtPlanVersion, storageId);
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    public void setF7PlanVersion(KDBizPromptBox bizBox, String storageUnitId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        bizBox.setEntityViewInfo(viewInfo);
        OrgUnitInfo mainOrg = (OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType());
        bizBox.setCurrentMainBizOrgUnit(mainOrg, this.getMainBizOrgType());
    }

    protected void setSPPLogNumber(SparePartsPlanRunLogInfo objRunLog) throws Exception {
        String strNumber = SparePartsPlanConst.getBizNumber((IObjectValue)objRunLog, objRunLog.getStorageOrgUnit().getId().toString());
        if (strNumber == null) {
            throw new SparePartsPlanException(SparePartsPlanException.MRP_RUN_LOG_RULE_NOT_EXIST);
        }
        objRunLog.setNumber(strNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSPPCalculate_actionPerformed(ActionEvent e) throws Exception {
        this.storeToBoundObject();
        SparePartsPlanRunLogInfo objRunLog = (SparePartsPlanRunLogInfo)this.getDataObject();
        StringBuffer sb = new StringBuffer();
        StorageOrgUnitInfo org = objRunLog.getStorageOrgUnit();
        SparepartPlanSchemaInfo sps = (SparepartPlanSchemaInfo)this.prmtPlanVersion.getValue();
        if (null == org) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.eqm.planning.spareparts.SparepartsResource.SP_NOTNULL_STORAGE", (Locale)this.getLocale())).append("\n");
        }
        if (null == sps) {
            if (org != null) {
                sb.append(org.getName()).append(" ");
            }
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.eqm.planning.spareparts.SparepartsResource.SP_NOTNULL_PLANVERSION", (Locale)this.getLocale())).append("\n");
        }
        if (this.pkStartTime.getValue() == null) {
            if (org != null) {
                sb.append(org.getName()).append(" ");
            }
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.eqm.planning.spareparts.SparepartsResource.SP_NOTNULL_PLANDATE", (Locale)this.getLocale()));
        }
        if (sb.length() > 0) {
            MsgBox.showWarning((String)sb.toString());
            return;
        }
        objRunLog.setStartTime(Calendar.getInstance().getTime());
        final ProgressDialog dialog = ProgressDialog.getDialogInstance(null);
        try {
            this.setSPPLogNumber(objRunLog);
            ISparePartsPlanCalcFacade calcFacade = SparePartsPlanCalcFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            boolean bRun = true;
            if (bRun) {
                objRunLog.setId(BOSUuid.create((BOSObjectType)objRunLog.getBOSType()));
                final String str = objRunLog.getId().toString();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SparePartsPlanRunUI.this.showProgressDialog(str, dialog);
                    }
                });
                calcFacade.backRun(objRunLog);
            }
        }
        catch (Exception e1) {
            this.finished = true;
            dialog.setCanBeDisposed(true);
            this.handleException(e1);
        }
        finally {
            this.finished = true;
        }
    }

    protected void checkSparePartsOrderCodingRule(StorageOrgUnitInfo org) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)new SparepartPlanOrderInfo(), org.getId().toString());
        if (!ruleStatus.isExist()) {
            throw new SparePartsPlanException(SparePartsPlanException.PLANORDERNUMBER_ERROR);
        }
    }

    protected void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType) {
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)bizOrgUnitBox, (String)this.strPermissionItem, (boolean)false, (OrgType)OrgType.Storage, (boolean)true, (boolean)false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtPlanVersion.setEditable(true);
        SparePartsPlanRunLogInfo info = new SparePartsPlanRunLogInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setStartTime(Calendar.getInstance().getTime());
        info.setDesc(" ");
        this.setDataObject((IObjectValue)info);
        this.prmtStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                StorageOrgUnitInfo org = (StorageOrgUnitInfo)e.getNewValue();
                if (org == null) {
                    return;
                }
                SparePartsPlanRunUI.this.initUIMainOrgContext(org.getId().toString());
                String storageId = org.getId().toString();
                SparePartsPlanRunUI.this.prmtPlanVersion.setValue(null);
                SparePartsPlanRunUI.this.setF7PlanVersion(storageId);
                SparePartsPlanRunUI.this.pkStartTime.setValue(null);
                SparePartsPlanRunUI.this.pkStartTime.setValue((Object)SparePartsPlanRunUI.this.getNextWorkDay());
            }
        });
        OrgUnitInfo orgUnit = SparePartsPlanConst.getDefaultMainBizOrg(this.getMainOrgContext(), OrgType.Storage, this.strPermissionItem);
        if (orgUnit != null) {
            this.initUIMainOrgContext(orgUnit.getId().toString());
            this.prmtStorageOrgUnit.setValue((Object)orgUnit);
        }
        this.setMainBizOrgF7(this.prmtStorageOrgUnit, OrgType.Storage);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    protected Date getNextWorkDay() {
        return GeneDateUtils.now();
    }

    private void storeToBoundObject() {
        SparePartsPlanRunLogInfo objRunLog = (SparePartsPlanRunLogInfo)this.getDataObject();
        objRunLog.setStorageOrgUnit((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        objRunLog.setPlanDate((Date)this.pkStartTime.getValue());
        objRunLog.setPlanSchema((SparepartPlanSchemaInfo)this.prmtPlanVersion.getValue());
    }

    protected void showProgressDialog(String id, ProgressDialog dialog) {
        try {
            dialog.setId(id);
            dialog.show();
            if (!dialog.getCanBeDisposed()) {
                this.actionExitCurrent_actionPerformed(null);
            }
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    protected IObjectPK getOrgPK(SparePartsPlanRunLogInfo objLog) {
        ObjectUuidPK orgPK = null;
        if (objLog != null) {
            orgPK = new ObjectUuidPK(objLog.getStorageOrgUnit().getId().toString());
        }
        return orgPK;
    }
}

