/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.client.GeneBillBaseFilterUI;
import com.kingdee.eas.eqm.common.core.client.listener.KDTNewEditListener;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.client.MultiMeasureUnitUtil;
import com.kingdee.eas.eqm.planning.spareparts.ISparePartsPlanCalcFacade;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanCalcFacadeFactory;
import com.kingdee.eas.eqm.planning.spareparts.client.AbstractSparepartPlanOrderBatchEditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SparepartPlanOrderBatchEditUI
extends AbstractSparepartPlanOrderBatchEditUI {
    private static final long serialVersionUID = 1L;
    public static final String Col_PlanCount = "PlanCount";
    public static final String Col_MaterialId = "material.id";
    public static final String Col_MaterialNumber = "MaterialNumber.number";
    public static final String Col_MaterialName = "MaterialName";
    public static final String Col_UnitId = "unit.id";
    public static final String Col_BillStatus = "billStatus";
    public static final String Col_Number = "number";
    public static final String Col_ID = "id";
    private Map edittedValues = new HashMap();
    private MultiMeasureUnitUtil multiMeasureUnitUtil = new MultiMeasureUnitUtil();

    @Override
    public void onLoad() throws Exception {
        this.tblMain.checkParsed(true);
        EntityViewInfo view = (EntityViewInfo)((ListUI)this.getUIContext().get("Owner")).getMainQuery().clone();
        this.setDefaultEntityViewInfo(view);
        super.onLoad();
        this.tblMain.checkParsed(true);
        this.appendPermFilter(view);
        this.excuteQuery(view, true, null);
        this.afterOnLoad();
        this.tblMain.getColumn("RequestDate").setRenderer((IBasicRender)EQMPromptDialogFactory.dateRenderer);
        this.tblMain.getColumn("bizDate").setRenderer((IBasicRender)EQMPromptDialogFactory.dateRenderer);
        this.tblMain.getColumn("createTime").setRenderer((IBasicRender)EQMPromptDialogFactory.dateRenderer);
        this.tblMain.getColumn("lastUpdateTime").setRenderer((IBasicRender)EQMPromptDialogFactory.dateRenderer);
        this.tblMain.getColumn("AdviceReqDate").setRenderer((IBasicRender)EQMPromptDialogFactory.dateRenderer);
    }

    protected List getMainBizOrgs(QuerySolutionInfo solution) {
        return null;
    }

    protected void appendPermFilter(EntityViewInfo view) {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer buffer = new StringBuffer();
        buffer.append("select perm.forgid from T_PM_UserOrgPerm as perm \n");
        buffer.append("left outer join t_pm_user as u \n");
        buffer.append("on perm.fowner = u.fid \n");
        buffer.append("left outer join T_PM_PermItem as pi \n");
        buffer.append("on perm.FPermItemID = pi.fid \n");
        buffer.append("where u.fid = '").append(userId).append("' \n");
        buffer.append("and pi.fnumber like 'eqm_SparepartPlanOrder_04update' \n");
        StringBuffer bufferEx = new StringBuffer();
        bufferEx.append("select perm.forgid from T_PM_UserOrgPerm as perm \n");
        bufferEx.append("left outer join T_PM_PermItem as pi \n");
        bufferEx.append("on perm.FPermItemID = pi.fid \n");
        bufferEx.append("where perm.fowner = '").append(userId).append("' \n");
        bufferEx.append("and pi.fnumber like 'eqm_SparepartPlanOrder_04update' \n");
        bufferEx.append("and perm.fpermtype=20 \n");
        FilterInfo permFilter = new FilterInfo();
        permFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)buffer.toString(), CompareType.INNER));
        permFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)bufferEx.toString(), CompareType.NOTINNER));
        try {
            view.getFilter().mergeFilter(permFilter, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void afterOnLoad() {
        this.actionAttachment.setVisible(false);
        KDTableUtils.registerBigDecimalTextToColumn((KDTable)this.tblMain, (String)Col_PlanCount, (int)8);
        KDTNewEditListener editListener = new KDTNewEditListener(){

            public void editStopped(KDTEditEvent e) {
                SparepartPlanOrderBatchEditUI.this.afterTableEdit(e);
            }
        };
        this.tblMain.addKDTEditListener((KDTEditListener)editListener);
    }

    protected void setPlanCountPrecision(IRow row) {
        MultiMeasureUnitInfo mutiMeasureUnitInfo = this.getMultiMeasureUnitInfo(row);
        if (mutiMeasureUnitInfo != null) {
            KDTableUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_PlanCount), (int)mutiMeasureUnitInfo.getQtyPrecision());
        } else {
            KDTableUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_PlanCount), (int)4);
        }
        if (row.getCell(Col_PlanCount).getEditor().getComponent() instanceof KDFormattedTextField) {
            KDFormattedTextField colTxtField = (KDFormattedTextField)row.getCell(Col_PlanCount).getEditor().getComponent();
            colTxtField.setMinimumValue((Comparable)new BigDecimal("0.00000000"));
        }
        row.getCell(Col_PlanCount).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
    }

    protected MultiMeasureUnitInfo getMultiMeasureUnitInfo(IRow row) {
        Object materialId = row.getCell(Col_MaterialId).getValue();
        Object materialNumber = row.getCell(Col_MaterialNumber).getValue();
        Object materialName = row.getCell(Col_MaterialName).getValue();
        Object unitId = row.getCell(Col_UnitId).getValue();
        MultiMeasureUnitInfo mutiMeasureUnitInfo = null;
        if (materialId != null && unitId != null) {
            mutiMeasureUnitInfo = this.multiMeasureUnitUtil.getMutiMeasureUnitInfo(materialId.toString(), materialNumber == null ? "" : materialNumber.toString(), materialName == null ? "" : materialName.toString(), unitId.toString());
        }
        return mutiMeasureUnitInfo;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getRowIndex() >= 0 && e.getColIndex() == this.tblMain.getColumnIndex(Col_PlanCount)) {
            return;
        }
        super.tblMain_tableClicked(e);
    }

    protected void afterTableEdit(KDTEditEvent e) {
        if (e.getRowIndex() < 0 || this.tblMain.getColumnIndex(Col_PlanCount) != e.getColIndex() || this.tblMain.getRow(e.getRowIndex()).getCell(Col_ID).getValue() == null) {
            return;
        }
        BigDecimal newValue = (BigDecimal)e.getValue();
        if (GeneEqualsUtils.equals((Object)newValue, (Object)e.getOldValue())) {
            return;
        }
        IRow row = this.tblMain.getRow(e.getRowIndex());
        String id = row.getCell(Col_ID).getValue().toString();
        ArrayList<Object> values = new ArrayList<Object>(3);
        values.add(row.getCell(Col_Number).getValue().toString());
        values.add(newValue);
        values.add(this.getBaseQty(newValue, row));
        this.edittedValues.put(id, values);
    }

    private Object getBaseQty(BigDecimal qty, IRow row) {
        if (qty == null) {
            return null;
        }
        MultiMeasureUnitInfo multiMeasureUnitInfo = this.getMultiMeasureUnitInfo(row);
        if (multiMeasureUnitInfo == null) {
            return qty;
        }
        BigDecimal baseConvsRate = multiMeasureUnitInfo.getBaseConvsRate();
        if (baseConvsRate != null) {
            return baseConvsRate.multiply(qty).setScale(multiMeasureUnitInfo.getQtyPrecision(), 4);
        }
        return qty;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void processKDTableRow(IRow row) {
        super.processKDTableRow(row);
        if (this.canEditPlanCount(row)) {
            row.getCell(Col_PlanCount).getStyleAttributes().setLocked(false);
            row.getCell(Col_PlanCount).getStyleAttributes().setFontColor(Color.RED);
            this.setPlanCountPrecision(row);
        } else {
            row.getCell(Col_PlanCount).getStyleAttributes().setLocked(true);
        }
    }

    protected boolean canEditPlanCount(IRow row) {
        Object billStatus = row.getCell(Col_BillStatus).getValue();
        int status = 0;
        if (billStatus instanceof BizEnumValueDTO) {
            status = ((BizEnumValueDTO)billStatus).getInt();
        } else if (billStatus instanceof GeneBillBaseStatusEnum) {
            status = ((GeneBillBaseStatusEnum)billStatus).getValue();
        }
        return 30 != status && 49 != status && 65 != status;
    }

    @Override
    protected GeneBillBaseFilterUI newInstanceFilterUI() throws Exception {
        return null;
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.confirmBatchEdit()) {
            return;
        }
        this.verifyHasModified();
        this.verifyHasNotNullPlanCount();
        ISparePartsPlanCalcFacade iExec = SparePartsPlanCalcFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        int size = this.edittedValues.size();
        Map result = iExec.batchEdit(this.edittedValues);
        int updateSize = (Integer)result.get("BATCH_UPDATE_SIZE");
        if (updateSize != size) {
            MsgBox.showInfo((String)this.getMsg("Msg_BatchEditFailReason", new String[]{new Integer(updateSize).toString(), new Integer(size - updateSize).toString()}));
        }
        this.uiWindow.close();
    }

    protected void verifyHasModified() {
        if (this.edittedValues.size() == 0) {
            MsgBox.showInfo((String)this.getMsg("Verify_HasNotModified"));
            SysUtil.abort();
        }
    }

    protected void verifyHasNotNullPlanCount() {
        StringBuffer errorDetail = new StringBuffer();
        for (Object id : this.edittedValues.keySet()) {
            List value = (List)this.edittedValues.get(id);
            BigDecimal planCount = (BigDecimal)value.get(1);
            if (planCount != null && planCount.compareTo(new BigDecimal(0)) > 0) continue;
            errorDetail.append(this.getMsg("ErrorDetail_PlanCountIsNull", new String[]{value.get(0) == null ? "" : value.get(0).toString()})).append("\n");
        }
        if (errorDetail.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getMsg("Error_PlanCountIsNotZero"), (String)errorDetail.toString(), (int)0);
            SysUtil.abort();
        }
    }

    protected boolean confirmBatchEdit() {
        return 0 == MsgBox.showConfirm2((String)this.getMsg("Confirm_BatchEdit"));
    }

    public String getMsg(String msg) {
        return ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.planning.spareparts.SharepartPlanOrderResource", (String)msg);
    }

    public String getMsg(String msg, String[] paras) {
        return ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.planning.spareparts.SharepartPlanOrderResource", (String)msg, (String[])paras);
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[0];
    }
}

