/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.print.ITDPrintStrategy;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.common.eqmcore.client.util.ControlledItems;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.client.MultiMeasureUnitUtil;
import com.kingdee.eas.eqm.planning.spareparts.SparepartPlanOrderFactory;
import com.kingdee.eas.eqm.planning.spareparts.SparepartPlanOrderInfo;
import com.kingdee.eas.eqm.planning.spareparts.client.AbstractSparepartPlanOrderEditUI;
import com.kingdee.eas.eqm.planning.spareparts.client.SparepartPlanOrderListUI;
import com.kingdee.eas.eqm.planning.spareparts.client.SparepartPlanOrderTDPrintStrategy;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SparepartPlanOrderEditUI
extends AbstractSparepartPlanOrderEditUI {
    protected static final String VALID_MSG_PLANCOUNT_RANGE = ".PlanCountRange";
    protected static final String VALID_MSG_MEASUREUNIT_MATCH = ".MearsureUnit_Match";
    protected static final String VALID_MSG_MATERIAL = ".CheckValid";
    private static final Logger logger = CoreUIObject.getLogger(SparepartPlanOrderEditUI.class);
    private static final String PROP_FILE = "com.kingdee.eas.eqm.planning.spareparts.SharepartPlanOrderResource";
    private String DEFAULT_LAUNCHCOUNT = "0";
    public static final String SPPLANORDER_RESOURCE_PATH = "com.kingdee.eas.eqm.planning.spareparts.SharepartPlanOrderResource";
    private MultiMeasureUnitUtil multiMeasureUnitUtil;
    Map map = new HashMap();
    private Map toUnitMap = new HashMap();

    public SparepartPlanOrderEditUI() throws Exception {
        this.multiMeasureUnitUtil = new MultiMeasureUnitUtil();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SparepartPlanOrderFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        return this.doCreateNewData(null);
    }

    protected IObjectValue createNewDetailData(KDTable table, IRow srcrow) {
        return null;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtOrgUnit;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAuditResult.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.txtPlanCount.setRemoveingZeroInDispaly(false);
        this.txtLaunchCount.setRemoveingZeroInDispaly(false);
        this.txtAdvicePlanCount.setRemoveingZeroInDispaly(false);
        this.setButtonVisible();
        this.setPrecisionByMaterial();
        if (GeneBillBaseStatusEnum.Audit.equals((Object)this.editData.getBillStatus())) {
            this.btnCreateTo.setEnabled(true);
        } else {
            this.btnCreateTo.setEnabled(false);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnAuditResult.setVisible(false);
        this.btnTDPrint.setVisible(true);
        this.btnTDPrint.setEnabled(true);
        this.btnTDPrintPreview.setVisible(true);
        this.btnTDPrintPreview.setEnabled(true);
        this.menuItemTDPrint.setVisible(true);
        this.menuItemTDPrint.setEnabled(true);
        this.menuItemTDPrintPreview.setVisible(true);
        this.menuItemTDPrintPreview.setEnabled(true);
        this.btnForceComplete.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_forcecomplete", (Locale)SysContext.getSysContext().getLocale()));
        this.menuForceComplete.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_forcecomplete", (Locale)SysContext.getSysContext().getLocale()));
    }

    public ITDPrintStrategy getTDPrintStrategy() throws Exception {
        SparepartPlanOrderTDPrintStrategy spotdps = new SparepartPlanOrderTDPrintStrategy();
        return spotdps;
    }

    protected IObjectValue newInstanceData() throws EASBizException, BOSException {
        SparepartPlanOrderInfo objectValue = new SparepartPlanOrderInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        objectValue.setCreateTime(new Timestamp(new Date().getTime()));
        objectValue.setBizDate(new Date());
        objectValue.setRequestDate(new Date());
        objectValue.setLaunchCount(new BigDecimal(this.DEFAULT_LAUNCHCOUNT));
        return objectValue;
    }

    public void registerCustomerBindings() {
        super.registerCustomerBindings();
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtOrgUnit, (String)this.getAddNewPermItemName(), (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
        try {
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtMaterialNumber, (String)"com.kingdee.eas.eqm.archives.app.F7MaterialInventoryNoGroupQuery", (String[])new String[]{"status", "equipProperty"}, (Object[])new Object[]{new Integer(1), new Integer(2)}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.NOTEQUALS});
            if (this.prmtMaterialNumber.getValue() != null) {
                this.setPrmpMeasuteUnitDialog();
            }
            this.txtPlanCount.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    SparepartPlanOrderEditUI.this.txtPlanCount_dataChange(eventObj);
                }
            });
            this.prmtMaterialNumber.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    SparepartPlanOrderEditUI.this.prmtMaterialNumber_dataChange(eventObj);
                }
            });
            this.prmtMeasureUnit.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    SparepartPlanOrderEditUI.this.prmtMeasureUnit_dataChange(eventObj);
                }
            });
            this.btnAuditResult.setVisible(false);
            if (this.editData.getBillStatus() == GeneBillBaseStatusEnum.Audit) {
                this.btnForceComplete.setEnabled(true);
                this.menuForceComplete.setEnabled(true);
            } else {
                this.btnForceComplete.setEnabled(false);
                this.menuForceComplete.setEnabled(false);
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    protected ControlledItems[] getNeedMainOrgControl() {
        ControlledItems materialItem = new ControlledItems(this.prmtMaterialNumber, "StorageOrgUnit.id");
        return new ControlledItems[]{materialItem};
    }

    private void txtPlanCount_dataChange(DataChangeEvent eventObj) {
        if (this.txtPlanCount.getBigDecimalValue() != null) {
            String sPlanCount;
            if (this.txtPlanCount.getBigDecimalValue().compareTo(new BigDecimal(0)) <= 0) {
                this.txtPlanCount.setValue((Object)new BigDecimal(this.DEFAULT_LAUNCHCOUNT));
                SysUtil.abort();
            }
            if ((sPlanCount = this.txtPlanCount.getBigDecimalValue().toString()).indexOf(".") > 13) {
                String intPlanCount = sPlanCount.substring(0, 13);
                sPlanCount = sPlanCount.replaceAll(sPlanCount.substring(0, sPlanCount.indexOf(".")), intPlanCount);
                this.txtPlanCount.setValue((Object)new BigDecimal(sPlanCount));
            }
        }
    }

    private void prmtMaterialNumber_dataChange(DataChangeEvent eventObj) {
        this.setPrecisionByMaterial();
        this.calcCountByPrecision();
        try {
            if (this.prmtMaterialNumber.getValue() != null) {
                this.setBaseUnitFromMaterial();
                this.setPrmpMeasuteUnitDialog();
                this.txtMaterialName.setText(((MaterialInfo)this.prmtMaterialNumber.getValue()).getName());
                this.txtMaterialModel.setText(((MaterialInfo)this.prmtMaterialNumber.getValue()).getModel());
            } else {
                this.txtMaterialName.setText("");
                this.txtMaterialModel.setText("");
                this.prmtMeasureUnit.setValue(null);
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void prmtMeasureUnit_dataChange(DataChangeEvent eventObj) {
        this.setPrecisionByMaterial();
        this.calcCountByPrecision();
    }

    private void setBaseUnitFromMaterial() throws BOSException {
        String baseUnitId = ((MaterialInfo)this.prmtMaterialNumber.getValue()).getBaseUnit().getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)baseUnitId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        CoreBaseCollection c = MeasureUnitFactory.getRemoteInstance().getCollection(viewInfo);
        MeasureUnitInfo info = (MeasureUnitInfo)c.get(0);
        this.prmtBaseUnit.setValue((Object)info);
        this.prmtMeasureUnit.setValue((Object)info);
    }

    private void setPrmpMaterialPlan() throws BOSException {
        this.prmtMaterialPlan.setValue(null);
        String materialId = "";
        materialId = this.editData.getMaterialNumber() != null ? this.editData.getMaterialNumber().getId().toString() : ((MaterialInfo)this.prmtMaterialNumber.getValue()).getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        items.add(new FilterItemInfo("ORGUNIT.id", (Object)((StorageOrgUnitInfo)this.prmtOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        viewInfo.setFilter(filter);
        CoreBaseCollection c = MaterialPlanFactory.getRemoteInstance().getCollection(viewInfo);
        MaterialPlanInfo info = (MaterialPlanInfo)c.get(0);
        if (info != null) {
            this.prmtMaterialPlan.setValue((Object)info);
        }
    }

    private void setPrmpMeasuteUnitDialog() throws BOSException {
        String baseUnitId = "";
        try {
            if (this.prmtMaterialNumber.getValue() != null) {
                if (((MaterialInfo)this.prmtMaterialNumber.getValue()).getBaseUnit() != null) {
                    baseUnitId = ((MaterialInfo)this.prmtMaterialNumber.getValue()).getBaseUnit().getId().toString();
                }
            } else if (this.editData.getBaseUnit() != null) {
                baseUnitId = this.editData.getBaseUnit().getId().toString();
            }
            if (baseUnitId != null && baseUnitId.length() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)baseUnitId, CompareType.EQUALS));
                viewInfo.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new MeasureUnitInfo().getBOSType(), (String)"measureUnitGroup", (boolean)false));
                viewInfo.setSelector(sic);
                CoreBaseCollection c = MeasureUnitFactory.getRemoteInstance().getCollection(viewInfo);
                MaterialInfo materialInfo = (MaterialInfo)this.prmtMaterialNumber.getValue();
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtMeasureUnit, (String)"com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery", (String[])new String[]{"material.id"}, (Object[])new Object[]{materialInfo.getId().toString()}, (CompareType[])new CompareType[]{CompareType.EQUALS});
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private boolean setBaseCount() {
        boolean ret = false;
        try {
            if (this.txtPlanCount.getBigDecimalValue() == null) {
                this.txtPlanCount.setValue((Object)new BigDecimal(this.DEFAULT_LAUNCHCOUNT));
            }
            if (this.txtPlanCount.getBigDecimalValue().compareTo(new BigDecimal(0)) <= 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.spareparts.SharepartPlanOrderResource.PlanCountRange"));
                this.txtPlanCount.setValue((Object)new BigDecimal(this.DEFAULT_LAUNCHCOUNT));
                this.txtPlanCount.requestFocus();
                return ret;
            }
            MultiMeasureUnitInfo multiUnitInfo = new MultiMeasureUnitInfo();
            MeasureUnitInfo baseUnit = ((MaterialInfo)this.prmtMaterialNumber.getValue()).getBaseUnit();
            baseUnit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(baseUnit.getId().toString()));
            multiUnitInfo.setMaterial((MaterialInfo)this.prmtMaterialNumber.getValue());
            multiUnitInfo.setMeasureUnit(baseUnit);
            multiUnitInfo.setConvsUnit((MeasureUnitInfo)this.prmtMeasureUnit.getValue());
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)multiUnitInfo.getMaterial().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)multiUnitInfo.getConvsUnit().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            viewInfo.setFilter(filter);
            CoreBaseCollection c = MultiMeasureUnitFactory.getRemoteInstance().getCollection(viewInfo);
            if (c.size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.spareparts.SharepartPlanOrderResource.MearsureUnit_Match"));
                ret = false;
            }
            MultiMeasureUnitInfo info = (MultiMeasureUnitInfo)c.get(0);
            int precision = baseUnit.getQtyPrecision();
            BigDecimal rate = info.getBaseConvsRate();
            if (rate != null) {
                BigDecimal planCount = (BigDecimal)this.txtPlanCount.getValue();
                BigDecimal launchCount = (BigDecimal)this.txtLaunchCount.getValue();
                this.txtBasePlanCount.setValue((Object)rate.multiply(planCount).setScale(precision, 4));
                this.txtBaseLaunchCount.setValue((Object)rate.multiply(launchCount).setScale(precision, 4));
                ret = true;
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.spareparts.SharepartPlanOrderResource.MearsureUnit_Match"));
                ret = false;
            }
            return true;
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.doBeforeSave(e);
        if (this.setBaseCount()) {
            this.setPrmpMaterialPlan();
            super.actionSubmit_actionPerformed(e);
        }
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        this.btnForceComplete.setEnabled(true);
        this.menuForceComplete.setEnabled(true);
        this.btnCreateTo.setEnabled(true);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        this.btnForceComplete.setEnabled(false);
        this.menuForceComplete.setEnabled(false);
        this.btnCreateTo.setEnabled(false);
    }

    @Override
    public void actionForceComplete_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmForceComplete()) {
            SparepartPlanOrderListUI spolUI = new SparepartPlanOrderListUI();
            SparepartPlanOrderListUI.ForceCompleteAction action = new SparepartPlanOrderListUI.ForceCompleteAction(spolUI);
            ArrayList<BOSUuid> id = new ArrayList<BOSUuid>();
            id.add(this.editData.getId());
            action.setIDs(id);
            action.doIt((CoreUI)this, this.actionForceComplete);
            this.showSuccessMsg(this.getResourceMsg("ForceComplete_Success"));
            Thread.sleep(3000L);
            this.refreshCurPage();
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.dateBizDate.setValue((Object)new Date());
        this.cboBillStatus.setSelectedItem((Object)GeneBillBaseStatusEnum.AddNew);
        this.prmtSPPLog.setValue(null);
        this.txtLaunchCount.setValue((Object)new BigDecimal(0));
        this.txtBaseLaunchCount.setValue((Object)new BigDecimal(0));
        this.prmtCreator.setValue((Object)((UserInfo)SysContext.getSysContext().getCurrentUser()));
        this.dateCreateTime.setValue((Object)new Timestamp(new Date().getTime()));
        this.prmtLastUpdateUser.setValue(null);
        this.dateLastUpdateTime.setValue(null);
        this.prmtAuditor.setValue(null);
        this.dateAuditTime.setValue(null);
        this.pkRequestDate.setValue((Object)new Date());
        this.prmtSppPlanSchema.setValue(null);
        this.pkAdviceReqDate.setValue(null);
        this.txtPlanCount.setValue(null);
        this.txtAdvicePlanCount.setValue(null);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showWarning((String)SaleUtil.getUIResource((String)"ORDER_ADDNEWCANNOT_OPERATOR"));
            return;
        }
        if (this.editData.getBillStatus().equals((Object)GeneBillBaseStatusEnum.ForceComplete) || this.editData.getBillStatus().equals((Object)GeneBillBaseStatusEnum.CLOSED)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.spareparts.SharepartPlanOrderResource.Check_NotForceCompleted"));
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(msgResource);
        this.showMessage();
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.planning.spareparts.SharepartPlanOrderResource", (String)key);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = this.getInnerSelectors();
        sic.add("BaseUnit");
        sic.add("BaseUnit.id");
        sic.add("BaseUnit.numbe");
        sic.add("BaseUnit.name");
        sic.add("MaterialNumber.BaseUnit");
        sic.add("MaterialNumber.model");
        return sic;
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    private void setPrecisionByMaterial() {
        if (this.prmtMaterialNumber.getValue() != null && this.prmtMeasureUnit.getValue() != null) {
            MultiMeasureUnitInfo multiUnitInfo;
            MaterialInfo materialInfo = (MaterialInfo)this.prmtMaterialNumber.getValue();
            MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)this.prmtMeasureUnit.getValue();
            if (materialInfo != null && measureUnitInfo != null && (multiUnitInfo = this.multiMeasureUnitUtil.getMutiMeasureUnitInfo(materialInfo, measureUnitInfo)) != null) {
                this.txtPlanCount.setPrecision(multiUnitInfo.getQtyPrecision());
                this.txtLaunchCount.setPrecision(multiUnitInfo.getQtyPrecision());
                this.txtAdvicePlanCount.setPrecision(multiUnitInfo.getQtyPrecision());
            }
        } else {
            this.txtPlanCount.setPrecision(4);
            this.txtLaunchCount.setPrecision(4);
            this.txtAdvicePlanCount.setPrecision(4);
        }
    }

    private boolean confirmForceComplete() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.eqm.planning.spareparts.SharepartPlanOrderResource.CheckForceComplete")));
    }

    private void setButtonVisible() {
        if (this.oprtState.equalsIgnoreCase(OprtState.ADDNEW)) {
            this.btnForceComplete.setEnabled(false);
            this.menuForceComplete.setEnabled(false);
        } else if (this.editData.getId() != null) {
            if (this.editData.getBillStatus() == GeneBillBaseStatusEnum.Audit) {
                this.btnForceComplete.setEnabled(true);
                this.menuForceComplete.setEnabled(true);
            } else {
                this.btnForceComplete.setEnabled(false);
                this.menuForceComplete.setEnabled(false);
            }
        }
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        this.prmtOrgUnit.requestFocus();
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        if (this.getToUnit(this.getCurrentOrgInfo().getId().toString(), 4, 1) == null) {
            MsgBox.showInfo((String)GeneResourceUtil.getMsg((String)"com.kingdee.eas.eqm.planning.spareparts.SharepartPlanOrderResource", (String)"Cannot_Crate", (Object[])new Object[]{this.getResourceMsg("CheckToOrgIsNull")}));
            SysUtil.abort();
        }
        super.actionCreateTo_actionPerformed(e);
    }

    private OrgUnitInfo getCurrentOrgInfo() throws BOSException {
        OrgUnitInfo org = (OrgUnitInfo)this.prmtOrgUnit.getValue();
        if (org == null) {
            org = this.getMainOrgInfo();
        }
        if (org.getCU() == null || org.getCU() != null && org.getCU().getNumber() == null || org.getCU() != null && org.getCU().getLongNumber() == null) {
            try {
                if (this.map.get(org.getId()) == null) {
                    if (org.getCU() == null) {
                        IStorageOrgUnit iStorage = StorageOrgUnitFactory.getRemoteInstance();
                        StorageOrgUnitInfo org1 = iStorage.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId()), GeneSelectorUtils.getSelector((BOSObjectType)new StorageOrgUnitInfo().getBOSType(), (String)"", (boolean)false, (boolean)true, (boolean)false));
                        org.setCU(org1.getCU());
                        this.map.put(org.getId(), org);
                    } else {
                        CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(org.getCU().getId()));
                        org.setCU(ctrlUnitInfo);
                        this.map.put(org.getId(), org);
                    }
                } else {
                    org = (OrgUnitInfo)this.map.get(org.getId());
                }
            }
            catch (EASBizException eASBizException) {
                // empty catch block
            }
        }
        return org;
    }

    public OrgUnitInfo getToUnit(String fromUnitID, int fromType, int toType) throws EASBizException, BOSException {
        OrgUnitInfo toUnit = null;
        if (this.toUnitMap != null && this.toUnitMap.get(fromUnitID) != null) {
            toUnit = (OrgUnitInfo)this.toUnitMap.get(fromUnitID);
        } else {
            OrgUnitCollection unitCol = OrgUnitRelationFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getToUnit(fromUnitID, fromType, toType);
            if (unitCol != null && unitCol.size() > 0) {
                toUnit = unitCol.get(0);
                this.toUnitMap.put(fromUnitID, toUnit);
            }
        }
        return toUnit;
    }

    protected String getMaterialIDForView() {
        if (this.prmtMaterialNumber.getValue() != null) {
            return ((MaterialInfo)this.prmtMaterialNumber.getValue()).getId().toString();
        }
        return null;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.setBaseCount();
        super.actionSave_actionPerformed(e);
    }

    private void calcCountByPrecision() {
        BigDecimal advicePlanCount;
        BigDecimal launchCount;
        int precision = this.txtPlanCount.getPrecision();
        BigDecimal planCount = this.txtPlanCount.getBigDecimalValue();
        if (planCount != null) {
            this.txtPlanCount.setValue((Object)planCount.setScale(precision, 4));
        }
        if ((launchCount = this.txtLaunchCount.getBigDecimalValue()) != null) {
            this.txtLaunchCount.setValue((Object)launchCount.setScale(precision, 4));
        }
        if ((advicePlanCount = this.txtAdvicePlanCount.getBigDecimalValue()) != null) {
            this.txtAdvicePlanCount.setValue((Object)advicePlanCount.setScale(precision, 4));
        }
    }
}

