/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.report.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.IEquipmentArchives;
import com.kingdee.eas.eqm.basedata.EquipmentCategoryFactory;
import com.kingdee.eas.eqm.basedata.EquipmentFaultSortTreeFactory;
import com.kingdee.eas.eqm.basedata.EquipmentLocationFactory;
import com.kingdee.eas.eqm.basedata.IEquipmentCategory;
import com.kingdee.eas.eqm.basedata.IEquipmentFaultSortTree;
import com.kingdee.eas.eqm.basedata.IEquipmentLocation;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.report.client.AbstractEQMDefectPoolFilterUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class EQMDefectPoolFilterUI
extends AbstractEQMDefectPoolFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EQMDefectPoolFilterUI.class);
    private static String VIEW_PERMISSION = "eqm_DefectPool_view";

    public void onInit(RptParams initParams) throws Exception {
        super.onInit(initParams);
        this.onLoad();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setFilterManager();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.storageOrgUnit, (OrgType)OrgType.Storage, (String)VIEW_PERMISSION);
        this.prmtMaintainOrgUnit.setEnabledMultiSelection(true);
        this.registerMainBizOrgF7(this.storageOrgUnit, OrgType.Storage, VIEW_PERMISSION, true);
        this.registerMainBizOrgF7(this.prmtMaintainOrgUnit, OrgType.Storage, null, true);
    }

    public void registerMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType, String permissionItem, boolean isSupportMultiOrgs) {
        if (orgType == null) {
            throw new NullPointerException("orgType can not null");
        }
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        NewOrgViewF7PromptDialog modelF7 = iProducer.getModel();
        modelF7.setShowAssistantOrg(false);
        modelF7.setIsCUFilter(false);
        modelF7.setShowVirtual(false);
        modelF7.setDefaultChkVirtual(false);
        if (permissionItem != null) {
            modelF7.setPermissionItem(permissionItem);
        }
        modelF7.setMultiSelect(isSupportMultiOrgs);
        bizOrgUnitBox.setSelector((KDPromptSelector)modelF7);
        bizOrgUnitBox.setCommitFormat("$number$;$name$;$code$");
        bizOrgUnitBox.setEnabledMultiSelection(isSupportMultiOrgs);
    }

    public void afterMainOrgChanged(String ids) {
        super.afterMainOrgChanged(ids);
        this.initBizArchives(ids);
        this.initBizLocation(ids);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtLocationFrom, this.prmtLocationTo, this.prmtEQMArchivesFrom, this.prmtEQMArchivesTo});
    }

    private void initBizLocation(String ids) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("storageOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        items.add(new FilterItemInfo("planOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        items.add(new FilterItemInfo("maintainOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        filter.setMaskString("#0 or #1 or #2");
        view.setFilter(filter);
        this.prmtLocationFrom.setEntityViewInfo(view);
        this.prmtLocationFrom.setValue(null);
        this.prmtLocationTo.setEntityViewInfo(view);
        this.prmtLocationTo.setValue(null);
    }

    private void initBizArchives(String ids) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("storageOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        items.add(new FilterItemInfo("planOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        items.add(new FilterItemInfo("maintainOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        filter.setMaskString("#0 or #1 or #2");
        view.setFilter(filter);
        this.prmtEQMArchivesFrom.setEntityViewInfo(view);
        this.prmtEQMArchivesFrom.setValue(null);
        this.prmtEQMArchivesTo.setEntityViewInfo(view);
        this.prmtEQMArchivesTo.setValue(null);
    }

    private void setFilterManager() {
        this.isReport = true;
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit", (Component)this.storageOrgUnit);
        mainOrgElement.setDefaultValue((Object)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)VIEW_PERMISSION));
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EQMDefectPoolFilterUI.getResource("STORAGEORG_ISNULL")));
        elements.add((FilterElement)mainOrgElement);
        SingleFilterElement maintainOrgElement = new SingleFilterElement("EQMMaintainOrgUnit", (Component)this.prmtMaintainOrgUnit);
        elements.add((FilterElement)maintainOrgElement);
        elements.add((FilterElement)new SingleComPromptFilterElement("EQMCategoryFrom", this.prmtEQMCategoryFrom));
        elements.add((FilterElement)new SingleComPromptFilterElement("EQMCategoryTo", this.prmtEQMCategoryTo));
        elements.add((FilterElement)new SingleComPromptFilterElement("EQMArchivesFrom", this.prmtEQMArchivesFrom));
        elements.add((FilterElement)new SingleComPromptFilterElement("EQMArchivesTo", this.prmtEQMArchivesTo));
        elements.add((FilterElement)new SingleComPromptFilterElement("EQMLocationFrom", this.prmtLocationFrom));
        elements.add((FilterElement)new SingleComPromptFilterElement("EQMLocationTo", this.prmtLocationTo));
        elements.add((FilterElement)new SingleComPromptFilterElement("EQMStopCodeFrom", this.prmtFaultCodeFrom));
        elements.add((FilterElement)new SingleComPromptFilterElement("EQMStopCodeTo", this.prmtFaultCodeTo));
        SingleFilterElement kDBizFindDateFrom = new SingleFilterElement("findDateFrom", (Component)this.kDFindDateFrom);
        kDBizFindDateFrom.setDefaultValue((Object)GeneDateUtils.getFirstDayOfCurMonth());
        kDBizFindDateFrom.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EQMDefectPoolFilterUI.getResource("FINDDATE_FROM")));
        SingleFilterElement kDBizFindDateTo = new SingleFilterElement("findDateTo", (Component)this.kDFindDateTo);
        kDBizFindDateTo.setDefaultValue((Object)GeneDateUtils.getLastDayOfCurMonth());
        kDBizFindDateTo.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EQMDefectPoolFilterUI.getResource("FINDDATE_TO")));
        elements.add((FilterElement)kDBizFindDateFrom);
        elements.add((FilterElement)kDBizFindDateTo);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.storageOrgUnit;
    }

    protected String getViewPermission() {
        return VIEW_PERMISSION;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public boolean verify() {
        if (this.kDFindDateFrom.getValue() == null || this.kDFindDateTo.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.report.EQMReportResource", (String)"FINDDATE_VERIFY"));
            return false;
        }
        if (this.kDFindDateFrom.getValue() != null && this.kDFindDateTo.getValue() != null && ((Date)this.kDFindDateTo.getValue()).getTime() < ((Date)this.kDFindDateFrom.getValue()).getTime()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.report.EQMReportResource", (String)"FINDDATE_VERIFY"));
            return false;
        }
        return super.verify();
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.report.ReportResource", (String)strKey);
    }

    private String transformNumberArray(KDBizPromptBox control) {
        String ids = control.getText();
        if (ids == null || ids != null && ids.length() == 0) {
            return null;
        }
        return ids.replaceAll(" ", "").replaceAll(";", "','");
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        try {
            IEquipmentFaultSortTree fstr;
            IEquipmentCategory category;
            CoreBaseCollection items;
            String numbers = null;
            for (FilterItemInfo itemInfo : entityViewInfo.getFilter().getFilterItems()) {
                if (itemInfo.getPropertyName() == null || !itemInfo.getPropertyName().equalsIgnoreCase("EQMArchivesFrom")) continue;
                numbers = itemInfo.get("compareValue").toString();
                break;
            }
            if (numbers != null) {
                IEquipmentArchives archives = EquipmentArchivesFactory.getRemoteInstance();
                items = archives.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtEQMArchivesFrom.setValue((Object)items.get(0));
                numbers = null;
            }
            for (FilterItemInfo itemInfo : entityViewInfo.getFilter().getFilterItems()) {
                if (itemInfo.getPropertyName() == null || !itemInfo.getPropertyName().equalsIgnoreCase("EQMArchivesTo")) continue;
                numbers = itemInfo.get("compareValue").toString();
                break;
            }
            if (numbers != null) {
                IEquipmentArchives archives = EquipmentArchivesFactory.getRemoteInstance();
                items = archives.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtEQMArchivesTo.setValue((Object)items.get(0));
                numbers = null;
            }
            if ((numbers = this.transformNumberArray(this.prmtEQMCategoryFrom)) != null) {
                category = EquipmentCategoryFactory.getRemoteInstance();
                items = category.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtEQMCategoryFrom.setValue((Object)items.get(0));
            }
            if ((numbers = this.transformNumberArray(this.prmtEQMCategoryTo)) != null) {
                category = EquipmentCategoryFactory.getRemoteInstance();
                items = category.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtEQMCategoryTo.setValue((Object)items.get(0));
            }
            for (FilterItemInfo itemInfo : entityViewInfo.getFilter().getFilterItems()) {
                if (itemInfo.getPropertyName() == null || !itemInfo.getPropertyName().equalsIgnoreCase("EQMLocationFrom")) continue;
                numbers = itemInfo.get("compareValue").toString();
                break;
            }
            if (numbers != null) {
                IEquipmentLocation loc = EquipmentLocationFactory.getRemoteInstance();
                items = loc.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtLocationFrom.setValue((Object)items.get(0));
                numbers = null;
            }
            for (FilterItemInfo itemInfo : entityViewInfo.getFilter().getFilterItems()) {
                if (itemInfo.getPropertyName() == null || !itemInfo.getPropertyName().equalsIgnoreCase("EQMLocationTo")) continue;
                numbers = itemInfo.get("compareValue").toString();
                break;
            }
            if (numbers != null) {
                IEquipmentLocation loc = EquipmentLocationFactory.getRemoteInstance();
                items = loc.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtLocationTo.setValue((Object)items.get(0));
                numbers = null;
            }
            if ((numbers = this.transformNumberArray(this.prmtFaultCodeFrom)) != null) {
                fstr = EquipmentFaultSortTreeFactory.getRemoteInstance();
                items = fstr.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtFaultCodeFrom.setValue((Object)items.get(0));
            }
            if ((numbers = this.transformNumberArray(this.prmtFaultCodeTo)) != null) {
                fstr = EquipmentFaultSortTreeFactory.getRemoteInstance();
                items = fstr.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtFaultCodeTo.setValue((Object)items.get(0));
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    class SingleComPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleComPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    IEquipmentFaultSortTree fstr;
                    IEquipmentLocation loc;
                    IEquipmentArchives archives;
                    CoreBaseCollection items;
                    IEquipmentCategory category;
                    String numbers;
                    if (this.prmt.getName().equals("prmtEQMCategoryFrom") && (numbers = EQMDefectPoolFilterUI.this.transformNumberArray(this.prmt)) != null) {
                        category = EquipmentCategoryFactory.getRemoteInstance();
                        items = category.getCollection("select id,name,number where number in ('" + numbers + "')");
                        this.prmt.setValue((Object)items.get(0));
                    }
                    if (this.prmt.getName().equals("prmtEQMCategoryTo") && (numbers = EQMDefectPoolFilterUI.this.transformNumberArray(this.prmt)) != null) {
                        category = EquipmentCategoryFactory.getRemoteInstance();
                        items = category.getCollection("select id,name,number where number in ('" + numbers + "')");
                        this.prmt.setValue((Object)items.get(0));
                    }
                    if (this.prmt.getName().equals("prmtEQMArchivesFrom") && (numbers = EQMDefectPoolFilterUI.this.transformNumberArray(this.prmt)) != null) {
                        archives = EquipmentArchivesFactory.getRemoteInstance();
                        items = archives.getCollection("select id,name,number where number in ('" + numbers + "')");
                        this.prmt.setValue((Object)items.get(0));
                    }
                    if (this.prmt.getName().equals("prmtEQMArchivesTo") && (numbers = EQMDefectPoolFilterUI.this.transformNumberArray(this.prmt)) != null) {
                        archives = EquipmentArchivesFactory.getRemoteInstance();
                        items = archives.getCollection("select id,name,number where number in ('" + numbers + "')");
                        this.prmt.setValue((Object)items.get(0));
                    }
                    if (this.prmt.getName().equals("prmtLocationFrom") && (numbers = EQMDefectPoolFilterUI.this.transformNumberArray(this.prmt)) != null) {
                        loc = EquipmentLocationFactory.getRemoteInstance();
                        items = loc.getCollection("select id,name,number where number in ('" + numbers + "')");
                        this.prmt.setValue((Object)items.get(0));
                    }
                    if (this.prmt.getName().equals("prmtLocationTo") && (numbers = EQMDefectPoolFilterUI.this.transformNumberArray(this.prmt)) != null) {
                        loc = EquipmentLocationFactory.getRemoteInstance();
                        items = loc.getCollection("select id,name,number where number in ('" + numbers + "')");
                        this.prmt.setValue((Object)items.get(0));
                    }
                    if (this.prmt.getName().equals("prmtFaultCodeFrom") && (numbers = EQMDefectPoolFilterUI.this.transformNumberArray(this.prmt)) != null) {
                        fstr = EquipmentFaultSortTreeFactory.getRemoteInstance();
                        items = fstr.getCollection("select id,name,number where number in ('" + numbers + "')");
                        this.prmt.setValue((Object)items.get(0));
                    }
                    if (this.prmt.getName().equals("prmtFaultCodeTo") && (numbers = EQMDefectPoolFilterUI.this.transformNumberArray(this.prmt)) != null) {
                        fstr = EquipmentFaultSortTreeFactory.getRemoteInstance();
                        items = fstr.getCollection("select id,name,number where number in ('" + numbers + "')");
                        this.prmt.setValue((Object)items.get(0));
                    }
                }
                catch (Throwable t) {
                    EQMDefectPoolFilterUI.this.handUIException(t);
                }
                object = this.prmt.getValue();
            }
            cp.setObject(this.getId(), object);
        }
    }
}

