/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.report.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentBizStatus;
import com.kingdee.eas.eqm.common.core.filter.CompositeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.DateCasterEnum;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.RangeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.SingleFilterElement;
import com.kingdee.eas.eqm.report.client.AbstractEQMLifeCyleTrackFilterUI;
import com.kingdee.eas.eqm.report.client.PrmptOrgDialogUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EQMLifeCyleTrackFilterUI
extends AbstractEQMLifeCyleTrackFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EQMLifeCyleTrackFilterUI.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.report.EQMReportResource";
    private Set set = new HashSet();
    private static String VIEW_PERMISSION = "eqm_LifeCyleTrack_view";
    private List statusList = new ArrayList();
    private Map statusMap = new HashMap();

    public void initLayout() {
        super.initLayout();
        this.registerBizStatus();
    }

    private void registerBizStatus() {
        this.statusList = EquipmentBizStatus.getEnumList();
        int x = 10;
        int y = 20;
        int width = 60;
        int height = 19;
        for (int i = 0; i < this.statusList.size(); ++i) {
            EquipmentBizStatus status = (EquipmentBizStatus)this.statusList.get(i);
            KDCheckBox kDCheckBox = new KDCheckBox();
            kDCheckBox.setName("kDCheckBox" + status.getName());
            kDCheckBox.setText(status.getAlias());
            int statusWid = status.getAlias().getBytes().length;
            width = 60 * (statusWid / 8 + 1);
            kDCheckBox.setBounds(new Rectangle(x, y, width, height));
            this.kDPanel3.add((Component)kDCheckBox, null);
            this.kDPanel3.setSize(578, y + 29);
            this.statusMap.put(status, kDCheckBox);
            if ((x += 82 * (statusWid / 8 + 1)) <= 502) continue;
            x = 10;
            y += 22;
        }
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        RangeFilterElement useDeptElement = new RangeFilterElement("usingDept.number", (Component)this.kDBizUseDeptFrom, (Component)this.kDBizUseDeptTo);
        useDeptElement.getFrom().putUserInfo("key", "number");
        useDeptElement.getTo().putUserInfo("key", "number");
        rootElement.add((IFilterElement)useDeptElement);
        RangeFilterElement EQMCategoryElement = new RangeFilterElement("category.number", (Component)this.kDBizEQMCategoryFrom, (Component)this.kDBizEQMCategoryTo);
        EQMCategoryElement.getFrom().putUserInfo("key", "number");
        EQMCategoryElement.getTo().putUserInfo("key", "number");
        rootElement.add((IFilterElement)EQMCategoryElement);
        RangeFilterElement EQMTypeElement = new RangeFilterElement("type.number", (Component)this.kDBizEQMTypeFrom, (Component)this.kDBizEQMTypeTo);
        EQMTypeElement.getFrom().putUserInfo("key", "number");
        EQMTypeElement.getTo().putUserInfo("key", "number");
        rootElement.add((IFilterElement)EQMTypeElement);
        RangeFilterElement techLevelElement = new RangeFilterElement("techLevel.number", (Component)this.kDBizTechLevelFrom, (Component)this.kDBizTechLevelTo);
        techLevelElement.getFrom().putUserInfo("key", "number");
        techLevelElement.getTo().putUserInfo("key", "number");
        rootElement.add((IFilterElement)techLevelElement);
        RangeFilterElement EQMArchivesElement = new RangeFilterElement("number", (Component)this.kDBizEQMArchivesFrom, (Component)this.kDBizEQMArchivesTo);
        EQMArchivesElement.getFrom().putUserInfo("key", "number");
        EQMArchivesElement.getTo().putUserInfo("key", "number");
        rootElement.add((IFilterElement)EQMArchivesElement);
        CompositeFilterElement bizStatus = new CompositeFilterElement("or");
        for (int i = 0; i < this.statusList.size(); ++i) {
            EquipmentBizStatus status = (EquipmentBizStatus)this.statusList.get(i);
            KDCheckBox kDCheckBox = (KDCheckBox)this.statusMap.get(status);
            SingleFilterElement statusElement = new SingleFilterElement("bizStatus", (Component)kDCheckBox);
            statusElement.putUserInfo("falseEqualAll", "1");
            statusElement.putUserInfo("trueValue", String.valueOf(status.getValue()));
            statusElement.setDataCaster(DateCasterEnum.IINTEGER_DC);
            statusElement.setDefaultValue(String.valueOf(true));
            kDCheckBox.setSelected(true);
            bizStatus.add((IFilterElement)statusElement);
        }
        rootElement.add((IFilterElement)bizStatus);
        CompositeFilterElement abcStatus = new CompositeFilterElement("or");
        SingleFilterElement generalLoc = new SingleFilterElement("abcIdentify", (Component)this.kDCheckBoxGeneralLoc);
        generalLoc.putUserInfo("falseEqualAll", "1");
        generalLoc.putUserInfo("trueValue", String.valueOf(30));
        generalLoc.setDataCaster(DateCasterEnum.IINTEGER_DC);
        generalLoc.setDefaultValue(String.valueOf(true));
        SingleFilterElement keyLoc = new SingleFilterElement("abcIdentify", (Component)this.kDCheckBoxKeyLoc);
        keyLoc.putUserInfo("falseEqualAll", "1");
        keyLoc.putUserInfo("trueValue", String.valueOf(10));
        keyLoc.setDataCaster(DateCasterEnum.IINTEGER_DC);
        keyLoc.setDefaultValue(String.valueOf(true));
        SingleFilterElement importantLoc = new SingleFilterElement("abcIdentify", (Component)this.kDCheckBoxImportantLoc);
        importantLoc.putUserInfo("falseEqualAll", "1");
        importantLoc.putUserInfo("trueValue", String.valueOf(20));
        importantLoc.setDataCaster(DateCasterEnum.IINTEGER_DC);
        importantLoc.setDefaultValue(String.valueOf(true));
        abcStatus.add((IFilterElement)generalLoc);
        abcStatus.add((IFilterElement)keyLoc);
        abcStatus.add((IFilterElement)importantLoc);
        rootElement.add((IFilterElement)abcStatus);
    }

    public FilterInfo getFilterInfo() {
        if (super.getFilterInfo() == null) {
            return null;
        }
        FilterInfo filterInfo = super.getFilterInfo();
        FilterItemCollection item = filterInfo.getFilterItems();
        for (int i = 0; i < item.size(); ++i) {
            FilterItemInfo type = item.get(i);
            if (!type.getPropertyName().equals("StorageOrgunit.id")) continue;
            item.remove(type);
            item.addObject(i, (IObjectValue)new FilterItemInfo("storageOrgUnit.id", null, CompareType.NOTEQUALS));
            filterInfo.setMaskString("(" + filterInfo.getMaskString() + ") and (#" + String.valueOf(filterInfo.getFilterItems().size()) + " or #" + String.valueOf(filterInfo.getFilterItems().size() + 1) + " or #" + String.valueOf(filterInfo.getFilterItems().size() + 2) + ")");
            item.add(new FilterItemInfo("storageOrgUnit.id", (Object)this.set, CompareType.INCLUDE));
            item.add(new FilterItemInfo("planOrgUnit.id", (Object)this.set, CompareType.INCLUDE));
            item.add(new FilterItemInfo("maintainOrgUnit.id", (Object)this.set, CompareType.INCLUDE));
        }
        return filterInfo;
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo[] orgs) {
        super.afterMainOrgChanged(oldOrg, orgs);
        try {
            this.set = new HashSet();
            for (int i = 0; i < orgs.length; ++i) {
                if (orgs[i] == null) continue;
                this.set.add(orgs[i].getId().toString());
            }
            this.initkDBizUseDept();
            this.initkDBizEQMArchives(this.set);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private void initkDBizEQMArchives(Set set) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("storageOrgUnit.id", (Object)set, CompareType.INCLUDE));
        items.add(new FilterItemInfo("planOrgUnit.id", (Object)set, CompareType.INCLUDE));
        items.add(new FilterItemInfo("maintainOrgUnit.id", (Object)set, CompareType.INCLUDE));
        filter.setMaskString("#0 or #1 or #2");
        view.setFilter(filter);
        this.kDBizEQMArchivesFrom.setEntityViewInfo(view);
        this.kDBizEQMArchivesFrom.setValue(null);
        this.kDBizEQMArchivesTo.setEntityViewInfo(view);
        this.kDBizEQMArchivesTo.setValue(null);
    }

    private void initkDBizUseDept() {
        try {
            PrmptOrgDialogUtil.createPrmptOrgDialog(this.kDBizUseDeptFrom, "com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery", OrgType.Storage, OrgType.Admin, this.getMainBizOrgs());
            this.kDBizUseDeptFrom.setValue(null);
            PrmptOrgDialogUtil.createPrmptOrgDialog(this.kDBizUseDeptTo, "com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery", OrgType.Storage, OrgType.Admin, this.getMainBizOrgs());
            this.kDBizUseDeptTo.setValue(null);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public KDBizPromptBox getMainBizOrg() {
        return this.prmtOrgUnit;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtOrgUnit;
    }

    protected String getMainBizOrgField() {
        return "StorageOrgunit";
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        if (null != this.getMainBizOrgs()) {
            try {
                PrmptOrgDialogUtil.createPrmptOrgDialog(this.kDBizUseDeptFrom, "com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery", OrgType.Storage, OrgType.Admin, this.getMainBizOrgs());
                PrmptOrgDialogUtil.createPrmptOrgDialog(this.kDBizUseDeptTo, "com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery", OrgType.Storage, OrgType.Admin, this.getMainBizOrgs());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.kDCheckBoxKeyLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(EQMLifeCyleTrackFilterUI.this.kDCheckBoxKeyLoc.isSelected() || EQMLifeCyleTrackFilterUI.this.kDCheckBoxImportantLoc.isSelected() || EQMLifeCyleTrackFilterUI.this.kDCheckBoxGeneralLoc.isSelected())) {
                    MsgBox.showWarning((String)EQMLifeCyleTrackFilterUI.getResource("BILLSTATE_CHECK"));
                    EQMLifeCyleTrackFilterUI.this.kDCheckBoxKeyLoc.setSelected(true);
                }
            }
        });
        this.kDCheckBoxImportantLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(EQMLifeCyleTrackFilterUI.this.kDCheckBoxKeyLoc.isSelected() || EQMLifeCyleTrackFilterUI.this.kDCheckBoxImportantLoc.isSelected() || EQMLifeCyleTrackFilterUI.this.kDCheckBoxGeneralLoc.isSelected())) {
                    MsgBox.showWarning((String)EQMLifeCyleTrackFilterUI.getResource("BILLSTATE_CHECK"));
                    EQMLifeCyleTrackFilterUI.this.kDCheckBoxImportantLoc.setSelected(true);
                }
            }
        });
        this.kDCheckBoxGeneralLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(EQMLifeCyleTrackFilterUI.this.kDCheckBoxKeyLoc.isSelected() || EQMLifeCyleTrackFilterUI.this.kDCheckBoxImportantLoc.isSelected() || EQMLifeCyleTrackFilterUI.this.kDCheckBoxGeneralLoc.isSelected())) {
                    MsgBox.showWarning((String)EQMLifeCyleTrackFilterUI.getResource("BILLSTATE_CHECK"));
                    EQMLifeCyleTrackFilterUI.this.kDCheckBoxGeneralLoc.setSelected(true);
                }
            }
        });
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)RESOURCE_PATH, (String)strKey);
    }

    public String getViewPermItemName() {
        return VIEW_PERMISSION;
    }

    public boolean verify() {
        boolean flag = super.verify();
        if (!flag) {
            return flag;
        }
        boolean selectedStatus = false;
        for (int i = 0; i < this.statusList.size(); ++i) {
            EquipmentBizStatus status = (EquipmentBizStatus)this.statusList.get(i);
            KDCheckBox kDCheckBox = (KDCheckBox)this.statusMap.get(status);
            if (!kDCheckBox.isSelected()) continue;
            selectedStatus = true;
            break;
        }
        if (!selectedStatus) {
            MsgBox.showWarning((String)EQMLifeCyleTrackFilterUI.getResource("BILLSTATE_CHECK"));
            EquipmentBizStatus status = (EquipmentBizStatus)this.statusList.get(0);
            KDCheckBox kDCheckBox = (KDCheckBox)this.statusMap.get(status);
            kDCheckBox.setSelected(true);
            flag = false;
        }
        return flag;
    }
}

