/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IAPBillDisposer;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.arap.BillDisposerAction;
import com.kingdee.eas.fi.arap.DisposerActionEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;

public class APDisposeUtil {
    public static void dispose(Context ctx, String otherBillId, DisposerActionEnum actionType) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)otherBillId));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("entry.sourceBillId");
        ev.setFilter(fi);
        ev.setSelector(sic);
        OtherBillCollection col = OtherBillFactory.getLocalInstance(ctx).getOtherBillCollection(ev);
        APDisposeUtil.dispose(ctx, col.get(0), actionType);
    }

    public static void dispose(Context ctx, OtherBillCollection col, DisposerActionEnum actionType) throws BOSException, EASBizException {
        int len = col.size();
        for (int i = 0; i < len; ++i) {
            OtherBillInfo info = col.get(i);
            APDisposeUtil.dispose(ctx, info, actionType);
        }
    }

    public static void dispose(Context ctx, OtherBillInfo info, DisposerActionEnum actionType) throws BOSException, EASBizException {
        IAPBillDisposer disposer = null;
        int j = 0;
        OtherBillentryCollection entries = info.getEntry();
        int lenj = entries.size();
        if (j < lenj) {
            OtherBillentryInfo entry = entries.get(j);
            disposer = APDisposeUtil.getDisposer(entry.getSourceBillId());
        }
        if (disposer != null && !info.isIsReverseBill()) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString()));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("entry.*");
            ev.setFilter(fi);
            ev.setSelector(sic);
            OtherBillCollection col = OtherBillFactory.getLocalInstance(ctx).getOtherBillCollection(ev);
            info = col.get(0);
            BillDisposerAction action = new BillDisposerAction();
            action.setActionType(actionType);
            action.setDestBill((CoreBaseInfo)info);
            disposer.dispose(ctx, action);
        }
    }

    private static IAPBillDisposer getDisposer(String bizBillId) throws BOSException {
        if (StringUtils.isEmpty((String)bizBillId)) {
            return null;
        }
        BOSObjectType bosType = BOSUuid.read((String)bizBillId).getType();
        String disposerName = null;
        if (bosType.equals((Object)BOSObjectType.create((String)"92F938DD")) || bosType.equals((Object)BOSObjectType.create((String)"30BD2798"))) {
            disposerName = "com.kingdee.eas.cp.bc.BizAPBillReBack";
        }
        if (disposerName == null) {
            return null;
        }
        try {
            return (IAPBillDisposer)Class.forName(disposerName).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

