/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.vc.VcSchemeInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.VerificationBillFactory;
import com.kingdee.eas.fi.ap.VerificationBillInfo;
import com.kingdee.eas.fi.ap.VerificationBillentryCollection;
import com.kingdee.eas.fi.ap.VerificationBillentryInfo;
import com.kingdee.eas.fi.ap.VerificationEnum;
import com.kingdee.eas.fi.ap.client.AbstractAp2PayVerifyUI;
import com.kingdee.eas.fi.ap.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.ArVerificationFacadeFactory;
import com.kingdee.eas.fi.arap.ARAPVerifynException;
import com.kingdee.eas.fi.arap.client.ArApClientHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.LineResult;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class Ap2PayVerifyUI
extends AbstractAp2PayVerifyUI {
    private static final Logger logger = CoreUIObject.getLogger(Ap2PayVerifyUI.class);
    private static final String IS_FROM_TOP = "IS_FROM_TOP";
    final BigDecimal ZERO = new BigDecimal("0.00");
    private String TB_ASSACTID = "acctCussID";
    private String TB_ASSACTNAME = "acctCussName";
    private static final String TB_COREBILLNUM = "coreBillNum";
    private static final String TB_COREENTRYSEQ = "coreBillEntrySeq";
    private static final String TB_CONTRACTNUM = "contractNum";
    private static final String TB_CONTRACTENTRYSEQ = "contractEntrySeq";
    private static final String TB_SELECT = "selected";
    private static final String TB_THISVERIAMT = "thisVerificateAmt";
    private static final String TB_THISVERIAMTLOC = "thisVerificateAmtLoc";
    private static final String TB_BILLDATE = "billDate";
    private static final String TB_SELECTED = "selected";
    private static final String TB_BILLID = "billid";
    private List requestLockIDList = new ArrayList();
    private List lockedIDList = new ArrayList();
    private IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getRemoteInstance();
    Map topCheckDataMaq = new HashMap();
    Map bottomCheckDataMaq = new HashMap();
    VerificateBillTypeEnum billType = null;
    protected KDTSortManager apSortManager;
    protected KDTSortManager paymentSortManager;

    public Ap2PayVerifyUI() throws Exception {
        this.verificateType = this.getMetaDataPK().getFullName();
    }

    protected VcSchemeInfo getVcSchemeInfoByBiz() {
        if (this.dialog == null) {
            return null;
        }
        return BaseDataUtil.getVcSchemeInfoByName("com.kingdee.eas.fi.ap", "");
    }

    @Override
    public void actionCoreNumVeri_actionPerformed(ActionEvent e) throws BOSException, EASBizException, Exception {
        int rowIndex;
        HashMap coreBills = this._selectEntrys();
        Map allCheckMap = this.getAllCheckMap();
        if (allCheckMap.size() > 0) {
            ArVerificationFacadeFactory.getRemoteInstance().batchCheckDataChanged(allCheckMap);
        }
        String billId = null;
        String coreBillKeys = null;
        for (rowIndex = 0; rowIndex < this.getTopTable().getRowCount3(); ++rowIndex) {
            coreBillKeys = (String)this.getTopTable().getCell(rowIndex, TB_COREBILLNUM).getValue() + IS_FROM_TOP + (String)this.getTopTable().getCell(rowIndex, TB_COREENTRYSEQ).getValue();
            if (!coreBills.containsKey(coreBillKeys)) continue;
            billId = (String)this.getTopTable().getCell(rowIndex, TB_BILLID).getValue();
            this.requestLockIDList.add(billId);
        }
        for (rowIndex = 0; rowIndex < this.getBottomTable().getRowCount3(); ++rowIndex) {
            coreBillKeys = (String)this.getBottomTable().getCell(rowIndex, TB_COREBILLNUM).getValue() + IS_FROM_TOP + (String)this.getBottomTable().getCell(rowIndex, TB_COREENTRYSEQ).getValue();
            if (!coreBills.containsKey(coreBillKeys)) continue;
            billId = (String)this.getBottomTable().getCell(rowIndex, TB_BILLID).getValue();
            this.requestLockIDList.add(billId);
        }
        try {
            ArrayList<String> otherLockedList = new ArrayList<String>();
            if (this.requestLockIDList != null && this.requestLockIDList.size() > 0) {
                Map map = this.iMutexServiceControl.batchRequestObjIDForUpdate(this.requestLockIDList);
                int size = this.requestLockIDList.size();
                for (int i = 0; i < size; ++i) {
                    String id = (String)this.requestLockIDList.get(i);
                    if (((Boolean)map.get(id)).booleanValue()) {
                        this.lockedIDList.add(id);
                        continue;
                    }
                    otherLockedList.add(id);
                }
                if (otherLockedList.size() > 0) {
                    this.releaseLocks(this.lockedIDList);
                    throw new ARAPVerifynException(ARAPVerifynException.BILL_LOCKED_NOT_VERI);
                }
            }
            CoreBaseCollection coll = new CoreBaseCollection();
            if (this._checkVeriCondition(this.getTopTable()) && this._checkVeriCondition(this.getBottomTable())) {
                Iterator iter = coreBills.keySet().iterator();
                String key = null;
                Ap2PaymentPair pair = null;
                while (iter.hasNext()) {
                    key = iter.next().toString();
                    pair = (Ap2PaymentPair)coreBills.get(key);
                    coll.addCollection(this.veriOneEntry(pair));
                }
            } else {
                SysUtil.abort();
            }
            Result result = VerificationBillFactory.getRemoteInstance().submit(coll);
            if (result != null) {
                this.verifyBillID.clear();
                for (int i = 0; i < result.size(); ++i) {
                    LineResult ret = result.getLineResult(i);
                    if (ret.isSucess()) {
                        this.verifyBillID.add(ret.getPk());
                        continue;
                    }
                    if (ret.getException() == null) continue;
                    throw ret.getException();
                }
            }
            if (this.verifyBillID.size() > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ap_verify_success"));
                this.refreshList();
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("VeriCore_Error"));
            }
        }
        catch (BOSException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.releaseLocks(this.lockedIDList);
        }
    }

    @Override
    public void actionContractNumVeri_actionPerformed(ActionEvent e) throws Exception {
        this.verifyByCoreBillNumorContractNum(false);
    }

    private void verifyByCoreBillNumorContractNum(boolean fByCoreBill) throws Exception {
        int rowIndex;
        HashMap pairBills = null;
        int flag = this.getSelectedTableCount();
        pairBills = this.cbSameSideFirst.isSelected() && Math.abs(flag) == 1 ? this._selectEntrysOneSideWithoutSeq(fByCoreBill) : this._selectEntrysWithoutSeq(fByCoreBill);
        String numFld = fByCoreBill ? TB_COREBILLNUM : TB_CONTRACTNUM;
        String billId = null;
        String matchFldKeys = null;
        for (rowIndex = 0; rowIndex < this.getTopTable().getRowCount3(); ++rowIndex) {
            matchFldKeys = (String)this.getTopTable().getCell(rowIndex, numFld).getValue();
            if (!pairBills.containsKey(matchFldKeys)) continue;
            billId = (String)this.getTopTable().getCell(rowIndex, TB_BILLID).getValue();
            this.requestLockIDList.add(billId);
        }
        for (rowIndex = 0; rowIndex < this.getBottomTable().getRowCount3(); ++rowIndex) {
            matchFldKeys = (String)this.getBottomTable().getCell(rowIndex, numFld).getValue();
            if (!pairBills.containsKey(matchFldKeys)) continue;
            billId = (String)this.getBottomTable().getCell(rowIndex, TB_BILLID).getValue();
            this.requestLockIDList.add(billId);
        }
        try {
            ArrayList<String> otherLockedList = new ArrayList<String>();
            if (this.requestLockIDList != null && this.requestLockIDList.size() > 0) {
                Map map = this.iMutexServiceControl.batchRequestObjIDForUpdate(this.requestLockIDList);
                int size = this.requestLockIDList.size();
                for (int i = 0; i < size; ++i) {
                    String id = (String)this.requestLockIDList.get(i);
                    if (((Boolean)map.get(id)).booleanValue()) {
                        this.lockedIDList.add(id);
                        continue;
                    }
                    otherLockedList.add(id);
                }
                if (otherLockedList.size() > 0) {
                    this.releaseLocks(this.lockedIDList);
                    throw new ARAPVerifynException(ARAPVerifynException.BILL_LOCKED_NOT_VERI);
                }
            }
            ArrayList coll = new ArrayList();
            if (this._checkVeriCondition(this.getTopTable()) && this._checkVeriCondition(this.getBottomTable())) {
                Iterator iter = pairBills.keySet().iterator();
                String key = null;
                Ap2PaymentPairOrderBySeq pair = null;
                while (iter.hasNext()) {
                    key = iter.next().toString();
                    pair = (Ap2PaymentPairOrderBySeq)pairBills.get(key);
                    if (this.cbSameSideFirst.isSelected() && Math.abs(flag) == 1) {
                        coll.addAll(this.veriOneEntryOneSideWithoutSeq(pair));
                        continue;
                    }
                    coll.addAll(this.veriOneEntryWithoutSeq(pair));
                }
            } else {
                SysUtil.abort();
            }
            if (coll.size() > 0) {
                this.verifyBillID.clear();
                this.verifyBillID.addAll(coll);
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ap_verify_success"));
                this.refreshList();
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource(fByCoreBill ? "VeriCoreWithoutSeq_Error" : "VeriContractWithoutMatchedPair"));
            }
        }
        catch (BOSException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.releaseLocks(this.lockedIDList);
        }
    }

    private int getSelectedTableCount() {
        int iTop = 0;
        int iBot = 0;
        iTop = this.getTopTable().getRowCount3();
        iBot = this.getBottomTable().getRowCount3();
        if (iTop > 0 && iBot > 0) {
            return 2;
        }
        if (iTop > 0) {
            return 1;
        }
        if (iBot > 0) {
            return -1;
        }
        return 0;
    }

    private HashMap _selectEntrysWithoutSeq(boolean fByCoreBill) throws BOSException, EASBizException {
        if (this.kDRadioButtonMenuItem2.isSelected()) {
            MsgBox.showWarning((String)this.getStrResource("VeriBy_ContractNum"));
            SysUtil.abort();
        }
        IRow row = null;
        Object numToPair = null;
        Object seqToPair = null;
        Object paymentType = null;
        ArrayList<String> numPair = new ArrayList<String>();
        HashMap values = new HashMap();
        String key = null;
        String seqStrToPair = null;
        ArrayList<String> topKeyList = new ArrayList<String>();
        this.topCheckDataMaq = new HashMap();
        this.bottomCheckDataMaq = new HashMap();
        if (this.kDRadioButtonMenuItem2.isSelected()) {
            this.topCheckDataMaq.put("Bill", "allBill");
            this.bottomCheckDataMaq.put("Bill", "allBill");
        } else {
            this.topCheckDataMaq.put("Bill", "recBill");
            this.bottomCheckDataMaq.put("Bill", "recBill");
        }
        String numFld = fByCoreBill ? TB_COREBILLNUM : TB_CONTRACTNUM;
        String entrySeqFld = fByCoreBill ? TB_COREENTRYSEQ : TB_CONTRACTENTRYSEQ;
        for (int rowIndex = 0; rowIndex < this.getTopTable().getRowCount3(); ++rowIndex) {
            HashMap<String, Boolean> flag = new HashMap<String, Boolean>();
            flag.put("flag", new Boolean(true));
            row = this.getTopTable().getRow(rowIndex);
            numToPair = row.getCell(numFld).getValue();
            seqToPair = row.getCell(entrySeqFld).getValue();
            paymentType = row.getCell("paymenttypeid").getValue();
            if (numToPair == null || seqToPair == null || paymentType == null) continue;
            seqStrToPair = seqToPair.toString();
            this.billType = (VerificateBillTypeEnum)row.getCell("billType").getValue();
            String billEntryID = row.getCell("entryid").getValue().toString();
            Object srcAssActID = row.getCell(this.TB_ASSACTID).getValue();
            BigDecimal unverificateamt = new BigDecimal("0.0");
            if (row.getCell("unVerificateAmt").getValue() != null) {
                unverificateamt = new BigDecimal(row.getCell("unVerificateAmt").getValue().toString());
            }
            if (this.kDRadioButtonMenuItem2.isSelected()) {
                String billID = row.getCell(TB_BILLID).getValue().toString();
                if (!this.topCheckDataMaq.containsKey(billID)) {
                    this.topCheckDataMaq.put(billID, unverificateamt);
                }
            } else if (!this.topCheckDataMaq.containsKey(billEntryID)) {
                this.topCheckDataMaq.put(billEntryID, unverificateamt);
            }
            key = numToPair.toString() + paymentType.toString();
            if (values.containsKey(key)) {
                if (!topKeyList.contains(key)) {
                    topKeyList.add(key);
                    ((Ap2PaymentPairOrderBySeq)values.get(key)).addToTop(rowIndex, seqStrToPair);
                    row.getCell("selected").setValue((Object)Boolean.TRUE);
                    continue;
                }
                ((Ap2PaymentPairOrderBySeq)values.get(key)).addToTop(rowIndex, seqStrToPair);
                row.getCell("selected").setValue((Object)Boolean.TRUE);
                continue;
            }
            if (numPair.contains(key) || this._checkCoreNumAndSeqWithoutSeq(key, rowIndex, values, seqStrToPair, fByCoreBill, srcAssActID, flag) || !((Boolean)flag.get("flag")).booleanValue()) continue;
            numPair.add(key);
        }
        if (this.topCheckDataMaq.size() > 1) {
            ArVerificationFacadeFactory.getRemoteInstance().isDataChanged(this.billType.getValue(), this.topCheckDataMaq);
        }
        this.topCheckDataMaq.clear();
        if (this.bottomCheckDataMaq.size() > 1) {
            ArVerificationFacadeFactory.getRemoteInstance().isDataChanged(this.billType.getValue(), this.bottomCheckDataMaq);
        }
        this.bottomCheckDataMaq.clear();
        return values;
    }

    private HashMap _selectEntrysOneSideWithoutSeq(boolean fByCoreBill) throws BOSException, EASBizException {
        if (this.kDRadioButtonMenuItem2.isSelected()) {
            MsgBox.showWarning((String)this.getStrResource("VeriBy_ContractNum"));
            SysUtil.abort();
        }
        IRow row = null;
        Object numToPair = null;
        Object seqToPair = null;
        Object paymentType = null;
        ArrayList<String> numPair = new ArrayList<String>();
        HashMap values = new HashMap();
        String key = null;
        String seqStrToPair = null;
        ArrayList<String> topKeyList = new ArrayList<String>();
        this.topCheckDataMaq = new HashMap();
        this.bottomCheckDataMaq = new HashMap();
        if (this.kDRadioButtonMenuItem2.isSelected()) {
            this.topCheckDataMaq.put("Bill", "allBill");
            this.bottomCheckDataMaq.put("Bill", "allBill");
        } else {
            this.topCheckDataMaq.put("Bill", "recBill");
            this.bottomCheckDataMaq.put("Bill", "recBill");
        }
        String numFld = fByCoreBill ? TB_COREBILLNUM : TB_CONTRACTNUM;
        String entrySeqFld = fByCoreBill ? TB_COREENTRYSEQ : TB_CONTRACTENTRYSEQ;
        for (int rowIndex = 0; rowIndex < this.getSelectedTable().getRowCount3(); ++rowIndex) {
            HashMap<String, Boolean> flag = new HashMap<String, Boolean>();
            flag.put("flag", new Boolean(true));
            row = this.getSelectedTable().getRow(rowIndex);
            numToPair = row.getCell(numFld).getValue();
            seqToPair = row.getCell(entrySeqFld).getValue();
            paymentType = row.getCell("paymenttypeid").getValue();
            if (numToPair == null || seqToPair == null || paymentType == null) continue;
            seqStrToPair = seqToPair.toString();
            this.billType = (VerificateBillTypeEnum)row.getCell("billType").getValue();
            String billEntryID = row.getCell("entryid").getValue().toString();
            Object srcAssActID = row.getCell(this.TB_ASSACTID).getValue();
            BigDecimal unverificateamt = new BigDecimal("0.0");
            if (row.getCell("unVerificateAmt").getValue() != null) {
                unverificateamt = new BigDecimal(row.getCell("unVerificateAmt").getValue().toString());
            }
            if (this.kDRadioButtonMenuItem2.isSelected()) {
                String billID = row.getCell(TB_BILLID).getValue().toString();
                if (!this.topCheckDataMaq.containsKey(billID)) {
                    this.topCheckDataMaq.put(billID, unverificateamt);
                }
            } else if (!this.topCheckDataMaq.containsKey(billEntryID)) {
                this.topCheckDataMaq.put(billEntryID, unverificateamt);
            }
            key = numToPair.toString() + paymentType.toString();
            if (values.containsKey(key)) {
                if (!topKeyList.contains(key)) {
                    topKeyList.add(key);
                    ((Ap2PaymentPairOrderBySeq)values.get(key)).addToTop(rowIndex, seqStrToPair);
                    row.getCell("selected").setValue((Object)Boolean.TRUE);
                    continue;
                }
                ((Ap2PaymentPairOrderBySeq)values.get(key)).addToTop(rowIndex, seqStrToPair);
                row.getCell("selected").setValue((Object)Boolean.TRUE);
                continue;
            }
            if (numPair.contains(key) || this._checkCoreNumAndSeqOndeSideWithoutSeq(key, rowIndex, values, seqStrToPair, fByCoreBill, srcAssActID, flag) || !((Boolean)flag.get("flag")).booleanValue()) continue;
            numPair.add(key);
        }
        if (this.topCheckDataMaq.size() > 1) {
            ArVerificationFacadeFactory.getRemoteInstance().isDataChanged(this.billType.getValue(), this.topCheckDataMaq);
        }
        this.topCheckDataMaq.clear();
        if (this.bottomCheckDataMaq.size() > 1) {
            ArVerificationFacadeFactory.getRemoteInstance().isDataChanged(this.billType.getValue(), this.bottomCheckDataMaq);
        }
        this.bottomCheckDataMaq.clear();
        return values;
    }

    private boolean _checkCoreNumAndSeqWithoutSeq(String key, int srcRowIndex, HashMap hm, String srcCoreSeq, boolean fByCoreBill, Object srcAssActID, HashMap flag) {
        IRow row = null;
        Object desMatchNum = null;
        Object desMatchSeq = null;
        Object desAssActID = null;
        Object paymentType = null;
        boolean contain = false;
        Ap2PaymentPairOrderBySeq pair = null;
        String desMatchSeqStr = null;
        String numFld = fByCoreBill ? TB_COREBILLNUM : TB_CONTRACTNUM;
        String entrySeqFld = fByCoreBill ? TB_COREENTRYSEQ : TB_CONTRACTENTRYSEQ;
        for (int j = 0; j < this.getBottomTable().getRowCount3(); ++j) {
            row = this.getBottomTable().getRow(j);
            desMatchNum = row.getCell(numFld).getValue();
            desMatchSeq = row.getCell(entrySeqFld).getValue();
            desAssActID = row.getCell(this.TB_ASSACTID).getValue();
            paymentType = row.getCell("paymenttypeid").getValue();
            if (desMatchNum == null || desMatchSeq == null) continue;
            desMatchSeqStr = desMatchSeq.toString();
            if (!key.equals(desMatchNum.toString() + paymentType.toString())) continue;
            if (!srcAssActID.equals(desAssActID)) {
                flag.put("flag", new Boolean(false));
                continue;
            }
            this.billType = (VerificateBillTypeEnum)row.getCell("billType").getValue();
            String billEntryID = row.getCell("entryid").getValue().toString();
            BigDecimal unverificateamt = new BigDecimal("0.0");
            if (row.getCell("unVerificateAmt").getValue() != null) {
                unverificateamt = new BigDecimal(row.getCell("unVerificateAmt").getValue().toString());
            }
            if (this.kDRadioButtonMenuItem2.isSelected()) {
                String billID = row.getCell(TB_BILLID).getValue().toString();
                if (!this.bottomCheckDataMaq.containsKey(billID)) {
                    this.bottomCheckDataMaq.put(billID, unverificateamt);
                }
            } else if (!this.bottomCheckDataMaq.containsKey(billEntryID)) {
                this.bottomCheckDataMaq.put(billEntryID, unverificateamt);
            }
            if (!hm.containsKey(key)) {
                pair = new Ap2PaymentPairOrderBySeq(desMatchNum.toString(), "");
                pair.addToTop(srcRowIndex, srcCoreSeq);
                hm.put(key, pair);
                row.getCell("selected").setValue((Object)Boolean.TRUE);
                this.getTopTable().getCell(srcRowIndex, "selected").setValue((Object)Boolean.TRUE);
                pair.addToBottom(j, desMatchSeqStr);
                contain = true;
                continue;
            }
            Ap2PaymentPairOrderBySeq aPair = (Ap2PaymentPairOrderBySeq)hm.get(key);
            aPair.addToBottom(j, desMatchSeqStr);
        }
        return contain;
    }

    private boolean _checkCoreNumAndSeqOndeSideWithoutSeq(String key, int srcRowIndex, HashMap hm, String srcCoreSeq, boolean fByCoreBill, Object srcAssActID, HashMap flag) {
        IRow row = null;
        Object desMatchNum = null;
        Object desMatchSeq = null;
        Object desAssActID = null;
        Object paymentType = null;
        boolean contain = false;
        Ap2PaymentPairOrderBySeq pair = null;
        String desMatchSeqStr = null;
        String numFld = fByCoreBill ? TB_COREBILLNUM : TB_CONTRACTNUM;
        String entrySeqFld = fByCoreBill ? TB_COREENTRYSEQ : TB_CONTRACTENTRYSEQ;
        for (int j = 0; j < this.getSelectedTable().getRowCount3(); ++j) {
            row = this.getSelectedTable().getRow(j);
            desMatchNum = row.getCell(numFld).getValue();
            desMatchSeq = row.getCell(entrySeqFld).getValue();
            desAssActID = row.getCell(this.TB_ASSACTID).getValue();
            paymentType = row.getCell("paymenttypeid").getValue();
            if (desMatchNum == null || desMatchSeq == null) continue;
            desMatchSeqStr = desMatchSeq.toString();
            if (!key.equals(desMatchNum.toString() + paymentType.toString())) continue;
            if (!srcAssActID.equals(desAssActID)) {
                flag.put("flag", new Boolean(false));
                continue;
            }
            this.billType = (VerificateBillTypeEnum)row.getCell("billType").getValue();
            String billEntryID = row.getCell("entryid").getValue().toString();
            BigDecimal unverificateamt = new BigDecimal("0.0");
            if (row.getCell("unVerificateAmt").getValue() != null) {
                unverificateamt = new BigDecimal(row.getCell("unVerificateAmt").getValue().toString());
            }
            if (this.kDRadioButtonMenuItem2.isSelected()) {
                String billID = row.getCell(TB_BILLID).getValue().toString();
                if (!this.bottomCheckDataMaq.containsKey(billID)) {
                    this.bottomCheckDataMaq.put(billID, unverificateamt);
                }
            } else if (!this.bottomCheckDataMaq.containsKey(billEntryID)) {
                this.bottomCheckDataMaq.put(billEntryID, unverificateamt);
            }
            if (!hm.containsKey(key)) {
                pair = new Ap2PaymentPairOrderBySeq(desMatchNum.toString(), "");
                pair.addToTop(srcRowIndex, srcCoreSeq);
                hm.put(key, pair);
                row.getCell("selected").setValue((Object)Boolean.TRUE);
                this.getSelectedTable().getCell(srcRowIndex, "selected").setValue((Object)Boolean.TRUE);
                pair.addToBottom(j, desMatchSeqStr);
                contain = true;
                continue;
            }
            Ap2PaymentPairOrderBySeq aPair = (Ap2PaymentPairOrderBySeq)hm.get(key);
            aPair.addToBottom(j, desMatchSeqStr);
        }
        return contain;
    }

    private Collection veriOneEntryWithoutSeq(Ap2PaymentPairOrderBySeq pair) throws EASBizException, BOSException, Exception {
        Iterator topIter = null;
        Iterator botIter = null;
        ArrayList<String> verifyIDs = new ArrayList<String>();
        int topIndex = 0;
        int botIndex = 0;
        KDTable topTable = this.getTopTable();
        KDTable botTable = this.getBottomTable();
        BigDecimal topUnVeriAmt = null;
        BigDecimal botUnVeriAmt = null;
        BigDecimal thisVeriAmt = null;
        VerificationBillInfo verificaionBill = null;
        String topAssActID = null;
        String botAssActID = null;
        BigDecimal newTopUnVeriAmt = null;
        Ap2PaymentRowValue topValue = null;
        Ap2PaymentRowValue bottomValue = null;
        topIter = pair.getTop().iterator();
        verificaionBill = new VerificationBillInfo();
        verificaionBill.setCompany(this.currentCompany);
        verificaionBill.setBizDate(this.dtVerificationDate.getTimestamp());
        verificaionBill.setCreator(this.defaultUserInfo);
        verificaionBill.setIsSameCurrency(this.isSameCurrency);
        VerificationBillentryCollection entrys = verificaionBill.getEntrys();
        while (topIter.hasNext()) {
            topValue = (Ap2PaymentRowValue)topIter.next();
            topIndex = topValue.getRowIndex();
            topUnVeriAmt = (BigDecimal)topTable.getCell(topIndex, TB_THISVERIAMT).getValue();
            newTopUnVeriAmt = (BigDecimal)topTable.getCell(topIndex, TB_THISVERIAMT).getValue();
            topAssActID = topTable.getCell(topIndex, this.TB_ASSACTID).getValue().toString();
            botIter = pair.getBottom().iterator();
            while (topUnVeriAmt.compareTo(this.ZERO) != 0 && botIter.hasNext()) {
                bottomValue = (Ap2PaymentRowValue)botIter.next();
                botIndex = bottomValue.getRowIndex();
                botUnVeriAmt = (BigDecimal)botTable.getCell(botIndex, TB_THISVERIAMT).getValue();
                botAssActID = botTable.getCell(botIndex, this.TB_ASSACTID).getValue().toString();
                thisVeriAmt = botUnVeriAmt;
                if (topUnVeriAmt.multiply(botUnVeriAmt).compareTo(new BigDecimal("0.0")) < 0) continue;
                newTopUnVeriAmt = (BigDecimal)topTable.getCell(topIndex, TB_THISVERIAMT).getValue();
                if (botUnVeriAmt.compareTo(this.ZERO) == 0 || newTopUnVeriAmt.compareTo(this.ZERO) == 0) continue;
                if (botUnVeriAmt.abs().compareTo(topUnVeriAmt.abs()) > 0) {
                    thisVeriAmt = topUnVeriAmt;
                }
                if (newTopUnVeriAmt.compareTo(topUnVeriAmt) != 0 && botUnVeriAmt.abs().compareTo(newTopUnVeriAmt.abs()) > 0) {
                    thisVeriAmt = newTopUnVeriAmt;
                }
                entrys.add(this.createVerificationEntryWithoutSeq(topTable, topIndex, thisVeriAmt, true, false));
                entrys.add(this.createVerificationEntryWithoutSeq(botTable, botIndex, thisVeriAmt, false, false));
            }
        }
        verificaionBill.setMainBillType(VerificateBillTypeEnum.OtherPaymentBill);
        verificaionBill.setSecondBillType(VerificateBillTypeEnum.PaymentBill);
        this.setVerificationBillInfoWithoutSeq(verificaionBill, topAssActID, botAssActID);
        verifyIDs.add(VerificationBillFactory.getRemoteInstance().submit((CoreBaseInfo)verificaionBill).toString());
        return verifyIDs;
    }

    private Collection veriOneEntryOneSideWithoutSeq(Ap2PaymentPairOrderBySeq pair) throws EASBizException, BOSException, Exception {
        Iterator topIter = null;
        Iterator botIter = null;
        ArrayList<String> verifyIDs = new ArrayList<String>();
        int topIndex = 0;
        int botIndex = 0;
        KDTable selTable = this.getSelectedTable();
        BigDecimal topUnVeriAmt = null;
        BigDecimal botUnVeriAmt = null;
        BigDecimal thisVeriAmt = null;
        VerificationBillInfo verificaionBill = null;
        String topAssActID = null;
        String botAssActID = null;
        BigDecimal newTopUnVeriAmt = null;
        Ap2PaymentRowValue topValue = null;
        Ap2PaymentRowValue bottomValue = null;
        String posBill = "positive";
        String negBill = "negetive";
        String billFlag = "";
        BigDecimal thisTopVeriAmt = this.ZERO;
        BigDecimal thisBotVeriAmt = this.ZERO;
        BigDecimal billPosAmt = this.ZERO;
        BigDecimal billNegAmt = this.ZERO;
        billPosAmt = this.sumPosAmt(selTable, pair.getTop());
        billNegAmt = this.sumNegAmt(selTable, pair.getBottom());
        if (billPosAmt.compareTo(this.ZERO) == 0 || billNegAmt.compareTo(this.ZERO) == 0) {
            return new ArrayList();
        }
        billFlag = billPosAmt.abs().compareTo(billNegAmt.abs()) > 0 ? posBill : negBill;
        topIter = pair.getTop().iterator();
        verificaionBill = new VerificationBillInfo();
        verificaionBill.setCompany(this.currentCompany);
        verificaionBill.setBizDate(this.dtVerificationDate.getTimestamp());
        verificaionBill.setCreator(this.defaultUserInfo);
        verificaionBill.setIsSameCurrency(this.isSameCurrency);
        VerificationBillentryCollection entrys = verificaionBill.getEntrys();
        block0: for (int topCounter = 0; topCounter < pair.getTop().size(); ++topCounter) {
            topValue = (Ap2PaymentRowValue)topIter.next();
            topIndex = topValue.getRowIndex();
            topUnVeriAmt = (BigDecimal)selTable.getCell(topIndex, TB_THISVERIAMT).getValue();
            newTopUnVeriAmt = (BigDecimal)selTable.getCell(topIndex, TB_THISVERIAMT).getValue();
            topAssActID = selTable.getCell(topIndex, this.TB_ASSACTID).getValue().toString();
            botIter = pair.getBottom().iterator();
            if (posBill.equals(billFlag) && topUnVeriAmt.signum() < 0 || negBill.equals(billFlag) && topUnVeriAmt.signum() > 0) continue;
            for (int botCounter = 0; botCounter < pair.getBottom().size(); ++botCounter) {
                bottomValue = (Ap2PaymentRowValue)botIter.next();
                botIndex = bottomValue.getRowIndex();
                botUnVeriAmt = (BigDecimal)selTable.getCell(botIndex, TB_THISVERIAMT).getValue();
                botAssActID = selTable.getCell(botIndex, this.TB_ASSACTID).getValue().toString();
                thisVeriAmt = botUnVeriAmt;
                if (posBill.equals(billFlag) && botUnVeriAmt.signum() > 0 || negBill.equals(billFlag) && botUnVeriAmt.signum() < 0 || botUnVeriAmt.signum() == 0) continue;
                newTopUnVeriAmt = (BigDecimal)selTable.getCell(topIndex, TB_THISVERIAMT).getValue();
                if (botUnVeriAmt.compareTo(this.ZERO) != 0 && newTopUnVeriAmt.compareTo(this.ZERO) != 0) {
                    if (billPosAmt.abs().compareTo(this.ZERO) > 0 || billNegAmt.abs().compareTo(this.ZERO) > 0) {
                        if (posBill.equals(billFlag)) {
                            if (topUnVeriAmt.abs().compareTo(botUnVeriAmt.abs()) > 0) {
                                if (billNegAmt.abs().compareTo(botUnVeriAmt.abs()) > 0) {
                                    thisTopVeriAmt = botUnVeriAmt.negate();
                                    thisBotVeriAmt = botUnVeriAmt;
                                    billPosAmt = billPosAmt.add(botUnVeriAmt);
                                    billNegAmt = billNegAmt.add(botUnVeriAmt.negate());
                                } else {
                                    thisTopVeriAmt = botUnVeriAmt.negate();
                                    thisBotVeriAmt = botUnVeriAmt;
                                    billPosAmt = billPosAmt.add(botUnVeriAmt);
                                    billNegAmt = this.ZERO;
                                }
                            } else {
                                thisTopVeriAmt = topUnVeriAmt;
                                thisBotVeriAmt = topUnVeriAmt.negate();
                                billPosAmt = billPosAmt.add(topUnVeriAmt.negate());
                                billNegAmt = billNegAmt.add(topUnVeriAmt);
                            }
                        } else if (topUnVeriAmt.abs().compareTo(botUnVeriAmt.abs()) < 0) {
                            if (billPosAmt.abs().compareTo(topUnVeriAmt.abs()) > 0) {
                                thisTopVeriAmt = topUnVeriAmt;
                                thisBotVeriAmt = topUnVeriAmt.negate();
                                billPosAmt = billPosAmt.add(topUnVeriAmt.negate());
                                billNegAmt = billNegAmt.add(topUnVeriAmt);
                            } else {
                                thisTopVeriAmt = topUnVeriAmt;
                                thisBotVeriAmt = topUnVeriAmt.negate();
                                billPosAmt = this.ZERO;
                                billNegAmt = billNegAmt.add(topUnVeriAmt);
                            }
                        } else {
                            thisTopVeriAmt = botUnVeriAmt.negate();
                            thisBotVeriAmt = botUnVeriAmt;
                            billPosAmt = billPosAmt.add(botUnVeriAmt);
                            billNegAmt = billNegAmt.add(botUnVeriAmt.negate());
                        }
                    }
                    entrys.add(this.createVerificationEntryWithoutSeq(selTable, topIndex, thisTopVeriAmt, true, true));
                    entrys.add(this.createVerificationEntryWithoutSeq(selTable, botIndex, thisBotVeriAmt, false, true));
                }
                topUnVeriAmt = (BigDecimal)selTable.getCell(topIndex, TB_THISVERIAMT).getValue();
                botUnVeriAmt = (BigDecimal)selTable.getCell(botIndex, TB_THISVERIAMT).getValue();
                if (topUnVeriAmt.compareTo(this.ZERO) == 0) continue block0;
            }
        }
        if (this.getSelectedTableCount() == 1) {
            verificaionBill.setMainBillType(VerificateBillTypeEnum.OtherPaymentBill);
            verificaionBill.setSecondBillType(VerificateBillTypeEnum.OtherPaymentBill);
        }
        if (this.getSelectedTableCount() == -1) {
            verificaionBill.setMainBillType(VerificateBillTypeEnum.PaymentBill);
            verificaionBill.setSecondBillType(VerificateBillTypeEnum.PaymentBill);
        }
        this.setVerificationBillInfoWithoutSeq(verificaionBill, topAssActID, botAssActID);
        verifyIDs.add(VerificationBillFactory.getRemoteInstance().submit((CoreBaseInfo)verificaionBill).toString());
        return verifyIDs;
    }

    private KDTable getSelectedTable() {
        int flag = this.getSelectedTableCount();
        if (flag == 1) {
            return this.getTopTable();
        }
        if (flag == -1) {
            return this.getBottomTable();
        }
        return null;
    }

    private BigDecimal sumPosAmt(KDTable table, List aList) {
        BigDecimal sigAmt = this.ZERO;
        for (int i = 0; i < aList.size(); ++i) {
            BigDecimal rowAmt;
            Ap2PaymentRowValue row;
            Object obj;
            if (!(aList.get(i) instanceof Ap2PaymentRowValue) || !((obj = table.getCell((row = (Ap2PaymentRowValue)aList.get(i)).getRowIndex().intValue(), TB_THISVERIAMT).getValue()) instanceof BigDecimal) || (rowAmt = (BigDecimal)obj).compareTo(this.ZERO) <= 0) continue;
            sigAmt = sigAmt.add(rowAmt);
        }
        return sigAmt;
    }

    private BigDecimal sumNegAmt(KDTable table, List aList) {
        BigDecimal sigAmt = this.ZERO;
        for (int i = 0; i < aList.size(); ++i) {
            BigDecimal rowAmt;
            Ap2PaymentRowValue row;
            Object obj;
            if (!(aList.get(i) instanceof Ap2PaymentRowValue) || !((obj = table.getCell((row = (Ap2PaymentRowValue)aList.get(i)).getRowIndex().intValue(), TB_THISVERIAMT).getValue()) instanceof BigDecimal) || (rowAmt = (BigDecimal)obj).compareTo(this.ZERO) >= 0) continue;
            sigAmt = sigAmt.add(rowAmt);
        }
        return sigAmt;
    }

    private void setVerificationBillInfoWithoutSeq(VerificationBillInfo verificaionBill, String topAssActID, String botAssActID) throws BOSException {
        AsstActTypeInfo mainAssActType = null;
        AsstActTypeInfo secondAssActType = null;
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.assActTypeId));
        ObjectUuidPK pkTo = new ObjectUuidPK(BOSUuid.read((String)this.assActTypeIdTo));
        try {
            mainAssActType = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)pk);
            secondAssActType = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)pkTo);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        IObjectValue objValue = this.getBizObject(topAssActID);
        String mainAssActID = objValue.getString("id");
        String mainAcctCussName = objValue.getString("name");
        objValue = this.getBizObject(botAssActID);
        String secondAssActID = objValue.getString("id");
        String secondAcctCussName = objValue.getString("name");
        CurrencyInfo mainCurrency = this.topCurrency;
        CurrencyInfo secondCurrency = this.bottomCurrency;
        verificaionBill.put("mainAcctCussType", mainAssActType);
        verificaionBill.put("mainAcctCussID", BOSUuid.read((String)mainAssActID));
        verificaionBill.put("mainAcctCussName", mainAcctCussName);
        verificaionBill.put("mainCurrency", mainCurrency);
        verificaionBill.put("secondAcctCussType", secondAssActType);
        verificaionBill.put("secondAcctCussID", BOSUuid.read((String)secondAssActID));
        verificaionBill.put("secondAcctCussName", secondAcctCussName);
        verificaionBill.put("secondCurrency", secondCurrency);
        boolean isSameCode = ArApClientHelper.isSameBizCode(topAssActID, botAssActID);
        VerificationEnum veriType = VerificationEnum.AP_Pay;
        if (!isSameCode) {
            veriType = VerificationEnum.AP_Pay_AB;
        }
        verificaionBill.setVerificationType(veriType);
        verificaionBill.setIsSameCode(isSameCode);
    }

    private VerificationBillentryInfo createVerificationEntryWithoutSeq(KDTable table, int rowIndex, BigDecimal amt, boolean isFromTop, boolean isOneSide) {
        VerificationBillentryInfo entryInfo = new VerificationBillentryInfo();
        IRow row = table.getRow(rowIndex);
        int billTypeEnum = ((VerificateBillTypeEnum)row.getCell("billType").getValue()).getValue();
        isFromTop = billTypeEnum != 6;
        if (isFromTop) {
            entryInfo.put(IS_FROM_TOP, Boolean.TRUE);
            entryInfo.setCurrency(this.topCurrency);
        } else {
            entryInfo.put(IS_FROM_TOP, Boolean.FALSE);
            entryInfo.setCurrency(this.bottomCurrency);
        }
        entryInfo.setBillType((VerificateBillTypeEnum)row.getCell("billType").getValue());
        if (row.getCell("billSubType").getValue() != null) {
            entryInfo.setBillSubType((VerificateBillTypeEnum)row.getCell("billSubType").getValue());
        }
        entryInfo.setBillID(BOSUuid.read((String)row.getCell(TB_BILLID).getValue().toString()));
        entryInfo.setEntryID(BOSUuid.read((String)row.getCell("entryid").getValue().toString()));
        entryInfo.setBillNumber(row.getCell("number").getValue().toString());
        entryInfo.setBillDate((Date)row.getCell(TB_BILLDATE).getValue());
        entryInfo.setAcctCussType((AsstActTypeInfo)row.getCell("acctCussType").getValue());
        entryInfo.setAcctCussID(BOSUuid.read((String)row.getCell("acctCussID").getValue().toString()));
        entryInfo.setAcctCussName(row.getCell("acctCussName").getValue().toString());
        if (row.getCell("accountID").getValue() != null && row.getCell("accountID").getValue().toString().trim().length() > 0) {
            AccountViewInfo account = new AccountViewInfo();
            account.setId(BOSUuid.read((String)row.getCell("accountID").getValue().toString()));
            entryInfo.setAccount(account);
        }
        if (row.getCell("adminOrgUnit").getValue() != null && row.getCell("adminOrgUnit").getValue().toString().trim().length() > 0) {
            AdminOrgUnitInfo adminOrgUnit = new AdminOrgUnitInfo();
            adminOrgUnit.setId(BOSUuid.read((String)row.getCell("adminOrgUnit").getValue().toString()));
            entryInfo.setAdminOrgUnit(adminOrgUnit);
        }
        if (row.getCell("personID").getValue() != null && row.getCell("personID").getValue().toString().trim().length() > 0) {
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)row.getCell("personID").getValue().toString()));
            entryInfo.setPerson(person);
        }
        if (row.getCell("materialId") != null && row.getCell("materialId").getValue() != null && row.getCell("materialId").getValue().toString().trim().length() > 0) {
            entryInfo.setMaterialId(BOSUuid.read((String)row.getCell("materialId").getValue().toString()));
        }
        if (row.getCell("materialNumber") != null && row.getCell("materialNumber").getValue() != null && row.getCell("materialNumber").getValue().toString().trim().length() > 0) {
            entryInfo.setMaterialNumber(row.getCell("materialNumber").getValue().toString());
        }
        if (row.getCell("materialName") != null && row.getCell("materialName").getValue() != null && row.getCell("materialName").getValue().toString().trim().length() > 0) {
            entryInfo.setMaterialName(row.getCell("materialName").getValue().toString());
        }
        if (row.getCell("veriRecPayTypeId") != null && row.getCell("veriRecPayTypeId").getValue() != null) {
            entryInfo.setVeriRecPayTypeId(BOSUuid.read((String)row.getCell("veriRecPayTypeId").getValue().toString()));
            entryInfo.setVeriRecPayTypeName(row.getCell("veriRecPayTypeName").getValue().toString());
            entryInfo.setVeriRecPayTypeNumber(row.getCell("veriRecPayTypeNumber").getValue().toString());
        }
        BigDecimal thisVeriAmt = null;
        BigDecimal unVeriAmt = null;
        BigDecimal unVeriAmtLoc = null;
        BigDecimal thisVeriAmtLoc = null;
        if (amt == null) {
            thisVeriAmt = new BigDecimal(row.getCell(TB_THISVERIAMT).getValue().toString());
            thisVeriAmt = thisVeriAmt.setScale(this.topCurrency.getPrecision(), 4);
            thisVeriAmtLoc = new BigDecimal(row.getCell(TB_THISVERIAMTLOC).getValue().toString());
            thisVeriAmtLoc = thisVeriAmtLoc.setScale(this.baseCurrency.getPrecision(), 4);
        } else {
            thisVeriAmt = amt;
            unVeriAmt = new BigDecimal(row.getCell(TB_THISVERIAMT).getValue().toString());
            unVeriAmtLoc = new BigDecimal(row.getCell(TB_THISVERIAMTLOC).getValue().toString());
            thisVeriAmtLoc = amt.multiply((BigDecimal)row.getCell("exchangeRate").getValue());
            thisVeriAmtLoc = thisVeriAmtLoc.setScale(this.baseCurrency.getPrecision(), 4);
            if (thisVeriAmt.compareTo(unVeriAmt) == 0) {
                thisVeriAmtLoc = unVeriAmtLoc;
            }
            row.getCell(TB_THISVERIAMT).setValue((Object)unVeriAmt.subtract(thisVeriAmt));
            row.getCell(TB_THISVERIAMTLOC).setValue((Object)unVeriAmtLoc.subtract(thisVeriAmtLoc));
        }
        entryInfo.setThisVerificateAmt(thisVeriAmt);
        entryInfo.setThisVerificateAmtLoc(thisVeriAmtLoc);
        if (row.getCell("description").getValue() == null) {
            entryInfo.setComment("");
        } else {
            entryInfo.setComment(row.getCell("description").getValue().toString());
        }
        if (isOneSide) {
            entryInfo.setVeriType(true);
        }
        return entryInfo;
    }

    public void releaseLocks(List lockList) {
        if (lockList != null && lockList.size() > 0) {
            this.iMutexServiceControl.batchReleaseObjIDForUpdate(lockList);
        }
        if (lockList != null) {
            lockList.clear();
        }
    }

    private CoreBaseCollection veriOneEntry(Ap2PaymentPair pair) throws EASBizException, BOSException, Exception {
        Iterator topIter = null;
        Iterator botIter = null;
        CoreBaseCollection verifBillColl = new CoreBaseCollection();
        int topIndex = 0;
        int botIndex = 0;
        KDTable topTable = this.getTopTable();
        KDTable botTable = this.getBottomTable();
        BigDecimal topUnVeriAmt = null;
        BigDecimal botUnVeriAmt = null;
        BigDecimal thisVeriAmt = null;
        BigDecimal thisVeriAmtLoc = null;
        String topAssActID = null;
        String botAssActID = null;
        String topAssActName = null;
        String botAssActName = null;
        topIter = pair.getTop().iterator();
        HashMap<Object, VerificationBillentryInfo> verificaionBillEntryMap = new HashMap<Object, VerificationBillentryInfo>();
        VerificationBillInfo verificaionBill = null;
        VerificationBillentryInfo verificaionBillEntry = null;
        while (topIter.hasNext()) {
            topIndex = (Integer)topIter.next();
            topAssActID = topTable.getCell(topIndex, this.TB_ASSACTID).getValue().toString();
            topAssActName = topTable.getCell(topIndex, this.TB_ASSACTNAME).getValue().toString();
            botIter = pair.getBottom().iterator();
            while (botIter.hasNext() && (topUnVeriAmt = (BigDecimal)topTable.getCell(topIndex, TB_THISVERIAMT).getValue()).compareTo(this.ZERO) != 0) {
                botIndex = (Integer)botIter.next();
                botUnVeriAmt = (BigDecimal)botTable.getCell(botIndex, TB_THISVERIAMT).getValue();
                botAssActID = botTable.getCell(botIndex, this.TB_ASSACTID).getValue().toString();
                botAssActName = botTable.getCell(botIndex, this.TB_ASSACTNAME).getValue().toString();
                thisVeriAmt = botUnVeriAmt;
                if (topUnVeriAmt.multiply(botUnVeriAmt).compareTo(new BigDecimal("0.0")) < 0 || botUnVeriAmt.compareTo(this.ZERO) == 0) continue;
                if (verifBillColl.size() == 0) {
                    verificaionBill = new VerificationBillInfo();
                    verificaionBill.setCompany(this.currentCompany);
                    verificaionBill.setBizDate(this.dtVerificationDate.getTimestamp());
                    verificaionBill.setCreator(this.defaultUserInfo);
                    verificaionBill.setIsSameCurrency(this.isSameCurrency);
                    verificaionBill.setMainBillType(VerificateBillTypeEnum.OtherPaymentBill);
                    verificaionBill.setSecondBillType(VerificateBillTypeEnum.PaymentBill);
                    verificaionBill.setVerificationType(VerificationEnum.AP_Pay);
                    verificaionBill.setIsSameCode(true);
                    verificaionBill.put("mainCurrency", this.topCurrency);
                    verificaionBill.put("secondCurrency", this.bottomCurrency);
                    AsstActTypeInfo mainAssActType = new AsstActTypeInfo();
                    mainAssActType.setId(BOSUuid.read((String)this.assActTypeId));
                    verificaionBill.put("mainAcctCussType", mainAssActType);
                    AsstActTypeInfo secondAssActType = new AsstActTypeInfo();
                    secondAssActType.setId(BOSUuid.read((String)this.assActTypeIdTo));
                    verificaionBill.put("secondAcctCussType", secondAssActType);
                    verificaionBill.put("mainAcctCussID", BOSUuid.read((String)topAssActID));
                    verificaionBill.put("mainAcctCussName", topAssActName);
                    verificaionBill.put("secondAcctCussID", BOSUuid.read((String)botAssActID));
                    verificaionBill.put("secondAcctCussName", botAssActName);
                    verifBillColl.add((CoreBaseInfo)verificaionBill);
                } else {
                    verificaionBill = (VerificationBillInfo)verifBillColl.get(0);
                }
                if (botUnVeriAmt.abs().compareTo(topUnVeriAmt.abs()) > 0) {
                    thisVeriAmt = topUnVeriAmt;
                    thisVeriAmtLoc = (BigDecimal)topTable.getCell(topIndex, TB_THISVERIAMTLOC).getValue();
                } else {
                    thisVeriAmtLoc = (BigDecimal)botTable.getCell(botIndex, TB_THISVERIAMTLOC).getValue();
                }
                if (verificaionBillEntryMap.containsKey(topTable.getCell(topIndex, "entryid").getValue())) {
                    verificaionBillEntry = (VerificationBillentryInfo)verificaionBillEntryMap.get(topTable.getCell(topIndex, "entryid").getValue());
                    verificaionBillEntry.setThisVerificateAmt(verificaionBillEntry.getThisVerificateAmt().add(thisVeriAmt));
                    verificaionBillEntry.setThisVerificateAmtLoc(verificaionBillEntry.getThisVerificateAmtLoc().add(thisVeriAmtLoc));
                } else {
                    verificaionBillEntry = this.createVerificationEntry(topTable, topIndex, thisVeriAmt, true);
                    verificaionBillEntryMap.put(topTable.getCell(topIndex, "entryid").getValue(), verificaionBillEntry);
                    verificaionBill.getEntrys().add(verificaionBillEntry);
                }
                if (verificaionBillEntryMap.containsKey(botTable.getCell(botIndex, "entryid").getValue())) {
                    verificaionBillEntry = (VerificationBillentryInfo)verificaionBillEntryMap.get(botTable.getCell(botIndex, "entryid").getValue());
                    verificaionBillEntry.setThisVerificateAmt(verificaionBillEntry.getThisVerificateAmt().add(thisVeriAmt));
                    verificaionBillEntry.setThisVerificateAmtLoc(verificaionBillEntry.getThisVerificateAmtLoc().add(thisVeriAmtLoc));
                    continue;
                }
                verificaionBillEntry = this.createVerificationEntry(botTable, botIndex, thisVeriAmt, false);
                verificaionBillEntryMap.put(botTable.getCell(botIndex, "entryid").getValue(), verificaionBillEntry);
                verificaionBill.getEntrys().add(verificaionBillEntry);
            }
        }
        return verifBillColl;
    }

    private boolean _checkVeriCondition(KDTable table) {
        Date date = (Date)this.dtVerificationDate.getValue();
        int rowCount = table.getRowCount3();
        Date billDate = null;
        for (int i = 0; i < rowCount; ++i) {
            if (!table.getCell(i, "selected").getValue().equals(Boolean.TRUE) || !date.before(billDate = (Date)table.getCell(i, TB_BILLDATE).getValue())) continue;
            MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("ap_verify_verDateIsError"));
            return false;
        }
        return true;
    }

    private void setVerificationBillInfo(VerificationBillInfo verificaionBill, String topAssActID, String topAssActName, String botAssActID, String botAssActName) throws BOSException {
        AsstActTypeInfo mainAssActType = null;
        AsstActTypeInfo secondAssActType = null;
        boolean isSameCode = false;
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.assActTypeId));
        ObjectUuidPK pkTo = new ObjectUuidPK(BOSUuid.read((String)this.assActTypeIdTo));
        try {
            mainAssActType = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)pk);
            secondAssActType = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)pkTo);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        CurrencyInfo mainCurrency = this.topCurrency;
        CurrencyInfo secondCurrency = this.bottomCurrency;
        verificaionBill.put("mainAcctCussType", mainAssActType);
        verificaionBill.put("mainAcctCussID", BOSUuid.read((String)topAssActID));
        verificaionBill.put("mainAcctCussName", topAssActName);
        verificaionBill.put("mainCurrency", mainCurrency);
        verificaionBill.put("secondAcctCussType", secondAssActType);
        verificaionBill.put("secondAcctCussID", BOSUuid.read((String)botAssActID));
        verificaionBill.put("secondAcctCussName", botAssActName);
        verificaionBill.put("secondCurrency", secondCurrency);
        isSameCode = ArApClientHelper.isSameBizCode(topAssActID, botAssActID);
        VerificationEnum veriType = VerificationEnum.AP_Pay;
        if (!isSameCode) {
            veriType = VerificationEnum.AP_Pay_AB;
        }
        verificaionBill.setVerificationType(veriType);
        verificaionBill.setIsSameCode(isSameCode);
    }

    private VerificationBillentryInfo createVerificationEntry(KDTable table, int rowIndex, BigDecimal amt, boolean isFromTop) {
        VerificationBillentryInfo entryInfo = new VerificationBillentryInfo();
        if (isFromTop) {
            entryInfo.put(IS_FROM_TOP, Boolean.TRUE);
        } else {
            entryInfo.put(IS_FROM_TOP, Boolean.FALSE);
        }
        IRow row = table.getRow(rowIndex);
        entryInfo.setBillType((VerificateBillTypeEnum)row.getCell("billType").getValue());
        if (row.getCell("billSubType").getValue() != null) {
            entryInfo.setBillSubType((VerificateBillTypeEnum)row.getCell("billSubType").getValue());
        }
        entryInfo.setCurrency(this.topCurrency);
        entryInfo.setBillID(BOSUuid.read((String)row.getCell(TB_BILLID).getValue().toString()));
        entryInfo.setEntryID(BOSUuid.read((String)row.getCell("entryid").getValue().toString()));
        entryInfo.setBillNumber(row.getCell("number").getValue().toString());
        entryInfo.setBillDate((Date)row.getCell(TB_BILLDATE).getValue());
        entryInfo.setAcctCussType((AsstActTypeInfo)row.getCell("acctCussType").getValue());
        entryInfo.setAcctCussID(BOSUuid.read((String)row.getCell("acctCussID").getValue().toString()));
        entryInfo.setAcctCussName(row.getCell("acctCussName").getValue().toString());
        if (row.getCell("accountID").getValue() != null && row.getCell("accountID").getValue().toString().trim().length() > 0) {
            AccountViewInfo account = new AccountViewInfo();
            account.setId(BOSUuid.read((String)row.getCell("accountID").getValue().toString()));
            entryInfo.setAccount(account);
        }
        if (row.getCell("adminOrgUnit").getValue() != null && row.getCell("adminOrgUnit").getValue().toString().trim().length() > 0) {
            AdminOrgUnitInfo adminOrgUnit = new AdminOrgUnitInfo();
            adminOrgUnit.setId(BOSUuid.read((String)row.getCell("adminOrgUnit").getValue().toString()));
            entryInfo.setAdminOrgUnit(adminOrgUnit);
        }
        if (row.getCell("personID").getValue() != null && row.getCell("personID").getValue().toString().trim().length() > 0) {
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)row.getCell("personID").getValue().toString()));
            entryInfo.setPerson(person);
        }
        if (row.getCell("materialId") != null && row.getCell("materialId").getValue() != null && row.getCell("materialId").getValue().toString().trim().length() > 0) {
            entryInfo.setMaterialId(BOSUuid.read((String)row.getCell("materialId").getValue().toString()));
        }
        if (row.getCell("materialNumber") != null && row.getCell("materialNumber").getValue() != null && row.getCell("materialNumber").getValue().toString().trim().length() > 0) {
            entryInfo.setMaterialNumber(row.getCell("materialNumber").getValue().toString());
        }
        if (row.getCell("materialName") != null && row.getCell("materialName").getValue() != null && row.getCell("materialName").getValue().toString().trim().length() > 0) {
            entryInfo.setMaterialName(row.getCell("materialName").getValue().toString());
        }
        if (row.getCell("veriRecPayTypeId") != null && row.getCell("veriRecPayTypeId").getValue() != null) {
            entryInfo.setVeriRecPayTypeId(BOSUuid.read((String)row.getCell("veriRecPayTypeId").getValue().toString()));
            entryInfo.setVeriRecPayTypeName(row.getCell("veriRecPayTypeName").getValue().toString());
            entryInfo.setVeriRecPayTypeNumber(row.getCell("veriRecPayTypeNumber").getValue().toString());
        }
        BigDecimal thisVeriAmt = null;
        BigDecimal unVeriAmt = null;
        BigDecimal unVeriAmtLoc = null;
        BigDecimal thisVeriAmtLoc = null;
        if (amt == null) {
            thisVeriAmt = new BigDecimal(row.getCell(TB_THISVERIAMT).getValue().toString());
            thisVeriAmt = thisVeriAmt.setScale(this.topCurrency.getPrecision(), 4);
            thisVeriAmtLoc = new BigDecimal(row.getCell(TB_THISVERIAMTLOC).getValue().toString());
            thisVeriAmtLoc = thisVeriAmtLoc.setScale(this.baseCurrency.getPrecision(), 4);
        } else {
            thisVeriAmt = amt;
            unVeriAmt = new BigDecimal(row.getCell(TB_THISVERIAMT).getValue().toString());
            unVeriAmtLoc = new BigDecimal(row.getCell(TB_THISVERIAMTLOC).getValue().toString());
            thisVeriAmtLoc = amt.multiply((BigDecimal)row.getCell("exchangeRate").getValue());
            thisVeriAmtLoc = thisVeriAmtLoc.setScale(this.baseCurrency.getPrecision(), 4);
            if (thisVeriAmt.compareTo(unVeriAmt) == 0) {
                thisVeriAmtLoc = unVeriAmtLoc;
            }
            row.getCell(TB_THISVERIAMT).setValue((Object)unVeriAmt.subtract(thisVeriAmt));
            row.getCell(TB_THISVERIAMTLOC).setValue((Object)unVeriAmtLoc.subtract(thisVeriAmtLoc));
        }
        entryInfo.setThisVerificateAmt(thisVeriAmt);
        entryInfo.setThisVerificateAmtLoc(thisVeriAmtLoc);
        if (row.getCell("description").getValue() == null) {
            entryInfo.setComment("");
        } else {
            entryInfo.setComment(row.getCell("description").getValue().toString());
        }
        return entryInfo;
    }

    private HashMap _selectEntrys() throws BOSException, EASBizException {
        if (this.kDRadioButtonMenuItem2.isSelected()) {
            MsgBox.showWarning((String)this.getStrResource("VeriBy_CoreNum"));
            SysUtil.abort();
        }
        IRow row = null;
        Object coreNum = null;
        Object coreSeq = null;
        Object paymentType = null;
        HashMap values = new HashMap();
        HashMap<VerificateBillTypeEnum, Map> allCheckDataMap = new HashMap<VerificateBillTypeEnum, Map>();
        String key = null;
        this.topCheckDataMaq = new LinkedHashMap();
        this.bottomCheckDataMaq = new LinkedHashMap();
        if (this.kDRadioButtonMenuItem2.isSelected()) {
            this.topCheckDataMaq.put("Bill", "allBill");
            this.bottomCheckDataMaq.put("Bill", "allBill");
        } else {
            this.topCheckDataMaq.put("Bill", "recBill");
            this.bottomCheckDataMaq.put("Bill", "recBill");
        }
        for (int rowIndex = 0; rowIndex < this.getTopTable().getRowCount3(); ++rowIndex) {
            HashMap<String, Boolean> flag = new HashMap<String, Boolean>();
            flag.put("flag", new Boolean(true));
            row = this.getTopTable().getRow(rowIndex);
            coreNum = row.getCell(TB_COREBILLNUM).getValue();
            coreSeq = row.getCell(TB_COREENTRYSEQ).getValue();
            paymentType = row.getCell("paymenttypeid").getValue();
            if (coreNum == null || coreSeq == null || paymentType == null) continue;
            this.billType = (VerificateBillTypeEnum)row.getCell("billType").getValue();
            String billEntryID = row.getCell("entryid").getValue().toString();
            Object srcAssActID = row.getCell(this.TB_ASSACTID).getValue();
            BigDecimal unverificateamt = new BigDecimal("0.0");
            if (row.getCell("unVerificateAmt").getValue() != null) {
                unverificateamt = new BigDecimal(row.getCell("unVerificateAmt").getValue().toString());
            }
            if (this.kDRadioButtonMenuItem2.isSelected()) {
                String billID = row.getCell(TB_BILLID).getValue().toString();
                if (!this.topCheckDataMaq.containsKey(billID)) {
                    this.topCheckDataMaq.put(billID, unverificateamt);
                }
            } else if (!this.topCheckDataMaq.containsKey(billEntryID)) {
                this.topCheckDataMaq.put(billEntryID, unverificateamt);
            }
            key = coreNum.toString() + IS_FROM_TOP + coreSeq.toString() + paymentType.toString();
            if (values.containsKey(key)) {
                ((Ap2PaymentPair)values.get(key)).addToTop(rowIndex);
                row.getCell("selected").setValue((Object)Boolean.TRUE);
                continue;
            }
            this._checkCoreNumAndSeq(key, rowIndex, values, srcAssActID, flag);
        }
        if (this.topCheckDataMaq.size() > 1) {
            allCheckDataMap.put(this.billType, this.topCheckDataMaq);
        }
        this.topCheckDataMaq.clear();
        if (this.bottomCheckDataMaq.size() > 1) {
            allCheckDataMap.put(this.billType, this.topCheckDataMaq);
        }
        this.bottomCheckDataMaq.clear();
        return values;
    }

    private Map getAllCheckMap() {
        HashMap<VerificateBillTypeEnum, Map> allCheckDataMap = new HashMap<VerificateBillTypeEnum, Map>();
        if (this.topCheckDataMaq.size() > 1) {
            allCheckDataMap.put(this.billType, this.topCheckDataMaq);
        }
        this.topCheckDataMaq.clear();
        if (this.bottomCheckDataMaq.size() > 1) {
            allCheckDataMap.put(this.billType, this.topCheckDataMaq);
        }
        return allCheckDataMap;
    }

    private boolean _checkCoreNumAndSeq(String key, int srcRowIndex, HashMap hm, Object srcAssActID, HashMap flag) {
        IRow row = null;
        Object desCoreNum = null;
        Object desCoreSeq = null;
        Object desAssActID = null;
        Object paymentType = null;
        boolean contain = false;
        Ap2PaymentPair pair = null;
        for (int j = 0; j < this.getBottomTable().getRowCount3(); ++j) {
            row = this.getBottomTable().getRow(j);
            desCoreNum = row.getCell(TB_COREBILLNUM).getValue();
            desCoreSeq = row.getCell(TB_COREENTRYSEQ).getValue();
            desAssActID = row.getCell(this.TB_ASSACTID).getValue();
            paymentType = row.getCell("paymenttypeid").getValue();
            if (desCoreNum == null || desCoreSeq == null || !key.equals(desCoreNum.toString() + IS_FROM_TOP + desCoreSeq.toString() + paymentType.toString()) || !srcAssActID.equals(desAssActID)) continue;
            this.billType = (VerificateBillTypeEnum)row.getCell("billType").getValue();
            String billEntryID = row.getCell("entryid").getValue().toString();
            BigDecimal unverificateamt = new BigDecimal("0.0");
            if (row.getCell("unVerificateAmt").getValue() != null) {
                unverificateamt = new BigDecimal(row.getCell("unVerificateAmt").getValue().toString());
            }
            if (this.kDRadioButtonMenuItem2.isSelected()) {
                String billID = row.getCell(TB_BILLID).getValue().toString();
                if (!this.bottomCheckDataMaq.containsKey(billID)) {
                    this.bottomCheckDataMaq.put(billID, unverificateamt);
                }
            } else if (!this.bottomCheckDataMaq.containsKey(billEntryID)) {
                this.bottomCheckDataMaq.put(billEntryID, unverificateamt);
            }
            if (!hm.containsKey(key)) {
                pair = new Ap2PaymentPair(desCoreNum.toString(), desCoreSeq.toString());
                pair.addToTop(srcRowIndex);
                hm.put(key, pair);
                row.getCell("selected").setValue((Object)Boolean.TRUE);
                this.getTopTable().getCell(srcRowIndex, "selected").setValue((Object)Boolean.TRUE);
                pair.addToBottom(j);
                contain = true;
                continue;
            }
            pair = (Ap2PaymentPair)hm.get(key);
            row.getCell("selected").setValue((Object)Boolean.TRUE);
            pair.addToBottom(j);
        }
        return contain;
    }

    protected KDTable getTopTable() {
        return this.kdTabAp;
    }

    protected KDTable getBottomTable() {
        return this.kdTabPayment;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.actionCoreNumVeri.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.cbSameSideFirst.setText(this.getStrResource("PurchaseModeSameSideFirst"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnContractNumVeri.setIcon(EASResource.getIcon((String)"imgTbtn_credencefascicule"));
        this.menuItemContractNumVeri.setIcon(EASResource.getIcon((String)"imgTbtn_credencefascicule"));
    }

    @Override
    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSPAYABLE;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public boolean isPrepareActionSelectAll() {
        return false;
    }

    @Override
    public boolean isPrepareActionSelectNone() {
        return false;
    }

    @Override
    public boolean isPrepareActionManualVerify() {
        return true;
    }

    @Override
    public boolean isPrepareActionCreatPrePayBill() {
        return false;
    }

    @Override
    public boolean isPrepareActionCreatPreRecBill() {
        return false;
    }

    @Override
    public boolean isPrepareActionRefresh() {
        return false;
    }

    @Override
    public boolean isPrepareActionAutoVerify() {
        return true;
    }

    @Override
    public boolean isPrepareActionFilter() {
        return false;
    }

    @Override
    public boolean isPrepareActionHistory() {
        return false;
    }

    @Override
    public boolean isPrepareActionResult() {
        return true;
    }

    @Override
    public boolean isPrepareActionViewBill() {
        return false;
    }

    @Override
    public boolean isPrepareActionCoreNumVeri() {
        return false;
    }

    @Override
    public RequestContext prepareActionCoreNumVeri(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionCoreNumVeri(itemAction);
        this._selectEntrys();
        Map allCheckMap = this.getAllCheckMap();
        if (allCheckMap != null && allCheckMap.size() > 0) {
            request.put("checkMutxMap", (Object)allCheckMap);
        }
        return request;
    }

    private static class Ap2PaymentPair {
        private TreeSet top = new TreeSet();
        private TreeSet bottom = new TreeSet();
        private String coreNum = null;
        private String coreBillEntrySeq = null;

        public Ap2PaymentPair(String coreBillNum, String coreBillEntrySeq) {
            this.coreNum = coreBillNum;
            this.coreBillEntrySeq = coreBillEntrySeq;
        }

        public void addToTop(int i) {
            Integer inValue = new Integer(i);
            if (!this.top.contains(inValue)) {
                this.top.add(inValue);
            }
        }

        public void addToBottom(int i) {
            Integer inValue = new Integer(i);
            if (!this.bottom.contains(inValue)) {
                this.bottom.add(inValue);
            }
        }

        public String getCoreNum() {
            return this.coreNum;
        }

        public String getCoreBillEntrySeq() {
            return this.coreBillEntrySeq;
        }

        public Collection getTop() {
            return this.top;
        }

        public Collection getBottom() {
            return this.bottom;
        }
    }

    private static class Ap2PaymentPairOrderBySeq {
        private Map top = new HashMap();
        private Map bottom = new HashMap();
        private String coreNum = null;
        private String assActID = null;

        public Ap2PaymentPairOrderBySeq(String coreBillNum, String assActID) {
            this.coreNum = coreBillNum;
            this.assActID = assActID;
        }

        public void addToTop(int rowIndex, String coreBillEntrySeq) {
            Integer inValue = new Integer(rowIndex);
            Ap2PaymentRowValue value = new Ap2PaymentRowValue(inValue, coreBillEntrySeq);
            if (!this.top.containsKey(inValue)) {
                this.top.put(inValue, value);
            }
        }

        public void addToBottom(int rowIndex, String coreBillEntrySeq) {
            Integer inValue = new Integer(rowIndex);
            Ap2PaymentRowValue value = new Ap2PaymentRowValue(inValue, coreBillEntrySeq);
            if (!this.bottom.containsKey(inValue)) {
                this.bottom.put(inValue, value);
            }
        }

        public String getCoreNum() {
            return this.coreNum;
        }

        public String getAssActID() {
            return this.assActID;
        }

        public List getTop() {
            ArrayList aList = new ArrayList();
            aList.addAll(this.top.values());
            Collections.sort(aList);
            return aList;
        }

        public List getBottom() {
            ArrayList aList = new ArrayList();
            aList.addAll(this.bottom.values());
            Collections.sort(aList);
            return aList;
        }

        public String toString() {
            return "Ar2PaymentPairOrderBySeq of coreNum: " + this.coreNum + " assActID:" + this.assActID + " top count:" + this.top.size() + " bottom count:" + this.bottom.size();
        }
    }

    private static class Ap2PaymentRowValue
    implements Comparable {
        private Integer rowIndex;
        private String coreBillEntrySeq;

        public Ap2PaymentRowValue(Integer rowIndex, String coreBillEntrySeq) {
            this.rowIndex = rowIndex;
            this.setCoreBillEntrySeq(coreBillEntrySeq);
        }

        public String getCoreBillEntrySeq() {
            return this.coreBillEntrySeq;
        }

        public void setCoreBillEntrySeq(String coreBillEntrySeq) {
            String seqStr = "0";
            seqStr = coreBillEntrySeq == null || "".equals(coreBillEntrySeq) ? "0" : coreBillEntrySeq;
            this.coreBillEntrySeq = seqStr;
        }

        public Integer getRowIndex() {
            return this.rowIndex;
        }

        public void setRowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
        }

        public int compareTo(Object obj) {
            if (obj == null) {
                return -1;
            }
            if (obj instanceof Ap2PaymentRowValue) {
                Integer objSeqInt;
                Ap2PaymentRowValue value = (Ap2PaymentRowValue)obj;
                Integer thisSeqInt = Integer.valueOf(this.coreBillEntrySeq);
                int compareIndex = thisSeqInt.compareTo(objSeqInt = Integer.valueOf(value.getCoreBillEntrySeq()));
                if (compareIndex == 0) {
                    return this.rowIndex.compareTo(value.getRowIndex());
                }
                return compareIndex;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Ap2PaymentRowValue)) {
                return false;
            }
            Ap2PaymentRowValue value = (Ap2PaymentRowValue)obj;
            return this.rowIndex.equals(value.getRowIndex()) && this.coreBillEntrySeq.equals(value.getCoreBillEntrySeq());
        }

        public int hashCode() {
            return this.rowIndex.hashCode() + this.coreBillEntrySeq.hashCode();
        }

        public String toString() {
            return "Ap2PaymentRowValue  rowIndex " + this.rowIndex.toString() + " coreBillEntrySeq " + this.coreBillEntrySeq;
        }
    }
}

